<?php
// Test the full activation flow

$XOR_KEY = "KvuZRm365wk5Sz&Xy.Zx";

function xor_encrypt($data, $key) {
    $json_str = json_encode($data);
    $keyLen = strlen($key);
    $encrypted = '';
    for ($i = 0; $i < strlen($json_str); $i++) {
        $encrypted .= chr(ord($json_str[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $encrypted;
}

function xor_decrypt($encrypted, $key) {
    $keyLen = strlen($key);
    $decrypted = '';
    for ($i = 0; $i < strlen($encrypted); $i++) {
        $decrypted .= chr(ord($encrypted[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $decrypted;
}

// Step 1: Activate code
$activation_request = [
    'code' => '298047191064',
    'mac' => '8c:fd:f0:00:7f:13',
    'sn' => '8c:fd:f0:00:7f:13',
    'model' => 'SM-N975F',
    'group' => 1,
    'mode' => 'active'
];

echo "=== STEP 1: Activation ===\n";
$encrypted = xor_encrypt($activation_request, $XOR_KEY);
$response = file_get_contents('http://45.154.207.45/iptv/V6APK/API-V6APK.php', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => "Content-Type: application/x-www-form-urlencoded\r\nUser-Agent: okhttp/3.10.0\r\n",
        'content' => 'json=' . urlencode($encrypted)
    ]
]));

$activation_data = json_decode(xor_decrypt($response, $XOR_KEY), true);
echo "Activation Response:\n";
echo json_encode($activation_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES) . "\n\n";

if ($activation_data && isset($activation_data['token'])) {
    $token = $activation_data['token'];
    echo "Token received: " . substr($token, 0, 50) . "...\n\n";

    // Step 2: Use token for movies_latest
    echo "=== STEP 2: Test token with movies_latest ===\n";
    $movies_request = [
        'mode' => 'movies_latest',
        'token' => $token
    ];

    $encrypted2 = xor_encrypt($movies_request, $XOR_KEY);
    $response2 = file_get_contents('http://45.154.207.45/iptv/V6APK/API-V6APK.php', false, stream_context_create([
        'http' => [
            'method' => 'POST',
            'header' => "Content-Type: application/x-www-form-urlencoded\r\nUser-Agent: okhttp/3.10.0\r\n",
            'content' => 'json=' . urlencode($encrypted2)
        ]
    ]));

    $movies_data = xor_decrypt($response2, $XOR_KEY);
    echo "Movies Response (first 500 chars):\n";
    echo substr($movies_data, 0, 500) . "\n";
}
