<?php
// Test the token from app activation

$XOR_KEY = "KvuZRm365wk5Sz&Xy.Zx";

function xor_encrypt($data, $key) {
    $json_str = json_encode($data);
    $keyLen = strlen($key);
    $encrypted = '';
    for ($i = 0; $i < strlen($json_str); $i++) {
        $encrypted .= chr(ord($json_str[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $encrypted;
}

function xor_decrypt($encrypted, $key) {
    $keyLen = strlen($key);
    $decrypted = '';
    for ($i = 0; $i < strlen($encrypted); $i++) {
        $decrypted .= chr(ord($encrypted[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $decrypted;
}

// Token from the activation response
$token_from_app = "f3ed71d56579442cbdc114e8f77e57b4rueo5uPmlFslxvKta6fG9lMBRXMKLU0VDwvqXuJXnhJs/PpqTO7+kK0mtjIDjNwj1ZVOAER8JPeqKd5QljjBHQ==";

// Token that app actually sends (with escaped slash)
$token_app_sends = "4f8ecf06c3bc9c8e0ca6aca2129e427bulAkIuLgOU1h0suMbUZrFchMETQsZxUtSb6V32USiF6BI05fY8FAt2v0vyxg1S8br446KyYRDgjfe2Y/GDePeQ==";

echo "=" . str_repeat("=", 70) . "\n";
echo "Testing Tokens\n";
echo "=" . str_repeat("=", 70) . "\n\n";

// Test 1: Token from activation response
echo "TEST 1: Token from activation response\n";
echo str_repeat("-", 72) . "\n";
echo "Token: " . substr($token_from_app, 0, 50) . "...\n\n";

$request1 = [
    'mode' => 'movies_latest',
    'token' => $token_from_app
];

$encrypted1 = xor_encrypt($request1, $XOR_KEY);
$response1 = @file_get_contents('http://45.154.207.45/iptv/V6APK/API-V6APK.php', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => "Content-Type: application/x-www-form-urlencoded\r\nUser-Agent: okhttp/3.10.0\r\n",
        'content' => 'json=' . urlencode($encrypted1),
        'ignore_errors' => true
    ]
]));

if ($response1) {
    $decrypted1 = xor_decrypt($response1, $XOR_KEY);
    if (strpos($decrypted1, 'error') === false) {
        echo "✅ SUCCESS! Received " . strlen($decrypted1) . " bytes of data\n";
        $data = json_decode($decrypted1, true);
        if (is_array($data)) {
            echo "   Movies count: " . count($data) . "\n";
        }
    } else {
        echo "❌ FAILED: $decrypted1\n";
    }
} else {
    echo "❌ No response\n";
}

echo "\n";

// Test 2: Token that app sends (wrong one)
echo "TEST 2: Token that app actually sends (with issue)\n";
echo str_repeat("-", 72) . "\n";
echo "Token: " . substr($token_app_sends, 0, 50) . "...\n\n";

$request2 = [
    'mode' => 'movies_latest',
    'token' => $token_app_sends
];

$encrypted2 = xor_encrypt($request2, $XOR_KEY);
$response2 = @file_get_contents('http://45.154.207.45/iptv/V6APK/API-V6APK.php', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => "Content-Type: application/x-www-form-urlencoded\r\nUser-Agent: okhttp/3.10.0\r\n",
        'content' => 'json=' . urlencode($encrypted2),
        'ignore_errors' => true
    ]
]));

if ($response2) {
    $decrypted2 = xor_decrypt($response2, $XOR_KEY);
    if (strpos($decrypted2, 'error') === false) {
        echo "✅ SUCCESS! Received " . strlen($decrypted2) . " bytes of data\n";
    } else {
        echo "❌ FAILED: $decrypted2\n";
    }
} else {
    echo "❌ No response\n";
}

echo "\n";

// Compare tokens
echo "TOKEN COMPARISON\n";
echo str_repeat("-", 72) . "\n";
echo "Correct token:    " . substr($token_from_app, 0, 50) . "...\n";
echo "App sends:        " . substr($token_app_sends, 0, 50) . "...\n\n";

echo "MD5 prefix comparison:\n";
echo "Correct: " . substr($token_from_app, 0, 32) . "\n";
echo "App:     " . substr($token_app_sends, 0, 32) . "\n\n";

if ($token_from_app === $token_app_sends) {
    echo "✅ Tokens are IDENTICAL\n";
} else {
    echo "❌ Tokens are DIFFERENT\n";
    echo "\nDifference details:\n";
    echo "Length: Correct=" . strlen($token_from_app) . ", App=" . strlen($token_app_sends) . "\n";

    // Find first difference
    $len = min(strlen($token_from_app), strlen($token_app_sends));
    for ($i = 0; $i < $len; $i++) {
        if ($token_from_app[$i] !== $token_app_sends[$i]) {
            echo "First difference at position $i:\n";
            echo "  Correct: '" . $token_from_app[$i] . "' (ASCII " . ord($token_from_app[$i]) . ")\n";
            echo "  App:     '" . $token_app_sends[$i] . "' (ASCII " . ord($token_app_sends[$i]) . ")\n";
            break;
        }
    }
}

echo "\n" . str_repeat("=", 72) . "\n";
echo "CONCLUSION: The app is NOT saving the token correctly!\n";
echo str_repeat("=", 72) . "\n";
