<?php
// Test if escaped token causes issues

$XOR_KEY = "KvuZRm365wk5Sz&Xy.Zx";

function xor_encrypt($data, $key) {
    $json_str = json_encode($data);
    $keyLen = strlen($key);
    $encrypted = '';
    for ($i = 0; $i < strlen($json_str); $i++) {
        $encrypted .= chr(ord($json_str[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $encrypted;
}

function xor_decrypt($encrypted, $key) {
    $keyLen = strlen($key);
    $decrypted = '';
    for ($i = 0; $i < strlen($encrypted); $i++) {
        $decrypted .= chr(ord($encrypted[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $decrypted;
}

// Simulate the issue: token with escaped forward slash
$token_with_escape = "4f8ecf06c3bc9c8e0ca6aca2129e427bulAkIuLgOU1h0suMbUZrFchMETQsZxUtSb6V32USiF6BI05fY8FAt2v0vyxg1S8br446KyYRDgjfe2Y\/GDePeQ==";

echo "Testing token with escaped slash: \/\n";
echo "Token: " . substr($token_with_escape, 0, 50) . "...\n\n";

$request = [
    'mode' => 'movies_latest',
    'token' => $token_with_escape
];

$encrypted = xor_encrypt($request, $XOR_KEY);
$response = @file_get_contents('http://45.154.207.45/iptv/V6APK/API-V6APK.php', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => "Content-Type: application/x-www-form-urlencoded\r\nUser-Agent: okhttp/3.10.0\r\n",
        'content' => 'json=' . urlencode($encrypted),
        'timeout' => 10
    ]
]));

if ($response) {
    $decrypted = xor_decrypt($response, $XOR_KEY);
    echo "Response: $decrypted\n";
} else {
    echo "No response or error\n";
}
