<?php 
class Movies
{
    public $CacheFile = '';
    public $CacheTime = 3600;
    public $CasheEnabled = true;
    public $API = null;
    public function __construct($API, $mode)
    {
        $this->API = $API;
        $data = [];
        $data['u'] = $API->user;
        $data['p'] = $API->pass;
        $data['e'] = $API->date_expire;
        $data['mode'] = $mode;
        $data['parent'] = $API->catid;
        $data['catid'] = $API->catid;
        $data['movie_id'] = $API->movie_id;
        $data['series_id'] = $API->series_id;
        $data['search'] = $API->search;
        $data['year'] = $API->year;
        $data['genre'] = $API->genre;
        $this->SetCacheFile($data);
        $cutomData = [];
        $cutomData['group'] = $API->DBgroup;
        $cutomData['islam_pkg'] = $API->islam_pkg;
        $cutomData['islam_pkg_mov'] = trim($API->conf['islam_pkg_mov']);
        $cutomData['islam_pkg_series'] = trim($API->conf['islam_pkg_series']);
        $cutomData['ratingPoints'] = (isset($_GET['ratingPoints']) ? trim($_GET['ratingPoints']) : '');
        $cutomData['code'] = $API->code;
        $cutomData['series_id'] = $data['series_id'];
        $cutomData['movie_id'] = $data['movie_id'];
        $cutomData['ip'] = $API->ip();
        $cutomData['title'] = (isset($_GET['title']) ? trim($_GET['title']) : '');
        if( $cutomData['title'] != '' ) 
        {
            $cutomData['title'] = urlencode($cutomData['title']);
        }
        $cutomData['comment'] = (isset($_GET['comment']) ? trim($_GET['comment']) : '');
        $cutomData['name'] = (isset($_GET['name']) ? trim($_GET['name']) : '');
        $cutomData['for'] = (isset($_GET['for']) ? trim($_GET['for']) : '');
        $cutomData['op'] = (isset($_GET['op']) ? trim($_GET['op']) : '');
        $data['data'] = json_encode($cutomData);
        $data['url'] = str_replace('|', '/', trim($API->conf['remote_movies_url']));
        $url = str_replace('|', '/', trim($API->conf['remote_movies_api']));
        $json = $this->intro_url($url, $data);

        // Apply XOR encryption before outputting
        $this->API->html_header();
        echo $this->API->runXOR($json);
        exit();
    }
    public function SetCacheFile($data)
    {
        $this->CacheFile = './cache/';
        $this->CacheFile .= 'vod_[';
        $this->CacheFile .= ($data['mode'] . ']_');
        if( $data['catid'] != '' ) 
        {
            $this->CacheFile .= ('CatID' . $data['catid'] . '_');
        }
        if( $data['mode'] == 'series_details' && intval($data['series_id']) != 0 ) 
        {
            $this->CacheFile .= ('SeriesID' . $data['series_id'] . '_');
        }
        if( $data['mode'] == 'movies_info' && intval($data['movie_id']) != 0 ) 
        {
            $this->CacheFile .= ('MovieID' . $data['movie_id'] . '_');
        }
        $this->CacheFile .= (md5($this->CacheFile . 'rareMicra') . '.txt');
    }
    public function intro_curl_url($url, $data = [])
    {
        if( in_array('curl', get_loaded_extensions()) ) 
        {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
            curl_setopt($ch, CURLOPT_TIMEOUT, 5);
            $output = curl_exec($ch);
            curl_close($ch);
            return $output;
        }
        else
        {
            $content = http_build_query($data, '', '&');
            $header = [
                'Content-Type: application/x-www-form-urlencoded', 
                'Content-Length: ' . strlen($content)
            ];
            $options = [
                'http' => [
                    'method' => 'POST', 
                    'content' => $content, 
                    'header' => implode("\r\n", $header)
                ]
            ];
            return file_get_contents($url, false, stream_context_create($options));
        }
    }
    public function intro_url($url, $data = [])
    {
        if( $this->CasheEnabled && file_exists($this->CacheFile) && filesize($this->CacheFile) > 0 && $this->CacheTime < (time() - filectime($this->CacheFile)) )
        {
            return file_get_contents($this->CacheFile);
        }

        // Use MidnightStreamer adapter
        require_once(__DIR__ . '/MidnightStreamerAdapter.php');

        global $_CFG;
        $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'https://flix-panel.xyz:2087/';
        $adapter = new MidnightStreamerAdapter($this->API->user, $this->API->pass, $panel_url);

        $mode = $data['mode'] ?? '';
        $output = '';

        switch($mode) {
            case 'movies_latest':
                $result = $adapter->getLatestMovies();
                $output = json_encode($result);
                break;
            case 'movies_list':
                $catid = $data['catid'] ?? 'all';
                if ($catid && $catid != 'all') {
                    $result = $adapter->getMoviesByCategory($catid);
                } else {
                    $result = $adapter->getLatestMovies(100);
                }
                $output = json_encode($result);
                break;
            case 'movies_cat':
                $result = $adapter->getMovieCategories();
                $output = json_encode($result);
                break;
            case 'movies_info':
                $movie_id = $data['movie_id'] ?? 0;
                if ($movie_id) {
                    $result = $adapter->getMovieInfo($movie_id);
                    $output = json_encode($result);
                } else {
                    $output = json_encode([]);
                }
                break;
            case 'series_latest':
                $result = $adapter->getLatestSeries();
                $output = json_encode($result);
                break;
            case 'series_cat':
                $result = $adapter->getSeriesCategories();
                $output = json_encode($result);
                break;
            case 'series_list':
                $catid = $data['catid'] ?? 0;
                $result = $adapter->getSeriesByCategory($catid);
                $output = json_encode($result);
                break;
            case 'series_info':
                $series_id = $data['series_id'] ?? 0;
                if ($series_id) {
                    $result = $adapter->getSeriesInfo($series_id);
                    $output = json_encode($result);
                } else {
                    $output = json_encode([]);
                }
                break;
            default:
                $output = $this->intro_curl_url($url, $data);
                break;
        }

        if( preg_match('/error:/i', $output) )
        {
            $this->API->insert('solus_logs_sys', [
                'dtime' => date('Y-m-d H:i:s'),
                'admin_user' => 'movies_api',
                'app' => 'movies_api',
                'ip' => $this->API->ip(),
                'action' => 'error',
                'the_log' => $output
            ]);
        }

        // Don't cache or XOR encrypt here - let the calling method handle it
        if( $this->CasheEnabled && file_put_contents($this->CacheFile, $output, LOCK_EX) === false )
        {
            @unlink($this->CacheFile);
        }

        return $output;
    }
}
class API6Core
{
    public $CatOrder = ' `category_name` ASC';
    public $mac = '';
    public $sn = '';
    public $chipid = '';
    public $code = '';
    public $ip = '';
    public $conf = [];
    public $free_codes = [];
    public $MasterCodes = [];
    public $bouquets = '';
    public $link = null;
    public $mac_enable = true;
    public $inputBy = 0;
    public $free = [
        101,
        103,
        107,
        110
    ];
    public $user = '';
    public $pass = '';
    public $data = [];  // Store nested JSON data (e.g., login credentials)
    public $date_expire = '';
    public $limit = 0;
    public $limit_qry = '';
    public $osd = '';
    public $debug = 0;
    public $transid = 0;
    public $cache = true;
    public $cache_time = 300;
    public $catid = '';
    public $movie_id = 0;
    public $series_id = 0;
    public $code_id = 0;
    public $read = 0;
    public $reply = '';
    public $raw = '';
    public $model = '';
    public $firmware_ver = '';
    public $iptv_stream_host = '';
    public $output = 'ts';
    public $DBgroup = 0;
    public $islam_pkg = 0;
    public $parent_id = 0;
    public $pkg_id = 0;
    public $genre = '';
    public $year = '';
    public $search = '';
    public $portal_url = '';
    public $portal_name = 'PortalNotSet in cfg';
    public function insertIP()
    {
        $file = basename($_SERVER['SCRIPT_FILENAME'], '.php');
        mysqli_query($this->link, 'INSERT INTO ' . PREFIX . '_ips (ip,file,type) ' . (' VALUES (\'' . $this->ip . '\',\'' . $file . '\',1) ON DUPLICATE KEY UPDATE hits=hits+1;'));
    }
    public function _die($msg)
    {
        echo $this->runXOR($msg);
        exit();
    }
    public function getCache($file)
    {
        $file = 'cache/' . $file;
        $cache_time = 600;
        if( !file_exists($file) ) 
        {
            return null;
        }
        if( filemtime($file) < (time() - $cache_time) ) 
        {
            return null;
        }
        $data = file_get_contents($file);
    }
    public function setCache($content, $file)
    {
        $file = 'cache/' . $file;
        if( file_put_contents($file, $content, LOCK_EX) === false ) 
        {
            @unlink($file);
        }
    }
    public function getMasterCodes()
    {
        global $intro;
        $sql = mysqli_query($this->link, 'SELECT * from solus_codes_master;');
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $code = trim($row['master_code']);
            $inputBy = intval($row['master_by']);
            $this->MasterCodes[$code] = $inputBy;
        }
    }
    public function insertModel()
    {
        $now = date('Y-m-d H:i:s');
        if( $this->model != '' ) 
        {
            mysqli_query($this->link, 'INSERT INTO ' . PREFIX . '_model ' . ' (m_name,m_ver,codeid,hits) ' . (' VALUES (\'' . $this->model . '\',\'' . $this->firmware_ver . '\',' . $this->code_id . ',1) ') . (' ON DUPLICATE KEY UPDATE hits=hits+1,lastdate=\'' . $now . '\';'));
        }
    }
    public function proccess_free_code($code, $sn, $mac, $ip)
    {
        $qry = '';
        $sqlFC = mysqli_query($this->link, 'select * from solus_free_code where code=\'' . $code . '\';');
        $rowFC = mysqli_fetch_array($sqlFC);
        if( intval($rowFC['status']) == 0 )
        {
            $array = [
                'status' => 3,
                'message' => 'Sorry: Our Free Code (' . $code . ') Available from Monday To Wednesday.',
                'expire' => '',
                'username' => '',
                'password' => ''
            ];
            $this->msg($array);
        }

        // Get lock settings
        $lock_isp = isset($rowFC['lock_isp']) ? intval($rowFC['lock_isp']) : 1;
        $lock_user_agent = isset($rowFC['lock_user_agent']) ? intval($rowFC['lock_user_agent']) : 1;
        $lock_country = isset($rowFC['lock_country']) ? intval($rowFC['lock_country']) : 1;
        $lock_ip = isset($rowFC['lock_ip']) ? intval($rowFC['lock_ip']) : 1;
        $max_activations = isset($rowFC['max_activations_per_device']) ? intval($rowFC['max_activations_per_device']) : 1;

        // Get client info
        $client_ip = $this->ip();
        $client_ua = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
        $client_country = $this->getCountryByIP($client_ip);
        $client_isp = $this->getISPByIP($client_ip);

        // Check if this device/IP/ISP already used a free code before
        // This prevents multiple trials by changing MAC only
        $check_device = mysqli_query($this->link,
            "SELECT c.*, u.username, u.password FROM solus_codes_free c
             LEFT JOIN users u ON c.user = u.username
             WHERE c.mac = '" . mysqli_real_escape_string($this->link, $mac) . "'
                OR c.serial = '" . mysqli_real_escape_string($this->link, $sn) . "'
                OR (c.ip_address = '" . mysqli_real_escape_string($this->link, $client_ip) . "' AND c.ip_address != '')
                OR (c.isp = '" . mysqli_real_escape_string($this->link, $client_isp) . "' AND c.country = '" . mysqli_real_escape_string($this->link, $client_country) . "' AND c.isp != '')
             LIMIT 1"
        );

        if(mysqli_num_rows($check_device) > 0) {
            $existing = mysqli_fetch_array($check_device);

            // Check if this is the SAME device (MAC matches)
            $is_same_device = ($existing['mac'] == $mac || $existing['serial'] == $sn);

            if(!$is_same_device) {
                // Different device but same IP/ISP - block new registration
                $array = [
                    'status' => 3,
                    'message' => 'Trial already used',
                    'expire' => '',
                    'username' => '',
                    'password' => ''
                ];
                $this->msg($array);
                exit();
            }

            // Same device - check if trying different code
            if($existing['code'] != $code) {
                $array = [
                    'status' => 3,
                    'message' => 'Trial already used',
                    'expire' => '',
                    'username' => '',
                    'password' => ''
                ];
                $this->msg($array);
                exit();
            }

            // Same device, same code - check ALL security locks
            $security_failed = false;
            $fail_message = '';

            if($lock_ip && $existing['ip_address'] != '' && $existing['ip_address'] != $client_ip) {
                $security_failed = true;
                $fail_message = 'IP Address changed. Your trial is locked to IP: ' . $existing['ip_address'];
            }

            if(!$security_failed && $lock_country && $existing['country'] != '' && $existing['country'] != $client_country) {
                $security_failed = true;
                $fail_message = 'Country changed. Your trial is locked to country: ' . $existing['country'];
            }

            if(!$security_failed && $lock_isp && $existing['isp'] != '' && $existing['isp'] != $client_isp) {
                $security_failed = true;
                $fail_message = 'ISP changed. Your trial is locked to ISP: ' . $existing['isp'];
            }

            if($security_failed) {
                $array = [
                    'status' => 3,
                    'message' => $fail_message . ' Please purchase a subscription.',
                    'expire' => '',
                    'username' => '',
                    'password' => ''
                ];
                $this->msg($array);
                exit();
            }

            // All checks passed - return existing account
            // Store credentials for this session
            $this->user = $existing['username'];
            $this->pass = $existing['password'];

            $array = [
                'status' => 100,
                'message' => 'Welcome back! Your trial account is active.',
                'osd' => (string)$this->osd,
                'expire' => $this->expire_date($existing['date_expire']),
                'user_agent' => trim($this->conf['user_agent']),
                'code_id' => 0,
                'username' => $existing['username'],
                'password' => $existing['password'],
                'lock_isp' => $lock_isp ? 'Yes' : 'No',
                'lock_user_agent' => $lock_user_agent ? 'Yes' : 'No',
                'lock_country' => $lock_country ? 'Yes' : 'No',
                'lock_ip' => $lock_ip ? 'Yes' : 'No',
                'client_isp' => $existing['isp'] ?? '',
                'client_user_agent' => $existing['user_agent'] ?? '',
                'client_country' => $existing['country'] ?? '',
                'client_ip' => $existing['ip_address'] ?? ''
            ];
            $this->msg($array);
            exit();
        }

        $days = intval($rowFC['days']);
        $days = ($days == 0 ? 1 : $days);
        $forced_country = $rowFC['forced_country'];
        if( $this->mac_enable )
        {
            $qry = ' AND c.mac=\'' . $mac . '\' ';
        }
        $sql_code = mysqli_query($this->link, 'SELECT c.code,c.date_expire,c.status,u.username, u.password FROM solus_codes_free c, users u ' . (' WHERE c.user=u.username AND c.code = \'' . $code . '\' AND c.serial=\'' . $sn . '\' ' . $qry . ';'));
        if( mysqli_num_rows($sql_code) == 0 )
        {
            $data['code'] = $code;
            $data['days'] = $days;
            $data['user'] = $this->random_number(12);
            $data['status'] = 1;
            $data['bouquets'] = '55,56,57,58,59,60,61,62,63,64,65,66,67,75,76,77,78,79,80,81,83,84,87,89,90';
            $data['mac'] = $mac;
            $data['serial'] = $sn;
            $data['date_expire'] = time() + ($data['days'] * 60 * 60 * 24);
            // Save security info
            $data['ip_address'] = $client_ip;
            $data['user_agent'] = $client_ua;
            $data['country'] = $client_country;
            $data['isp'] = $client_isp;
            $data['created_at'] = time();

            $this->insert(PREFIX . '_codes_free', $data);
            $dataUser['member_id'] = 1;
            $dataUser['username'] = $data['user'];
            // Generate password with exact same length as username
            $code_length = strlen($data['user']);
            $password = '';
            for($i = 0; $i < $code_length; $i++) {
                $password .= rand(0, 9);
            }
            $dataUser['password'] = $password;
            $dataUser['exp_date'] = $data['date_expire'];
            $dataUser['admin_notes'] = 'free code - IP: ' . $client_ip . ' | ISP: ' . $client_isp . ' | Country: ' . $client_country;
            $dataUser['admin_enabled'] = 1;
            $dataUser['enabled'] = 1;
            $dataUser['bouquet'] = '[55,56,57,58,59,60,61,62,63,64,65,66,67,75,76,77,78,79,80,81,83,84,87,89,90]';
            $dataUser['max_connections'] = 1;
            $dataUser['created_at'] = time();
            $dataUser['created_by'] = 1;
            $dataUser['is_trial'] = 1;
            $dataUser['forced_country'] = $forced_country;

            // Create user on external MidnightStreamer panel
            global $_CFG;
            $subscription_plan = isset($_CFG['subscription_plan']) ? intval($_CFG['subscription_plan']) : 1;
            $max_connections = isset($_CFG['max_connections']) ? intval($_CFG['max_connections']) : 1;

            $external_result = $this->createUserOnExternalPanel(
                $dataUser['username'],
                $dataUser['password'],
                $data['date_expire'],
                $max_connections,
                $subscription_plan
            );

            if($external_result && $external_result['success']) {
                // Use credentials returned from external panel if different
                if(isset($external_result['username'])) {
                    $dataUser['username'] = $external_result['username'];
                    $data['user'] = $external_result['username'];
                }
                if(isset($external_result['password'])) {
                    $dataUser['password'] = $external_result['password'];
                }
                // Update solus_codes_free with correct username and password
                mysqli_query($this->link, "UPDATE " . PREFIX . "_codes_free SET user='" . mysqli_real_escape_string($this->link, $dataUser['username']) . "', password='" . mysqli_real_escape_string($this->link, $dataUser['password']) . "' WHERE code='" . mysqli_real_escape_string($this->link, $code) . "' AND serial='" . mysqli_real_escape_string($this->link, $sn) . "'");

                $dataUser['admin_notes'] .= ' | ExtPanel ID: ' . $external_result['created_id'];
                $this->logfile("Free code user created on external panel: " . $dataUser['username'] . " (ID: " . $external_result['created_id'] . ")");
            } else {
                $this->logfile("WARNING: Failed to create user on external panel: " . $dataUser['username']);
            }

            $id = $this->insert('users', $dataUser);
            $this->insert('user_output', [
                'user_id' => $id,
                'access_output_id' => 1
            ]);
            $this->insert('user_output', [
                'user_id' => $id,
                'access_output_id' => 2
            ]);
            $this->insert('user_output', [
                'user_id' => $id,
                'access_output_id' => 3
            ]);
            mysqli_query($this->link, 'UPDATE ' . PREFIX . ('_free_code set code_used=code_used+1 where code = \'' . $code . '\';'));

            // Store credentials for this session
            $this->user = $dataUser['username'];
            $this->pass = $dataUser['password'];

            $array = [
                'status' => 100,
                'message' => 'The account has been activated successfully',
                'osd' => (string)$this->osd,
                'expire' => $this->expire_date($data['date_expire']),
                'user_agent' => trim($this->conf['user_agent']),
                'code_id' => 0,
                'username' => $dataUser['username'],
                'password' => $dataUser['password'],
                'lock_isp' => $lock_isp ? 'Yes' : 'No',
                'lock_user_agent' => $lock_user_agent ? 'Yes' : 'No',
                'lock_country' => $lock_country ? 'Yes' : 'No',
                'lock_ip' => $lock_ip ? 'Yes' : 'No',
                'client_isp' => $client_isp,
                'client_user_agent' => $client_ua,
                'client_country' => $client_country,
                'client_ip' => $client_ip
            ];
            $this->msg($array, 'Free code Activated : User== ' . $dataUser['username']);
        }
        if( mysqli_num_rows($sql_code) == 1 )
        {
            $row = mysqli_fetch_array($sql_code);

            // Store credentials for this session
            $this->user = $row['username'];
            $this->pass = $row['password'];

            $array = [
                'status' => 100,
                'message' => 'The account has been activated successfully',
                'osd' => (string)$this->osd,
                'expire' => $this->expire_date($row['date_expire']),
                'user_agent' => trim($this->conf['user_agent']),
                'code_id' => 0,
                'username' => $row['username'],
                'password' => $row['password']
            ];
            $this->msg($array);
        }
        exit();
    }

    // Get country by IP
    private function getCountryByIP($ip) {
        $url = "http://ip-api.com/json/" . $ip . "?fields=countryCode";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 3);
        $response = curl_exec($ch);
        curl_close($ch);
        if($response) {
            $data = json_decode($response, true);
            return isset($data['countryCode']) ? $data['countryCode'] : '';
        }
        return '';
    }

    // Get ISP by IP
    private function getISPByIP($ip) {
        $url = "http://ip-api.com/json/" . $ip . "?fields=isp";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 3);
        $response = curl_exec($ch);
        curl_close($ch);
        if($response) {
            $data = json_decode($response, true);
            return isset($data['isp']) ? $data['isp'] : '';
        }
        return '';
    }

    // Create user on MidnightStreamer external panel
    protected function createUserOnExternalPanel($username, $password, $expire_timestamp, $max_connections = 1, $subscription_plan = 1) {
        global $_CFG;

        // Ensure config is loaded
        if(empty($_CFG) || !isset($_CFG['panel_url'])) {
            $config_file = __DIR__ . '/api_cfg_v6.php';
            if(file_exists($config_file)) {
                include($config_file);
            }
        }

        $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') : '';
        $api_key = isset($_CFG['api_key']) ? $_CFG['api_key'] : '';

        if(empty($panel_url) || empty($api_key)) {
            $this->logfile("createUserOnExternalPanel: Missing panel_url or api_key in config. panel_url='$panel_url', api_key='$api_key'");
            return false;
        }

        $api_url = $panel_url . '/api/line/new';

        // Get bouquets from config or use default (all bouquets 1-18)
        $bouquets = isset($_CFG['external_bouquets']) ? $_CFG['external_bouquets'] : [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18];

        // Prepare POST data for MidnightStreamer API
        $post_data = http_build_query([
            'api_key' => $api_key,
            'data[username]' => $username,
            'data[password]' => $password,
            'data[max_allowed_connections]' => $max_connections,
            'data[expire_date]' => $expire_timestamp,
            'data[subscription_plan_id]' => $subscription_plan,
            'data[allow_m3u]' => 1,
            'data[https]' => 1
        ]);

        // Add bouquets as array
        foreach($bouquets as $bouquet_id) {
            $post_data .= '&' . urlencode('data[bouquets][]') . '=' . intval($bouquet_id);
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/x-www-form-urlencoded'
        ]);

        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curl_error = curl_error($ch);
        curl_close($ch);

        // Log the API call for debugging
        $log_msg = "External Panel API Call: URL=$api_url, User=$username, HTTP=$http_code, Response=$response";
        if($curl_error) {
            $log_msg .= ", cURL Error=$curl_error";
        }
        $this->logfile($log_msg);

        if($response) {
            $result = json_decode($response, true);
            if(isset($result['result']) && $result['result'] === true) {
                return [
                    'success' => true,
                    'created_id' => $result['created_id'] ?? 0,
                    'username' => $result['username'] ?? $username,
                    'password' => $result['password'] ?? $password
                ];
            }
        }

        return false;
    }

    public function proccess_master_code()
    {
        $qry = '';
        $period = intval($this->conf['mc_period']);
        if( in_array($period, $this->free) ) 
        {
            $dd = $period - 100;
            $exp_date = strtotime('+' . $dd . ' days');
            $days = $dd;
        }
        else
        {
            $exp_date = strtotime('+' . $period . ' month');
            $days = $period * 30;
        }
        $sql_code = mysqli_query($this->link, 'SELECT c.code,c.date_expire,c.status,u.username, u.password FROM solus_codes c, users u ' . (' WHERE c.username=u.username AND c.code = \'' . $this->code . '\' AND c.serial=\'' . $this->sn . '\' AND c.mac=\'' . $this->mac . '\';'));
        if( mysqli_num_rows($sql_code) == 0 ) 
        {
            $data = [];
            $data['code'] = $this->code;
            $data['days'] = $days;
            $data['period'] = $period;
            $data['username'] = $this->random_number(12);
            $data['status'] = 1;
            $data['bouquets'] = implode(',', $this->get_bouquets());
            $data['mac'] = $this->mac;
            $data['serial'] = $this->sn;
            $data['date_expire'] = $exp_date;
            $data['inputBy'] = 1;
            $this->insert(PREFIX . '_codes', $data);
            $dataUser = [];
            $dataUser['member_id'] = 1;
            $dataUser['username'] = $data['username'];
            $dataUser['password'] = uniqid();
            $dataUser['exp_date'] = $exp_date;
            $dataUser['admin_notes'] = 'from master code';
            $dataUser['admin_enabled'] = 1;
            $dataUser['enabled'] = 1;
            $dataUser['bouquet'] = $data['bouquets'];
            $dataUser['max_connections'] = 1;
            $dataUser['created_at'] = time();
            $dataUser['created_by'] = 1;
            $dataUser['is_trial'] = 0;
            $dataUser['forced_country'] = '';
            $id = $this->insert('users', $dataUser);
            $this->insert('user_output', [
                'user_id' => $id, 
                'access_output_id' => 1
            ]);
            $this->insert('user_output', [
                'user_id' => $id, 
                'access_output_id' => 2
            ]);
            $this->insert('user_output', [
                'user_id' => $id, 
                'access_output_id' => 3
            ]);
            $array = [
                'status' => 100, 
                'message' => 'The account has been activated successfully', 
                'osd' => (string)$this->osd, 
                'expire' => $this->expire_date($exp_date), 
                'user_agent' => trim($this->conf['user_agent']), 
                'code_id' => $id
            ];
            $this->msg($array, 'MasterCode User== ' . $dataUser['username']);
        }
        if( mysqli_num_rows($sql_code) == 1 ) 
        {
            $row = mysqli_fetch_array($sql_code);
            $this->user = $row['username'];
            $this->pass = $row['password'];
            $this->code_id = $row['id'];
            $status = intval($row['status']);
            $expire = date('Y-m-d', $row['date_expire']);
            if( $expire < date('Y-m-d') ) 
            {
                $status = 4;
            }
            switch( $status ) 
            {
                case 1:
                    $this->pass = uniqid();
                    mysqli_query($this->link, 'UPDATE `users` set `password`=\'' . $this->pass . '\' where `username`=\'' . trim($row['username']) . '\';');
                    $array = [
                        'status' => 100, 
                        'message' => 'The Code is active', 
                        'osd' => (string)$this->osd, 
                        'expire' => $this->expire_date($row['date_expire']), 
                        'user_agent' => trim($this->conf['user_agent']), 
                        'code_id' => $row['id']
                    ];
                    $this->msg($array, 'ReActivation');
                    break;
                case 2:
                    $this->reply(102, 'The Code is suspended', '@Suspended');
                    break;
                case 3:
                    $this->reply(103, 'The Code is Deleted', '@Deleted Code');
                    break;
                case 4:
                    $this->reply(104, 'The Code is Expired', '@Expired Code');
                    break;
            }
        }
        exit();
    }
    public function expire_date($exp_date)
    {
        if( $this->conf['expire_date_type'] == 'days' ) 
        {
            $datediff = $exp_date - time();
            $days = ceil($datediff / 86400);
            return $days . ' Days';
        }
        else
        {
            return date('Y-m-d', $exp_date);
        }
    }
    public function activate_new_code_on_same_box($row_new_code)
    {
        $sql = mysqli_query($this->link, 'SELECT id,code,userid,days,date_expire FROM solus_codes ' . (' WHERE status=1 AND inputBy=0 AND mac=\'' . $this->mac . '\' AND serial=\'' . $this->sn . '\';'));
        if( mysqli_num_rows($sql) > 0 ) 
        {
            $row = mysqli_fetch_array($sql);
            $code_id = $row['id'];
            $old_code = $row['code'];
            $date_expire = $row['date_expire'];
            $userid = $row['userid'];
            $sql_u = mysqli_query($this->link, 'SELECT id,username,exp_date from users where id = \'' . $userid . '\';');
            $row_u = mysqli_fetch_array($sql_u);
            $xlog = 'OLdcode=[' . $old_code . '] New Code = [' . $this->code . "]<br/>\n<br/>";
            $xlog .= ('OLD_CODE_date_expire=[' . $date_expire . '] OLD USER exp_date = [' . $row_u['exp_date'] . "]<br/>\n");
            $this->log($xlog);
            $new_expire_date = $date_expire + ($row_new_code['days']);
            $up1 = mysqli_query($this->link, 'update solus_codes set ' . (' status=1,mac=\'' . $this->mac . '\',serial=\'' . $this->sn . '\', ') . (' date_expire=\'' . $new_expire_date . '\',userid=\'' . $row_u['id'] . '\' ') . (' where code=\'' . $this->code . '\';'));
            $up2 = mysqli_query($this->link, 'update solus_codes set ' . (' status=5,mac=\'\',serial=\'\',code_replaced=\'' . $this->code . '\',date_expire=\'' . $new_expire_date . '\' where id=' . $code_id . ';'));
            $up3 = mysqli_query($this->link, 'UPDATE users set username=\'' . $this->code . '\',exp_date=\'' . $new_expire_date . '\' where id = \'' . $userid . '\';');
            $this->log('INSERT CODE on TOP of Code. ' . (' OLD=' . $old_code . ' NEW=' . $this->code . ' New Expiry = ') . date('Y-m-d', $new_expire_date));
            $array = [
                'status' => 100, 
                'message' => 'The account has been activated successfully', 
                'osd' => (string)$this->osd, 
                'expire' => $this->expire_date($new_expire_date)
            ];
            $this->msg($array, 'Success');
            exit();
        }
    }
    public function boolVerifyFree($code)
    {
        $sql_code = mysqli_query($this->link, 'SELECT c.code,c.date_expire,c.status,u.username, u.password FROM solus_codes_free c, users u ' . (' WHERE c.user=u.username AND c.code = \'' . $code . '\' AND c.serial=\'' . $this->sn . '\' AND c.mac=\'' . $this->mac . '\';'));
        if( mysqli_num_rows($sql_code) == 1 ) 
        {
            $this->bouquets = 1;
            return true;
        }
        return false;
    }
    public function get_bouquets()
    {
        $sql = mysqli_query($this->link, 'SELECT SQL_CACHE id FROM bouquets order by view_order asc;');
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $ar[] = $row['id'];
        }
        return $ar;
    }
    public function reply($status, $msg, $log)
    {
        $array = [
            'status' => $status, 
            'message' => $msg, 
            'osd' => '', 
            'expire' => 'NULL', 
            'user_agent' => 'NULL', 
            'code_id' => 'NULL'
        ];
        $this->msg($array, $log);
    }
    public function osd_dismiss()
    {
        $code_id = intval($this->code_id);
        mysqli_query($this->link, 'UPDATE solus_codes set osd_stat=1,osd_msg=\'\' WHERE id=' . $code_id . ';');
        $this->msg([
            'status' => 100, 
            'message' => 'success', 
            'id' => ''
        ]);
    }
    public function osd_get()
    {
        $code_id = intval($this->code_id);
        $read = intval($this->read);
        $qry = '';
        if( $code_id == 0 ) 
        {
            exit( 'error: please set code_id' );
        }
        $stat = [
            '2' => 'مرسلة', 
            'تمت القراءة'
        ];
        $result = mysqli_query($this->link, 'SELECT id,osd_msg FROM solus_codes WHERE id=' . $code_id . ';');
        $found = intval(mysqli_num_rows($result));
        if( $found == 1 ) 
        {
            $row = mysqli_fetch_array($result);
            $id = $row['id'];
            $osd_msg = $row['osd_msg'];
            $this->msg([
                'status' => 100, 
                'message' => $osd_msg
            ]);
        }
        else
        {
            $this->msg([
                'status' => 0, 
                'message' => 'no_osd_message'
            ]);
        }
    }
    public function osd()
    {
        $code_id = intval($this->code_id);
        $read = intval($this->read);
        $qry = '';
        $stat = [
            '2' => 'مرسلة', 
            'تمت القراءة'
        ];
        if( $read == 1 ) 
        {
            $reply = trim($this->reply);
            if( $reply != '' ) 
            {
                $result = mysqli_query($this->link, 'SELECT osd_msg FROM solus_codes WHERE code=\'' . $this->code . '\' AND id=' . $code_id . ';');
                $row = mysqli_fetch_array($result);
                $reply = $row['osd_msg'] . '\n\n\n at' . DATE('Y-m-d H:i:s') . '\n\n User Reply:\n\n ' . $reply;
                mysqli_query($this->link, 'UPDATE solus_codes set osd_msg=\'' . $reply . '\' WHERE id=' . $code_id . ' AND code=\'' . $this->code . '\';');
            }
            mysqli_query($this->link, 'UPDATE solus_codes set osd_stat=1 WHERE id=' . $code_id . ' AND code=\'' . $this->code . '\';');
            exit();
        }
        $result = mysqli_query($this->link, 'SELECT id,osd_msg FROM solus_codes WHERE osd_stat=2 AND code=\'' . $this->code . '\' AND id=' . $code_id . ';');
        $found = intval(mysqli_num_rows($result));
        if( $found == 1 ) 
        {
            $row = mysqli_fetch_array($result);
            $id = $row['id'];
            $osd_msg = $row['osd_msg'];
            $this->msg([
                'status' => 100, 
                'message' => $osd_msg, 
                'id' => $id
            ]);
        }
        else
        {
            exit( 'not found in db.' );
        }
    }
    public function insert($tableName, $insData = [])
    {
        $columns = implode(', ', array_keys($insData));
        $filtered = [];
        foreach( $insData as $idx => $data ) 
        {
            $filtered[$idx] = '\'' . mysqli_real_escape_string($this->link, $data) . '\'';
        }
        $values = implode(', ', $filtered);
        mysqli_query($this->link, 'INSERT INTO ' . $tableName . ' (' . $columns . ') VALUES (' . $values . ')');
        return mysqli_insert_id($this->link);
    }
    public function get_free_codes()
    {
        $sql = mysqli_query($this->link, 'select * from solus_free_code;');
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $this->free_codes[] = trim($row['code']);
        }
    }
    public function config()
    {
        global $_CFG;
        $replace = false;
        if( isset($_CFG['strm_url_rep']) && $_CFG['strm_url_rep'] != '' && isset($_CFG['strm_url_with']) && $_CFG['strm_url_with'] != '' ) 
        {
            $replace = true;
        }
        $sql = mysqli_query($this->link, 'select * from solus_options');
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $op_name = trim($row['name']);
            $val = trim($row['val']);
            if( $replace && ($op_name == 'iptv_host' || $op_name == 'iptv_host_vods') ) 
            {
                $val = str_replace($_CFG['strm_url_rep'], $_CFG['strm_url_with'], $val);
            }
            $this->conf[$op_name] = $val;
        }
    }
    public function log($thelog)
    {
        $file = basename($_SERVER['SCRIPT_FILENAME'], '.php');
        $fullDATA = '';
        $currentDomain = preg_replace('/www\./i', '', $_SERVER['SERVER_NAME']);
        $userAgent = (isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '');
        $data = [];
        if( isset($_POST['data']) && is_array($_POST['data']) ) 
        {
            $fullDATA = var_export($_POST['data'], true);
        }
        $data['ver'] = str_replace('API-', '', $file);
        $data['dtime'] = time();
        $data['thelog'] = $thelog . '';
        $data['ip'] = $this->ip();
        $data['code'] = $this->code;
        $data['serial'] = $this->sn;
        $data['mac'] = $this->mac;
        $data['model'] = $this->model;
        $data['adminid'] = 0;
        $data['uagent'] = $userAgent . (' | ' . $currentDomain . '<hr>' . $fullDATA . ' ');
        $this->insert('' . PREFIX . '_logs', $data);
    }
    public function connect()
    {
        if( file_exists('../includes/Config.php') ) 
        {
            require_once('../includes/Config.php');
        }
        $host = $config['db']['hostname'];
        $user = $config['db']['username'];
        $pass = $config['db']['password'];
        $db = $config['db']['database'];
        $port = $config['db']['port'] . '';
        $this->link = mysqli_init();
        if( !$this->link ) 
        {
            exit( 'mysqli_init failed' );
        }
        if( strlen($port) > 3 ) 
        {
            if( !mysqli_real_connect($this->link, $host, $user, $pass, $db, intval($port)) ) 
            {
                exit( 'Connect Error (' . mysqli_connect_errno() . ') ' . mysqli_connect_error() );
            }
        }
        else if( !mysqli_real_connect($this->link, $host, $user, $pass, $db) ) 
        {
            exit( 'Connect Error (' . mysqli_connect_errno() . ') ' . mysqli_connect_error() );
        }
        @mysqli_query($this->link, 'SET CHARACTER SET utf8;');
        @mysqli_query($this->link, 'SET sql_mode = \'\';');
        if( !defined('PREFIX') ) 
        {
            define('PREFIX', 'solus');
        }
    }
    public function random_number($length)
    {
        $random = substr(number_format(time() * rand(), 0, '', ''), 0, $length);
        return $random;
    }
    public function generateRandomString($length = 10)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for( $i = 0; $i < $length; $i++ ) 
        {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    public function msg($array, $msg = '', $cache_file = '')
    {
        global $_CFG;
        $this->html_header();
        $data = json_encode($array, JSON_UNESCAPED_SLASHES);
        if( $cache_file != '' && $this->cache ) 
        {
            $this->cache_file($data, $cache_file, true);
        }
        if( $msg != '' ) 
        {
            $this->log($msg);
        }
        echo $this->runXOR($data);
        exit();
    }
    public function html_header()
    {
        if( !headers_sent() ) 
        {
            header('Content-Type: text/plain; charset=utf-8');
        }
    }
    public function capture()
    {
        if( trim($this->conf['capture_ip']) != '' && trim($this->conf['capture_ip']) == $this->ip ) 
        {
            $data = '';
            foreach( $_POST['data'] as $key => $val ) 
            {
                $data .= ('<li>' . $key . ' = ');
                if( is_array($val) ) 
                {
                    $data .= '<ul>';
                    foreach( $val as $key2 => $val2 ) 
                    {
                        $data .= ('<li>' . $key2 . ' = ' . $val2 . '</li>');
                    }
                    $data .= '</ul>';
                }
                else
                {
                    $data .= (' ' . $val . ' ');
                }
                $data .= '</li>';
            }
            $data .= '<hr>';
            $vars = [
                'HTTP_HOST', 
                'HTTP_USER_AGENT', 
                'CONTENT_TYPE', 
                'REQUEST_URI', 
                'SCRIPT_NAME'
            ];
            foreach( $vars as $key ) 
            {
                $val = (isset($_SERVER[$key]) ? $_SERVER[$key] : '');
                $data .= ('<li>' . $key . ' = ' . $val . '</li>');
            }
            foreach( $_POST as $key => $val ) 
            {
                $data .= ('<li>' . $key . ' = ');
            }
            $this->insert('solus_logs_sys', [
                'dtime' => date('Y-m-d H:i:s'), 
                'admin_user' => 'capture', 
                'app' => 'V6', 
                'ip' => $this->ip, 
                'action' => 'capture', 
                'the_log' => $data
            ]);
        }
    }
    public function error($msg, $log = '')
    {
        $array = [
            'status' => 9, 
            'message' => $msg, 
            'osd' => '', 
            'expire' => '', 
            'user_agent' => '', 
            'code_id' => 0
        ];
        $this->msg($array, $log);
    }
    public function ip()
    {
        if( !empty($_SERVER['HTTP_CLIENT_IP']) ) 
        {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        }
        else if( !empty($_SERVER['HTTP_X_FORWARDED_FOR']) ) 
        {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        }
        else
        {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        if( strpos($ip, ',') !== false ) 
        {
            $x = explode(',', $ip);
            $ip = trim($x[0]);
        }
        return $ip;
    }
// Replace the runXOR method in API6Core.php with this version

public function runXOR($InputString)
{
    global $_CFG;
    $KeyPhrase = $_CFG['XOR_KEY'];
    
    if ($KeyPhrase == '') {
        exit('error: please set xor key.');
    }
    
    $KeyPhraseLength = strlen($KeyPhrase);
    $output = '';
    
    for ($i = 0; $i < strlen($InputString); $i++) {
        $rPos = $i % $KeyPhraseLength;
        $r = ord($InputString[$i]) ^ ord($KeyPhrase[$rPos]);
        $output .= chr($r);
    }
    
    return $output;
}
    public function cache_display($file, $CacheForChannels = false)
    {
        global $_CFG;
        $file = 'cache/' . $file;
        if( !file_exists($file) ) 
        {
            return null;
        }
        if( filemtime($file) < (time() - $this->cache_time) ) 
        {
            return null;
        }
        if( $CacheForChannels ) 
        {
            $data = file_get_contents($file);
            $data = str_replace([
                '{XuserX}', 
                '{XpassX}'
            ], [
                $this->user, 
                $this->pass
            ], $data);
        }
        else
        {
            $data = file_get_contents($file);
        }
        $this->html_header();
        echo $this->runXOR($data);
        exit();
    }
    public function cache_file($content, $file, $CacheForChannels = false)
    {
        if( $CacheForChannels ) 
        {
            $content = str_replace([
                $this->user, 
                $this->pass
            ], [
                '{XuserX}', 
                '{XpassX}'
            ], $content);
        }
        $file = 'cache/' . $file;
        if( file_put_contents($file, $content, LOCK_EX) === false ) 
        {
            @unlink($file);
        }
    }
    public function query($sql)
    {
        $res = @mysqli_query($this->link, $sql);
        if( $this->link->error != '' ) 
        {
            $err = date('Y-m-d H:i:s');
            $err .= (' SQL = ' . $sql . "\n");
            $err .= (' Error = ' . $this->link->error);
            $err .= "\n";
            $this->logfile($err);
        }
        return $res;
    }
    public function logfile($data)
    {
        if( !is_dir('./cache/') ) 
        {
            return null;
        }
        if( !is_writable('./cache/') ) 
        {
            return null;
        }
        $date = date('Y-m-d H:i:s');
        $log_file = './cache/error_' . date('Y-m') . md5(date('Y-m') . 'HiMama') . '.log';
        $data .= "\n\n";
        $backtrace = '';
        @file_put_contents($log_file, $data, FILE_APPEND | LOCK_EX);
    }
}