# App Not Working - Double URL Decode Bug Fix

## Problem

The mobile app was not working and returning error:
```json
{
  "error": "error: converting json data. Data you sent is: {\"code\":\"236825115603\"...",
  "status": 999
}
```

The app could send requests but the API couldn't parse the decrypted JSON data.

## Root Cause

**Double URL-Decoding Bug** in `/var/www/html/iptv/V6APK/API-V6APK.php` at line 103.

### The Bug
```php
// WRONG - Line 103 (before fix)
$encryptedData = urldecode($_POST['json']);
$jsonRow = $this->runXOR($encryptedData);
```

**Why it's wrong:**
- PHP automatically URL-decodes all `$_POST` parameters when processing the request
- Calling `urldecode()` again causes **double URL-decoding**
- This corrupts the encrypted data, making XOR decryption fail

### Example of Double Decoding Issue
```
Original encrypted data: "%20" (URL-encoded space)
↓ PHP automatic decode: " " (space character)
↓ Manual urldecode(): " " (space character - no change this time)

But for special chars:
Original: "%25" (URL-encoded percent sign)
↓ PHP automatic decode: "%" (percent sign)
↓ Manual urldecode(): (tries to interpret % as URL encoding, corruption!)
```

## Solution

Removed the redundant `urldecode()` call:

```php
// CORRECT - Line 103-105 (after fix)
// PHP already URL-decodes $_POST data, so don't decode again
$encryptedData = $_POST['json'];
$jsonRow = $this->runXOR($encryptedData);
```

### File Changed
- `/var/www/html/iptv/V6APK/API-V6APK.php` (Line 103-104)

## Verification

### Test 1: Actual App Request
```bash
curl -X POST http://45.154.207.45/iptv/V6APK/API-V6APK.php \
  -H "Content-Type: application/x-www-form-urlencoded" \
  -H "User-Agent: okhttp/3.10.0" \
  -d 'json=0T%1656%08%11%0C%17EX%03kH...'
```

**Result:** ✅ Status 100, properly encrypted response

### Test 2: Active Mode (Authentication)
**Request:**
```json
{
  "code": "236825115603",
  "mac": "8c:fd:f0:00:7f:0b",
  "mode": "active",
  "token": "177e599ba4a256692f2d38326279c1ae..."
}
```

**Response:**
```json
{
  "status": 100,
  "message": "The Code is active",
  "username": "236825115603",
  "password": "1475899348690bd9e230799",
  "expire": "2025-11-09",
  "host": "http://45.154.207.117:8000",
  "player_api": "http://45.154.207.117:8000/player_api.php",
  ...
}
```

✅ All modes working:
- active (User activation)
- movies_cat (Movie categories)
- movies_latest (Latest movies)
- movies_list (Movies by category)
- series_cat (Series categories)
- series_latest (Latest series)
- series_list (Series by category)
- packages (Available packages)

## Technical Details

### Request Flow (After Fix)
```
1. App encodes JSON with XOR
2. App URL-encodes the encrypted data
3. App sends as: json=<url_encoded_encrypted_data>

4. PHP receives POST request
5. PHP automatically URL-decodes: $_POST['json'] = <encrypted_data>
6. API uses $_POST['json'] directly (no double decode!)
7. API XOR-decrypts to get original JSON
8. API processes request
9. API XOR-encrypts response
10. App receives and XOR-decrypts response
```

### Key Points
- `$_POST` variables are **already URL-decoded** by PHP
- Never call `urldecode()` on `$_POST` or `$_GET` parameters
- Only use `urldecode()` on raw data from `php://input` or manually parsed query strings

## Impact

This fix resolves:
- ✅ App authentication (active mode)
- ✅ All content browsing modes
- ✅ MidnightStreamer integration
- ✅ XOR encryption/decryption flow
- ✅ Token-based authentication

## Date Fixed
2025-11-07

## Related Issues
- Initial issue: "responses encrypted error app not work" (Fixed by adding XOR encryption to Movies class)
- This issue: "app not working" (Fixed by removing double URL-decode)
