# MidnightStreamer Integration Documentation

## Overview

The V6APK API now fetches data from MidnightStreamer panel and transforms it to match the app-API format.

## Configuration

### Database Settings
```sql
UPDATE solus_options SET val='1' WHERE name='remote_movies_use';
UPDATE solus_options SET val='http://45.154.207.117:8000/api/player' WHERE name='remote_movies_api';
```

### Files
- `/var/www/html/iptv/V6APK/MidnightStreamerAdapter.php` - Main adapter class
- `/var/www/html/iptv/V6APK/API6Core.php` - Modified to use adapter
- `/var/www/html/iptv/V6APK/API-V6APK.php` - Main API file

## Data Flow

```
App Request (XOR Encrypted)
    ↓
V6APK API (Token Authentication)
    ↓
MidnightStreamer Adapter
    ↓
MidnightStreamer Panel (http://45.154.207.117:8000)
    ↓
Transform to App Format
    ↓
Return XOR Encrypted Response
```

## Supported Modes

### 1. Active (Authentication)
**Request:**
```json
{
  "code": "236825115603",
  "mac": "8c:fd:f0:00:7f:0b",
  "sn": "8c:fd:f0:00:7f:0b",
  "model": "SM-N975F",
  "group": 1,
  "token": "...",
  "mode": "active"
}
```

**Response:**
```json
{
  "status": 100,
  "server_name": "V6apk",
  "message": "The Code is active",
  "username": "236825115603",
  "password": "1475899348690bd9e230799",
  "expire": "2025-11-09",
  "max_connections": "1",
  "host": "http://45.154.207.117:8000",
  "player_api": "http://45.154.207.117:8000/player_api.php",
  ...
}
```

### 2. Movies Latest
**MidnightStreamer:** `GET /api/player/{user}/{pass}/vod/streams`

**Transformed Response:**
```json
[
  {
    "id": "387463",
    "title": "Movie Name",
    "catid": "43",
    "icon": "https://image.tmdb.org/t/p/...",
    "stream_url": "http://45.154.207.117:8000/movie/user/pass/387463.mp4"
  }
]
```

### 3. Movie Categories
**MidnightStreamer:** `GET /api/player/{user}/{pass}/vod/categories`

**Transformed Response:**
```json
[
  {
    "id": "1",
    "category_name": "Action",
    "category_type": 1,
    "category_icon": "http://...",
    "view_order": 1
  }
]
```

### 4. Series Latest
**MidnightStreamer:** `GET /api/player/{user}/{pass}/series_cat`

**Transformed Response:**
```json
[
  {
    "id": "1",
    "title": "Breaking Bad",
    "catid": "1",
    "cover": "https://image.tmdb.org/t/p/...",
    "genre": "Crime, Drama",
    "rating": 10
  }
]
```

### 5. Packages (Live Categories)
**MidnightStreamer:** `GET /api/player/{user}/{pass}/live/categories`

**Transformed Response:**
```json
[
  {
    "id": "1",
    "category_name": "Sports",
    "category_type": 0,
    "view_order": 1
  }
]
```

## Adapter Class Methods

```php
class MidnightStreamerAdapter {
    // Main methods
    public function authenticate()
    public function getLatestMovies($limit = 50)
    public function getMoviesByCategory($category_id)
    public function getMovieCategories()
    public function getLatestSeries($limit = 50)
    public function getSeriesCategories()
    public function getLiveCategories()
    
    // Transformation methods
    private function transformAuth($data)
    private function transformMovies($data)
    private function transformSeries($data)
    private function transformCategories($data, $type)
}
```

## Testing

```bash
php /var/www/html/iptv/V6APK/test_midnight.php
```

## Stream URL Format

### Movies
```
http://45.154.207.117:8000/movie/{username}/{password}/{stream_id}.mp4
```

### Series
```
http://45.154.207.117:8000/series/{username}/{password}/{stream_id}.mp4
```

### Live
```
http://45.154.207.117:8000/live/{username}/{password}/{stream_id}.ts
```

## Caching

The adapter respects the cache settings from API6Core:
- Cache time: 3600 seconds (configurable)
- Cache location: `./cache/`
- Cache enabled: Yes (configurable)

## Error Handling

The adapter returns empty arrays or error responses on failure:
- Connection timeout: 10 seconds
- Request timeout: 30 seconds
- SSL verification: Disabled (for testing)

## Notes

1. XOR encryption/decryption is handled by the main API
2. Token authentication validates before calling MidnightStreamer
3. All responses are JSON encoded
4. MidnightStreamer credentials come from authenticated user

## Troubleshooting

### Issue: Empty responses
**Solution:** Check MidnightStreamer panel is accessible:
```bash
curl http://45.154.207.117:8000/api/player/{user}/{pass}
```

### Issue: Invalid credentials
**Solution:** Verify user exists in both databases:
```sql
SELECT username, password FROM users WHERE id=24;
```

### Issue: Timeout
**Solution:** Increase timeout in MidnightStreamerAdapter.php:
```php
curl_setopt($ch, CURLOPT_TIMEOUT, 60); // Increase to 60 seconds
```
