#!/bin/bash
# Add token directly via MySQL command

if [ $# -lt 2 ]; then
    echo "Usage: ./add_token_sql.sh <username> <token>"
    echo ""
    echo "Example:"
    echo "./add_token_sql.sh 426687097695 \"f3ed71d56579442cbdc114e8f77e57b4...\""
    exit 1
fi

USERNAME="$1"
TOKEN="$2"
DB_USER="root"
DB_PASS="1231231"
DB_NAME="xtream_iptvpro"

echo "Adding Token via SQL"
echo "======================================================================"
echo ""

# Get user ID
USER_ID=$(mysql -u $DB_USER -p$DB_PASS $DB_NAME -sN -e "SELECT id FROM users WHERE username = '$USERNAME'")

if [ -z "$USER_ID" ]; then
    echo "❌ User '$USERNAME' not found!"
    exit 1
fi

echo "✅ Found user: $USERNAME (ID: $USER_ID)"

# Check if token exists
TOKEN_EXISTS=$(mysql -u $DB_USER -p$DB_PASS $DB_NAME -sN -e "SELECT COUNT(*) FROM user_tokens WHERE token = '$TOKEN'")

if [ "$TOKEN_EXISTS" -gt 0 ]; then
    echo "⚠️  Token already exists in database!"
    exit 0
fi

# Calculate timestamps
CREATED=$(date +%s)
EXPIRES=$((CREATED + 604800))  # 7 days

# Insert token
mysql -u $DB_USER -p$DB_PASS $DB_NAME -e "
INSERT INTO user_tokens (user_id, token, created, expires, ip, user_agent)
VALUES ($USER_ID, '$TOKEN', $CREATED, $EXPIRES, '127.0.0.1', 'Manual SQL Entry');
"

if [ $? -eq 0 ]; then
    echo "✅ Token added successfully!"
    echo ""
    echo "Details:"
    echo "  User ID: $USER_ID"
    echo "  Created: $(date -d @$CREATED '+%Y-%m-%d %H:%M:%S')"
    echo "  Expires: $(date -d @$EXPIRES '+%Y-%m-%d %H:%M:%S')"
    echo ""
    echo "✅ Token is ready to use!"
else
    echo "❌ Failed to add token"
    exit 1
fi

echo ""
echo "======================================================================"
