<?php 
class AES
{
    private static $Nb = 4;
    private $Nk = null;
    private $Nr = null;
    private static $sBox = [
        99, 
        124, 
        119, 
        123, 
        242, 
        107, 
        111, 
        197, 
        48, 
        1, 
        103, 
        43, 
        254, 
        215, 
        171, 
        118, 
        202, 
        130, 
        201, 
        125, 
        250, 
        89, 
        71, 
        240, 
        173, 
        212, 
        162, 
        175, 
        156, 
        164, 
        114, 
        192, 
        183, 
        253, 
        147, 
        38, 
        54, 
        63, 
        247, 
        204, 
        52, 
        165, 
        229, 
        241, 
        113, 
        216, 
        49, 
        21, 
        4, 
        199, 
        35, 
        195, 
        24, 
        150, 
        5, 
        154, 
        7, 
        18, 
        128, 
        226, 
        235, 
        39, 
        178, 
        117, 
        9, 
        131, 
        44, 
        26, 
        27, 
        110, 
        90, 
        160, 
        82, 
        59, 
        214, 
        179, 
        41, 
        227, 
        47, 
        132, 
        83, 
        209, 
        0, 
        237, 
        32, 
        252, 
        177, 
        91, 
        106, 
        203, 
        190, 
        57, 
        74, 
        76, 
        88, 
        207, 
        208, 
        239, 
        170, 
        251, 
        67, 
        77, 
        51, 
        133, 
        69, 
        249, 
        2, 
        127, 
        80, 
        60, 
        159, 
        168, 
        81, 
        163, 
        64, 
        143, 
        146, 
        157, 
        56, 
        245, 
        188, 
        182, 
        218, 
        33, 
        16, 
        255, 
        243, 
        210, 
        205, 
        12, 
        19, 
        236, 
        95, 
        151, 
        68, 
        23, 
        196, 
        167, 
        126, 
        61, 
        100, 
        93, 
        25, 
        115, 
        96, 
        129, 
        79, 
        220, 
        34, 
        42, 
        144, 
        136, 
        70, 
        238, 
        184, 
        20, 
        222, 
        94, 
        11, 
        219, 
        224, 
        50, 
        58, 
        10, 
        73, 
        6, 
        36, 
        92, 
        194, 
        211, 
        172, 
        98, 
        145, 
        149, 
        228, 
        121, 
        231, 
        200, 
        55, 
        109, 
        141, 
        213, 
        78, 
        169, 
        108, 
        86, 
        244, 
        234, 
        101, 
        122, 
        174, 
        8, 
        186, 
        120, 
        37, 
        46, 
        28, 
        166, 
        180, 
        198, 
        232, 
        221, 
        116, 
        31, 
        75, 
        189, 
        139, 
        138, 
        112, 
        62, 
        181, 
        102, 
        72, 
        3, 
        246, 
        14, 
        97, 
        53, 
        87, 
        185, 
        134, 
        193, 
        29, 
        158, 
        225, 
        248, 
        152, 
        17, 
        105, 
        217, 
        142, 
        148, 
        155, 
        30, 
        135, 
        233, 
        206, 
        85, 
        40, 
        223, 
        140, 
        161, 
        137, 
        13, 
        191, 
        230, 
        66, 
        104, 
        65, 
        153, 
        45, 
        15, 
        176, 
        84, 
        187, 
        22
    ];
    private static $invSBox = [
        82, 
        9, 
        106, 
        213, 
        48, 
        54, 
        165, 
        56, 
        191, 
        64, 
        163, 
        158, 
        129, 
        243, 
        215, 
        251, 
        124, 
        227, 
        57, 
        130, 
        155, 
        47, 
        255, 
        135, 
        52, 
        142, 
        67, 
        68, 
        196, 
        222, 
        233, 
        203, 
        84, 
        123, 
        148, 
        50, 
        166, 
        194, 
        35, 
        61, 
        238, 
        76, 
        149, 
        11, 
        66, 
        250, 
        195, 
        78, 
        8, 
        46, 
        161, 
        102, 
        40, 
        217, 
        36, 
        178, 
        118, 
        91, 
        162, 
        73, 
        109, 
        139, 
        209, 
        37, 
        114, 
        248, 
        246, 
        100, 
        134, 
        104, 
        152, 
        22, 
        212, 
        164, 
        92, 
        204, 
        93, 
        101, 
        182, 
        146, 
        108, 
        112, 
        72, 
        80, 
        253, 
        237, 
        185, 
        218, 
        94, 
        21, 
        70, 
        87, 
        167, 
        141, 
        157, 
        132, 
        144, 
        216, 
        171, 
        0, 
        140, 
        188, 
        211, 
        10, 
        247, 
        228, 
        88, 
        5, 
        184, 
        179, 
        69, 
        6, 
        208, 
        44, 
        30, 
        143, 
        202, 
        63, 
        15, 
        2, 
        193, 
        175, 
        189, 
        3, 
        1, 
        19, 
        138, 
        107, 
        58, 
        145, 
        17, 
        65, 
        79, 
        103, 
        220, 
        234, 
        151, 
        242, 
        207, 
        206, 
        240, 
        180, 
        230, 
        115, 
        150, 
        172, 
        116, 
        34, 
        231, 
        173, 
        53, 
        133, 
        226, 
        249, 
        55, 
        232, 
        28, 
        117, 
        223, 
        110, 
        71, 
        241, 
        26, 
        113, 
        29, 
        41, 
        197, 
        137, 
        111, 
        183, 
        98, 
        14, 
        170, 
        24, 
        190, 
        27, 
        252, 
        86, 
        62, 
        75, 
        198, 
        210, 
        121, 
        32, 
        154, 
        219, 
        192, 
        254, 
        120, 
        205, 
        90, 
        244, 
        31, 
        221, 
        168, 
        51, 
        136, 
        7, 
        199, 
        49, 
        177, 
        18, 
        16, 
        89, 
        39, 
        128, 
        236, 
        95, 
        96, 
        81, 
        127, 
        169, 
        25, 
        181, 
        74, 
        13, 
        45, 
        229, 
        122, 
        159, 
        147, 
        201, 
        156, 
        239, 
        160, 
        224, 
        59, 
        77, 
        174, 
        42, 
        245, 
        176, 
        200, 
        235, 
        187, 
        60, 
        131, 
        83, 
        153, 
        97, 
        23, 
        43, 
        4, 
        126, 
        186, 
        119, 
        214, 
        38, 
        225, 
        105, 
        20, 
        99, 
        85, 
        33, 
        12, 
        125
    ];
    private static $ltable = [
        0, 
        255, 
        200, 
        8, 
        145, 
        16, 
        208, 
        54, 
        90, 
        62, 
        216, 
        67, 
        153, 
        119, 
        254, 
        24, 
        35, 
        32, 
        7, 
        112, 
        161, 
        108, 
        12, 
        127, 
        98, 
        139, 
        64, 
        70, 
        199, 
        75, 
        224, 
        14, 
        235, 
        22, 
        232, 
        173, 
        207, 
        205, 
        57, 
        83, 
        106, 
        39, 
        53, 
        147, 
        212, 
        78, 
        72, 
        195, 
        43, 
        121, 
        84, 
        40, 
        9, 
        120, 
        15, 
        33, 
        144, 
        135, 
        20, 
        42, 
        169, 
        156, 
        214, 
        116, 
        180, 
        124, 
        222, 
        237, 
        177, 
        134, 
        118, 
        164, 
        152, 
        226, 
        150, 
        143, 
        2, 
        50, 
        28, 
        193, 
        51, 
        238, 
        239, 
        129, 
        253, 
        48, 
        92, 
        19, 
        157, 
        41, 
        23, 
        196, 
        17, 
        68, 
        140, 
        128, 
        243, 
        115, 
        66, 
        30, 
        29, 
        181, 
        240, 
        18, 
        209, 
        91, 
        65, 
        162, 
        215, 
        44, 
        233, 
        213, 
        89, 
        203, 
        80, 
        168, 
        220, 
        252, 
        242, 
        86, 
        114, 
        166, 
        101, 
        47, 
        159, 
        155, 
        61, 
        186, 
        125, 
        194, 
        69, 
        130, 
        167, 
        87, 
        182, 
        163, 
        122, 
        117, 
        79, 
        174, 
        63, 
        55, 
        109, 
        71, 
        97, 
        190, 
        171, 
        211, 
        95, 
        176, 
        88, 
        175, 
        202, 
        94, 
        250, 
        133, 
        228, 
        77, 
        138, 
        5, 
        251, 
        96, 
        183, 
        123, 
        184, 
        38, 
        74, 
        103, 
        198, 
        26, 
        248, 
        105, 
        37, 
        179, 
        219, 
        189, 
        102, 
        221, 
        241, 
        210, 
        223, 
        3, 
        141, 
        52, 
        217, 
        146, 
        13, 
        99, 
        85, 
        170, 
        73, 
        236, 
        188, 
        149, 
        60, 
        132, 
        11, 
        245, 
        230, 
        231, 
        229, 
        172, 
        126, 
        110, 
        185, 
        249, 
        218, 
        142, 
        154, 
        201, 
        36, 
        225, 
        10, 
        21, 
        107, 
        58, 
        160, 
        81, 
        244, 
        234, 
        178, 
        151, 
        158, 
        93, 
        34, 
        136, 
        148, 
        206, 
        25, 
        1, 
        113, 
        76, 
        165, 
        227, 
        197, 
        49, 
        187, 
        204, 
        31, 
        45, 
        59, 
        82, 
        111, 
        246, 
        46, 
        137, 
        247, 
        192, 
        104, 
        27, 
        100, 
        4, 
        6, 
        191, 
        131, 
        56
    ];
    private static $atable = [
        1, 
        229, 
        76, 
        181, 
        251, 
        159, 
        252, 
        18, 
        3, 
        52, 
        212, 
        196, 
        22, 
        186, 
        31, 
        54, 
        5, 
        92, 
        103, 
        87, 
        58, 
        213, 
        33, 
        90, 
        15, 
        228, 
        169, 
        249, 
        78, 
        100, 
        99, 
        238, 
        17, 
        55, 
        224, 
        16, 
        210, 
        172, 
        165, 
        41, 
        51, 
        89, 
        59, 
        48, 
        109, 
        239, 
        244, 
        123, 
        85, 
        235, 
        77, 
        80, 
        183, 
        42, 
        7, 
        141, 
        255, 
        38, 
        215, 
        240, 
        194, 
        126, 
        9, 
        140, 
        26, 
        106, 
        98, 
        11, 
        93, 
        130, 
        27, 
        143, 
        46, 
        190, 
        166, 
        29, 
        231, 
        157, 
        45, 
        138, 
        114, 
        217, 
        241, 
        39, 
        50, 
        188, 
        119, 
        133, 
        150, 
        112, 
        8, 
        105, 
        86, 
        223, 
        153, 
        148, 
        161, 
        144, 
        24, 
        187, 
        250, 
        122, 
        176, 
        167, 
        248, 
        171, 
        40, 
        214, 
        21, 
        142, 
        203, 
        242, 
        19, 
        230, 
        120, 
        97, 
        63, 
        137, 
        70, 
        13, 
        53, 
        49, 
        136, 
        163, 
        65, 
        128, 
        202, 
        23, 
        95, 
        83, 
        131, 
        254, 
        195, 
        155, 
        69, 
        57, 
        225, 
        245, 
        158, 
        25, 
        94, 
        182, 
        207, 
        75, 
        56, 
        4, 
        185, 
        43, 
        226, 
        193, 
        74, 
        221, 
        72, 
        12, 
        208, 
        125, 
        61, 
        88, 
        222, 
        124, 
        216, 
        20, 
        107, 
        135, 
        71, 
        232, 
        121, 
        132, 
        115, 
        60, 
        189, 
        146, 
        201, 
        35, 
        139, 
        151, 
        149, 
        68, 
        220, 
        173, 
        64, 
        101, 
        134, 
        162, 
        164, 
        204, 
        127, 
        236, 
        192, 
        175, 
        145, 
        253, 
        247, 
        79, 
        129, 
        47, 
        91, 
        234, 
        168, 
        28, 
        2, 
        209, 
        152, 
        113, 
        237, 
        37, 
        227, 
        36, 
        6, 
        104, 
        179, 
        147, 
        44, 
        111, 
        62, 
        108, 
        10, 
        184, 
        206, 
        174, 
        116, 
        177, 
        66, 
        180, 
        30, 
        211, 
        73, 
        233, 
        156, 
        200, 
        198, 
        199, 
        34, 
        110, 
        219, 
        32, 
        191, 
        67, 
        81, 
        82, 
        102, 
        178, 
        118, 
        96, 
        218, 
        197, 
        243, 
        246, 
        170, 
        205, 
        154, 
        160, 
        117, 
        84, 
        14, 
        1
    ];
    private $w = null;
    private $s = null;
    private $keyLength = null;
    public function __construct($z)
    {
        $this->Nk = strlen($z) / 4;
        $this->Nr = $this->Nk + self::$Nb + 2;
        if( $this->Nk != 4 && $this->Nk != 6 && $this->Nk != 8 ) 
        {
            exit( 'Key is ' . ($this->Nk * 32) . ' bits long. *not* 128, 192, or 256.' );
        }
        $this->Nr = $this->Nk + self::$Nb + 2;
        $this->w = [];
        $this->s = [
            []
        ];
        $this->KeyExpansion($z);
    }
    public function encrypt($x)
    {
        $t = '';
        $y = '';
        $xsize = strlen($x);
        for( $i = 0; $i < $xsize; $i += 16 ) 
        {
            for( $j = 0; $j < 16; $j++ ) 
            {
                if( $i + $j < $xsize ) 
                {
                    $t[$j] = $x[$i + $j];
                }
                else
                {
                    $t[$j] = chr(0);
                }
            }
            $y .= $this->encryptBlock($t);
        }
        return $y;
    }
    public function decrypt($y)
    {
        $t = '';
        $x = '';
        $ysize = strlen($y);
        for( $i = 0; $i < $ysize; $i += 16 ) 
        {
            for( $j = 0; $j < 16; $j++ ) 
            {
                if( $i + $j < $ysize ) 
                {
                    $t[$j] = $y[$i + $j];
                }
                else
                {
                    $t[$j] = chr(0);
                }
            }
            $x .= $this->decryptBlock($t);
        }
        return $x;
    }
    public function encryptBlock($x)
    {
        $y = '';
        for( $i = 0; $i < (4 * self::$Nb); $i++ ) 
        {
            $this->s[$i % 4][($i - ($i % self::$Nb)) / self::$Nb] = ord($x[$i]);
        }
        $this->addRoundKey(0);
        for( $i = 1; $i < $this->Nr; $i++ ) 
        {
            $this->subBytes();
            $this->shiftRows();
            $this->mixColumns();
            $this->addRoundKey($i);
        }
        $this->subBytes();
        $this->shiftRows();
        $this->addRoundKey($i);
        for( $i = 0; $i < (4 * self::$Nb); $i++ ) 
        {
            $y .= chr($this->s[$i % 4][($i - ($i % self::$Nb)) / self::$Nb]);
        }
        return $y;
    }
    public function decryptBlock($y)
    {
        $x = '';
        for( $i = 0; $i < (4 * self::$Nb); $i++ ) 
        {
            $this->s[$i % 4][($i - ($i % self::$Nb)) / self::$Nb] = ord($y[$i]);
        }
        $this->addRoundKey($this->Nr);
        for( $i = $this->Nr - 1; $i > 0; $i-- ) 
        {
            $this->invShiftRows();
            $this->invSubBytes();
            $this->addRoundKey($i);
            $this->invMixColumns();
        }
        $this->invShiftRows();
        $this->invSubBytes();
        $this->addRoundKey($i);
        for( $i = 0; $i < (4 * self::$Nb); $i++ ) 
        {
            $x .= ($this->s[$i % 4][($i - ($i % self::$Nb)) / self::$Nb] == chr(0) ? '' : chr($this->s[$i % 4][($i - ($i % self::$Nb)) / self::$Nb]));
        }
        return $x;
    }
    public function __destruct()
    {
        unset($this->w);
        unset($this->s);
    }
    private function KeyExpansion($z)
    {
        static $Rcon = [
            0, 
            16777216, 
            33554432, 
            67108864, 
            134217728, 
            268435456, 
            536870912, 
            1073741824, 
            2147483648, 
            452984832, 
            905969664, 
            1811939328, 
            3623878656, 
            2868903936, 
            1291845632, 
            2583691264, 
            788529152
        ];
        $temp = 0;
        for( $i = 0; $i < $this->Nk; $i++ ) 
        {
            $this->w[$i] = 0;
            $this->w[$i] = ord($z[4 * $i]);
            $this->w[$i] <<= 8;
            $this->w[$i] += ord($z[4 * $i + 1]);
            $this->w[$i] <<= 8;
            $this->w[$i] += ord($z[4 * $i + 2]);
            $this->w[$i] <<= 8;
            $this->w[$i] += ord($z[4 * $i + 3]);
        }
        while( $i < (self::$Nb * ($this->Nr + 1)) ) 
        {
            $temp = $this->w[$i - 1];
            if( $i % $this->Nk == 0 ) 
            {
                $temp = $this->subWord($this->rotWord($temp)) ^ $Rcon[$i / $this->Nk];
            }
            else if( $this->Nk > 6 && $i % $this->Nk == 4 ) 
            {
                $temp = $this->subWord($temp);
            }
            $this->w[$i] = $this->w[$i - $this->Nk] ^ $temp;
            self::make32BitWord($this->w[$i]);
            $i++;
        }
    }
    private function addRoundKey($round)
    {
        $temp = '';
        for( $i = 0; $i < 4; $i++ ) 
        {
            for( $j = 0; $j < self::$Nb; $j++ ) 
            {
                $temp = $this->w[$round * self::$Nb + $j] >> ((3 - $i) * 8);
                $temp %= 256;
                $temp = ($temp < 0 ? 256 + $temp : $temp);
                $this->s[$i][$j] ^= $temp;
            }
        }
    }
    private function invMixColumns()
    {
        $s0 = $s1 = $s2 = $s3 = '';
        for( $i = 0; $i < self::$Nb; $i++ ) 
        {
            $s0 = $this->s[0][$i];
            $s1 = $this->s[1][$i];
            $s2 = $this->s[2][$i];
            $s3 = $this->s[3][$i];
            $this->s[0][$i] = $this->mult(14, $s0) ^ $this->mult(11, $s1) ^ $this->mult(13, $s2) ^ $this->mult(9, $s3);
            $this->s[1][$i] = $this->mult(9, $s0) ^ $this->mult(14, $s1) ^ $this->mult(11, $s2) ^ $this->mult(13, $s3);
            $this->s[2][$i] = $this->mult(13, $s0) ^ $this->mult(9, $s1) ^ $this->mult(14, $s2) ^ $this->mult(11, $s3);
            $this->s[3][$i] = $this->mult(11, $s0) ^ $this->mult(13, $s1) ^ $this->mult(9, $s2) ^ $this->mult(14, $s3);
        }
    }
    private function invShiftRows()
    {
        $temp = '';
        for( $i = 1; $i < 4; $i++ ) 
        {
            for( $j = 0; $j < self::$Nb; $j++ ) 
            {
                $temp[($i + $j) % self::$Nb] = $this->s[$i][$j];
            }
            for( $j = 0; $j < self::$Nb; $j++ ) 
            {
                $this->s[$i][$j] = $temp[$j];
            }
        }
    }
    private function invSubBytes()
    {
        for( $i = 0; $i < 4; $i++ ) 
        {
            for( $j = 0; $j < self::$Nb; $j++ ) 
            {
                $this->s[$i][$j] = self::$invSBox[$this->s[$i][$j]];
            }
        }
    }
    private function mixColumns()
    {
        $s0 = $s1 = $s2 = $s3 = '';
        for( $i = 0; $i < self::$Nb; $i++ ) 
        {
            $s0 = $this->s[0][$i];
            $s1 = $this->s[1][$i];
            $s2 = $this->s[2][$i];
            $s3 = $this->s[3][$i];
            $this->s[0][$i] = $this->mult(2, $s0) ^ $this->mult(3, $s1) ^ $this->mult(1, $s2) ^ $this->mult(1, $s3);
            $this->s[1][$i] = $this->mult(1, $s0) ^ $this->mult(2, $s1) ^ $this->mult(3, $s2) ^ $this->mult(1, $s3);
            $this->s[2][$i] = $this->mult(1, $s0) ^ $this->mult(1, $s1) ^ $this->mult(2, $s2) ^ $this->mult(3, $s3);
            $this->s[3][$i] = $this->mult(3, $s0) ^ $this->mult(1, $s1) ^ $this->mult(1, $s2) ^ $this->mult(2, $s3);
        }
    }
    private function shiftRows()
    {
        $temp = '';
        for( $i = 1; $i < 4; $i++ ) 
        {
            for( $j = 0; $j < self::$Nb; $j++ ) 
            {
                $temp[$j] = $this->s[$i][($j + $i) % self::$Nb];
            }
            for( $j = 0; $j < self::$Nb; $j++ ) 
            {
                $this->s[$i][$j] = $temp[$j];
            }
        }
    }
    private function subBytes()
    {
        for( $i = 0; $i < 4; $i++ ) 
        {
            for( $j = 0; $j < self::$Nb; $j++ ) 
            {
                $this->s[$i][$j] = self::$sBox[$this->s[$i][$j]];
            }
        }
    }
    private static function mult($a, $b)
    {
        $sum = self::$ltable[$a] + self::$ltable[$b];
        $sum %= 255;
        $sum = self::$atable[$sum];
        return ($a == 0 ? 0 : ($b == 0 ? 0 : $sum));
    }
    private static function rotWord($w)
    {
        $temp = $w >> 24;
        $w <<= 8;
        self::make32BitWord($w);
        $temp = ($temp < 0 ? 256 + $temp : $temp);
        $w += $temp;
        return $w;
    }
    private static function subWord($w)
    {
        $temp = 0;
        for( $i = 0; $i < 4; $i++ ) 
        {
            $temp = $w >> 24;
            $temp = ($temp < 0 ? 256 + $temp : $temp);
            $w <<= 8;
            self::make32BitWord($w);
            $w += self::$sBox[$temp];
        }
        self::make32BitWord($w);
        return $w;
    }
    private static function make32BitWord(&$w)
    {
        $w &= 4294967295;
    }
}
