<?php
class Api_v6_settings_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $config_file = null;

    public function __construct($appname, $base)
    {
        global $intro;
        $this->admin = $intro->auth->sess_admin();
        $this->appname = $appname;
        $this->base = $base;
        $this->config_file = dirname(__FILE__) . '/../V6APK/api_cfg_v6.php';

        if (!in_array($this->admin['level'], [1, 9])) {
            exit('<h3>Error: you don\'t have permissions to access this file.</h3>');
        }
    }

    public function nav()
    {
        echo '<div class="app_nav">
            <a class="btn btn-primary" href="' . $this->base . '/index"><icon class="icon-cog"> API V6 Settings </icon></a>
        </div>';
    }

    public function index()
    {
        global $intro;
        $this->nav();

        // Show session messages
        if (isset($_SESSION['msg'])) {
            echo $_SESSION['msg'];
            unset($_SESSION['msg']);
        }

        // Load current config
        $config = $this->loadConfig();

        echo '<div class="panel panel-info">
            <div class="panel-heading"><i class="icon-cog"></i> API V6APK Settings</div>
            <div class="panel-body">';

        echo '<form method="POST" action="' . $this->base . '/doSave">
            <table class="table table-bordered table-hover">
                <tr>
                    <th colspan="2"><span>General Settings</span></th>
                </tr>
                <tr>
                    <td style="width:30%;">Portal Name:</td>
                    <td><input type="text" name="portalName" value="' . htmlspecialchars($config['portalName'] ?? 'LYNX') . '" class="form-control" /></td>
                </tr>
                <tr>
                    <td>Panel URL:</td>
                    <td><input type="text" name="panel_url" value="' . htmlspecialchars($config['panel_url'] ?? '') . '" class="form-control" placeholder="https://example.com:2087/" /></td>
                </tr>
                <tr>
                    <td>Stream Base URL:</td>
                    <td><input type="text" name="stream_base" value="' . htmlspecialchars($config['stream_base'] ?? '') . '" class="form-control" placeholder="http://example.com:80/" /></td>
                </tr>
                <tr>
                    <td>EPG Server:</td>
                    <td><input type="text" name="epg_server" value="' . htmlspecialchars($config['epg_server'] ?? '') . '" class="form-control" /></td>
                </tr>
                <tr>
                    <td>API Key:</td>
                    <td><input type="text" name="api_key" value="' . htmlspecialchars($config['api_key'] ?? '') . '" class="form-control" /></td>
                </tr>

                <tr>
                    <th colspan="2"><span>Connection Settings</span></th>
                </tr>
                <tr>
                    <td>Max Connections:</td>
                    <td><input type="number" name="max_connections" value="' . intval($config['max_connections'] ?? 1) . '" class="form-control" style="width:150px;" /></td>
                </tr>
                <tr>
                    <td>Restreamer Mode:</td>
                    <td>
                        <select name="restreamer" class="form-control" style="width:150px;">
                            <option value="0"' . (($config['restreamer'] ?? 0) == 0 ? ' selected' : '') . '>Disabled</option>
                            <option value="1"' . (($config['restreamer'] ?? 0) == 1 ? ' selected' : '') . '>Enabled</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>Allow M3U:</td>
                    <td>
                        <select name="allow_m3u" class="form-control" style="width:150px;">
                            <option value="1"' . (($config['allow_m3u'] ?? 1) == 1 ? ' selected' : '') . '>Yes</option>
                            <option value="0"' . (($config['allow_m3u'] ?? 1) == 0 ? ' selected' : '') . '>No</option>
                        </select>
                    </td>
                </tr>

                <tr>
                    <th colspan="2"><span>Encryption Settings</span></th>
                </tr>
                <tr>
                    <td>Enable XOR Encryption:</td>
                    <td>
                        <select name="XOR" class="form-control" style="width:150px;">
                            <option value="yes"' . (($config['XOR'] ?? 'yes') == 'yes' ? ' selected' : '') . '>Yes</option>
                            <option value="no"' . (($config['XOR'] ?? 'yes') == 'no' ? ' selected' : '') . '>No</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>XOR Key:</td>
                    <td><input type="text" name="XOR_KEY" value="' . htmlspecialchars($config['XOR_KEY'] ?? '') . '" class="form-control" /></td>
                </tr>
                <tr>
                    <td>Allow Direct JSON:</td>
                    <td>
                        <select name="allow_direct_json" class="form-control" style="width:150px;">
                            <option value="1"' . (($config['allow_direct_json'] ?? true) ? ' selected' : '') . '>Yes</option>
                            <option value="0"' . (!($config['allow_direct_json'] ?? true) ? ' selected' : '') . '>No</option>
                        </select>
                    </td>
                </tr>

                <tr>
                    <th colspan="2"><span>Token Settings</span></th>
                </tr>
                <tr>
                    <td>Token Expiry Days:</td>
                    <td><input type="number" name="token_expiry_days" value="' . intval($config['token_expiry_days'] ?? 7) . '" class="form-control" style="width:150px;" /></td>
                </tr>
                <tr>
                    <td>Verify Token IP:</td>
                    <td>
                        <select name="verify_token_ip" class="form-control" style="width:150px;">
                            <option value="1"' . (($config['verify_token_ip'] ?? false) ? ' selected' : '') . '>Yes</option>
                            <option value="0"' . (!($config['verify_token_ip'] ?? false) ? ' selected' : '') . '>No</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>Update Password:</td>
                    <td>
                        <select name="update_password" class="form-control" style="width:150px;">
                            <option value="Yes"' . (($config['update_password'] ?? 'Yes') == 'Yes' ? ' selected' : '') . '>Yes</option>
                            <option value="No"' . (($config['update_password'] ?? 'Yes') == 'No' ? ' selected' : '') . '>No</option>
                        </select>
                    </td>
                </tr>

                <tr>
                    <th colspan="2"><span>VOD Settings</span></th>
                </tr>
                <tr>
                    <td>Enable VOD:</td>
                    <td>
                        <select name="vod" class="form-control" style="width:150px;">
                            <option value="Yes"' . (($config['vod'] ?? 'Yes') == 'Yes' ? ' selected' : '') . '>Yes</option>
                            <option value="No"' . (($config['vod'] ?? 'Yes') == 'No' ? ' selected' : '') . '>No</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>Subscription Plan:</td>
                    <td><input type="number" name="subscription_plan" value="' . intval($config['subscription_plan'] ?? 1) . '" class="form-control" style="width:150px;" /></td>
                </tr>

                <tr>
                    <th colspan="2"><span>MidnightStreamer API Settings</span></th>
                </tr>
                <tr>
                    <td>MidnightStreamer API URL:</td>
                    <td><input type="text" name="midnight_api_url" value="' . htmlspecialchars($config['midnight_api_url'] ?? 'http://204.188.233.170:8000/api/') . '" class="form-control" placeholder="http://204.188.233.170:8000/api/" /></td>
                </tr>
                <tr>
                    <td>MidnightStreamer API Key:</td>
                    <td><input type="text" name="midnight_api_key" value="' . htmlspecialchars($config['midnight_api_key'] ?? 'eJIdy5sAgD') . '" class="form-control" /></td>
                </tr>

                <tr>
                    <th colspan="2"><span>Debug Settings</span></th>
                </tr>
                <tr>
                    <td>Debug Mode:</td>
                    <td>
                        <select name="debug" class="form-control" style="width:150px;">
                            <option value="1"' . (($config['debug'] ?? false) ? ' selected' : '') . '>Enabled</option>
                            <option value="0"' . (!($config['debug'] ?? false) ? ' selected' : '') . '>Disabled</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>Debug POST:</td>
                    <td>
                        <select name="debug_post" class="form-control" style="width:150px;">
                            <option value="1"' . (($config['debug_post'] ?? false) ? ' selected' : '') . '>Enabled</option>
                            <option value="0"' . (!($config['debug_post'] ?? false) ? ' selected' : '') . '>Disabled</option>
                        </select>
                    </td>
                </tr>

                <tr>
                    <th colspan="2" style="background:#f8f9fa;"><span style="color:#d9534f;font-weight:bold;">🌐 Remote Panels Configuration</span></th>
                </tr>
                <tr>
                    <td>Enable Remote Panel Access:</td>
                    <td>
                        <select name="remote_panel_enabled" class="form-control" style="width:150px;">
                            <option value="1"' . (($config['remote_panel_enabled'] ?? true) ? ' selected' : '') . '>Enabled</option>
                            <option value="0"' . (!($config['remote_panel_enabled'] ?? true) ? ' selected' : '') . '>Disabled</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>Remote Panel Host:</td>
                    <td><input type="text" name="remote_host" value="' . htmlspecialchars($config['remote_host'] ?? '204.188.233.170') . '" class="form-control" placeholder="204.188.233.170" /></td>
                </tr>
                <tr>
                    <td>Remote SSH User:</td>
                    <td><input type="text" name="remote_ssh_user" value="' . htmlspecialchars($config['remote_ssh_user'] ?? 'root') . '" class="form-control" /></td>
                </tr>
                <tr>
                    <td>Remote SSH Password:</td>
                    <td><input type="password" name="remote_ssh_pass" value="' . htmlspecialchars($config['remote_ssh_pass'] ?? 'R7nMi4KCzZv920pG') . '" class="form-control" placeholder="Enter SSH password" /></td>
                </tr>
                <tr>
                    <td>Remote Database Name:</td>
                    <td><input type="text" name="remote_db_name" value="' . htmlspecialchars($config['remote_db_name'] ?? 'midnight_iptv') . '" class="form-control" /></td>
                </tr>
                <tr>
                    <td>Remote MySQL Host:</td>
                    <td><input type="text" name="remote_mysql_host" value="' . htmlspecialchars($config['remote_mysql_host'] ?? '204.188.233.170') . '" class="form-control" placeholder="localhost or IP" /></td>
                </tr>
                <tr>
                    <td>Remote MySQL User:</td>
                    <td><input type="text" name="remote_mysql_user" value="' . htmlspecialchars($config['remote_mysql_user'] ?? 'grboxbilling') . '" class="form-control" /></td>
                </tr>
                <tr>
                    <td>Remote MySQL Password:</td>
                    <td><input type="password" name="remote_mysql_pass" value="' . htmlspecialchars($config['remote_mysql_pass'] ?? 'nasasat') . '" class="form-control" /></td>
                </tr>
                <tr>
                    <td>Remote MySQL Port:</td>
                    <td><input type="number" name="remote_mysql_port" value="' . intval($config['remote_mysql_port'] ?? 7999) . '" class="form-control" style="width:150px;" /></td>
                </tr>
                <tr>
                    <td>Connection Method:</td>
                    <td>
                        <select name="remote_connection_method" class="form-control" style="width:200px;">
                            <option value="ssh"' . (($config['remote_connection_method'] ?? 'ssh') == 'ssh' ? ' selected' : '') . '>SSH + MySQL (Current)</option>
                            <option value="mysql"' . (($config['remote_connection_method'] ?? 'ssh') == 'mysql' ? ' selected' : '') . '>Direct MySQL (Faster)</option>
                            <option value="api"' . (($config['remote_connection_method'] ?? 'ssh') == 'api' ? ' selected' : '') . '>REST API</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>Connection Timeout (seconds):</td>
                    <td><input type="number" name="remote_timeout" value="' . intval($config['remote_timeout'] ?? 10) . '" class="form-control" style="width:150px;" min="5" max="60" /></td>
                </tr>

                <tr>
                    <td class="center" colspan="2">
                        <button class="btn btn-success" type="submit"><i class="icon-floppy"> </i> Save Settings</button>
                        <a href="' . $this->base . '/testRemote" class="btn btn-info"><i class="icon-pulse"> </i> Test Remote Connection</a>
                    </td>
                </tr>
            </table>
        </form>';

        echo '</div></div>';
    }

    public function doSave()
    {
        global $intro;

        $config = [
            'debug' => ($_POST['debug'] ?? '0') == '1',
            'debug_post' => ($_POST['debug_post'] ?? '0') == '1',
            'XOR' => $_POST['XOR'] ?? 'yes',
            'XOR_KEY' => $_POST['XOR_KEY'] ?? '',
            'allow_direct_json' => ($_POST['allow_direct_json'] ?? '1') == '1',
            'update_password' => $_POST['update_password'] ?? 'Yes',
            'vod' => $_POST['vod'] ?? 'Yes',
            'portalName' => $_POST['portalName'] ?? 'LYNX',
            'url' => parse_url($_POST['panel_url'] ?? '', PHP_URL_HOST) ?: '',
            'port' => '',
            'panel_url' => $_POST['panel_url'] ?? '',
            'stream_base' => $_POST['stream_base'] ?? '',
            'epg_server' => $_POST['epg_server'] ?? '',
            'api_key' => $_POST['api_key'] ?? '',
            'max_connections' => intval($_POST['max_connections'] ?? 1),
            'restreamer' => intval($_POST['restreamer'] ?? 0),
            'allow_m3u' => intval($_POST['allow_m3u'] ?? 1),
            'subscription_plan' => intval($_POST['subscription_plan'] ?? 1),
            'token_expiry_days' => intval($_POST['token_expiry_days'] ?? 7),
            'verify_token_ip' => ($_POST['verify_token_ip'] ?? '0') == '1',
            'midnight_api_url' => $_POST['midnight_api_url'] ?? 'http://204.188.233.170:8000/api/',
            'midnight_api_key' => $_POST['midnight_api_key'] ?? 'eJIdy5sAgD',

            // Remote Panel Settings
            'remote_panel_enabled' => ($_POST['remote_panel_enabled'] ?? '1') == '1',
            'remote_host' => $_POST['remote_host'] ?? '204.188.233.170',
            'remote_ssh_user' => $_POST['remote_ssh_user'] ?? 'root',
            'remote_ssh_pass' => $_POST['remote_ssh_pass'] ?? 'R7nMi4KCzZv920pG',
            'remote_db_name' => $_POST['remote_db_name'] ?? 'midnight_iptv',
            'remote_mysql_host' => $_POST['remote_mysql_host'] ?? '204.188.233.170',
            'remote_mysql_user' => $_POST['remote_mysql_user'] ?? 'grboxbilling',
            'remote_mysql_pass' => $_POST['remote_mysql_pass'] ?? 'nasasat',
            'remote_mysql_port' => intval($_POST['remote_mysql_port'] ?? 7999),
            'remote_connection_method' => $_POST['remote_connection_method'] ?? 'ssh',
            'remote_timeout' => intval($_POST['remote_timeout'] ?? 10),
        ];

        // Extract port from panel_url
        $parsed = parse_url($config['panel_url']);
        if (isset($parsed['port'])) {
            $config['port'] = (string)$parsed['port'];
        }

        $result = $this->saveConfig($config);

        // Also save remote panel settings to panel_settings table for RemotePanelConfig
        if ($result !== false) {
            require_once(dirname(__FILE__) . '/../includes/RemotePanelConfig.php');

            RemotePanelConfig::updateSetting('host', $config['remote_mysql_host']);
            RemotePanelConfig::updateSetting('port', $config['remote_mysql_port']);
            RemotePanelConfig::updateSetting('user', $config['remote_mysql_user']);
            RemotePanelConfig::updateSetting('pass', $config['remote_mysql_pass']);
            RemotePanelConfig::updateSetting('database', $config['remote_db_name']);
            RemotePanelConfig::updateSetting('enabled', $config['remote_panel_enabled'] ? '1' : '0');

            // Restart sync daemon to use new settings
            shell_exec('systemctl restart stream-sync.service 2>&1');
        }

        if ($result === false) {
            $_SESSION['msg'] = '<div class="alert alert-danger">Error: Could not save settings. Check file permissions.</div>';
        } else {
            $_SESSION['msg'] = '<div class="alert alert-success">Settings saved successfully! Sync daemon restarted with new configuration.</div>';
        }

        $intro->redirect($this->appname, 'index');
    }

    private function loadConfig()
    {
        $_CFG = [];
        if (file_exists($this->config_file)) {
            include($this->config_file);
        }
        return $_CFG;
    }

    private function saveConfig($config)
    {
        $content = "<?php\n";
        $content .= "\$_CFG = array();\n";
        $content .= "\$_CFG['debug'] = " . ($config['debug'] ? 'true' : 'false') . ";                \n";
        $content .= "\$_CFG['debug_post'] = " . ($config['debug_post'] ? 'true' : 'false') . ";            \n";
        $content .= "\$_CFG['XOR'] = \"" . addslashes($config['XOR']) . "\";                  \n";
        $content .= "\$_CFG['XOR_KEY'] = \"" . addslashes($config['XOR_KEY']) . "\"; \n";
        $content .= "\$_CFG['allow_direct_json'] = " . ($config['allow_direct_json'] ? 'true' : 'false') . ";     \n";
        $content .= "\$_CFG['update_password'] = \"" . addslashes($config['update_password']) . "\";   \n";
        $content .= "\$_CFG['vod'] = \"" . addslashes($config['vod']) . "\";                  \n";
        $content .= "\$_CFG['portalName'] = \"" . addslashes($config['portalName']) . "\";          \n";
        $content .= "\$_CFG['url'] = \"" . addslashes($config['url']) . "\";\n";
        $content .= "\$_CFG['port'] = \"" . addslashes($config['port']) . "\";\n";
        $content .= "\$_CFG['panel_url'] = \"" . addslashes($config['panel_url']) . "\";\n";
        $content .= "\$_CFG['stream_base'] = \"" . addslashes($config['stream_base']) . "\";\n";
        $content .= "\$_CFG['epg_server'] = \"" . addslashes($config['epg_server']) . "\";  \n";
        $content .= "\$_CFG['api_key'] = \"" . addslashes($config['api_key']) . "\";       \n";
        $content .= "\$_CFG['max_connections'] = " . intval($config['max_connections']) . ";          \n";
        $content .= "\$_CFG['restreamer'] = " . intval($config['restreamer']) . ";  \n";
        $content .= "\$_CFG['allow_m3u'] = " . intval($config['allow_m3u']) . ";                            \n";
        $content .= "\$_CFG['subscription_plan'] = " . intval($config['subscription_plan']) . ";        \n";
        $content .= "\$_CFG['token_expiry_days'] = " . intval($config['token_expiry_days']) . ";  \n";
        $content .= "\$_CFG['verify_token_ip'] = " . ($config['verify_token_ip'] ? 'true' : 'false') . ";      \n";
        $content .= "\$_CFG['midnight_api_url'] = \"" . addslashes($config['midnight_api_url']) . "\";\n";
        $content .= "\$_CFG['midnight_api_key'] = \"" . addslashes($config['midnight_api_key']) . "\";\n";

        // Remote Panel Settings
        $content .= "\n// Remote Panel Configuration\n";
        $content .= "\$_CFG['remote_panel_enabled'] = " . ($config['remote_panel_enabled'] ? 'true' : 'false') . ";\n";
        $content .= "\$_CFG['remote_host'] = \"" . addslashes($config['remote_host']) . "\";\n";
        $content .= "\$_CFG['remote_ssh_user'] = \"" . addslashes($config['remote_ssh_user']) . "\";\n";
        $content .= "\$_CFG['remote_ssh_pass'] = \"" . addslashes($config['remote_ssh_pass']) . "\";\n";
        $content .= "\$_CFG['remote_db_name'] = \"" . addslashes($config['remote_db_name']) . "\";\n";
        $content .= "\$_CFG['remote_mysql_host'] = \"" . addslashes($config['remote_mysql_host']) . "\";\n";
        $content .= "\$_CFG['remote_mysql_user'] = \"" . addslashes($config['remote_mysql_user']) . "\";\n";
        $content .= "\$_CFG['remote_mysql_pass'] = \"" . addslashes($config['remote_mysql_pass']) . "\";\n";
        $content .= "\$_CFG['remote_mysql_port'] = " . intval($config['remote_mysql_port']) . ";\n";
        $content .= "\$_CFG['remote_connection_method'] = \"" . addslashes($config['remote_connection_method']) . "\";\n";
        $content .= "\$_CFG['remote_timeout'] = " . intval($config['remote_timeout']) . ";\n";

        return file_put_contents($this->config_file, $content);
    }

    public function testRemote()
    {
        global $intro;
        $this->nav();

        $config = $this->loadConfig();

        echo '<div class="panel panel-primary">
            <div class="panel-heading"><i class="icon-pulse"></i> Remote Connection Test</div>
            <div class="panel-body">';

        echo '<h4>Testing Remote Panel Connection...</h4>';
        echo '<div style="background:#f8f9fa;padding:20px;border-radius:5px;margin:15px 0;">';

        $tests = [];

        // Test 1: SSH Connection
        echo '<h5>1️⃣ Testing SSH Connection...</h5>';
        $ssh_cmd = "timeout 5 sshpass -p " . escapeshellarg($config['remote_ssh_pass'] ?? 'R7nMi4KCzZv920pG') .
                   " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=5 " .
                   escapeshellarg($config['remote_ssh_user'] ?? 'root') . "@" .
                   escapeshellarg($config['remote_host'] ?? '204.188.233.170') .
                   " 'echo SSH_OK' 2>&1";

        $ssh_result = trim(shell_exec($ssh_cmd));
        if(strpos($ssh_result, 'SSH_OK') !== false) {
            echo '<div class="alert alert-success"><i class="icon-ok"></i> SSH Connection: <strong>SUCCESS</strong></div>';
            $tests['ssh'] = true;
        } else {
            echo '<div class="alert alert-danger"><i class="icon-cancel"></i> SSH Connection: <strong>FAILED</strong><br>Error: ' . htmlspecialchars($ssh_result) . '</div>';
            $tests['ssh'] = false;
        }

        // Test 2: MySQL via SSH
        echo '<h5>2️⃣ Testing MySQL Access via SSH...</h5>';
        $mysql_cmd = "sshpass -p " . escapeshellarg($config['remote_ssh_pass'] ?? 'R7nMi4KCzZv920pG') .
                     " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=5 " .
                     escapeshellarg($config['remote_ssh_user'] ?? 'root') . "@" .
                     escapeshellarg($config['remote_host'] ?? '204.188.233.170') .
                     " 'mysql -e \"SELECT 1 as test;\"' 2>&1";

        $mysql_result = trim(shell_exec($mysql_cmd));
        if(strpos($mysql_result, 'test') !== false || strpos($mysql_result, '1') !== false) {
            echo '<div class="alert alert-success"><i class="icon-ok"></i> MySQL Access: <strong>SUCCESS</strong></div>';
            $tests['mysql'] = true;
        } else {
            echo '<div class="alert alert-danger"><i class="icon-cancel"></i> MySQL Access: <strong>FAILED</strong><br>Error: ' . htmlspecialchars($mysql_result) . '</div>';
            $tests['mysql'] = false;
        }

        // Test 3: Database Check
        echo '<h5>3️⃣ Testing Database Access...</h5>';
        $db_cmd = "sshpass -p " . escapeshellarg($config['remote_ssh_pass'] ?? 'R7nMi4KCzZv920pG') .
                  " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=5 " .
                  escapeshellarg($config['remote_ssh_user'] ?? 'root') . "@" .
                  escapeshellarg($config['remote_host'] ?? '204.188.233.170') .
                  " 'mysql " . escapeshellarg($config['remote_db_name'] ?? 'midnight_iptv') .
                  " -N -e \"SHOW TABLES;\"' 2>&1";

        $db_result = trim(shell_exec($db_cmd));
        if(strpos($db_result, 'lines') !== false || strpos($db_result, 'streams') !== false) {
            echo '<div class="alert alert-success"><i class="icon-ok"></i> Database "' . htmlspecialchars($config['remote_db_name'] ?? 'midnight_iptv') . '": <strong>SUCCESS</strong>';
            echo '<br><small>Tables found: ' . str_replace("\n", ", ", $db_result) . '</small></div>';
            $tests['database'] = true;
        } else {
            echo '<div class="alert alert-danger"><i class="icon-cancel"></i> Database Access: <strong>FAILED</strong><br>Error: ' . htmlspecialchars($db_result) . '</div>';
            $tests['database'] = false;
        }

        // Test 4: Count Users
        echo '<h5>4️⃣ Testing User Count Query...</h5>';
        $count_cmd = "sshpass -p " . escapeshellarg($config['remote_ssh_pass'] ?? 'R7nMi4KCzZv920pG') .
                     " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=5 " .
                     escapeshellarg($config['remote_ssh_user'] ?? 'root') . "@" .
                     escapeshellarg($config['remote_host'] ?? '204.188.233.170') .
                     " 'mysql " . escapeshellarg($config['remote_db_name'] ?? 'midnight_iptv') .
                     " -N -e \"SELECT COUNT(*) FROM \\`lines\\`;\"' 2>&1";

        $count_result = trim(shell_exec($count_cmd));
        if(is_numeric($count_result)) {
            echo '<div class="alert alert-success"><i class="icon-ok"></i> User Count Query: <strong>SUCCESS</strong><br>Total Users: <strong>' . number_format($count_result) . '</strong></div>';
            $tests['query'] = true;
        } else {
            echo '<div class="alert alert-danger"><i class="icon-cancel"></i> User Count Query: <strong>FAILED</strong><br>Error: ' . htmlspecialchars($count_result) . '</div>';
            $tests['query'] = false;
        }

        // Test 5: Sample Data
        echo '<h5>5️⃣ Testing Sample Data Retrieval...</h5>';
        $sample_cmd = "sshpass -p " . escapeshellarg($config['remote_ssh_pass'] ?? 'R7nMi4KCzZv920pG') .
                      " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=5 " .
                      escapeshellarg($config['remote_ssh_user'] ?? 'root') . "@" .
                      escapeshellarg($config['remote_host'] ?? '204.188.233.170') .
                      " 'mysql " . escapeshellarg($config['remote_db_name'] ?? 'midnight_iptv') .
                      " -N -e \"SELECT id, username FROM \\`lines\\` LIMIT 1;\"' 2>&1";

        $sample_result = trim(shell_exec($sample_cmd));
        if(!empty($sample_result) && !strpos($sample_result, 'ERROR')) {
            echo '<div class="alert alert-success"><i class="icon-ok"></i> Sample Data: <strong>SUCCESS</strong><br>Sample: <code>' . htmlspecialchars($sample_result) . '</code></div>';
            $tests['sample'] = true;
        } else {
            echo '<div class="alert alert-danger"><i class="icon-cancel"></i> Sample Data: <strong>FAILED</strong><br>Error: ' . htmlspecialchars($sample_result) . '</div>';
            $tests['sample'] = false;
        }

        echo '</div>';

        // Summary
        $passed = array_filter($tests);
        $total = count($tests);
        $success_rate = round((count($passed) / $total) * 100);

        echo '<div class="alert alert-' . ($success_rate == 100 ? 'success' : ($success_rate >= 60 ? 'warning' : 'danger')) . '">';
        echo '<h4><i class="icon-' . ($success_rate == 100 ? 'ok' : 'attention') . '"></i> Test Summary</h4>';
        echo '<p>Passed: <strong>' . count($passed) . '/' . $total . '</strong> (' . $success_rate . '%)</p>';

        if($success_rate == 100) {
            echo '<p><strong>✅ All tests passed! Remote connection is fully functional.</strong></p>';
        } elseif($success_rate >= 60) {
            echo '<p><strong>⚠️ Some tests failed. Check the configuration.</strong></p>';
        } else {
            echo '<p><strong>❌ Connection failed. Please verify credentials and network access.</strong></p>';
        }
        echo '</div>';

        echo '<div class="text-center" style="margin-top:20px;">
            <a href="' . $this->base . '/index" class="btn btn-primary"><i class="icon-left"></i> Back to Settings</a>
        </div>';

        echo '</div></div>';
    }
}
