<?php 
class E2_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $qry_admin_where = '';
    public $admin = [];
    public $adminRow = [];
    public $inputBy = [
        'Code', 
        'MAC', 
        'Serial'
    ];
    public $free = [
        101, 
        103, 
        107, 
        110
    ];
    public $output = [
        'ts' => ' MPEGTS (.ts)', 
        'm3u8' => 'HLS (.m3u8)'
    ];
    public $time = null;
    private $user_pattern = ':.@*_-';
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        global $array;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        $adminid = intval($this->admin['adminid']);
        $this->adminRow = $intro->auth->admin_data($adminid);
        if( $this->admin['level'] == 1 ) 
        {
            $this->qry_admin = '';
            $this->qry_admin_where = '';
        }
        else
        {
            $this->qry_admin = ' and member_id=' . $adminid;
            $this->qry_admin_where = ' where member_id=' . $adminid;
        }
        if( $this->adminRow['level'] == 6 ) 
        {
            $this->qry_admin = ' and ( member_id=' . $adminid . ' OR member_id IN (select adminid from ' . PREFIX . ('_admin WHERE father=' . $adminid . '))');
            $this->qry_admin_where = ' where member_id=' . $adminid . ' OR member_id IN (select adminid from ' . PREFIX . ('_admin WHERE father=' . $adminid . ')');
        }
        $this->time = time();
        $this->free = $array['free'];
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo "\r\n\t\t<div class=\"app_nav\">\r\n\t\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . "/index\"><icon class=\"icon-user\"></icon> E2 Devices</a>  \r\n\t\t\t<a class=\"btn btn-") . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="' . $this->base . "/Form?t=add\"><icon class=\"icon-plus-squared\"></icon> Add New E2 Box</a>\r\n\t\t</div>");
    }
    public function index()
    {
        global $intro;
        global $array;
        $qry = $params = '';
        $status = trim($intro->input->get_post('status'));
        $view = trim($intro->input->get_post('view'));
        $page = intval($intro->input->get_post('page'));
        $order = trim($intro->input->get_post('order'));
        $mac = strtoupper(trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('mac'), ':')));
        $period = intval($intro->input->get_post('period'));
        $is_restreamer = intval($intro->input->get_post('is_restreamer'));
        $is_trial = intval($intro->input->get_post('is_trial'));
        $member_id = intval($intro->input->get_post('resid'));
        $adminid = intval($intro->input->get_post('adminid'));
        $admin_notes = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('admin_notes'), ' {ar}' . $this->user_pattern));
        $reseller_notes = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('reseller_notes'), ' {ar}' . $this->user_pattern));
        $mobile = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('mobile'), '\+\-\*'));
        $username = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('username'), $this->user_pattern));
        $this->nav();
        if( $is_trial == 1 ) 
        {
            $qry .= ' AND is_trial=1';
            $params .= '&is_trial=1';
        }
        if( $username != '' ) 
        {
            if( preg_match('/[*]/i', $username) ) 
            {
                $qry .= (' AND username  LIKE \'' . str_replace('*', '%', $username) . '\' ');
            }
            else
            {
                $qry .= (' AND username  LIKE \'%' . $username . '%\' ');
                $params .= ('&username=' . $username);
            }
        }
        if( $mac != '' ) 
        {
            $qry .= (' AND e2.mac LIKE \'%' . $mac . '%\' ');
            $params .= ('&mac=' . $mac);
        }
        if( $admin_notes != '' ) 
        {
            $qry .= (' AND admin_notes LIKE \'%' . $admin_notes . '%\' ');
            $params .= ('&admin_notes=' . $admin_notes);
        }
        if( $reseller_notes != '' ) 
        {
            $qry .= (' AND reseller_notes LIKE \'%' . $reseller_notes . '%\' ');
            $params .= ('&reseller_notes=' . $reseller_notes);
        }
        if( $mobile != '' ) 
        {
            $qry .= (' AND mobile=\'' . $mobile . '\' ');
            $params .= ('&mobile=' . $mobile);
        }
        if( $member_id != '' ) 
        {
            $qry .= (' AND member_id=' . $member_id . ' ');
            $params .= ('&resid=' . $member_id);
        }
        if( $period != 0 ) 
        {
            $qry .= (' AND period=' . $period . ' ');
            $params .= ('&period=' . $period);
        }
        if( $view == 'expired' ) 
        {
            $qry = ' AND is_restreamer=0 AND exp_date !=0 AND exp_date <= \'' . $this->time . '\' AND exp_date IS NOT NULL  ';
            $params .= '&view=expired';
        }
        if( $view == 'banned' ) 
        {
            $qry = ' AND admin_enabled=0 ';
            $params .= '&view=banned';
        }
        if( $view == 'disabled' ) 
        {
            $qry = ' AND enabled=0 ';
            $params .= '&view=disabled';
        }
        if( $order == '' ) 
        {
            $order = 'device_id:desc';
        }
        $order = str_replace(':', ' ', $order);
        $rows_per_page = 100;
        if( $page == 0 ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $concat = 'stream_id,\'|\',user_agent,\'|\',user_ip,\'|\',container,\'|\',geoip_country_code,\'|\',isp';
        $qry_online = ',IF(u.enabled=1,(select CONCAT(' . $concat . ') as online from user_activity_now online ' . ' where online.user_id=e2.user_id ORDER BY activity_id DESC LIMIT 1),\'\') as online';
        $result = $intro->db->query('SELECT *' . $qry_online . ' from enigma2_devices e2,`users` u ' . (' WHERE e2.user_id=u.id ' . $this->qry_admin . ' ' . $qry . '  order by ' . $order . ' limit ' . $nexlimit . ',' . $rows_per_page));
        $totrows = $intro->db->returned_rows;
        $sql_all_rows = $intro->db->query('SELECT device_id from enigma2_devices where true /*' . $this->qry_admin . ' ' . $qry . '*/ ');
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Found users (' . money($totalrows) . ')', 'primary');
        echo "\r\n\t\t<form action=\"\" method=\"GET\">\r\n\t\t\t<table class=\"table table-bordered table-condensed\">\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>E2 MAC:</td>\r\n\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"mac\" value=\"" . $mac . "\" size=\"20\" placeholder='E2 Device MAC Address' autofocus></td>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t</tr>\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Period: </td>\r\n\t\t\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period', _obf_0D322A5B141A102E2824032B03230A35140306272F2F11(), $period, 'All') . "</td>\r\n\t\t\t\t\t<td>Rseller:</td>";
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t\t\t<td>" . form_resellers('resid', $member_id, 'All Resellers') . '</td>';
        }
        else
        {
            echo '<td>' . $this->admin['admin_name'] . '</td>';
        }
        echo "\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t\t<td> </td>\r\n\t\t\t\t\t\r\n\t\t\t\t</tr>\r\n\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Mobile:</td>\r\n\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"mobile\" value=\"" . $mobile . '" size="20" placeholder=\'Mobile\'></td>';
        if( $this->admin['level'] == 1 ) 
        {
            echo "<td>Admin Notes:</td>\r\n\t\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"admin_notes\" value=\"" . $admin_notes . '" size="20" placeholder=Notes></td>';
        }
        else
        {
            echo "<td>Notes:</td>\r\n\t\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"reseller_notes\" value=\"" . $reseller_notes . '" size="20" placeholder=Notes></td>';
        }
        echo "<td><input type=\"submit\" class=\"btn btn-success\" value=\" Search! \" class='btn btn-default'></td>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t<input type=\"hidden\" name=\"status\" value=\"" . $status . "\">\r\n\t\t</form>";
        echo "\r\n\t\t<table class=\"DataTable table-striped table-bordered table-condensed\" id=\"table_codes\">\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('device_id', 'index') . " </th>\r\n\t\t\t<th></th>\r\n\t\t\t<th>Reseller</th>\r\n\t\t\t<th>Userid " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('user_id', 'index') . "</th>\r\n\t\t\t<th>Device MAC " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('mac', 'index') . " </th>\r\n\t\t\t<th>Original MAC</th>\r\n\t\t\t<th>Image Ver.</th>\r\n\t\t\t<th>Plugin Ver.</th>\r\n\t\t\t<th>Device CPU</th>\r\n\t\t\t<th>Expire " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('exp_date', 'index') . "</th>\r\n\t\t\t<th>" . (($this->admin['level'] == 1 ? 'Admin ' : '')) . "Notes</th>\r\n\t\t\t<th>Options</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = 0;
        $free_days = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $user_id = $id;
            $userid = $id;
            if( $exp_date == '' ) 
            {
                $exp_date = 'Unlimited';
            }
            else if( $exp_date < time() ) 
            {
                $exp_date = 'Expired';
            }
            else
            {
                $exp_date = date('Y-m-d H:i', $exp_date);
            }
            if( $online != '' ) 
            {
                $online = '<a class="AjaxModal" href="' . $intro->app_url('online', 'index') . ('/?id=' . $userid . '&for=user"><icon class="icon-globe" style=\'color:green;\' title="' . $online . '"></icon></a>');
            }
            else
            {
                $online = '<a class="AjaxModal" href="' . $intro->app_url('online', 'was') . ('/?id=' . $userid . '&for=user"><icon class="icon-globe" style=\'color:gray;\' title="offline"></icon></a>');
            }
            if( $enabled == 0 ) 
            {
                $online = '<span class="icon-off label label-danger" title="Disabled!"> </span>';
            }
            if( $admin_enabled == 0 ) 
            {
                $online = '<span class="icon-block label label-danger" title="Banned!"> </span>';
            }
            echo "\r\n\t\t\t<tr id='tr_" . $id . '\' ' . (($is_trial == 1 ? 'style=\'color:#ff2626\'' : '')) . ' ' . (($myrow['exp_date'] == '' ? 'style=\'color:#2db300\'' : '')) . ' ' . (($exp_date == 'Expired' ? 'style=\'color:#888888;\'' : '')) . (">\r\n\t\t\t\t<td class='c'>" . $device_id . "</td>\r\n\t\t\t\t<td class='c' id='status_" . $id . '\'>' . $online . "</td>\r\n\t\t\t\t<td class='c'>") . ((isset($array['admins'][$member_id]) ? $array['admins'][$member_id] : 'not set')) . ("</td>\t\r\n\t\t\t\t<td>" . $user_id . "</td>\r\n\t\t\t\t<td>" . $mac . "</td>\r\n\t\t\t\t<td>" . $original_mac . "</td>\t\r\n\t\t\t\t<td>" . $enigma_version . "</td>\t\r\n\t\t\t\t<td>" . $version . "</td>\t\r\n\t\t\t\t<td>" . $cpu . "</td>\r\n\t\t\t\t<td class='c'><span class=\"editExpireDate\" data-type=\"text\" data-pk=\"" . $id . '" data-name="exp_date">' . $exp_date . "</span></td>\r\n\t\t\t\t<td class='c'>") . (($this->admin['level'] == 1 ? $admin_notes : $reseller_notes)) . "</td>\r\n\t\t\t\t<td class='c'>";
            echo "\r\n\t\t\t\t\t<div class=\"btn-group\">\r\n                        <button class=\"btn btn-primary btn-xs dropdown-toggle\" href=\"#\" data-toggle=\"dropdown\">\r\n                        <span class='icon-cog'></span> <span class=\"caret\"></span>\r\n                        </button>\r\n                        <ul class=\"dropdown-menu stay-open pull-right\" role=\"menu\" style=\"padding: 15px; min-width: 200px;\">";
            if( $enabled == 0 && $admin_enabled == 1 ) 
            {
                echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&NH=1&sus=off" OnClick="return false;"  title="Disable/Suspend"><span class="btn btn-success btn-xs icon-ok"></span>Enable</a></li>';
            }
            if( $enabled == 1 && $admin_enabled == 1 ) 
            {
                echo '<li><a class="p_edit AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&NH=1&sus=on" OnClick="return false;" title="Enable/unsuspend"><span class="btn btn-danger btn-xs icon-off"></span> Disable </a></li>';
            }
            if( $this->admin['level'] == 1 && $admin_enabled == 1 ) 
            {
                echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&sus=ban" title="Ban!"><span class="btn btn-danger btn-xs icon-cancel-circled2"></span> Ban!</a></li>';
            }
            if( $this->admin['level'] == 1 && $admin_enabled == 0 ) 
            {
                echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&sus=unban" title="Unban!"><span class="btn btn-success btn-xs icon-ok"></span> UnBan!</a></li>';
            }
            if( $enabled == 1 && $admin_enabled == 1 ) 
            {
                echo '<li><a class="AjaxModal" href="' . $intro->app_url('renew', 'User') . ('?id=' . $user_id . '&e2=' . $device_id . '" title="Renew E2 Device"><span class="btn btn-success btn-xs icon-cw"></span> Renew E2 Device</a></li>');
            }
            echo '<li><a class="p_edit" href="##' . $this->base . '/Form?t=edit&amp;id=' . $id . '" title="Edit User"><span class="btn btn-info btn-xs icon-edit"></span> Edit </a></li>';
            if( $this->admin['level'] == 1 ) 
            {
                echo '<li><a class="p_edit AjaxModal" href="' . $intro->app_url('users', 'm3u') . '?id=' . $user_id . "\" title=\"Download m3u\">\r\n\t\t\t\t\t\t\t\t<span class=\"btn btn-success btn-xs icon-download\"></span> m3u </a></li>";
            }
            if( $this->admin['level'] == 1 || intval($this->admin['can_delete']) == 1 ) 
            {
                echo '<li><a class="p_del AjaxModal" href="' . $this->base . '/DelForm?e2=' . $device_id . '" title="' . $intro->lang['del'] . '"><span class="btn btn-danger btn-xs icon-trash"></span> Delete</a></li>';
            }
            echo "\r\n                        </ul>\r\n\t\t\t\t\t</div>";
        }
        echo "</tbody>\r\n\t\t\t</table>";
        $order = str_replace(' ', ':', $order);
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411('<div class=\'text-center\'>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?' . $params, $totalrows, $rows_per_page, $page) . '</div>');
        echo "\t\t<script>\r\n\t\t\$(document).ready(function() {\r\n\r\n\t\t\t";
        if( $this->admin['level'] == 1 || $this->admin['level'] == 9 ) 
        {
            echo "\t\t\t\t\$.fn.editable.defaults.mode = 'pop';     \r\n\t\t\t\t\$('.editExpireDate').editable({\r\n\t\t\t\t\turl: '";
            echo $this->base;
            echo "/EditCodeDate?NH=1',\r\n\t\t\t\t\tsuccess: function(response) {\r\n\t\t\t\t\t\tif(response != \"success\" && response != \"\")\r\n\t\t\t\t\t\t\talert(response);\r\n\t\t\t\t\t}\r\n\t\t\t\t});\r\n\t\t\t";
        }
        echo "\t\t\t\r\n\t\t});\r\n\t\t</script>\r\n\t\t";
    }
    public function EditCodeDate()
    {
        global $intro;
        $data = $dataU = [];
        $id = intval($intro->input->get_post('pk'));
        $name = trim($intro->input->get_post('name'));
        $value = trim($intro->input->get_post('value'));
        if( $name == 'exp_date' ) 
        {
            if( !IntroDate::validateDate($value, 'Y-m-d H:i') ) 
            {
                exit( 'Wrong Date Format: use yyyy-mm-dd HH:ii' );
            }
            $value = strtotime($value);
        }
        $data[$name] = $value;
        if( $this->admin['level'] == 1 || $this->admin['level'] == 9 ) 
        {
            $intro->db->update('users', $data, 'id=' . $id);
            $af = $intro->db->affected_rows;
            exit( 'success (' . $af . ') ' );
        }
    }
    public function m3u()
    {
        global $intro;
        global $array;
        global $options;
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        @extract($row);
        if( $username == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("Error: you cannot change this username:\r\n\t\t\t\t<li>The username may not found or is deleted.\r\n\t\t\t\t<li>Or you don't have the right permisions to edit this username.", 'danger');
            exit();
        }
        $user = $username;
        $pass = $password;
        $url = _obf_0D30011C3F2A2E3F22302707253C09162F3D0E082D0E11();
        if( $this->adminRow['host'] != '' ) 
        {
            $url['host'] = $this->adminRow['host'];
        }
        $host = $url['scheme'] . '://' . $url['host'] . ':' . $url['port'];
        $sql = $intro->db->query('SELECT * from devices order by device_name asc;');
        $data = 'Host: ' . $url['host'] . ':' . $url['port'] . "\n";
        $data .= ('Username: ' . $user . "\n");
        $data .= ('Password: ' . $pass . "\n");
        $maa = 1;
        $m3u8 = $host . ('/get.php?username=' . $user . '&password=' . $pass . '&type=m3u_plus&output=mpegts');
        echo '<textarea class=\'AutoCopy form-control\' style=\'height:100px;font-size:16px;\' spellcheck="false" data-gramm="false">' . $data . '</textarea>';
        echo '<br/><textarea class=\'AutoCopy form-control\' style=\'height:60px;font-size:16px;\' spellcheck="false" data-gramm="false">' . $m3u8 . '</textarea>';
        echo '<br/><ul class="list-group">';
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $device_name = $row['device_name'];
            $device_key = $row['device_key'];
            $device_id = $row['device_id'];
            $link = $host . '/get.php?' . ('username=' . $user . '&password=' . $pass . '&type=' . $device_key . '&output=mpegts');
            echo '<li data-id="' . $device_id . '" class="m3uSelector list-group-item ' . (($device_name == 'm3u' ? 'list-group-item-info' : '')) . ('"><a href="' . $link . "\" OnClick='return false;'>\r\n\t\t\t\t" . $device_name . " \r\n\t\t\t\t</a>\r\n\t\t\t\t<div id='div_m3uinput_" . $device_id . "' style='display:none'>\r\n\t\t\t\t<input id='m3uinput_" . $device_id . '\' type=\'text\' class=\'form-control\' value=\'' . $link . "' />\r\n\t\t\t\t</div>\r\n\t\t\t</li>");
        }
        echo '</ul>';
    }
    public function OSDMessage()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        @extract($row);
        if( $username == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("Error: you cannot change this code:\r\n\t\t\t\t<li>The code may not found or is deleted.\r\n\t\t\t\t<li>Or you don't have the right permisions to edit this code.", 'danger');
            exit();
        }
        $exp_date = ($exp_date != '' ? date('Y-m-d', $exp_date) : '-');
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Send OSD Message to username: ' . $username, 'success');
        echo "<table class=\"table table-striped table-bordered\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>username:</td>\r\n\t\t\t\t<td>" . $username . "</td>\r\n\t\t\t\t<td class='info'>Adminid:</td>\r\n\t\t\t\t<td>" . $array['admins'][$member_id] . ("</td>\r\n\t\t\t\t\r\n\t\t\t</tr>\r\n\t\t\t<tr>\t\t\r\n\t\t\t\t<td class='info'>Days:</td>\r\n\t\t\t\t<td> </td>\r\n\t\t\t\t<td class='info'>Date Expire</td>\r\n\t\t\t\t<td>" . $exp_date . "</td>\t\r\n\t\t\t\t\r\n\t\t\t</tr>\r\n\t\t</table>");
        echo "\r\n\t\t<form name=\"frmSendOSD\"  id=\"frmSendOSD\" method=\"post\" action=\"" . $this->base . "/doSendOSD\">\r\n\t\t<div id='result'></div>\r\n\t\t<table class=\"table table-striped table-bordered\">\r\n\t\t<tr>\r\n\t\t\t<td>Mesaage: </td>\r\n\t\t\t<td><textarea name=\"OSD_message\" style=\"width:99%;height:150px\">  </textarea></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Status:</td>\r\n\t\t\t<td>  </td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td> </td>\r\n\t\t\t<td> <input type=\"submit\" id=\"OsdSubmit\" value=\" Send \" class=\"btn btn-success\" OnClick=\"return confirm('Are you sure?')\" /> </td>\r\n\t\t</tr>\r\n\t\t\r\n\t\t</table>\r\n\r\n\t\t<input type=\"hidden\" name=\"userid\" value=\"" . $id . "\" />\r\n\t\t\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\$(document).ready(function(){\r\n\t\t\t\$(\"#frmSendOSD\").submit(function(event){\r\n\t\t\t\tevent.preventDefault();\r\n\r\n\t\t\t\t\$.ajax({\r\n\t\t\t\t\turl:'" . $this->base . "/doSendOSD?NH=1',\r\n\t\t\t\t\ttype:'POST',\r\n\t\t\t\t\tdata:\$(this).serialize(),\r\n\t\t\t\t\tsuccess:function(result){\r\n\t\t\t\t\t\t\$('#result').html(result);\r\n\t\t\t\t\t}\r\n\r\n\t\t\t\t});\r\n\t\t\t});\r\n\t\t});\r\n\t\t</script>";
    }
    public function doSendOSD()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('userid'));
        $OSD_message = trim($intro->input->get_post('OSD_message'));
        $OSD_message = strip_tags($OSD_message);
        $OSD_message = preg_replace('/[^a-zA-Z0-9-أ-ي. ]/ui', '', $OSD_message);
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Success:  Message Sent. ', 'success');
    }
    public function Suspend()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('uid'));
        $sus = trim($intro->input->get_post('sus'));
        if( $sus == 'on' ) 
        {
            $qry = 'enabled=0';
            $span_sus = '<span class="icon-off label label-danger" title="Disabled!"> </span>';
        }
        else if( $sus == 'off' ) 
        {
            $qry = 'enabled=1';
            $span_sus = '<span class="label label-success">Active</span>';
        }
        else if( $sus == 'ban' ) 
        {
            $qry = 'admin_enabled=0';
            $span_sus = '<span class="icon-block label label-danger" title="Banned!"> </span>';
        }
        else if( $sus == 'unban' ) 
        {
            $qry = 'admin_enabled=1';
            $span_sus = '<span class="label label-success">Active</span>';
        }
        else
        {
            exit( 'Opps!!!' );
        }
        $qq = $code = '';
        if( intval($this->admin['level']) == 1 || intval($this->admin['level']) == 9 ) 
        {
            $qq = '';
        }
        else
        {
            $qq = ' and member_id=' . intval($this->admin['adminid']);
        }
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $qq . ';');
        $row = $intro->db->fetch_assoc($sql);
        $username = $row['username'];
        $intro->db->query('UPDATE users SET ' . $qry . ' WHERE id=' . $id . ' ' . $qq . ';');
        $arr = ['status_' . $id => $span_sus];
        header('Content-Type: application/json');
        echo json_encode($arr);
    }
    public function Kill()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('uid'));
        $span_sus = '<span class="icon-unlink label label-default" title="Killed"> </span>';
        $qq = $code = '';
        if( intval($this->admin['level']) == 1 || intval($this->admin['level']) == 9 ) 
        {
            $qq = '';
        }
        else
        {
            $qq = ' and member_id=' . intval($this->admin['adminid']);
        }
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $qq . ';');
        $row = $intro->db->fetch_assoc($sql);
        if( isset($row['id']) ) 
        {
            $intro->db->query('DELETE FROM `user_activity_now` WHERE user_id=' . $id . ' ' . $qq . ';');
        }
        else
        {
            $span_sus = '<span class="label label-danger">You have no perms.</span>';
            $arr = ['status_' . $id => $span_sus];
            header('Content-Type: application/json');
            echo json_encode($arr);
        }
    }
    public function DelForm()
    {
        global $intro;
        global $array;
        $e2 = intval($intro->input->get_post('e2'));
        $sql = $intro->db->query('SELECT * FROM enigma2_devices e2, users u where e2.user_id=u.id AND device_id=' . $e2 . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        if( !is_array($row) ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('E2 Device MAC is not found or deleted. OR you are not authorized to delete this E2 Device.', 'danger');
            exit();
        }
        @extract($row);
        $exp_date = ($exp_date != '' ? date('Y-m-d H:s', $exp_date) : 'Unlimited');
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Delete E2 Device MAC: ' . $mac, 'danger');
        echo "<table class=\"table table-striped table-bordered\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>MAC:</td>\r\n\t\t\t\t<td>" . $mac . "</td>\r\n\t\t\t\t<td class='info'>Reseller:</td>\r\n\t\t\t\t<td>" . ((isset($array['admins'][$member_id]) ? $array['admins'][$member_id] : 'not set')) . ("</td>\r\n\t\t\t\t<td class='info'>Expire:</td>\r\n\t\t\t\t<td>" . $exp_date . "</td>\r\n\t\t\t</tr>");
        $sql = $intro->db->query('SELECT * from ' . PREFIX . ('_trans where type=1 AND userid=' . $id));
        $r = $intro->db->fetch_assoc($sql);
        if( is_array($r) ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>Invoice:</td>\r\n\t\t\t\t<td>Amount: " . $r['amount'] . "</td>\r\n\t\t\t\t<td colspan='4'>Notes: " . $r['Notes'] . "</td>\r\n\t\t\t</tr>";
        }
        echo "\r\n\t\t</table>";
        echo "<div class=\"btn-group\" role=\"group\" aria-label=\"Delete\">\r\n\t\t\t\t  \r\n\t\t\t\t  <a class=\"btn btn-danger p_del\" id=\"delete\" href=\"" . $this->base . '/Del?e2=' . $e2 . "&NH=1&db=1\">\r\n\t\t\t\t\t<i class=\"icon-cancel-circled2\"></i> Delete E2 Device MAC From database\r\n\t\t\t\t  </a>\r\n\t\t\t\t  \r\n\t\t\t</div>\r\n\t\t\t\t\r\n\t\t\t\t<span id=\"spin\" class='icon-spin5'></span>";
        echo '<div id=\'result\'>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\$('documnet').ready(function(){\r\n\t\t\t\$('#delete').click(function(e){\r\n\t\t\t\te.preventDefaults;\r\n\t\t\t\t\r\n\t\t\t\tif(!confirm('Are you sure?')) return false;\r\n\t\t\t\t\r\n\t\t\t\t\$('#spin').addClass('animate-spin');\r\n\t\t\t\t\$.get( \$(this).attr('href'), function( data ) {\r\n\t\t\t\t\t\$( \"#result\" ).html( data );\r\n\t\t\t\t\t\$('#spin').removeClass('animate-spin');\r\n\t\t\t\t});\r\n\t\t\t\treturn false;\r\n\t\t\t});\r\n\t\t\t\r\n\t\t});\r\n\t\t</script>";
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $period;
        global $fullname;
        global $code;
        global $days;
        global $adminid;
        global $status;
        global $created_at;
        global $num;
        global $bouquets;
        global $forced_country;
        global $allowed_ua;
        global $allowed_ips;
        global $mobile;
        global $mac;
        global $free_days;
        global $length;
        global $created_by;
        global $options;
        global $container;
        global $password;
        global $admin_notes;
        global $reseller_notes;
        global $bypass_ua;
        global $lock_device;
        global $is_isplock;
        global $max_connections;
        global $bouquet;
        global $is_restreamer;
        global $member_id;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $IF = intval($intro->input->get_post('IF'));
        $device_id = intval($intro->input->get_post('device_id'));
        $page = intval($intro->input->get_post('page'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        $btn = [];
        $user_id = 0;
        $db_mac = '';
        if( $IF != 1 ) 
        {
            $this->nav();
        }
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $qry = '';
            if( $this->admin['level'] != 1 && $this->admin['level'] != 9 ) 
            {
                $qry = ' and member_id=' . $this->admin['adminid'];
            }
            $sql = $intro->db->query('SELECT * FROM enigma2_devices where device_id=' . $device_id . ';');
            $rowMag = $intro->db->fetch_assoc($sql);
            @extract($rowMag);
            $user_id = intval($rowMag['user_id']);
            $db_mac = base64_decode($rowMag['mac']);
            $sql2 = $intro->db->query('SELECT * FROM users where id=' . $user_id . ' ' . $qry . ';');
            $row = $intro->db->fetch_assoc($sql2);
            @extract($row);
            $sql2 = $intro->db->query('SELECT * FROM ' . PREFIX . ('_users_data where userid=' . $user_id . ';'));
            $row2 = $intro->db->fetch_assoc($sql2);
            @extract($row2);
            $mac = base64_decode($mac);
            $btn['legend_name'] = 'Edit MAG: <b>' . $mac . '</b>';
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
            $bouquet = json_decode($bouquet, true);
            if( $allowed_ips != '' ) 
            {
                $tmp_ua = json_decode($allowed_ips, true);
                $allowed_ips = implode(',', $tmp_ua);
            }
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            new IntroPerms('CheckBalance', $this->adminRow);
            $btn['legend_name'] = 'Add new MAG';
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = $intro->lang['save'];
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            $is_isplock = ($is_isplock == '' ? 0 : $is_isplock);
            if( $this->adminRow['num_free'] == 0 ) 
            {
            }
            $max_connections = ($max_connections == '' ? 1 : $max_connections);
            if( is_array($intro->input->post('bouquets')) && count($intro->input->post('bouquets')) >= 1 ) 
            {
                $bouquet = $intro->input->post('bouquets');
            }
            if( intval($intro->input->post('adminid')) != 0 ) 
            {
                $member_id = intval($intro->input->post('adminid'));
            }
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ') . "\r\n\t\t" . _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911() . (" \r\n\t\t<form method=\"POST\" name=\"form_add\" id='frmUsers' action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\r\n\t\t<table class=\"table table-bordered\">\r\n\t\t<tr>\r\n\t\t\t<td style='width:30%'>") . $intro->lang['codes_fullname'] . (" :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"fullname\" value=\"" . $fullname . "\" class=\"form-control\" style='min-width:70%'>\r\n\t\t\t\t\t" . $this->error('fullname') . "\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Mobile : </td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"mobile\" value=\"" . $mobile . "\" class=\"form-control\"  style='min-width:70%'> \r\n\t\t\t\t\t" . $this->error('mobile') . "\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Device MAC Address : <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td><div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"mac\" value=\"" . $mac . "\" class=\"form-control\" style=\"min-width:300px;text-transform:uppercase\"> \r\n\t\t\t\t\t" . $this->error('mac') . "\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>");
        if( $this->admin['level'] == 1 || $t == 'add' ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Period (days) :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td><div class=\"form-inline\">\r\n\t\t\t\t\t\t" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period', _obf_0D322A5B141A102E2824032B03230A35140306272F2F11(), $period) . (' ' . $this->error('period'));
            if( $this->admin['level'] == 1 ) 
            {
                echo '<span id="span_free_days" style="display:none">Free Extra Days: <input  type="number" name="free_days" value="' . $free_days . '" ' . (($t == 'add' ? 'min="1"' : '')) . ' class="form-control" size="10"></span>';
            }
            else if( strlen($this->adminRow['extra_free_days']) >= 2 ) 
            {
                echo extra_free_days($this->adminRow['extra_free_days'], $free_days);
            }
            echo "\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        if( $t == 'edit' ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Created at : </td>\r\n\t\t\t\t<td><i>" . date('Y-m-d H:i:s', $created_at) . "</i></td>\r\n\t\t\t</tr>";
        }
        if( $this->admin['level'] == 1 && $t == 'edit' ) 
        {
            $exp_date = date('Y-m-d H:i:s', $exp_date);
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>End Date : </td>\r\n\t\t\t\t<td><input type=\"text\" name=\"exp_date\" value=\"" . $exp_date . "\" size=\"25\"></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Is Trial  : </td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('is_trial', $is_trial, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>";
        }
        echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Bouquets:  <span style='color:#ff0000'>*</span>\r\n\t\t\t\t\t<div style=\"float:right;\">\r\n\t\t\t\t\t\t   <input type=\"checkbox\" id=\"checkAll\"/> <b>Check All</b>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td> " . $this->error('bouquets') . ' ' . bouquets($bouquet) . "</td>\r\n\t\t\t</tr>";
        if( $this->admin['level'] == 1 || $this->adminRow['can_set_country'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Override General Country Restriction:  </td>\r\n\t\t\t\t<td> " . forced_country($forced_country) . " </td>\r\n\t\t\t</tr>";
        }
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Lock STB Device on Hardware :</td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('lock_device', $lock_device, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Lock user to his ISP :</td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('is_isplock', $is_isplock, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>";
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Allowed IPs :</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t\t<input class=\"form-control\" data-role=\"tagsinput\" type=\"text\" name=\"allowed_ips\" value=\"" . $allowed_ips . '" size="30"> ' . $this->error('allowed_ips') . " \r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        if( in_array($this->admin['level'], [
            1, 
            6
        ]) ) 
        {
            $qry_father = '';
            if( $this->admin['level'] == 6 ) 
            {
                $fath = intval($this->admin['adminid']);
                $qry_father = 'WHERE adminid=' . $fath . ' OR father=' . $fath . ' ';
                if( $t == 'add' ) 
                {
                    $adminid = $fath;
                }
            }
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>" . $intro->lang['codes_adminid'] . " :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td>" . _obf_0D312C22263726180408322D1B0C363E320C351C1B0B32($adminid, $qry_father) . (' ' . $this->error('adminid') . "</td>\r\n\t\t\t</tr>");
        }
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Admin Notes :</td>\r\n\t\t\t\t<td><textarea name=\"admin_notes\" class=\"form-control\" style='width:100%;height:70px;'>" . $admin_notes . '</textarea> ' . $this->error('admin_notes') . "</td>\r\n\t\t\t</tr>";
        }
        echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Reseller Notes :</td>\r\n\t\t\t\t<td><textarea name=\"reseller_notes\" class=\"form-control\" style='width:100%;height:70px;'>" . $reseller_notes . '</textarea> ' . $this->error('reseller_notes') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"user_id\"  value=\"" . $user_id . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"device_id\"  value=\"" . $device_id . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"IF\"  value=\"" . $IF . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"page\"  value=\"" . $page . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"db_mac\"  value=\"" . $db_mac . "\">\r\n\t\t\t\t\t<button type=\"submit\" class=\"btn btn-success\" value=\"" . $btn['action'] . '"><i class="' . $btn['img_icon'] . '"> ' . $btn['name'] . " </i></button>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\tfunction isValidMac(mystring){\r\n\t\t\tvar regex = /^([0-9A-F]{2}[:-]){5}([0-9A-F]{2})\$/;\r\n\t\t\treturn regex.test(mystring);\r\n\t\t}\r\n\t\t\$(document).ready(function(){\r\n\r\n\t\t\t\$(\"#checkAll\").change(function () {\r\n\t\t\t\t\$(this).closest('tr').find(':checkbox').prop('checked', \$(this).prop(\"checked\"));\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$(\"select[name=period]\").change(function () {\r\n\t\t\t\t\r\n\t\t\t\tvar groupName = \$(this).val();\r\n\t\t\t\t\r\n\t\t\t\tif(groupName < 100 && groupName >= 1){\r\n\t\t\t\t\t\$('#span_free_days').show();\r\n\t\t\t\t\t\r\n\t\t\t\t}else{\r\n\t\t\t\t\t\$('#span_free_days').hide();\r\n\t\t\t\t}\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$.validator.addMethod(\"macVldt\", function(value) {\r\n\t\t\t\treturn isValidMac(value.toUpperCase());\r\n\t\t\t}, 'Please enter valid MAC Address!');\r\n\t\t\t\r\n\t\t\t\$(\"#frmUsers\").validate({\r\n\t\t\t\tignore: [],\r\n\t\t\t\trules: {\r\n\t\t\t\t\tfullname: \"required\",\r\n\t\t\t\t\tperiod: \"required\",\r\n\t\t\t\t\tadminid: \"required\",\r\n\t\t\t\t\tusername: {\r\n\t\t\t\t\t\trequired: true,\r\n\t\t\t\t\t\tminlength: 5\r\n\t\t\t\t\t},\r\n\t\t\t\t\tmac: 'macVldt',\r\n\t\t\t\t\t'bouquets[]': {\r\n\t\t\t\t\t\trequired: true,\r\n\t\t\t\t\t\tminlength: 1\r\n\t\t\t\t\t}\r\n\t\t\t\t},\r\n\t\t\t\tmessages: {\r\n\t\t\t\t\tfullname: \"Required!\",\r\n\t\t\t\t\tperiod: \"Choose Period!\",\r\n\t\t\t\t\tusername: \"Required!\",\r\n\t\t\t\t\t\r\n\t\t\t\t\t'bouquets[]': \"Choose Bouquets.\"\r\n\t\t\t\t}\r\n\t\t\t});\r\n\t\t\t\r\n\t\t});";
        if( $period >= 1 && $period < 100 ) 
        {
            echo "\$('#span_free_days').show();\n";
        }
        else
        {
            echo "\$('#span_free_days').hide();\n";
        }
        echo "\r\n\t\t</script>";
    }
    public function stream_output_format($userid, $t = '')
    {
        global $intro;
        $html = '';
        $outputs = [
            '1' => 'HLS', 
            '2' => 'MPEGTS', 
            '3' => 'RTMP'
        ];
        $output = [];
        $sql = $intro->db->query('select access_output_id from user_output where user_id=' . $userid . ';');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $output[] = intval($row['access_output_id']);
        }
        if( isset($_POST['stream_output_format']) && count($_POST['stream_output_format']) > 0 ) 
        {
            $output = $intro->input->post('stream_output_format');
        }
        foreach( $outputs as $key => $val ) 
        {
            $html .= ("<label class=\"checkbox-inline\">\r\n\t\t\t\t<input type=\"checkbox\" name=\"stream_output_format[]\" value=\"" . $key . '" ' . (($t == 'add' ? 'checked' : '')) . ' ' . ((in_array($key, $output) ? 'checked' : '')) . ('> ' . $val . "\r\n\t\t\t\t</label>"));
        }
        return $html;
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        global $array;
        $fullname = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('fullname'), ' {ar}');
        $mobile = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('mobile'), '+-');
        $mac = strtoupper(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('mac'), ':'));
        $period = intval($intro->input->post('period'));
        $adminid = intval($intro->input->post('adminid'));
        $bypass_ua = intval($intro->input->post('bypass_ua'));
        $is_isplock = intval($intro->input->post('is_isplock'));
        $lock_device = intval($intro->input->post('lock_device'));
        $free_days = intval($intro->input->post('free_days'));
        $bouquets = $intro->input->post('bouquets');
        $forced_country = trim($intro->input->post('forced_country'));
        $allowed_ua = trim($intro->input->post('allowed_ua'));
        $allowed_ips = trim($intro->input->post('allowed_ips'));
        $admin_notes = $intro->db->escape($intro->input->post('admin_notes'));
        $reseller_notes = $intro->db->escape($intro->input->post('reseller_notes'));
        $username = 'e2' . preg_replace('/[^a-zA-Z0-9:]+/', '', $mac);
        if( $fullname == '' || $adminid == 0 && $this->admin['level'] == 1 || $period == 0 || $bouquets == null || $this->adminRow['num_free'] == 0 && in_array($period, $array['free']) ) 
        {
            if( $fullname == '' ) 
            {
                $error['fullname'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $period == 0 ) 
            {
                $error['period'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $this->adminRow['num_free'] == 0 && in_array($period, $array['free']) ) 
            {
                $error['period'] = '<span class=error>Error: you can\'t Add free MAGs at this time. Please contact admin.</span>';
            }
            if( $adminid == 0 && $this->admin['level'] == 1 ) 
            {
                $error['adminid'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $bouquets == null ) 
            {
                $error['bouquets'] = '<span class=error>Please choose at least one Bouquets/PACKAGE</span>';
            }
            $this->Form('add');
            exit();
        }
        $intro->db->query_fast('SELECT device_id FROM `enigma2_devices`  where mac LIKE \'' . $mac . '\';');
        if( $intro->db->returned_rows > 0 ) 
        {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Error: adding E2.', 'danger');
            $error['mac'] = '<span class=\'error\'>E2 MAC ' . $mac . ' Already used. Please input new one.</span>';
            $this->Form('add');
            exit();
        }
        if( $this->admin['level'] != 1 && $adminid == 0 ) 
        {
            $adminid = intval($this->admin['adminid']);
        }
        $adm = $intro->auth->admin_data($adminid);
        $p = new IntroPerms('CheckCost', $adm, 1, $period);
        if( $p->error != '' ) 
        {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011($p->error, 'danger');
            $error['cost_err'] = _obf_0D3D40321528110F062A0B0321102712170C15030F2232($p->error, 'danger');
            $this->Form('add');
            exit();
        }
        $dataE2 = $dataUser = [];
        $time = time();
        $dataUser = [
            'is_e2' => 1, 
            'exp_date' => _obf_0D1E12391F102F2E2A3E23330537315C320C3910402322($period, $free_days), 
            'member_id' => $adminid, 
            'created_by' => $adminid, 
            'username' => $username, 
            'password' => _obf_0D2F32243C12041507380F0603331A24041D1E32150A32(), 
            'is_isplock' => $is_isplock, 
            'admin_notes' => $admin_notes, 
            'allowed_ua' => json_encode([]), 
            'created_at' => $time, 
            'reseller_notes' => $reseller_notes, 
            'forced_country' => $forced_country, 
            'allowed_ips' => _obf_0D2A1F0B1D22240D3D103E2A0D32125C5C013F192C3632($allowed_ips, 'save'), 
            'bouquet' => json_encode($bouquets)
        ];
        $dataUser['is_trial'] = (in_array($period, $array['free']) && $period != -1 ? 1 : 0);
        $intro->db->insert('users', $dataUser);
        $user_id = $intro->db->insert_id();
        $intro->db->insert('user_output', [
            'user_id' => $user_id, 
            'access_output_id' => 2
        ]);
        $dataE2['user_id'] = $user_id;
        $dataE2['mac'] = $mac;
        $dataE2['lock_device'] = $lock_device;
        $intro->db->insert('enigma2_devices', $dataE2);
        $sql = $intro->db->query_fast('SELECT device_id,user_id FROM `enigma2_devices`  where mac LIKE \'' . $mac . '\' LIMIT 1;');
        $magRow = $intro->db->fetch_assoc($sql);
        $device_id = intval($magRow['device_id']);
        if( $device_id == 0 ) 
        {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Error: adding E2.', 'danger');
            $error['mac'] = '<span class=\'error\'>Error: something wrong with adding E2 MAC. can\'t know id.</span>';
            $this->Form('add');
            exit();
            exit();
        }
        $data = $data2 = [];
        $data2['fullname'] = $fullname;
        $data2['mobile'] = $mobile;
        $data2['period'] = $period;
        $data2['free_days'] = $free_days;
        $data2['userid'] = $user_id;
        $intro->db->insert_update('' . PREFIX . '_users_data', $data2);
        if( !in_array($period, $array['free']) && $user_id != 0 ) 
        {
            $inv = new IntroInvoice();
            $inv->set('adminid', $adminid);
            $inv->set('period', $period);
            $inv->set('num', 1);
            $inv->set('code_trans', 0);
            $inv->set('all_data', '');
            $inv->set('userid', $user_id);
            $inv->set('notes', 'add E2: ' . $mac);
            $inv->Save();
        }
        if( in_array($period, $array['free']) && $this->adminRow['num_free'] > 0 && $success > 0 ) 
        {
            $intro->db->query('UPDATE ' . PREFIX . ('_admin SET num_free=num_free-' . $success . ' WHERE num_free>0 AND adminid=' . $adminid . ';'));
            if( $this->adminRow['father'] > 0 ) 
            {
                $intro->db->query('UPDATE ' . PREFIX . ('_admin SET num_free=num_free-' . $success . ' WHERE num_free>0 AND adminid=' . $this->adminRow['father'] . ';'));
            }
            $intro->db->query('UPDATE ' . PREFIX . '_admin SET num_free=0 WHERE num_free<-1;');
        }
        $intro->redirect($this->appname);
    }
    public function random_number($length)
    {
        $random = substr(number_format(time() * rand(), 0, '', ''), 0, $length);
        return $random;
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        global $error;
        exit( '<h1>Soon' );
        $userid = intval($intro->input->get_post('user_id'));
        $device_id = intval($intro->input->get_post('device_id'));
        $fullname = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('fullname'), ' {ar}');
        $mobile = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('mobile'), '\+');
        $mac = strtoupper(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('mac'), ':'));
        $username = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('username'));
        $password = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('password'));
        $period = intval($intro->input->post('period'));
        $adminid = intval($intro->input->post('adminid'));
        $bypass_ua = intval($intro->input->post('bypass_ua'));
        $is_isplock = intval($intro->input->post('is_isplock'));
        $is_stalker = intval($intro->input->post('is_stalker'));
        $lock_device = intval($intro->input->post('lock_device'));
        $free_days = intval($intro->input->post('free_days'));
        $db_mac = trim($intro->input->post('db_mac'));
        $exp_date = trim($intro->input->post('exp_date'));
        $forced_country = trim($intro->input->post('forced_country'));
        $allowed_ua = trim($intro->input->post('allowed_ua'));
        $allowed_ips = trim($intro->input->post('allowed_ips'));
        $admin_notes = $intro->db->escape($intro->input->post('admin_notes'));
        $reseller_notes = $intro->db->escape($intro->input->post('reseller_notes'));
        $bouquets = $intro->input->post('bouquets');
        $data = $data2 = $MAG = [];
        if( $db_mac != $mac ) 
        {
            $sql = $intro->db->query_fast('SELECT device_id,mac FROM `enigma2_devices`   WHERE mac LIKE \'' . base64_encode($mac) . '\' /*AND mac NOT LIKE \'' . base64_encode($db_mac) . '\'*/ LIMIT 1;');
            $row_check = $intro->db->fetch_assoc($sql);
            if( intval($row_check['device_id']) > 0 ) 
            {
                _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Error: the MAC ' . $mac . ' is already exists.', 'danger');
                $error['mac'] = '<span class=\'error\'>your new MAC (' . $mac . ') already used.</span>';
                $this->Form('edit');
                exit();
            }
            $MAG['mac'] = base64_encode($mac);
        }
        $data2['userid'] = $userid;
        $data2['fullname'] = $fullname;
        $data2['mobile'] = $mobile;
        if( $this->admin['level'] == 1 ) 
        {
            $data['created_by'] = intval($intro->input->post('adminid'));
            $data['member_id'] = intval($intro->input->post('adminid'));
            $data['exp_date'] = strtotime($exp_date);
            $data2['period'] = $period;
            $data2['free_days'] = $free_days;
            $data['admin_notes'] = $admin_notes;
            $data['is_trial'] = intval($intro->input->post('is_trial'));
        }
        $data['bouquet'] = '[' . implode(',', $bouquets) . ']';
        $data['forced_country'] = $forced_country;
        $data['allowed_ips'] = _obf_0D2A1F0B1D22240D3D103E2A0D32125C5C013F192C3632($allowed_ips, 'save');
        $data['is_isplock'] = $is_isplock;
        $data['reseller_notes'] = $reseller_notes;
        $qry = '';
        if( $this->admin['level'] != 1 && $this->admin['level'] != 9 ) 
        {
            $qry = ' and member_id=' . $this->admin['adminid'];
        }
        $intro->db->update('users', $data, 'id=' . $userid . ' ' . $qry);
        $intro->db->insert_update('' . PREFIX . '_users_data', $data2, $data2);
        $MAG['lock_device'] = $lock_device;
        $intro->db->update('enigma2_devices', $MAG, 'device_id=' . $device_id);
        $intro->redirect($this->appname);
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $e2 = intval($intro->input->get_post('e2'));
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');
        $sql = $intro->db->query('SELECT * FROM enigma2_devices e2, users u ' . (' where e2.user_id=u.id AND device_id=' . $e2 . ' ' . $this->qry_admin . ';'));
        $row = $intro->db->fetch_assoc($sql);
        $mac = $row['mac'];
        $id = intval($row['user_id']);
        if( intval($row['id']) == 0 ) 
        {
            echo '<h1>Not authorized!</h1>';
            exit();
        }
        if( $this->admin['level'] == 1 || $this->admin['can_delete'] == 1 ) 
        {
            $intro->db->query('delete FROM `enigma2_actions` WHERE `device_id` = ' . $e2 . ';');
            $intro->db->query('delete FROM `user_output` where user_id=' . $id . ';');
            $intro->db->query('delete FROM `users` WHERE id=' . $id . ';');
            $intro->db->query('delete FROM `enigma2_devices` WHERE device_id=' . $e2 . ' ' . $this->qry_admin);
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('E2 deleted form database forever!', 'success');
            echo "<script>\r\n\t\t\t\$(function () {\r\n\t\t\t   setTimeout(function()\r\n\t\t\t   {\r\n\t\t\t\t\t\$('#m3u-modal').modal('hide');\r\n\t\t\t\t\t\$('#tr_" . $id . "').fadeOut();\r\n\t\t\t   }, 1000);\r\n\t\t\t   \r\n\t\t\t});</script>";
            exit();
        }
        else
        {
            exit( '<h1>Not authorized!</h1>' );
        }
    }
}
