<?php 
class Fix_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $qry_admin_where = '';
    public $admin = [];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        if( $this->admin['level'] != 1 ) 
        {
            $this->qry_admin = ' and adminid=' . intval($this->admin['adminid']);
            $this->qry_admin_where = ' where adminid=' . intval($this->admin['adminid']);
        }
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "\n\t\t<div class=\"app_nav\">\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . "/index\">\n\t\t\t<icon class=\"icon-list\">Fix</icon>\n\t\t</a>\n\t\t<a class=\"btn btn-success\" href=\"" . $this->base . "/index?fixall=yes\">Fix All</a>\n\t\t\n\t\t<a class=\"btn btn-warning\" href=\"" . $this->base . "/Duplicated\">\n\t\t\t<icon class=\"icon-list\">Duplicated Codes</icon>\n\t\t</a>\n\t\t<a class=\"btn btn-warning\" href=\"" . $this->base . "/DuplicatedUsers\">\n\t\t\t<icon class=\"icon-list\">Duplicated Users</icon>\n\t\t</a>\n\t\t\n\t\t<a class=\"btn btn-default\" href=\"" . $this->base . "/clean\">\n\t\t\t<icon class=\"icon-list\">Fix user_output</icon>\n\t\t</a>\n\t\t<a class=\"btn btn-default\" href=\"" . $this->base . "/fixUserid\">\n\t\t\t<icon class=\"icon-list\">Fix UserID</icon>\n\t\t</a>\n\t\t\n\t\t<a class=\"btn btn-default\" href=\"" . $this->base . "/FixDates\">\n\t\t\t<icon class=\"icon-list\">Fix Dates</icon>\n\t\t</a>\n\t\t\n\t\t</div>");
    }
    public function vod()
    {
        global $intro;
        global $array;
        $this->nav();
        echo '<h1>Fixing VOD </h1>';
        $result = $intro->db->query('SELECT * from streams where type = 2');
        echo "<table class=\"tableX table-bordered table-hover table-striped\">\n        <thead>\n\t    <tr>\n\t\t\t\n\t\t\t<th>#</th>\n\t\t\t<th>catid</th>\n\t\t\t<th>movie name </th>\n\t\t\t<th>movie source </th>\n\t\t\t<th> </th>\n\t\t\t<th> </th>\n\t    </tr>\n\t\t</thead>\n\t\t\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $stream_display_name = urldecode($stream_display_name);
            $stream_display_name = str_replace('_', ' ', $stream_display_name);
            $intro->db->query('update streams set stream_display_name=\'' . $stream_display_name . '\' where id=' . $id);
            $stream_source2 = '';
            if( preg_match('/%/', $stream_source) ) 
            {
                $stream_source2 = urldecode($stream_source);
                $intro->db->query('update streams set stream_source=\'' . $stream_source2 . '\' where id=' . $id);
            }
            echo "\n\t\t\t<tr class=\"" . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\n\t\t\t\t\n\t\t\t\t<td class=\"center\">" . $i . "</td>\n\t\t\t\t<td>" . $category_id . "</td>\n\t\t\t\t<td>" . $stream_display_name . "</td>\n\t\t\t\t<td>" . $stream_source . "</td>\n\t\t\t\t<td>" . $stream_source2 . "</td>\n\t\t\t\t<td></td>\n\t\t\t\t<td class=\"center\"></td>\n\t\t\t</tr>");
        }
        echo "</tbody>\n\t\t</table>";
    }
    public function index()
    {
        global $intro;
        global $array;
        $this->nav();
        $fixall = trim($intro->input->get_post('fixall'));
        $result = $intro->db->query('SELECT * FROM ' . PREFIX . '_codes WHERE `status`=1 AND inputBy=0 ' . ' and userid NOT IN (SELECT id FROM users);');
        $totrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Codes are Activated and Not in Xtream database (' . $totrows . ')');
        echo "\n\t\t<table class=\"DataTable table-striped table-bordered\" id=\"table_codes\">\n        <thead>\n\t    <tr>\n\t\t\n\t\t\t<th>#</th>\n\t\t\t<th> Fullname </th>\n\t\t\t<th> Code </th>\n\t\t\t<th> username </th>\n\t\t\t<th> Status </th>\n\t\t\t\n\t\t\t<th> Expire </th>\n\t\t\t<th> TransID </th>\n\t\t\t<th> Reseller </th>\n\t\t\t<th> MAC </th>\n\t\t\t<th> Serial </th>\n\t\t\t<th>\n\t\t\t<a class=\"btn btn-success\" href=\"" . $this->base . "/index?fixall=yes\">Fix All</a>\n\t\t\t</th>\n\t    </tr>\n\t\t</thead>\n\t\t\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $date_expire = ($date_expire != '' ? date('Y-m-d', $date_expire) : '-');
            echo "\n\t\t\t<tr class=\"" . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\n\t\t\t\t<td class=\"center\">" . $id . "</td>\n\t\t\t\t<td class=\"center\">" . $fullname . "</td>\n\t\t\t\t<td class=\"center\">" . $code . "</td>\n\t\t\t\t<td class=\"center\">" . $username . "</td>\n\t\t\t\t<td class=\"center\">" . $status . "</td>\n\t\t\t\t<td class=\"center\">" . $date_expire . "</td>\n\t\t\t\t<td class=\"center\">" . $transid . "</td>\n\t\t\t\t<td class=\"center\">" . $adminid . "</td>\n\t\t\t\t<td class=\"center\">" . $mac . "</td>\n\t\t\t\t<td class=\"center\">" . $serial . "</td>\n\t\t\t\t<td class=\"center\">");
            if( $fixall == 'yes' ) 
            {
                $this->Fix($id);
            }
            else
            {
                echo '<span id="RES' . $id . '"></span><a class="FixAll" id="' . $id . '" href="' . $this->base . '/Fix?NH=1&id=' . $id . '" OnClick="return false;">Fix</a>';
            }
            echo "\n\t\t\t\t</td>\n\t\t\t</tr>";
        }
        $result = $myrow = '';
        $result = $intro->db->query('SELECT * FROM ' . PREFIX . '_codes WHERE `status`=1 AND inputBy>0 ' . ' and `username` NOT IN (SELECT username FROM users);');
        if( $intro->db->returned_rows > 0 ) 
        {
            echo "\n\t\t\t<tr>\n\t\t\t\t<th class=\"center\" colspan=11>FIX SERIAL/MAC Activated Codes</th>\n\t\t\t</tr>";
        }
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $date_expire = ($date_expire != '' ? date('Y-m-d', $date_expire) : '-');
            echo "\n\t\t\t<tr class=\"" . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\n\t\t\t\t<td class=\"center\">" . $id . "</td>\n\t\t\t\t<td class=\"center\">" . $fullname . "</td>\n\t\t\t\t<td class=\"center\">" . $code . "</td>\n\t\t\t\t<td class=\"center\">" . $username . "</td>\n\t\t\t\t<td class=\"center\">" . $status . "</td>\n\t\t\t\t<td class=\"center\">" . $date_expire . "</td>\n\t\t\t\t<td class=\"center\">" . $transid . "</td>\n\t\t\t\t<td class=\"center\">" . $adminid . "</td>\n\t\t\t\t<td class=\"center\">" . $mac . "</td>\n\t\t\t\t<td class=\"center\">" . $serial . "</td>\n\t\t\t\t<td class=\"center\">");
            if( $fixall == 'yes' ) 
            {
                $this->Fix($id);
            }
            else
            {
                echo '<span id="RES' . $id . '"></span><a class="FixAll" id="' . $id . '" href="' . $this->base . '/Fix?NH=1&id=' . $id . '" OnClick="return false;">Fix</a>';
            }
            echo "\n\t\t\t\t</td>\n\t\t\t</tr>";
        }
        echo "</tbody>\n\t\t\t</table>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\n\t\t\$(document).ready(function() {\n\t\t\t\$(\".FixAll\").on(\"click\", function(e) {\n\t\t\t\t\n\t\t\t\te.preventDefault();\n\t\t\t\tvar id = \$(this).attr('id');\n\n\t\t\t\t\$.get( \$(this).attr('href') , function( data ) { \n\t\t\t\t\t\$(\"#RES\" + id).html(data);\n\t\t\t\t});\n\t\t\t\t\n\t\t\t\treturn false;\n\t\t\t});\n\t\t\t\n\t\t});\n\t\t</script>";
    }
    public function getAdmin()
    {
        global $intro;
        if( isset($intro->option['default_users_acct']) && intval($intro->option['default_users_acct']) > 0 ) 
        {
            return intval($intro->option['default_users_acct']);
        }
        else
        {
            return 1;
        }
    }
    public function Fix($id = 0)
    {
        global $intro;
        if( $id == 0 ) 
        {
            $id = intval($intro->input->get_post('id'));
        }
        $sql = $intro->db->query('SELECT * FROM ' . PREFIX . ('_codes WHERE id=' . $id . ';'));
        $row = $intro->db->fetch_assoc($sql);
        extract($row);
        $data = [];
        $data['member_id'] = $this->getAdmin();
        $data['username'] = ($row['inputBy'] == 0 ? $row['code'] : $row['username']);
        $data['password'] = uniqid();
        $data['exp_date'] = $row['date_expire'];
        $data['admin_notes'] = $row['fullname'];
        $data['admin_enabled'] = 1;
        $data['enabled'] = 1;
        $data['bouquet'] = '[' . $row['bouquets'] . ']';
        $data['max_connections'] = 1;
        $data['created_at'] = time();
        $data['created_by'] = $this->getAdmin();
        $data['forced_country'] = $row['forced_country'] . '';
        $intro->db->insert('users', $data);
        $userID = $intro->db->insert_id();
        $intro->db->insert('user_output', [
            'user_id' => $userID, 
            'access_output_id' => 2
        ]);
        $intro->db->query('UPDATE ' . PREFIX . ('_codes set userid=' . $userID . ' WHERE id=' . $id . ';'));
        echo 'Success';
    }
    public function Duplicated()
    {
        global $intro;
        global $array;
        $this->nav();
        $delAll = trim($intro->input->get_post('delAll'));
        if( $delAll == 'yes' ) 
        {
            $limit = 2500;
        }
        else
        {
            $limit = 500;
        }
        $result = $intro->db->query("    \n\t\t\t\tSELECT u.id, u.username, u.exp_date  \n\t\t\t\tFROM users u\n\t\t\t\tINNER JOIN(  \n\t\t\t\tSELECT username  \n\t\t\t\tFROM users  \n\t\t\t\tGROUP BY username  \n\t\t\t\tHAVING COUNT(username) >1  \n\t\t\t\t)temp ON u.username= temp.username ORDER BY u.username ASC LIMIT " . $limit . ';  ');
        $totrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Codes are Activated and Not in Xtream database (' . $totrows . ')');
        echo "\n\t\t<table class=\"DataTable table-striped table-bordered\" id=\"table_codes\">\n        <thead>\n\t    <tr>\n\t\t\n\t\t\t<th>#</th>\n\t\t\t<th> Fullname </th>\n\t\t\t<th> Code </th>\n\t\t\t<th> username </th>\n\t\t\t<th> Status </th>\n\t\t\t\n\t\t\t<th> Expire </th>\n\t\t\t<th> TransID </th>\n\t\t\t<th> Count </th>\n\t\t\t<th> MAC </th>\n\t\t\t<th> Serial </th>\n\t\t\t<th>\n\t\t\t<a class=\"btn btn-danger\" href=\"" . $this->base . "/Duplicated?delAll=yes\">Del All</a>\n\t\t\t</th>\n\t    </tr>\n\t\t</thead>\n\t\t\n\t\t<tbody>";
        $i = 0;
        $found_user = '';
        $fullname = $code = $mac = $serial = '';
        $status = $transid = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $date_expire = ($exp_date != '' ? date('Y-m-d H:i:s', $exp_date) : '-');
            $username = strtolower($username);
            if( $username == $found_user ) 
            {
                $bg = '';
            }
            else
            {
                $bg = '#ffff26';
            }
            echo "\n\t\t\t<tr style='background:" . $bg . "'>\n\t\t\t\t<td class=\"center\">" . $id . "</td>\n\t\t\t\t<td class=\"center\">" . $fullname . "</td>\n\t\t\t\t<td class=\"center\">" . $code . "</td>\n\t\t\t\t<td class=\"center\">" . $username . "</td>\n\t\t\t\t<td class=\"center\">" . $status . "</td>\n\t\t\t\t<td class=\"center\">" . $date_expire . "</td>\n\t\t\t\t<td class=\"center\">" . $transid . "</td>\n\t\t\t\t<td class=\"center\"></td>\n\t\t\t\t<td class=\"center\">" . $mac . "</td>\n\t\t\t\t<td class=\"center\">" . $serial . "</td>\n\t\t\t\t<td class=\"center\">";
            if( $username == $found_user ) 
            {
                echo '<span id="RES' . $id . '"><a class="DellAll" id="' . $id . '" href="' . $this->base . '/DelDuplicated?NH=1&id=' . $id . '" OnClick="return false;">Del</a></span>';
                if( $delAll == 'yes' ) 
                {
                    $intro->db->query_fast('delete from users where id=' . $id . ';');
                }
            }
            echo "\n\t\t\t\t</td>\n\t\t\t</tr>";
            $found_user = $username;
        }
        echo "</tbody>\n\t\t\t</table>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\n\t\t\$(document).ready(function() {\n\t\t\t\$(\".DellAll\").on(\"click\", function(e) {\n\t\t\t\t\n\t\t\t\te.preventDefault();\n\t\t\t\tvar id = \$(this).attr('id');\n\n\t\t\t\t\$.get( \$(this).attr('href') , function( data ) { \n\t\t\t\t\t\$(\"#RES\" + id).html(data);\n\t\t\t\t});\n\t\t\t\t\n\t\t\t\treturn false;\n\t\t\t});\n\t\t\t\n\t\t});\n\t\t</script>";
    }
    public function DuplicatedUsers()
    {
        global $intro;
        global $array;
        $this->nav();
        $fixAll = trim($intro->input->get_post('fixAll'));
        if( $fixAll == 'yes' ) 
        {
            $limit = 2500;
        }
        else
        {
            $limit = 500;
        }
        $result = $intro->db->query("    \n\t\t\t\tSELECT c.id, c.username, c.date_expire,c.code,c.fullname,c.userid,c.status,c.transid,\n\t\t\t\tc.mac,c.serial\n\t\t\t\tFROM " . PREFIX . "_codes c\n\t\t\t\tINNER JOIN(  \n\t\t\t\tSELECT username  \n\t\t\t\tFROM " . PREFIX . ("_codes  \n\t\t\t\tGROUP BY username  \n\t\t\t\tHAVING COUNT(username) >1  \n\t\t\t\t)temp ON c.username=temp.username AND c.username!=''  ORDER BY c.username ASC LIMIT " . $limit . ';  '));
        $totrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Duplicated Users in codes. (' . $totrows . ')');
        echo "\n\t\t<table class=\"DataTable table-striped table-bordered\" id=\"table_codes\">\n        <thead>\n\t    <tr>\n\t\t\t<th>CodeID</th>\n\t\t\t<th>Userid</th>\n\t\t\t<th>Fullname</th>\n\t\t\t<th>Code</th>\n\t\t\t<th>username</th>\n\t\t\t<th>Status</th>\t\t\t\n\t\t\t<th>Expire</th>\n\t\t\t<th>TransID</th>\n\t\t\t<th>Count</th>\n\t\t\t<th>MAC</th>\n\t\t\t<th>Serial</th>\n\t\t\t<th>\n\t\t\t\t<a class=\"btn btn-danger\" href=\"" . $this->base . "/DuplicatedUsers?fixAll=yes\">Fix All</a>\n\t\t\t</th>\n\t    </tr>\n\t\t</thead>\n\t\t<tbody>";
        $i = 0;
        $found_user = '';
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $date_expire = ($date_expire != '' ? date('Y-m-d H:i:s', $date_expire) : '-');
            $username = strtolower($username);
            if( $username == $found_user ) 
            {
                $bg = '';
            }
            else
            {
                $bg = '#ffff26';
            }
            echo "\n\t\t\t<tr style='background:" . $bg . "'>\n\t\t\t\t<td class=\"center\">" . $id . "</td>\n\t\t\t\t<td class=\"center\">" . $userid . "</td>\n\t\t\t\t<td class=\"center\">" . $fullname . "</td>\n\t\t\t\t<td class=\"center\">" . $code . "</td>\n\t\t\t\t<td class=\"center\">" . $username . "</td>\n\t\t\t\t<td class=\"center\">" . $status . "</td>\n\t\t\t\t<td class=\"center\">" . $date_expire . "</td>\n\t\t\t\t<td class=\"center\">" . $transid . "</td>\n\t\t\t\t<td class=\"center\"></td>\n\t\t\t\t<td class=\"center\">" . $mac . "</td>\n\t\t\t\t<td class=\"center\">" . $serial . "</td>\n\t\t\t\t<td class=\"center\">";
            if( $username == $found_user ) 
            {
                $newUser = $username . 'FIX' . $i;
                if( $fixAll == 'yes' ) 
                {
                    $intro->db->query_fast('update ' . PREFIX . ('_codes set username=\'' . $newUser . '\' where id=' . $id . ';'));
                    if( $userid > 0 ) 
                    {
                        $intro->db->query_fast('update users set username=\'' . $newUser . '\' where id=' . $userid . ';');
                    }
                    echo 'Success';
                }
            }
            echo "\n\t\t\t\t</td>\n\t\t\t</tr>";
            $found_user = $username;
        }
        echo "</tbody>\n\t\t\t</table>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\n\t\t\$(document).ready(function() {\n\t\t\t\$(\".DellAll\").on(\"click\", function(e) {\n\t\t\t\t\n\t\t\t\te.preventDefault();\n\t\t\t\tvar id = \$(this).attr('id');\n\n\t\t\t\t\$.get( \$(this).attr('href') , function( data ) { \n\t\t\t\t\t\$(\"#RES\" + id).html(data);\n\t\t\t\t});\n\t\t\t\t\n\t\t\t\treturn false;\n\t\t\t});\n\t\t\t\n\t\t});\n\t\t</script>";
    }
    public function DelDuplicated()
    {
        global $intro;
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('delete from users WHERE id=' . $id . ';');
        $aff = $intro->db->affected_rows;
        echo 'Deleted (' . $aff . ')';
    }
    public function clean()
    {
        global $intro;
        $sql = $intro->db->query('SELECT id FROM users WHERE id NOT IN (SELECT user_id from user_output);');
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $i++;
            $intro->db->insert('user_output', [
                'user_id' => $row['id'], 
                'access_output_id' => 2
            ]);
        }
        $sql = $intro->db->query('DELETE FROM `user_output` WHERE user_id NOT IN (SELECT id FROM users)');
        $aff = $intro->db->affected_rows;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Codes are Activated and Not in Xtream database (' . $aff . ')');
        echo '<h2><li> Fixed [user_output] = (' . $i . ')</li></h2>';
        echo '<h2><li> Cleaned [user_output] = (' . $aff . ')</li></h2>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function fixUserid()
    {
        global $intro;
        $sql = $intro->db->query('SELECT id,code,username,inputBy FROM solus_codes WHERE `status`=1  AND userid NOT IN (SELECT id from users);');
        $i = $aff = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $i++;
            if( $inputBy == 0 ) 
            {
                $qry = ' username=\'' . $code . '\' ';
            }
            else
            {
                $qry = ' username=\'' . $username . '\' ';
            }
            $sql2 = $intro->db->query('SELECT id from users where ' . $qry . ' limit 1');
            $row2 = $intro->db->fetch_assoc($sql2);
            $newUserID = intval($row2['id']);
            $intro->db->query('update solus_codes set userid=' . $newUserID . ' WHERE id=' . $id . ';');
            $aff += $intro->db->affected_rows;
        }
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('fix userid ');
        echo '<h2><li> Found [userid] = (' . $i . ')</li></h2>';
        echo '<h2><li> Fixed [userid] = (' . $aff . ')</li></h2>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function fix_user_output()
    {
        global $intro;
        $sql = $intro->db->query('SELECT id FROM users  WHERE id NOT IN ( SELECT user_id FROM `user_output` );');
        $aff = $intro->db->affected_rows;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Fix user output (' . $aff . ')');
        echo '<ul>';
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $intro->db->insert('user_output', [
                'user_id' => $id, 
                'access_output_id' => 2
            ]);
            echo '<li> Success = ' . $id . ' </li>';
        }
        echo '</ul>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function FixDates()
    {
        global $intro;
        $sql = $intro->db->query('SELECT cod.id as codeid,cod.code,u.id as userid,u.username ,cod.fullname,cod.date_expire,u.exp_date FROM ' . PREFIX . '_codes cod , users u ' . ' WHERE cod.userid=u.id AND cod.status=1 AND cod.date_expire<>u.exp_date LIMIT 500;');
        $count = $intro->db->returned_rows;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Fix dates (' . $count . ')');
        echo "\n\t\t<table class=\"DataTable table-striped table-bordered\" id=\"table_codes\">\n        <thead>\n\t    <tr>\n\t\t\t<th>#</th>\n\t\t\t<th> Code ID </th>\n\t\t\t<th> Userid </th>\n\t\t\t<th> Fullname </th>\n\t\t\t<th> Code </th>\n\t\t\t\n\t\t\t<th> Username </th>\n\t\t\t<th> Code Date </th>\n\t\t\t<th> Xtream Date </th>\n\t\t\t<th> Status </th>\n\t    </tr>\n\t\t</thead>\n\t\t<tbody>";
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $userid = intval($userid);
            $date_expire = $row['date_expire'];
            $exp_date = $row['exp_date'];
            if( $date_expire != '' && $date_expire != 0 ) 
            {
                if( $date_expire != $exp_date ) 
                {
                    $intro->db->query('UPDATE users SET exp_date=\'' . $date_expire . '\' WHERE id=' . $userid . ';');
                    $aff = 'Success=' . $intro->db->affected_rows;
                }
            }
            else
            {
                $aff = 'err';
            }
            echo "<tr>\n\t\t\t\t\t<td>#</td>\n\t\t\t\t\t<td>" . $codeid . "</td>\n\t\t\t\t\t<td>" . $userid . "</td>\n\t\t\t\t\t<td>" . $fullname . "</td>\n\t\t\t\t\t<td>" . $code . "</td>\n\t\t\t\t\t<td>" . $username . "</td>\n\t\t\t\t\t<td>" . date('Y-m-d H:i:s', $date_expire) . "</td>\n\t\t\t\t\t<td>" . date('Y-m-d H:i:s', $exp_date) . ("</td>\n\t\t\t\t\t<td> " . $aff . "</td>\n\t\t\t\t\t\n\t\t\t\t\t\n\t\t\t\t</tr>");
        }
        echo '</table>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function fix_conn()
    {
        global $intro;
        global $array;
        $this->nav();
        $result = $intro->db->query('SELECT cod.id as codeid,cod.code,u.id as userid,u.username  FROM ' . PREFIX . '_codes cod , users u WHERE cod.code=u.username AND cod.inputBy=0 AND u.max_connections!=2;');
        $totrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Codes by codes as username (' . $totrows . ')');
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $userid = intval($userid);
            $intro->db->query_fast('UPDATE users set max_connections=2 where id=' . $userid . ';');
            echo '<li> ' . $userid . ' - ' . $intro->db->affected_rows . ' ';
        }
        $result = $myrow = '';
        $result = $intro->db->query('SELECT cod.id as codeid,cod.code,u.id as userid,u.username  FROM ' . PREFIX . '_codes cod , users u WHERE cod.username=u.username AND cod.inputBy>0 AND u.max_connections!=2;');
        $totrows = $intro->db->returned_rows;
        echo '<hr><hr> ' . $totrows . ' <hr>';
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $userid = intval($userid);
            $intro->db->query_fast('UPDATE users set max_connections=2 where id=' . $userid . ';');
            echo '<li> ' . $userid . ' - ' . $intro->db->affected_rows . ' ';
        }
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
}
