<?php 
class Free_code_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->admin = $intro->auth->sess_admin();
        if( $this->admin['level'] != 1 ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "<div class=\"app_nav\">\r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . '/index"><icon class="icon-list"></icon>') . $intro->lang['free_code_appname'] . "</a> \r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="' . $this->base . '/Form?t=add"><icon class="icon-plus-squared"></icon>') . $intro->lang['free_code_add'] . "</a>  \t\t \t\t \r\n\t\t</div>";
    }
    public function index()
    {
        global $intro;
        global $array;
        $qry = $forced_country = '';
        $page = intval($intro->input->get_post('page'));
        $order = trim($intro->input->get_post('order'));
        $search_txt = trim($intro->input->get_post('search_txt'));
        $intro->country[''] = 'Don\'t override';
        $this->nav();
        if( $search_txt != '' )
        {
            $qry = ' where code  LIKE \'%' . $search_txt . '%\' ';
        }
        if( $order == '' )
        {
            $order = 'id:desc';
        }
        $order = str_replace(':', ' ', $order);
        $rows_per_page = 30;
        if( $page == 0 )
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $result = $intro->db->query('SELECT * from ' . PREFIX . ('_free_code ' . $qry . ' order by ' . $order . '  limit ' . $nexlimit . ',' . $rows_per_page));
        $totrows = $intro->db->returned_rows;
        $sql_all_rows = $intro->db->query('SELECT id from ' . PREFIX . ('_free_code ' . $qry . ' '));
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-list"></i> ' . $intro->lang['free_code_cur'] . (' (' . $totalrows . ')'), 'info');
        echo "\r\n\t\t\r\n\t\t<fieldset>\r\n\t\t\t<form action=\"\" method=\"post\">\r\n\t\t\t\t<input type=\"text\" name=\"search_txt\" value=\"" . $search_txt . '" placeholder="' . $intro->lang['search_form'] . "\" size=\"20\">\r\n\t\t\t\t<input name=\"name\" value=\"" . $intro->lang['search'] . "\" type=\"submit\">\r\n\t\t\t</form>\r\n\t\t</fieldset>\r\n\t\t\r\n\t\t<div class=\"table-responsive\">\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t<th> </th>\r\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index') . "</th>\r\n\t\t\t<th>" . $intro->lang['free_code_code'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('code', 'index') . " </th>\r\n\t\t\t<th>" . $intro->lang['free_code_days'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('days', 'index') . " </th>\r\n\t\t\t<th>" . $intro->lang['free_code_code_total'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('code_total', 'index') . " </th>\r\n\t\t\t<th>" . $intro->lang['free_code_code_used'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('code_used', 'index') . " </th>\r\n\t\t\t<th>Country Restriction</th>\r\n\t\t\t<th>Status</th>\r\n\t\t\t<th>" . $intro->lang['options'] . "</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) )
        {
            @extract($myrow);
            $i++;
            echo "\r\n\t\t\t<tr class=\"" . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\r\n\t\t\t\t<td class=\"center\"><input type=\"checkbox\" value=\"" . $id . "\" name=\"selected_fld[]\"></td>\r\n\t\t\t\t<td class=\"center\">" . $id . "</td>\r\n\t\t\t\t<td>" . $code . "</td>\r\n\t\t\t\t<td>" . $days . "</td>\r\n\t\t\t\t<td>" . $code_total . "</td>\r\n\t\t\t\t<td>" . $code_used . ' <a class="btn btn-success" href="' . $this->base . '/ListCodes?code=' . $code . "\" title=\"View\"><i class=\"icon-search\"></i></a></td>\r\n\t\t\t\t<td>") . $intro->country[$forced_country] . "</td>\r\n\t\t\t\t<td>" . (($status == 1 ? '<span class=\'label label-success\'>Runing</span>' : '<span class=\'label label-danger\'>Stopped</span>')) . ("</td>\r\n\t\t\t\t<td class=\"center\"> \r\n\t\t\t\t\t<a class=\"btn btn-info p_edit\" href=\"" . $this->base . '/Form?t=edit&amp;id=' . $id . '" title="') . $intro->lang['edit'] . ("\"><i class=\"icon-edit\"></i></a>\r\n\t\t\t\t\t<a class=\"btn btn-danger p_del\" href=\"" . $this->base . '/DelConfirm?id=' . $id . '&code=' . $code . '" title="') . $intro->lang['del'] . "\"><i class=\"icon-cancel-circled2\"></i></a>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        echo "</tbody>\r\n\t\t</table>\r\n\t\t</div>";
        $order = str_replace(' ', ':', $order);
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo '<center>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?search_txt=' . $search_txt . '&amp;order=' . $order, $totalrows, $rows_per_page, $page) . '</center>';
        echo '</fieldset>';

        // Show all activated users with credentials
        $this->showActivatedUsers();
    }

    public function showActivatedUsers()
    {
        global $intro;

        $page2 = intval($intro->input->get_post('page2'));
        $rows_per_page = 50;
        if($page2 == 0) $page2 = 1;
        $nexlimit = $page2 * $rows_per_page - $rows_per_page;

        $result = $intro->db->query('SELECT c.*, c.password as user_pass, u.enabled as user_enabled FROM ' . PREFIX . '_codes_free c LEFT JOIN users u ON c.user = u.username ORDER BY c.id DESC LIMIT ' . $nexlimit . ',' . $rows_per_page);
        $sql_all = $intro->db->query('SELECT c.id FROM ' . PREFIX . '_codes_free c');
        $totalrows = $intro->db->returned_rows;

        echo '<div class="panel panel-primary" style="margin-top:20px;">
            <div class="panel-heading">
                <i class="icon-users"></i> All Activated Free Code Users (' . $totalrows . ')
                <div class="pull-right">
                    <a class="btn btn-danger btn-xs" href="' . $this->base . '/DeleteAllFreeUsers" onclick="return confirmDeleteAll(' . $totalrows . ');">
                        <i class="icon-trash"></i> Delete All (' . $totalrows . ')
                    </a>
                </div>
            </div>
            <div class="panel-body">
            <script>
            function confirmDeleteAll(count) {
                return confirm("⚠️ DELETE ALL " + count + " FREE USERS?\\n\\nThis will delete from:\\n- Local Database\\n- Flix Panel\\n\\nThis cannot be undone!");
            }
            function confirmDeleteUser(username, password) {
                return confirm("Delete user?\\n\\nUsername: " + username + "\\nPassword: " + password + "\\n\\nWill be deleted from both panels.");
            }
            function toggleAll(source) {
                var checkboxes = document.querySelectorAll("input[name=\'selected_users[]\']");
                for(var i=0; i<checkboxes.length; i++) {
                    checkboxes[i].checked = source.checked;
                }
                updateSelectedCount();
            }
            function updateSelectedCount() {
                var checkboxes = document.querySelectorAll("input[name=\'selected_users[]\']:checked");
                document.getElementById("selected_count").innerText = checkboxes.length;
            }
            function confirmDeleteSelected() {
                var checkboxes = document.querySelectorAll("input[name=\'selected_users[]\']:checked");
                if(checkboxes.length == 0) {
                    alert("Please select at least one user!");
                    return false;
                }
                return confirm("⚠️ DELETE " + checkboxes.length + " SELECTED USERS?\\n\\nThis will delete from:\\n- Local Database\\n- Flix Panel\\n\\nThis cannot be undone!");
            }
            </script>
            <form method="POST" action="' . $this->base . '/DeleteSelectedUsers">
            <div style="margin-bottom:10px;">
                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirmDeleteSelected();">
                    <i class="icon-trash"></i> Delete Selected (<span id="selected_count">0</span>)
                </button>
            </div>
            <div class="table-responsive">
            <table class="table table-bordered table-hover table-striped" style="font-size:12px;">
            <thead>
                <tr>
                    <th><input type="checkbox" onclick="toggleAll(this);" title="Select All"></th>
                    <th>#</th>
                    <th>Free Code</th>
                    <th>Username</th>
                    <th>Password</th>
                    <th>IP</th>
                    <th>ISP</th>
                    <th>Country</th>
                    <th>MAC</th>
                    <th>Status</th>
                    <th>Expire</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>';

        $i = $nexlimit;
        while($row = $intro->db->fetch_assoc($result)) {
            $i++;
            $is_enabled = isset($row['user_enabled']) ? $row['user_enabled'] : 1;
            $status_label = $is_enabled == 1 ? '<span class="label label-success">Active</span>' : '<span class="label label-danger">Disabled</span>';
            $expire = ($row['date_expire'] > 0) ? date('Y-m-d', $row['date_expire']) : '-';
            $user_pass = isset($row['user_pass']) ? $row['user_pass'] : '-';
            $ip_address = isset($row['ip_address']) ? $row['ip_address'] : '-';
            $isp = isset($row['isp']) ? substr($row['isp'], 0, 15) : '-';
            $country = isset($row['country']) ? $row['country'] : '-';

            echo '<tr>
                <td><input type="checkbox" name="selected_users[]" value="' . $row['id'] . '" onclick="updateSelectedCount();"></td>
                <td>' . $i . '</td>
                <td><strong>' . htmlspecialchars($row['code']) . '</strong></td>
                <td><code style="background:#e8f5e9;padding:2px 5px;border-radius:3px;">' . htmlspecialchars($row['user']) . '</code></td>
                <td><code style="background:#fff3e0;padding:2px 5px;border-radius:3px;">' . htmlspecialchars($user_pass) . '</code></td>
                <td><small>' . htmlspecialchars($ip_address) . '</small></td>
                <td><small>' . htmlspecialchars($isp) . '</small></td>
                <td><img src="https://flagcdn.com/20x15/' . strtolower($country) . '.png" onerror="this.style.display=\'none\'" style="margin-right:5px;vertical-align:middle;">' . htmlspecialchars($country) . '</td>
                <td><small>' . htmlspecialchars(substr($row['mac'], 0, 12)) . '</small></td>
                <td>' . $status_label . '</td>
                <td><small>' . $expire . '</small></td>
                <td>
                    ' . ($is_enabled == 1 ?
                        '<a class="btn btn-warning btn-xs" href="' . $this->base . '/ToggleFreeUser?id=' . $row['id'] . '&action=disable" title="Disable"><i class="icon-block"></i></a>' :
                        '<a class="btn btn-success btn-xs" href="' . $this->base . '/ToggleFreeUser?id=' . $row['id'] . '&action=enable" title="Enable"><i class="icon-check"></i></a>'
                    ) . '
                    <a class="btn btn-danger btn-xs" href="' . $this->base . '/DelFreeCode?id=' . $row['id'] . '" onclick="return confirmDeleteUser(\'' . htmlspecialchars($row['user']) . '\', \'' . htmlspecialchars($user_pass) . '\');" title="Delete"><i class="icon-trash"></i></a>
                </td>
            </tr>';
        }

        echo '</tbody></table></div>
        </form>';
        echo '<center>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?page2=', $totalrows, $rows_per_page, $page2) . '</center>';
        echo '</div></div>';

        // Security settings info
        echo '<div class="panel panel-warning" style="margin-top:15px;">
            <div class="panel-heading"><i class="icon-shield"></i> Security Protection</div>
            <div class="panel-body" style="padding:10px;">
                <div class="row">
                    <div class="col-md-6">
                        <ul style="margin:0;padding-left:20px;">
                            <li><strong>Device Lock:</strong> MAC/Serial</li>
                            <li><strong>IP Lock:</strong> IP Address</li>
                            <li><strong>ISP Lock:</strong> Internet Provider</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <ul style="margin:0;padding-left:20px;">
                            <li><strong>Country Lock:</strong> Country</li>
                            <li><strong>User Agent Lock:</strong> Device/App</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>';
    }

    public function DeleteAllFreeUsers()
    {
        global $intro;
        global $sess_admin;
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');

        // Get all free users
        $result = $intro->db->query('SELECT user FROM ' . PREFIX . '_codes_free');
        while($row = $intro->db->fetch_assoc($result)) {
            // Delete from Flix Panel
            $this->deleteFromFlixPanel($row['user']);
            // Delete from users table
            $intro->db->query("DELETE FROM users WHERE username = '" . $intro->db->escape($row['user']) . "'");
        }
        // Delete all from codes_free
        $intro->db->query('DELETE FROM ' . PREFIX . '_codes_free');

        $intro->redirect($this->appname);
    }

    public function DeleteSelectedUsers()
    {
        global $intro;
        global $sess_admin;
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');

        $selected_users = isset($_POST['selected_users']) ? $_POST['selected_users'] : [];

        if(!empty($selected_users)) {
            foreach($selected_users as $id) {
                $id = intval($id);
                // Get username before deleting
                $result = $intro->db->query('SELECT user FROM ' . PREFIX . '_codes_free WHERE id=' . $id);
                $row = $intro->db->fetch_assoc($result);
                if($row) {
                    // Delete from Flix Panel
                    $this->deleteFromFlixPanel($row['user']);
                    // Delete from local users table
                    $intro->db->query("DELETE FROM users WHERE username = '" . $intro->db->escape($row['user']) . "'");
                    // Delete from codes_free
                    $intro->db->query('DELETE FROM ' . PREFIX . '_codes_free WHERE id=' . $id);
                }
            }
        }

        $intro->redirect($this->appname);
    }

    private function deleteFromFlixPanel($username)
    {
        $panel_url = 'https://flix-panel.xyz:2087';
        $api_key = 'eJIdy5sAgD';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $panel_url . '/api/line/delete');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'api_key' => $api_key,
            'username' => $username
        ]));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response, true);
    }

    public function ToggleFreeUser()
    {
        global $intro;
        global $sess_admin;
        policy($sess_admin['adminid'], $this->appname . '.php', 'edit');

        $id = intval($intro->input->get_post('id'));
        $action = trim($intro->input->get_post('action'));

        // Get user info
        $result = $intro->db->query('SELECT user FROM ' . PREFIX . '_codes_free WHERE id = ' . $id);
        $row = $intro->db->fetch_assoc($result);

        if($row) {
            $enabled = ($action == 'enable') ? 1 : 0;
            $intro->db->query("UPDATE users SET enabled = " . $enabled . ", admin_enabled = " . $enabled . " WHERE username = '" . $intro->db->escape($row['user']) . "'");
        }

        $intro->redirect($this->appname);
    }

    public function ListCodes()
    {
        global $intro;
        global $array;
        $intro->country[0] = '-';
        $intro->country[''] = '-';
        $qry = $forced_country = '';
        $page = intval($intro->input->get_post('page'));
        $code_filter = trim($intro->input->get_post('code'));
        $this->nav();
        $rows_per_page = 30;
        if( $page == 0 )
        {
            $page = 1;
        }
        if($code_filter != '') {
            $qry = " AND c.code = '" . $intro->db->escape($code_filter) . "' ";
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $result = $intro->db->query('SELECT c.*, u.username, u.password as user_pass FROM ' . PREFIX . '_codes_free c LEFT JOIN users u ON c.user = u.username where true ' . $qry . ' order by c.id desc limit ' . $nexlimit . ',' . $rows_per_page);
        $totrows = $intro->db->returned_rows;
        $sql_all_rows = $intro->db->query('SELECT c.id from ' . PREFIX . '_codes_free c where true ' . $qry);
        $totalrows = $intro->db->returned_rows;
        echo "\r\n\t\t<fieldset><legend><i class=\"icon-list\"></i> Free Codes Activated (" . $totalrows . ")</legend>\r\n\t\t\r\n\t\t<table class=\"DataTable table-striped table-bordered\" id=\"table_codes\">\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t<th>ID</th>\r\n\t\t\t<th>Free Code</th>\r\n\t\t\t<th>Username (Flix Panel)</th>\r\n\t\t\t<th>Password (Flix Panel)</th>\r\n\t\t\t<th>Days</th>\r\n\t\t\t<th>Status</th>\r\n\t\t\t<th>MAC</th>\r\n\t\t\t<th>Serial</th>\r\n\t\t\t<th>Expire</th>\r\n\t\t\t<th>Options</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = 0;
        $mac = $serial = '';
        while( $myrow = $intro->db->fetch_assoc($result) )
        {
            @extract($myrow);
            $i++;
            if( $status == 0 )
            {
                $label = 'default';
                $status_txt = '<span class="label label-default">Inactive</span>';
            }
            else if( $status == 1 )
            {
                $label = 'success';
                $status_txt = '<span class="label label-success">Active</span>';
            }
            else
            {
                $label = 'warning';
                $status_txt = '<span class="label label-warning">'.$status.'</span>';
            }
            $date_expire_txt = ($date_expire != '' && $date_expire > 0 ? date('Y-m-d H:i', $date_expire) : '-');
            $user_pass = isset($user_pass) ? $user_pass : '-';
            echo "\r\n\t\t\t<tr class=\"" . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . "\">\r\n\t\t\t\t<td class=\"center\">" . $id . "</td>\r\n\t\t\t\t<td><strong>" . $code . "</strong></td>\r\n\t\t\t\t<td><code>" . $user . "</code></td>\r\n\t\t\t\t<td><code>" . $user_pass . "</code></td>\r\n\t\t\t\t<td>" . $days . "</td>\r\n\t\t\t\t<td>" . $status_txt . "</td>\r\n\t\t\t\t<td><small>" . $mac . "</small></td>\r\n\t\t\t\t<td><small>" . $serial . "</small></td>\r\n\t\t\t\t<td>" . $date_expire_txt . "</td>\r\n\t\t\t\t<td class=\"center\"> \r\n\t\t\t\t\t<a class=\"btn btn-danger btn-sm p_del intro_ui_del\" href=\"" . $this->base . '/DelFreeCode?id=' . $id . "\" OnClick=\"return confirm('Delete this entry?');\" title=\"Delete\"><i class=\"icon-cancel-circled2\"></i></a>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        echo "</tbody>\r\n\t\t\t</table>";
        echo '<center>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/ListCodes?code=' . urlencode($code_filter), $totalrows, $rows_per_page, $page) . '</center>';
        echo '</fieldset>';
    }
    public function multiDel()
    {
        global $intro;
        global $error;
        global $sess_admin;
        $selected_fld = $_POST['selected_fld'];
        $count = count($selected_fld);
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');
        for( $i = 0; $i < $count; $i++ ) 
        {
            $sql = $intro->db->query('DELETE FROM ' . PREFIX . ('_free_code WHERE id=\'' . $selected_fld[$i] . '\' '));
        }
        $intro->redirect($this->appname);
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $code;
        global $days;
        global $code_total;
        global $status;
        global $code_used;
        global $forced_country;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $IF = intval($intro->input->get_post('IF'));
        $id = intval($intro->input->get_post('id'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        if( $IF != 1 ) 
        {
            $this->nav();
        }
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * FROM ' . PREFIX . ('_free_code where id=\'' . $id . '\''));
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $btn['legend_name'] = $intro->lang['free_code_edit'] . (' <b>' . $id . '</b>');
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = $intro->lang['free_code_add'];
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = $intro->lang['save'];
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ', 'info');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\r\n\t\t<div class=\"table-responsive\">\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t<tr>\r\n\t\t\t<td>" . $intro->lang['free_code_code'] . (" :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td><input  type=\"text\" name=\"code\" value=\"" . $code . '" size="30"> ' . $this->error('code') . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>") . $intro->lang['free_code_days'] . (" :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td><input  type=\"text\" name=\"days\" value=\"" . $days . '" size="30"> ' . $this->error('days') . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>") . $intro->lang['free_code_code_total'] . (" : </td>\r\n\t\t\t<td><input  type=\"text\" name=\"code_total\" value=\"" . $code_total . '" size="30"> ' . $this->error('code_total') . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Override General Country Restriction:  </td>\r\n\t\t\t<td> ") . forced_country($forced_country) . (" </td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Status : </td>\r\n\t\t\t<td><input  type=\"text\" name=\"status\" value=\"" . $status . "\" size=\"5\"> 1 = Running , 0 = Stopped</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\r\n\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\r\n\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $id . "\">\r\n\t\t\t\t<input type=\"hidden\" name=\"IF\"  value=\"" . $IF . "\">\r\n\t\t\t\t<button type=\"submit\" name=\"app_action\" value=\"" . $btn['action'] . "\">\r\n\t\t\t\t\t<i class=\"" . $btn['img_icon'] . '"></i> ' . $btn['name'] . " \r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</div>\r\n\t\t</form>");
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        $code = trim($intro->input->post('code'));
        $forced_country = trim($intro->input->post('forced_country'));
        $days = intval($intro->input->post('days'));
        $code_total = intval($intro->input->post('code_total'));
        $code_used = intval($intro->input->post('code_used'));
        if( $code == '' || $days == 0 ) 
        {
            if( $code == '' ) 
            {
                $error['code'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $days == 0 ) 
            {
                $error['days'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            $this->Form('add');
            exit();
        }
        $data['code'] = $intro->input->post('code');
        $data['days'] = $intro->input->post('days');
        $data['code_total'] = $intro->input->post('code_total');
        $data['forced_country'] = $forced_country;
        $data['status'] = intval($intro->input->post('status'));
        $intro->db->insert(PREFIX . '_free_code', $data);
        $intro->redirect($this->appname);
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        $data['status'] = intval($intro->input->post('status'));
        $data['code'] = $intro->input->post('code');
        $data['days'] = $intro->input->post('days');
        $data['code_total'] = $intro->input->post('code_total');
        $data['forced_country'] = $forced_country;
        $id = intval($intro->input->post('id'));
        $intro->db->update(PREFIX . '_free_code', $data, 'id=' . $id);
        $intro->redirect($this->appname);
    }
    public function DelConfirm()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $code = trim($intro->input->get_post('code'));
        echo "<div class=\"panel panel-danger\">\r\n\t\t  <div class=\"panel-heading\">Confirm DELETE!!!</div>\r\n\t\t  <div class=\"panel-body\">\r\n\t\t  \r\n\t\t\t\t<h3 class='alert alert-danger'>Deleting this code: " . $code . " will delete all free codes from database!!!</h3>\r\n\t\t\t\t\r\n\t\t\t\t<a class=\"btn btn-danger p_del\"  onclick=\"return confirm('Are you sure?')\" href=\"" . $this->base . '/Del?id=' . $id . '&code=' . $code . '" title="' . $intro->lang['del'] . "\"><i class=\"icon-cancel-circled2\"></i> Yes Delete Now.</a>\r\n\t\t  </div>\r\n\t\t</div>";
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $code = trim($intro->input->get_post('code'));
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');
        $sql = $intro->db->query('DELETE FROM ' . PREFIX . ('_codes_free WHERE code=\'' . $code . '\'; '));
        $sql = $intro->db->query('DELETE FROM ' . PREFIX . ('_free_code WHERE id=' . $id . ' '));
        $intro->redirect($this->appname);
    }
    public function DelFreeCode()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');

        // Get username before deleting
        $result = $intro->db->query('SELECT user FROM ' . PREFIX . '_codes_free WHERE id=' . $id);
        $row = $intro->db->fetch_assoc($result);
        if($row) {
            // Delete from Flix Panel
            $this->deleteFromFlixPanel($row['user']);
            // Delete from local users table
            $intro->db->query("DELETE FROM users WHERE username = '" . $intro->db->escape($row['user']) . "'");
        }

        $sql = $intro->db->query('DELETE FROM ' . PREFIX . ('_codes_free WHERE id=' . $id . ' '));
        $intro->redirect($this->appname);
    }
}
