<?php 
class Mag_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $qry_admin_where = '';
    public $admin = [];
    public $adminRow = [];
    public $inputBy = [
        'Code', 
        'MAC', 
        'Serial'
    ];
    public $free = [
        101, 
        103, 
        107, 
        110
    ];
    public $time = null;
    public $time7 = null;
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        global $array;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        $adminid = intval($this->admin['adminid']);
        $this->adminRow = $intro->auth->admin_data($adminid);
        if( $this->admin['level'] == 1 ) 
        {
            $this->qry_admin = '';
            $this->qry_admin_where = '';
        }
        else
        {
            $this->qry_admin = ' and ( member_id=' . $adminid . ' OR member_id IN (select adminid from ' . PREFIX . ('_admin WHERE father=' . $adminid . ' OR main_father=' . $adminid . '))');
            $this->qry_admin_where = str_replace(' and (', ' WHERE (', $this->qry_admin);
        }
        $this->time = time();
        $this->time7 = strtotime('+7 day');
        $this->free = $array['free'];
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        $sql_all = $intro->db->query('SELECT id FROM `users` WHERE is_mag=1 ' . $this->qry_admin . ';');
        $all = $intro->db->returned_rows;
        $sql = $intro->db->query('SELECT ' . ('(SELECT COUNT(id) FROM `users` WHERE is_mag=1 AND is_trial=1 ' . $this->qry_admin . ') AS tot_trial') . (',(SELECT COUNT(id) FROM `users` WHERE is_mag=1 AND enabled=0 ' . $this->qry_admin . ') AS tot_disabled') . (',(SELECT COUNT(id) FROM `users` WHERE is_mag=1 AND admin_enabled=0 ' . $this->qry_admin . ') AS tot_adm_disabled') . (',(SELECT COUNT(id) FROM `users` WHERE is_mag=1 AND exp_date <= \'' . $this->time . '\' AND exp_date IS NOT NULL ' . $this->qry_admin . ') AS tot_expired') . '');
        $myrow = $intro->db->fetch_assoc($sql);
        $tot_trial = intval($myrow['tot_trial']);
        $tot_disabled = intval($myrow['tot_disabled']);
        $tot_expired = intval($myrow['tot_expired']);
        $tot_adm_disabled = intval($myrow['tot_adm_disabled']);
        echo "<div class=\"app_nav\">\r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . '/index"><icon class="icon-dektop"></icon> MAG (') . money($all) . ")</a>  \r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="' . $this->base . '/Form?t=add"><icon class="icon-plus-squared"></icon> Add MAG</a> ');
        if( $this->admin['level'] == 1 ) 
        {
            echo ' <a class="btn btn-success" href="' . $this->base . '/clean"><icon class="icon-bug">Clean MAC</icon></a> ';
        }
        echo "\r\n\t\t</div>";
        echo "<div class=\"app_nav\">\r\n\t\t\r\n\t\t<a class=\"btn btn-info\" href=\"" . $this->base . '/index?is_trial=1"> Trial MAG (' . money($tot_trial) . (")</a> \r\n\t\t<a class=\"btn btn-warning\" href=\"" . $this->base . '/index?view=expired"> Expired MAG (') . money($tot_expired) . ')</a>';
        if( $tot_disabled > 0 ) 
        {
            echo ' <a class="btn btn-danger icon-block" href="' . $this->base . '/index?view=disabled"> Disabled MAG (' . money($tot_disabled) . ')</a>';
        }
        if( $tot_adm_disabled > 0 ) 
        {
            echo ' <a class="btn btn-danger icon-cancel-circled2" href="' . $this->base . '/index?view=banned"> Banned MAG (' . money($tot_adm_disabled) . ')</a>';
        }
        echo "\r\n\t\t</div>";
    }
    public function index()
    {
        global $intro;
        global $array;
        $qry = $params = '';
        $status = trim($intro->input->get_post('status'));
        $view = trim($intro->input->get_post('view'));
        $page = intval($intro->input->get_post('page'));
        $order = trim($intro->input->get_post('order'));
        $fullname = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('fullname'), ' {ar}'));
        $period = intval($intro->input->get_post('period'));
        $is_trial = intval($intro->input->get_post('is_trial'));
        $adminid = intval($intro->input->get_post('adminid'));
        $admin_notes = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('admin_notes'), ' {ar}:.@*'));
        $reseller_notes = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('reseller_notes'), ' {ar}:.@*'));
        $mobile = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('mobile'), '\+\-\*'));
        $mac = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('mac'), '\*:-'));
        $username = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('username'), '\*:-_.@'));
        $mac = strtoupper($mac);
        $date_add = $intro->db->escape(trim($intro->db->escape($intro->input->get_post('date_add'))));
        $date_addto = trim($intro->db->escape($intro->input->get_post('date_addto')));
        $date_expire = trim($intro->db->escape($intro->input->get_post('date_expire')));
        $date_expireto = trim($intro->db->escape($intro->input->get_post('date_expireto')));
        $this->nav();
        if( intval($intro->input->get_post('clean')) > 0 ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h3>Total cleaned MAGs: ' . $intro->input->get_post('clean') . '</h3>', 'success');
        }
        if( $is_trial == 1 ) 
        {
            $qry .= ' AND is_trial=1';
            $params .= '&is_trial=1';
        }
        if( $mac != '' ) 
        {
            $qry .= (' AND mac  LIKE \'%' . base64_encode($mac) . '%\' ');
            $params .= ('&mac=' . $mac);
        }
        if( $fullname != '' ) 
        {
            $qry .= (' AND ud.fullname  LIKE \'%' . $fullname . '%\' ');
            $params .= ('&fullname=' . $fullname);
        }
        if( $username != '' ) 
        {
            $qry .= (' AND users.username  LIKE \'%' . $username . '%\' ');
            $params .= ('&username=' . $username);
        }
        if( $admin_notes != '' ) 
        {
            $qry .= (' AND admin_notes LIKE \'%' . $admin_notes . '%\' ');
            $params .= ('&admin_notes=' . $admin_notes);
        }
        if( $reseller_notes != '' ) 
        {
            $qry .= (' AND reseller_notes LIKE \'%' . $reseller_notes . '%\' ');
            $params .= ('&reseller_notes=' . $reseller_notes);
        }
        if( $mobile != '' ) 
        {
            $qry .= (' AND mobile=\'' . $mobile . '\' ');
            $params .= ('&mobile=' . $mobile);
        }
        if( $adminid != '' ) 
        {
            $qry .= (' AND member_id=' . $adminid . ' ');
            $params .= ('&member_id=' . $adminid);
        }
        if( $period != 0 ) 
        {
            $qry .= (' AND period=' . $period . ' ');
            $params .= ('&period=' . $period);
        }
        if( $view == 'soon_to_expire' ) 
        {
            $qry = ' AND exp_date BETWEEN \'' . $this->time . '\' AND \'' . $this->time7 . '\' ';
            $params .= '&view=soon_to_expire';
            $order = 'exp_date:ASC';
        }
        if( $view == 'expired' ) 
        {
            $qry = ' AND exp_date <= \'' . $this->time . '\' AND exp_date IS NOT NULL ';
            $params .= '&view=expired';
        }
        if( $view == 'banned' ) 
        {
            $qry = ' AND admin_enabled=0 ';
            $params .= '&view=banned';
        }
        if( $view == 'disabled' ) 
        {
            $qry = ' AND enabled=0 ';
            $params .= '&view=disabled';
        }
        if( $date_add != '' ) 
        {
            $qry_date = ' AND users.created_at BETWEEN \'' . strtotime($date_add . ' 00:00:00') . '\' AND \'' . strtotime($date_add . ' 23:59:59') . '\' ';
            if( $date_addto != '' ) 
            {
                $qry_date = ' AND users.created_at BETWEEN \'' . strtotime($date_add . ' 00:00:00') . '\' AND \'' . strtotime($date_addto . ' 23:59:59') . '\' ';
            }
            $qry = $qry_date;
            $params .= ('&date_add=' . $date_add . '&date_addto=' . $date_addto);
        }
        if( $date_expire != '' ) 
        {
            $qry_date = ' AND users.exp_date BETWEEN \'' . strtotime($date_expire . ' 00:00:00') . '\' AND \'' . strtotime($date_expire . ' 23:59:59') . '\' ';
            if( $date_expireto != '' ) 
            {
                $qry_date = ' AND users.exp_date BETWEEN \'' . strtotime($date_expire . ' 00:00:00') . '\' AND \'' . strtotime($date_expireto . ' 23:59:59') . '\' ';
            }
            $qry = $qry_date;
            $params .= ('&date_expire=' . $date_expire . '&date_expireto=' . $date_expireto);
        }
        if( $order == '' ) 
        {
            $order = 'id:desc';
        }
        $order = str_replace(':', ' ', $order);
        $rows_per_page = 50;
        if( $page == 0 ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $concat = 'stream_id,\'|\',user_agent,\'|\',user_ip,\'|\',container,\'|\',geoip_country_code,\'|\',isp';
        $qry_online = ',IF(enabled=1,(select CONCAT(' . $concat . ') as online from user_activity_now online ' . ' where online.user_id=users.id ORDER BY activity_id DESC LIMIT 1),\'\') as online';
        $result = $intro->db->query('SELECT *' . $qry_online . ' from `users` ' . ' INNER JOIN mag_devices mag ON users.id=mag.user_id ' . ' LEFT JOIN ' . PREFIX . '_users_data ud on users.id=ud.userid  ' . (' where users.is_mag=1  ' . $this->qry_admin . ' ' . $qry . ' order by ' . $order . ' limit ' . $nexlimit . ',' . $rows_per_page));
        $totrows = $intro->db->returned_rows;
        $sql_all_rows = $intro->db->query('SELECT id from `users`  INNER JOIN mag_devices mag ON users.id=mag.user_id  LEFT JOIN ' . PREFIX . '_users_data ud on users.id=ud.userid  ' . (' where users.is_mag=1 ' . $this->qry_admin . ' ' . $qry . ' '));
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Found MAG (' . money($totalrows) . ')', 'primary');
        echo "\r\n\t\t<form action=\"\" method=\"GET\">\r\n\t\t\t<table class=\"table table-bordered table-condensed\">\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>MAC:</td>\r\n\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"mac\" value=\"" . $mac . "\" size=\"20\" placeholder='MAC Address' autofocus='' style=\"text-transform:uppercase\"></td>\r\n\t\t\t\t\t<td>Fullname:</td>\r\n\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"fullname\" value=\"" . $fullname . "\" size=\"15\" placeholder=Fullname></td>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t</tr>\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Period: </td>\r\n\t\t\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period', _obf_0D322A5B141A102E2824032B03230A35140306272F2F11(), $period, 'All') . "</td>\r\n\t\t\t\t\t<td>Rseller:</td>";
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t\t\t<td>" . form_resellers('adminid', $adminid, 'All Resellers') . '</td>';
        }
        else
        {
            echo '<td>' . $this->admin['admin_name'] . '</td>';
        }
        echo "\r\n\t\t\t\t\t<td>" . (($this->admin['level'] == 1 ? 'Username:' : '')) . "</td>\r\n\t\t\t\t\t<td>" . (($this->admin['level'] == 1 ? '<input class="form-control" type="text" name="username" value="' . $username . '" size="15" placeholder=\'username\'>' : '')) . ("</td>\r\n\t\t\t\t\t\r\n\t\t\t\t</tr>\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Date Created:</td>\r\n\t\t\t\t\t<td class='form-inline'><input class=\"form-control date_picker\" type=\"text\" name=\"date_add\" value=\"" . $date_add . "\" style=\"width:200px;\" placeholder='Date of adding this user'>\r\n\t\t\t\t\t<input class=\"form-control date_picker\" type=\"text\" name=\"date_addto\" value=\"" . $date_addto . "\" style=\"width:150px;\" placeholder='to date'>\r\n\t\t\t\t\t</td>\r\n\t\t\t\t\t\r\n\t\t\t\t\t<td>Date Expire:</td>\r\n\t\t\t\t\t<td class='form-inline'><input class=\"form-control date_picker\" type=\"text\" name=\"date_expire\" value=\"" . $date_expire . "\" style=\"width:200px;\" placeholder='Date of expiry'>\r\n\t\t\t\t\t<input class=\"form-control date_picker\" type=\"text\" name=\"date_expireto\" value=\"" . $date_expireto . "\" style=\"width:150px;\" placeholder='to date'>\r\n\t\t\t\t\t</td>\r\n\t\t\t\t\t\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t</tr>\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Mobile:</td>\r\n\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"mobile\" value=\"" . $mobile . '" size="20" placeholder=\'Mobile\'></td>');
        if( $this->admin['level'] == 1 ) 
        {
            echo "<td>Admin Notes:</td>\r\n\t\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"admin_notes\" value=\"" . $admin_notes . '" size="20" placeholder=Notes></td>';
        }
        else
        {
            echo "<td>Notes:</td>\r\n\t\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"reseller_notes\" value=\"" . $reseller_notes . '" size="20" placeholder=Notes></td>';
        }
        echo "\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t\t<td><input type=\"submit\" class=\"btn btn-success\" value=\" Search! \" class='btn btn-default'></td>\r\n\t\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t<input type=\"hidden\" name=\"status\" value=\"" . $status . "\">\r\n\t\t</form>";
        echo "\r\n\t\t" . (($intro->input->get('msg') == 'renew_success' ? _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Code [' . $code . '] Renew Success!', 'success') : '')) . "\r\n\t\t" . (($intro->input->get('msg') == 'renew_fail' ? _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Failed: ' . $intro->input->get('fail'), 'danger') : '')) . "\r\n\t\t<table class=\"DataTable table-striped table-bordered table-condensed\" id=\"table_codes\">\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index') . " </th>\r\n\t\t\t<th></th>\r\n\t\t\t<th>Reseller</th>\r\n\t\t\t<th>Fullname</th>\r\n\t\t\t<th>MAC</th>\r\n\t\t\t\r\n\t\t\t<th>Period</th>\r\n\t\t\t<th>Created on</th>\r\n\t\t\t<th>Expire</th>\r\n\t\t\t<th>" . (($this->admin['level'] == 1 ? 'Admin ' : '')) . "Notes</th>\r\n\t\t\t<th>Options</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            if( $exp_date == '' ) 
            {
                $exp_date = 'Unlimited';
            }
            else if( $exp_date < time() ) 
            {
                $exp_date = 'Expired';
            }
            else
            {
                $exp_date = date('Y-m-d H:i', $exp_date);
            }
            $userid = $user_id;
            if( $online != '' ) 
            {
                $online = '<a class="AjaxModal" href="' . $intro->app_url('online', 'index') . ('/?id=' . $userid . '&for=mag"><icon class="icon-globe" style=\'color:green;\' title="' . $online . '"></icon></a>');
            }
            else
            {
                $online = '<a class="AjaxModal" href="' . $intro->app_url('online', 'was') . ('/?id=' . $userid . '&for=mag"><icon class="icon-globe" style=\'color:gray;\' title="offline"></icon></a>');
            }
            if( $enabled == 0 ) 
            {
                $online = '<span class="icon-cancel-circled2 label label-danger" title="Disabled!"> </span>';
            }
            if( $admin_enabled == 0 ) 
            {
                $online = '<span class="icon-block label label-danger" title="Banned!"> </span>';
            }
            $linethrough = ($exp_date == 'Expired' ? 'style=\'text-decoration: line-through;\'' : '');
            $mac = base64_decode($mac);
            echo "\r\n\t\t\t<tr id=\"tr_" . $user_id . '" ' . (($is_trial == 1 ? 'style=\'color:#ff2626\'' : '')) . ' ' . (($myrow['exp_date'] == '' ? 'style=\'color:#2db300\'' : '')) . ' ' . (($exp_date == 'Expired' ? 'style=\'color:#d90000;\'' : '')) . (">\r\n\t\t\t\t<td class='c'>" . $mag_id . "</td>\r\n\t\t\t\t<td class='c' id=\"status_" . $user_id . '">' . $online . "</td>\r\n\t\t\t\t<td class='c'>") . $array['admins'][$member_id] . (' (' . $member_id . ")</td>\t\r\n\t\t\t\t<td>" . $fullname . "</td>\r\n\t\t\t\t<td " . $linethrough . '>' . $mac . "</td>\r\n\t\t\t\t\r\n\t\t\t\t<td " . $linethrough . '>') . (($pkg > 0 ? $intro->packages[$pkg] : period($period, $free_days))) . "</td>\r\n\t\t\t\t<td style='color:#888888'>" . (($created_at != '' ? date('Y-m-d', $created_at) : '-')) . ("</td>\r\n\t\t\t\t<td class='c' id='expire_" . $user_id . '\' ' . $linethrough . '><span class="editExpireDate" data-type="text" data-pk="' . $id . '" data-name="exp_date">' . $exp_date . "</span></td>\r\n\t\t\t\t<td class='c'>") . (($this->admin['level'] == 1 ? $admin_notes : $reseller_notes)) . "</td>\r\n\t\t\t\t\r\n\t\t\t\t<td class='c'>";
            echo "\r\n\t\t\t\t\t<div class=\"btn-group\">\r\n                        <button class=\"btn btn-primary btn-xs dropdown-toggle\" href=\"#\" data-toggle=\"dropdown\">\r\n                        <span class='icon-cog'></span> <span class=\"caret\"></span>\r\n                        </button>\r\n                        <ul class=\"dropdown-menu stay-open pull-right\" role=\"menu\" style=\"padding: 15px; min-width: 200px;\">";
            if( $enabled == 0 && $admin_enabled == 1 ) 
            {
                echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&NH=1&sus=off" OnClick="return false;"  title="Disable/Suspend"><span class="btn btn-success btn-xs icon-ok"></span>Enable</a></li>';
            }
            if( $enabled == 1 && $admin_enabled == 1 ) 
            {
                echo '<li><a class="p_edit AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&NH=1&sus=on" OnClick="return false;" title="Enable/unsuspend"><span class="btn btn-danger btn-xs icon-off"></span> Disable </a></li>';
            }
            if( $this->admin['level'] == 1 && $admin_enabled == 1 ) 
            {
                echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&sus=ban" title="Ban!"><span class="btn btn-danger btn-xs icon-cancel-circled2"></span> Ban!</a></li>';
            }
            if( $this->admin['level'] == 1 && $admin_enabled == 0 ) 
            {
                echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&sus=unban" title="Unban!"><span class="btn btn-success btn-xs icon-ok"></span> UnBan!</a></li>';
            }
            if( $enabled == 1 ) 
            {
                echo '<li><a class="AjaxModal" href="' . $intro->app_url('renew', 'RenewMag') . ('/?id=' . $mag_id . '" title="Renew Code تجديد"><span class="btn btn-success btn-xs icon-cw"></span> Renew MAG</a></li>');
            }
            if( in_array($this->admin['level'], [
                1, 
                2, 
                9
            ]) || $this->adminRow['can_change'] == 1 || 1 ) 
            {
                echo '<li><a class="p_edit" href="' . $this->base . '/Form?t=edit&amp;mag_id=' . $mag_id . '" title="Edit and Update MAG Info"><span class="btn btn-info btn-xs icon-edit"></span> Edit </a></li>';
            }
            if( $this->admin['level'] == 1 || intval($this->adminRow['can_delete']) == 1 ) 
            {
                echo '<li><a class="p_del AjaxModal" href="' . $this->base . '/DelForm?id=' . $mag_id . '&u=' . $user_id . '" title="' . $intro->lang['del'] . '"><span class="btn btn-danger btn-xs icon-trash"></span> Delete</a></li>';
            }
            if( $this->admin['level'] == 1 ) 
            {
                echo '<li><a class="p_edit AjaxModal" href="' . $intro->app_url('users', 'm3u') . '?id=' . $user_id . "\" title=\"Download m3u\">\r\n\t\t\t\t\t\t\t\t<span class=\"btn btn-success btn-xs icon-download\"></span> m3u </a></li>";
            }
            echo "\r\n\t\t\t\t\t\t\t<li class=\"divider\"></li>";
            if( $enabled == 1 ) 
            {
                echo '<li><a class="p_view AjaxModal" href="' . $intro->app_url('osd', 'mag') . ('?id=' . $mag_id . '" title="Send OSD Message for user on his tv."><span class="btn btn-default btn-xs icon-desktop"></span> Send OSD Msg</a></li>');
            }
            echo '<li><a class="AjaxConfirm" href="' . $intro->app_url('users', 'Kill') . '?uid=' . $user_id . '" title="Kill Connection!"><span class="btn btn-success btn-xs icon-emo-shoot"></span>Kill</a></li>';
            echo "\r\n                        </ul>\r\n\t\t\t\t\t</div>";
        }
        echo "</tbody>\r\n\t\t\t</table>";
        $order = str_replace(' ', ':', $order);
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411('<div class=\'text-center\'>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?' . $params, $totalrows, $rows_per_page, $page) . '</div>');
        echo "\t\t<script>\t\r\n\t\t\$(document).ready(function() {\r\n\r\n\t\t\t";
        if( $this->admin['level'] == 1 || $this->admin['level'] == 9 ) 
        {
            echo "\t\t\t\t\$.fn.editable.defaults.mode = 'pop';     \r\n\t\t\t\t\$('.editExpireDate').editable({\r\n\t\t\t\t\turl: '";
            echo $this->base;
            echo "/EditCodeDate?NH=1',\r\n\t\t\t\t\tsuccess: function(response) {\r\n\t\t\t\t\t\tif(response != \"success\" && response != \"\")\r\n\t\t\t\t\t\t\talert(response);\r\n\t\t\t\t\t}\r\n\t\t\t\t});\r\n\t\t\t";
        }
        echo "\t\t\t\r\n\t\t});\r\n\t\t</script>\r\n\t\t<style>\r\n\t\t.modal-body {\r\n\t\t\tmax-height: calc(100vh - 150px);\r\n\t\t\toverflow-y: auto;\r\n\t\t}\r\n\t\t</style>\r\n\t\t";
    }
    public function EditCodeDate()
    {
        global $intro;
        $data = $dataU = [];
        $id = intval($intro->input->get_post('pk'));
        $name = trim($intro->input->get_post('name'));
        $value = trim($intro->input->get_post('value'));
        if( $name == 'exp_date' ) 
        {
            if( !IntroDate::validateDate($value, 'Y-m-d H:i') ) 
            {
                exit( 'Wrong Date Format: use yyyy-mm-dd HH:ii' );
            }
            $value = strtotime($value);
        }
        $data[$name] = $value;
        if( $this->admin['level'] == 1 || $this->admin['level'] == 9 ) 
        {
            $intro->db->update('users', $data, 'id=' . $id);
            $af = $intro->db->affected_rows;
            exit( 'success (' . $af . ') ' );
        }
    }
    public function Renew()
    {
        global $intro;
        global $array;
        $username = '';
        if( $this->admin['level'] != 1 ) 
        {
            $intro->option['BlockAddFree'] = 1;
        }
        if( $this->admin['level'] == 9 ) 
        {
            $this->qry_admin = '';
        }
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM mag_devices where mag_id=' . $id . ';');
        $row = $intro->db->fetch_assoc($sql);
        @extract($row);
        $user_id = intval($row['user_id']);
        $sql = $intro->db->query('SELECT * FROM users where id=' . $user_id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        @extract($row);
        if( $username == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("Error: you cannot change this MAG.\r\n\t\t\t\t<li>The MAG may not found.\r\n\t\t\t\t<li>Or you don't have the right permisions to edit this MAG.", 'danger');
            exit();
        }
        $sql = $intro->db->query('SELECT * FROM ' . PREFIX . ('_users_data where userid=' . $user_id . ';'));
        $row = $intro->db->fetch_assoc($sql);
        @extract($row);
        $mac = base64_decode($mac);
        $date_expire = ($exp_date != '' ? date('Y-m-d H:i', $exp_date) : '-');
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Renew MAG: ' . $mac, 'success');
        echo "<table class=\"table table-striped table-bordered\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>Fullname:</td>\r\n\t\t\t\t<td>" . $fullname . "</td>\r\n\t\t\t\t<td class='info'>Reseller:</td>\r\n\t\t\t\t<td>" . $array['admins'][$member_id] . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\t\t\r\n\t\t\t\t<td class='info'>Period:</td>\r\n\t\t\t\t<td>" . period($period, $free_days) . ("</td>\r\n\t\t\t\t<td class='info'>Date Expire:</td>\r\n\t\t\t\t<td>" . $date_expire . "</td>\t\r\n\t\t\t</tr>\r\n\t\t\t<tr>\t\t\t\t\r\n\t\t\t\t<td class='info'>MAC:</td>\r\n\t\t\t\t<td><strong>" . $mac . "</strong></td>\r\n\t\t\t\t<td class='info'> </td>\r\n\t\t\t\t<td></td>\r\n\t\t\t</tr>\r\n\t\t</table>");
        $new_end = $this->getEndDate($date_expire, $period);
        echo "\r\n\t\t<form name=\"renew\" id='frmRenew' method=\"post\" action=\"" . $this->base . "/doRenew\">\r\n\t\t<table class=\"table table-striped table-bordered\">\r\n\t\t<tr>\r\n\t\t\t<td class=\"tr_bg2\" width=\"150\"> Period :</td>\r\n\t\t\t<td class=\"tr_bg1\">" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period', _obf_0D322A5B141A102E2824032B03230A35140306272F2F11(), $period) . (' ' . $this->error('period') . "</td>\r\n\t\t</tr>\t\t\r\n\t\t<tr>\r\n\t\t\t<td>New Start Date: </td>\r\n\t\t\t<td><font color=red><b>" . $this->cur_date . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Expire Date: </td>\r\n\t\t\t<td><font color=red><b><span id='calc_div'>" . $new_end . "</span> <span id=\"spin\" class='icon-spin5'></span> </td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Cost: </td>\r\n\t\t\t<td><font color=red><b><span id='cost_cost'>");
        $this->calcCost($member_id, $period);
        echo "</span> </td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td> </td>\r\n\t\t\t<td> <input type=\"submit\" value=\" Renew Now\" class=\"btn btn-success\" OnClick=\"return confirm('Are you sure?')\" /> </td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t<input type=\"hidden\" name=\"mag_id\" value=\"" . $mag_id . "\" />\r\n\t\t<input type=\"hidden\" name=\"user_id\" value=\"" . $user_id . "\" />\r\n\t\t<input type=\"hidden\" name=\"mac\" value=\"" . $mac . "\" />\r\n\t\t\r\n\t\t</form>";
        echo '<div id=\'result\'>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\$('documnet').ready(function(){\r\n\t\t\t\r\n\t\t\t\$(\"#frmRenew\").submit(function(event){\r\n\t\t\t\tevent.preventDefault();\r\n\r\n\t\t\t\t\$.ajax({\r\n\t\t\t\t\turl:'" . $this->base . "/doRenew/?NH=1',\r\n\t\t\t\t\ttype:'POST',\r\n\t\t\t\t\tdata:\$(this).serialize(),\r\n\t\t\t\t\tsuccess:function(result){\r\n\t\t\t\t\t\t\$('#result').html(result);\r\n\t\t\t\t\t}\r\n\r\n\t\t\t\t});\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$(\"select[name=period]\").change(function(){\r\n\t\t\t\tvar val = \$(this).val();\r\n\t\t\t\t\r\n\t\t\t\tif(val == 0){\r\n\t\t\t\t\talert('Error: you can\\'t renew Free.');\r\n\t\t\t\t\treturn false;\r\n\t\t\t\t}\r\n\t\t\t\t\r\n\t\t\t\t\$('#spin').addClass('animate-spin');\r\n\t\t\t\t\t\t\t\r\n\t\t\t\t\$.get(\"" . $this->base . '/calc/?cur_date=' . $this->cur_date . "&NH=1&period=\"+val+\"\", function( data ) {\r\n\t\t\t\t\t\$(\"#calc_div\" ).html( data );\r\n\t\t\t\t\t\$('#spin').removeClass('animate-spin');\r\n\t\t\t\t});\r\n\t\t\t\t\r\n\t\t\t\t\$(\"#cost_cost\").load('" . $this->base . '/calcCost/?NH=1&resel=' . $member_id . "&period='+val);\r\n\t\t\t\t\r\n\t\t\t});\r\n\t\t\t\r\n\t\t});\r\n\t\t</script>";
    }
    public function calcCost($adminid = 0, $period = 0)
    {
        global $intro;
        global $array;
        if( $adminid == 0 ) 
        {
            $adminid = intval($intro->input->get('resel'));
        }
        if( $period == 0 ) 
        {
            $period = intval($intro->input->get('period'));
        }
        if( in_array($period, $array['free']) ) 
        {
            echo '0';
        }
        $adm = $intro->auth->admin_data($adminid);
        $cost = floatval($adm['cost_' . $period]);
        if( $cost <= 0 ) 
        {
            exit( 'Contact admin to set you cost for (' . $period . ') Months.' );
        }
        $bal = _obf_0D3B1A30163C23381912245B381E2D3F0B0B340C070901($adminid);
        if( $bal < $cost ) 
        {
            exit( 'Insufficient balance. Your balance is: ' . $bal . '.' );
        }
        echo $cost;
    }
    public function calc()
    {
        global $intro;
        $cur_date = trim($intro->input->get_post('cur_date'));
        $period = trim($intro->input->get_post('period'));
        if( in_array($period, $this->free) ) 
        {
            if( $this->admin['level'] != 1 ) 
            {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Sorry: you can\'t renew Free Days. It\'s not allowed.', 'danger');
                exit();
            }
            $days = $period - 100;
            $new_end = _obf_0D1E0F36162C3B153E080E40155C280D0A052340013701($cur_date, 'day', $days, 'Y-m-d');
            echo (string)$new_end;
        }
        else
        {
            $new_end = _obf_0D1E0F36162C3B153E080E40155C280D0A052340013701($cur_date, 'month', $period, 'Y-m-d');
            echo (string)$new_end;
        }
    }
    public function getEndDate($date_expire, $period)
    {
        $rem = _obf_0D0B35352F210E3915162B31313632322D080512342E01(date('Y-m-d'), $date_expire);
        if( $rem > 0 ) 
        {
            $this->cur_date = $date_expire;
        }
        else
        {
            $this->cur_date = date('Y-m-d');
        }
        if( in_array($period, $this->free) ) 
        {
            $days = $period - 100;
            $new_end = _obf_0D1E0F36162C3B153E080E40155C280D0A052340013701($this->cur_date, 'day', $days, 'Y-m-d');
            return $new_end;
        }
        $new_end = _obf_0D1E0F36162C3B153E080E40155C280D0A052340013701($this->cur_date, 'month', $period, 'Y-m-d');
        return $new_end;
    }
    public function doRenew()
    {
        global $intro;
        global $error;
        global $array;
        if( $this->admin['level'] == 9 ) 
        {
            $this->qry_admin = '';
        }
        $cost = 0;
        $id = intval($intro->input->post('user_id'));
        $user_id = $id;
        $mac = trim($intro->input->post('mac'));
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        @extract($row);
        $date_expire = $exp_date;
        $adminid = intval($row['member_id']);
        $userid = intval($row['id']);
        $period = intval($intro->input->post('period'));
        if( $username == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: you can not Renew this MAG: <strong>' . $mac . "</strong>\r\n\t\t\t\t<li>The MAG may not found.\r\n\t\t\t\t<li>Or you don't have the right permisions to edit this MAG.", 'danger');
            exit();
        }
        if( $period == 0 ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: please choose period.', 'danger');
            exit();
        }
        $date_expire = ($date_expire != '' ? date('Y-m-d', $date_expire) : '-');
        $new_end = $this->getEndDate($date_expire, $period);
        if( !in_array($period, $array['free']) ) 
        {
            $inv = new IntroInvoice();
            $inv->set('adminid', $adminid);
            $inv->set('period', $period);
            $inv->set('userid', $userid);
            $inv->set('notes', 'Renew MAG: ' . $mac);
            $inv->Single();
        }
        $data = [];
        $data['exp_date'] = strtotime($new_end);
        $data['enabled'] = 1;
        $intro->db->update('users', $data, ' id=' . $userid);
        $af = $intro->db->affected_rows;
        $data = [];
        $data2['userid'] = $userid;
        $data2['period'] = $period;
        $intro->db->insert_update('' . PREFIX . '_users_data', $data2, $data2);
        echo "<script>\r\n\t\t\t\r\n\t\t\t\$('#expire_" . $id . '\').html(\'<span class="label label-success label-lg">' . $new_end . "</span>');\r\n\t\t\talert('Success! (" . $af . ")'); \r\n\t\t\t\t\r\n\t\t\t\$('#m3u-modal').modal('hide'); \r\n\t\t\t\r\n\t\t</script>";
    }
    public function Suspend()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('uid'));
        $sus = trim($intro->input->get_post('sus'));
        if( $sus == 'on' ) 
        {
            $qry = 'enabled=0';
            $span_sus = '<span class="icon-off label label-danger" title="Disabled!"> </span>';
        }
        else if( $sus == 'off' ) 
        {
            $qry = 'enabled=1';
            $span_sus = '<span class="label label-success">Active</span>';
        }
        else if( $sus == 'ban' ) 
        {
            $qry = 'admin_enabled=0';
            $span_sus = '<span class="icon-block label label-danger" title="Banned!"> </span>';
        }
        else if( $sus == 'unban' ) 
        {
            $qry = 'admin_enabled=1';
            $span_sus = '<span class="label label-success">Active</span>';
        }
        else
        {
            exit( 'Opps!!!' );
        }
        $qq = $code = '';
        if( intval($this->admin['level']) == 1 || intval($this->admin['level']) == 9 ) 
        {
            $qq = '';
        }
        else
        {
            $qq = ' and member_id=' . intval($this->admin['adminid']);
        }
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $qq . ';');
        $row = $intro->db->fetch_assoc($sql);
        $username = $row['username'];
        $intro->db->query('UPDATE users SET ' . $qry . ' WHERE id=' . $id . ' ' . $qq . ';');
        $arr = ['status_' . $id => $span_sus];
        header('Content-Type: application/json');
        echo json_encode($arr);
    }
    public function DelForm()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * from `users`  INNER JOIN mag_devices mag ON users.id=mag.user_id  LEFT JOIN ' . PREFIX . '_users_data ud on users.id=ud.userid  ' . (' where is_mag=1 AND mag_id=' . $id . '  ' . $this->qry_admin));
        $row = $intro->db->fetch_assoc($sql);
        if( !is_array($row) ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('MAG is not found or deleted. OR you are not authorized to delete this MAG.', 'danger');
            exit();
        }
        @extract($row);
        $adminid = $member_id;
        $date_expire = ($exp_date != '' ? date('Y-m-d H:i:s', $exp_date) : '-');
        $this->nav();
        $mac = base64_decode($mac);
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Delete MAG: ' . $mac, 'danger');
        echo "<table class=\"table table-striped table-bordered\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>MAC</td>\r\n\t\t\t\t<td>" . $mac . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>Fullname:</td>\r\n\t\t\t\t<td>" . $fullname . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\t\t\r\n\t\t\t\t<td class='info'>Reseller:</td>\r\n\t\t\t\t<td>" . $adminid . "</td>\r\n\t\t\t</tr>\r\n\t\t</table>";
        $id = intval($intro->input->get_post('id'));
        echo "<div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">\r\n\t\t\t\t  \r\n\t\t\t\t  <a class=\"btn btn-danger p_del\" id=\"delete\" href=\"" . $this->base . '/Del?id=' . $mag_id . '&u=' . $user_id . "&NH=1&db=1\">\r\n\t\t\t\t\t<i class=\"icon-cancel-circled2\"></i> Delete MAG From database " . $user_id . "\r\n\t\t\t\t  </a>\r\n\r\n\t\t\t</div>\r\n\t\t\t\t\r\n\t\t\t\t<span id=\"spin\" class='icon-spin5'></span>";
        echo '<div id=\'result\'>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\$('documnet').ready(function(){\r\n\t\t\t\$('#delete').click(function(e){\r\n\t\t\t\te.preventDefaults;\r\n\t\t\t\t\r\n\t\t\t\tif(!confirm('Are you sure?')) return false;\r\n\t\t\t\t\r\n\t\t\t\t\$('#spin').addClass('animate-spin');\r\n\t\t\t\t\$.get( \$(this).attr('href'), function( data ) {\r\n\t\t\t\t\t\$( \"#result\" ).html( data );\r\n\t\t\t\t\t\$('#spin').removeClass('animate-spin');\r\n\t\t\t\t});\r\n\t\t\t\treturn false;\r\n\t\t\t});\r\n\t\t});\r\n\t\t</script>";
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $period;
        global $fullname;
        global $code;
        global $days;
        global $adminid;
        global $status;
        global $created_at;
        global $num;
        global $bouquets;
        global $forced_country;
        global $allowed_ua;
        global $allowed_ips;
        global $mobile;
        global $mac;
        global $free_days;
        global $length;
        global $created_by;
        global $options;
        global $container;
        global $password;
        global $admin_notes;
        global $reseller_notes;
        global $bypass_ua;
        global $lock_device;
        global $is_isplock;
        global $max_connections;
        global $bouquet;
        global $is_restreamer;
        global $member_id;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $IF = intval($intro->input->get_post('IF'));
        $mag_id = intval($intro->input->get_post('mag_id'));
        $page = intval($intro->input->get_post('page'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        $btn = [];
        $user_id = 0;
        $db_mac = '';
        if( $IF != 1 ) 
        {
            $this->nav();
        }
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $qry = '';
            if( $this->admin['level'] != 1 && $this->admin['level'] != 9 ) 
            {
                $qry = ' and member_id=' . $this->admin['adminid'];
            }
            $sql = $intro->db->query('SELECT * FROM mag_devices where mag_id=' . $mag_id . ';');
            $rowMag = $intro->db->fetch_assoc($sql);
            @extract($rowMag);
            $user_id = intval($rowMag['user_id']);
            $db_mac = base64_decode($rowMag['mac']);
            $sql2 = $intro->db->query('SELECT * FROM users where id=' . $user_id . ' ' . $qry . ';');
            $row = $intro->db->fetch_assoc($sql2);
            @extract($row);
            $sql2 = $intro->db->query('SELECT * FROM ' . PREFIX . ('_users_data where userid=' . $user_id . ';'));
            $row2 = $intro->db->fetch_assoc($sql2);
            @extract($row2);
            $mac = base64_decode($mac);
            $btn['legend_name'] = 'Edit MAG: <b>' . $mac . '</b>';
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
            $bouquet = json_decode($bouquet, true);
            if( $allowed_ips != '' ) 
            {
                $tmp_ua = json_decode($allowed_ips, true);
                $allowed_ips = implode(',', $tmp_ua);
            }
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            new IntroPerms('CheckBalance', $this->adminRow);
            $btn['legend_name'] = 'Add new MAG';
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = $intro->lang['save'];
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            $is_isplock = ($is_isplock == '' ? 0 : $is_isplock);
            if( $this->adminRow['num_free'] == 0 ) 
            {
            }
            $max_connections = ($max_connections == '' ? 1 : $max_connections);
            if( is_array($intro->input->post('bouquets')) && count($intro->input->post('bouquets')) >= 1 ) 
            {
                $bouquet = $intro->input->post('bouquets');
            }
            if( intval($intro->input->post('adminid')) != 0 ) 
            {
                $member_id = intval($intro->input->post('adminid'));
            }
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ') . "\r\n\t\t" . _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911() . (" \r\n\t\t<form method=\"POST\" name=\"form_add\" id='frmUsers' action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\r\n\t\t<table class=\"table table-bordered\">\r\n\t\t<tr>\r\n\t\t\t<td style='width:30%'>") . $intro->lang['codes_fullname'] . (" :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"fullname\" value=\"" . $fullname . "\" class=\"form-control\" style='min-width:70%'>\r\n\t\t\t\t\t" . $this->error('fullname') . "\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Mobile : </td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"mobile\" value=\"" . $mobile . "\" class=\"form-control\"  style='min-width:70%'> \r\n\t\t\t\t\t" . $this->error('mobile') . "\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Device MAC Address : <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td><div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"mac\" value=\"" . $mac . "\" class=\"form-control\" style=\"min-width:300px;text-transform:uppercase\"> \r\n\t\t\t\t\t" . $this->error('mac') . "\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>");
        if( ($this->admin['level'] == 1 || $t == 'add') && $this->adminRow['member_group_id'] == 0 ) 
        {
            echo "\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Period (days) :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t\t<td><div class=\"form-inline\">\r\n\t\t\t\t\t\t\t" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period', _obf_0D322A5B141A102E2824032B03230A35140306272F2F11(), $period) . (' ' . $this->error('period'));
            if( $this->admin['level'] == 1 ) 
            {
                echo '<span id="span_free_days" style="display:none">Free Extra Days: <input  type="number" name="free_days" value="' . $free_days . '" ' . (($t == 'add' ? 'min="1"' : '')) . ' class="form-control" size="10"></span>';
            }
            else if( strlen($this->adminRow['extra_free_days']) >= 2 ) 
            {
                echo extra_free_days($this->adminRow['extra_free_days'], $free_days);
            }
            echo "\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t</td>\r\n\t\t\t\t</tr>";
        }
        if( $t == 'edit' ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Created at : </td>\r\n\t\t\t\t<td><i>" . date('Y-m-d H:i:s', $created_at) . "</i></td>\r\n\t\t\t</tr>";
        }
        if( $this->admin['level'] == 1 && $t == 'edit' ) 
        {
            $exp_date = date('Y-m-d H:i:s', $exp_date);
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>End Date : </td>\r\n\t\t\t\t<td><input type=\"text\" name=\"exp_date\" value=\"" . $exp_date . "\" size=\"25\"></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Is Trial  : </td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('is_trial', $is_trial, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>";
        }
        if( $this->adminRow['member_group_id'] > 0 && $t == 'add' ) 
        {
            $pkg = new Packages($this->adminRow);
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Package: <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td>";
            echo $pkg->FormDropDown();
            echo "\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Bouquets:  <span style='color:#ff0000'>*</span>\r\n\t\t\t\t\t<div style=\"float:right;\">\r\n\t\t\t\t\t\t   <input type=\"checkbox\" id=\"checkAll\"/> <b>Check All</b>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td> " . $this->error('bouquets') . " <div id='bouquets_result'></div></td>\r\n\t\t\t</tr>";
        }
        else
        {
            if( $this->adminRow['member_group_id'] > 0 ) 
            {
                $intro->member_group_id = $this->adminRow['member_group_id'];
                $intro->code_pkg = $pkg;
            }
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Bouquets:  <span style='color:#ff0000'>*</span>\r\n\t\t\t\t\t<div style=\"float:right;\">\r\n\t\t\t\t\t\t   <input type=\"checkbox\" id=\"checkAll\"/> <b>Check All</b>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td> " . $this->error('bouquets') . ' ' . bouquets($bouquet) . "</td>\r\n\t\t\t</tr>";
        }
        if( $this->admin['level'] == 1 || $this->adminRow['can_set_country'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Override General Country Restriction:  </td>\r\n\t\t\t\t<td> " . forced_country($forced_country) . " </td>\r\n\t\t\t</tr>";
        }
        echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Lock STB Device on Hardware :</td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('lock_device', $lock_device, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Lock user to his ISP :</td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('is_isplock', $is_isplock, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>";
        echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Allowed IPs :</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t\t<input class=\"form-control\" data-role=\"tagsinput\" type=\"text\" name=\"allowed_ips\" value=\"" . $allowed_ips . '" size="30"> ' . $this->error('allowed_ips') . " \r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>" . $intro->lang['codes_adminid'] . " :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td>" . _obf_0D312C22263726180408322D1B0C363E320C351C1B0B32($member_id) . (' ' . $this->error('adminid') . "</td>\r\n\t\t\t</tr>");
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Admin Notes :</td>\r\n\t\t\t\t<td><textarea name=\"admin_notes\" class=\"form-control\" style='width:100%;height:70px;'>" . $admin_notes . '</textarea> ' . $this->error('admin_notes') . "</td>\r\n\t\t\t</tr>";
        }
        echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Reseller Notes :</td>\r\n\t\t\t\t<td><textarea name=\"reseller_notes\" class=\"form-control\" style='width:100%;height:70px;'>" . $reseller_notes . '</textarea> ' . $this->error('reseller_notes') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"user_id\"  value=\"" . $user_id . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"mag_id\"  value=\"" . $mag_id . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"IF\"  value=\"" . $IF . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"page\"  value=\"" . $page . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"db_mac\"  value=\"" . $db_mac . "\">\r\n\t\t\t\t\t<button type=\"submit\" class=\"btn btn-success\" value=\"" . $btn['action'] . '"><i class="' . $btn['img_icon'] . '"> ' . $btn['name'] . " </i></button>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\tfunction isValidMac(mystring){\r\n\t\t\tvar regex = /^([0-9A-F]{2}[:-]){5}([0-9A-F]{2})\$/;\r\n\t\t\treturn regex.test(mystring);\r\n\t\t}\r\n\t\t\$(document).ready(function(){\r\n\r\n\t\t\t\$(\"select[name='package']\").change(function () {\r\n\t\t\t\t\r\n\t\t\t\tvar package = \$(this).val();\r\n\t\t\t\t\r\n\t\t\t\t\$.post(\"" . $intro->app_url('renew', 'getBouquets') . "/?NH=1\", \r\n\t\t\t\t\t{package:package}, function(data,status,xhr){\t\r\n\t\t\t\t\t\$(\"#bouquets_result\").html(data);\r\n\t\t\t\t\t/*\$(\"#checkAll\").trigger('click');*/\r\n\t\t\t\t\t\$(\"#UsersBouquets\").find(':checkbox').prop('checked', true);\r\n\t\t\t\t});\r\n\t\t\t\r\n\t\t\t\t\r\n\t\t\t});\r\n\t\t\t\$(\"#checkAll\").change(function () {\r\n\t\t\t\t\$(this).closest('tr').find(':checkbox').prop('checked', \$(this).prop(\"checked\"));\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$(\"select[name=period]\").change(function () {\r\n\t\t\t\t\r\n\t\t\t\tvar groupName = \$(this).val();\r\n\t\t\t\t\r\n\t\t\t\tif(groupName < 100 && groupName >= 1){\r\n\t\t\t\t\t\$('#span_free_days').show();\r\n\t\t\t\t\t\r\n\t\t\t\t}else{\r\n\t\t\t\t\t\$('#span_free_days').hide();\r\n\t\t\t\t}\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$.validator.addMethod(\"macVldt\", function(value) {\r\n\t\t\t\treturn isValidMac(value.toUpperCase());\r\n\t\t\t}, 'Please enter valid MAC Address!');\r\n\t\t\t\r\n\t\t\t\$(\"#frmUsers\").validate({\r\n\t\t\t\tignore: [],\r\n\t\t\t\trules: {\r\n\t\t\t\t\tfullname: \"required\",\r\n\t\t\t\t\tperiod: \"required\",\r\n\t\t\t\t\tadminid: \"required\",\r\n\t\t\t\t\tusername: {\r\n\t\t\t\t\t\trequired: true,\r\n\t\t\t\t\t\tminlength: 5\r\n\t\t\t\t\t},\r\n\t\t\t\t\tmac: 'macVldt',\r\n\t\t\t\t\t'bouquets[]': {\r\n\t\t\t\t\t\trequired: true,\r\n\t\t\t\t\t\tminlength: 1\r\n\t\t\t\t\t}\r\n\t\t\t\t},\r\n\t\t\t\tmessages: {\r\n\t\t\t\t\tfullname: \"Required!\",\r\n\t\t\t\t\tperiod: \"Choose Period!\",\r\n\t\t\t\t\tusername: \"Required!\",\r\n\t\t\t\t\t\r\n\t\t\t\t\t'bouquets[]': \"Choose Bouquets.\"\r\n\t\t\t\t}\r\n\t\t\t});\r\n\t\t\t\r\n\t\t});";
        if( $period >= 1 && $period < 100 ) 
        {
            echo "\$('#span_free_days').show();\n";
        }
        else
        {
            echo "\$('#span_free_days').hide();\n";
        }
        echo "\r\n\t\t</script>";
    }
    public function clean()
    {
        global $intro;
        global $error;
        global $array;
        $intro->db->query('delete from mag_devices where user_id not in (select id from users)');
        $totrows = $intro->db->affected_rows;
        $intro->redirect($this->appname, 'index', '?clean=' . $totrows);
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        global $array;
        $fullname = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('fullname'), ' {ar}');
        $mobile = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('mobile'), '+-');
        $mac = strtoupper(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('mac'), ':'));
        $period = intval($intro->input->post('period'));
        $adminid = intval($intro->input->post('adminid'));
        $bypass_ua = intval($intro->input->post('bypass_ua'));
        $is_isplock = intval($intro->input->post('is_isplock'));
        $lock_device = intval($intro->input->post('lock_device'));
        $free_days = intval($intro->input->post('free_days'));
        $package = intval($intro->input->post('package'));
        $bouquets = $intro->input->post('bouquets');
        $forced_country = trim($intro->input->post('forced_country'));
        $allowed_ua = trim($intro->input->post('allowed_ua'));
        $allowed_ips = trim($intro->input->post('allowed_ips'));
        $admin_notes = $intro->db->escape($intro->input->post('admin_notes'));
        $reseller_notes = $intro->db->escape($intro->input->post('reseller_notes'));
        $username = 'mag' . preg_replace('/[^a-zA-Z0-9:]+/', '', $mac);
        if( $fullname == '' || $adminid == 0 && $this->admin['level'] == 1 || $period == 0 && $package == 0 || $bouquets == null || $this->adminRow['num_free'] == 0 && in_array($period, $array['free']) && $package == 0 ) 
        {
            if( $fullname == '' ) 
            {
                $error['fullname'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $period == 0 && $package == 0 ) 
            {
                $error['period'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $this->adminRow['num_free'] == 0 && in_array($period, $array['free']) && $package == 0 ) 
            {
                $error['period'] = '<span class=error>Error: you can\'t Add free MAGs at this time. Please contact admin.</span>';
            }
            if( $adminid == 0 && $this->admin['level'] == 1 ) 
            {
                $error['adminid'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $bouquets == null ) 
            {
                $error['bouquets'] = '<span class=error>Please choose at least one Bouquets/PACKAGE</span>';
            }
            $this->Form('add');
            exit();
        }
        $intro->db->query_fast('SELECT mag_id FROM `mag_devices`  where mac LIKE \'' . base64_encode($mac) . '\';');
        if( $intro->db->returned_rows > 0 ) 
        {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Error: adding MAG.', 'danger');
            $error['mac'] = '<span class=\'error\'>MAC ' . $mac . ' Already used. Please input new one.</span>';
            $this->Form('add');
            exit();
        }
        if( $this->admin['level'] != 1 && $adminid == 0 ) 
        {
            $adminid = intval($this->admin['adminid']);
        }
        $adm = $intro->auth->admin_data($adminid);
        $p = new IntroPerms('CheckCost', $adm, 1, $period, $package);
        if( $p->error != '' ) 
        {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011($p->error, 'danger');
            $error['cost_err'] = _obf_0D3D40321528110F062A0B0321102712170C15030F2232($p->error, 'danger');
            $this->Form('add');
            exit();
        }
        $dataMAG = $dataUser = [];
        $time = time();
        $dataUser = [
            'is_mag' => 1, 
            'exp_date' => _obf_0D1E12391F102F2E2A3E23330537315C320C3910402322($period, $free_days), 
            'member_id' => $adminid, 
            'created_by' => $adminid, 
            'username' => $username, 
            'password' => _obf_0D2F32243C12041507380F0603331A24041D1E32150A32(), 
            'is_isplock' => $is_isplock, 
            'admin_notes' => $admin_notes, 
            'allowed_ua' => json_encode([]), 
            'created_at' => $time, 
            'reseller_notes' => $reseller_notes, 
            'forced_country' => $forced_country, 
            'pkg' => $package, 
            'allowed_ips' => _obf_0D2A1F0B1D22240D3D103E2A0D32125C5C013F192C3632($allowed_ips, 'save'), 
            'bouquet' => json_encode($bouquets)
        ];
        $dataUser['is_trial'] = (in_array($period, $array['free']) && $period != -1 ? 1 : 0);
        if( $package > 0 ) 
        {
            $pkg = _obf_0D0E122A21280A14271F3B1D1727291E290A0A2A092E11($package);
            $dataUser['max_connections'] = $pkg['max_connections'];
            $dataUser['exp_date'] = $pkg['exp_date'];
            $dataUser['is_trial'] = $pkg['is_trial'];
            $dataUser['pkg'] = $package;
            $data2['period'] = $package;
            $stream_output_format = $pkg['output_formats_array'];
        }
        $intro->db->insert('users', $dataUser);
        $user_id = $intro->db->insert_id();
        if( $package > 0 ) 
        {
            foreach( $stream_output_format as $key => $val ) 
            {
                $intro->db->insert('user_output', [
                    'user_id' => $user_id, 
                    'access_output_id' => $val
                ]);
            }
        }
        else
        {
            $intro->db->insert('user_output', [
                'user_id' => $user_id, 
                'access_output_id' => 2
            ]);
        }
        $dataMAG['user_id'] = $user_id;
        $dataMAG['mac'] = base64_encode($mac);
        $dataMAG['created'] = $time;
        $intro->db->insert('mag_devices', $dataMAG);
        $sql = $intro->db->query_fast('SELECT mag_id,user_id FROM `mag_devices`  where mac LIKE \'' . base64_encode($mac) . '\' LIMIT 1;');
        $magRow = $intro->db->fetch_assoc($sql);
        $mag_id = intval($magRow['mag_id']);
        if( $mag_id == 0 ) 
        {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Error: adding MAG.', 'danger');
            $error['mac'] = '<span class=\'error\'>Error: something wrong with adding MAC. can\'t know id.</span>';
            $this->Form('add');
            exit();
            exit();
        }
        $data = $data2 = [];
        $data2['fullname'] = $fullname;
        $data2['mobile'] = $mobile;
        if( $package > 0 ) 
        {
            $data2['period'] = $package;
        }
        else
        {
            $data2['period'] = $period;
        }
        $data2['free_days'] = $free_days;
        $data2['userid'] = $user_id;
        $intro->db->insert_update('' . PREFIX . '_users_data', $data2);
        if( $package == 0 ) 
        {
            if( !in_array($period, $array['free']) && $user_id != 0 ) 
            {
                $inv = new IntroInvoice();
                $inv->set('adminid', $adminid);
                $inv->set('period', $period);
                $inv->set('num', 1);
                $inv->set('code_trans', 0);
                $inv->set('all_data', '');
                $inv->set('userid', $user_id);
                $inv->set('notes', 'add MAG: ' . $mac);
                $inv->Save();
            }
        }
        else
        {
            $inv = new IntroInvoice();
            $inv->set('isPackage', true);
            $inv->set('adminid', $adminid);
            $inv->set('package', $package);
            $inv->set('period', $package);
            $inv->set('num', 1);
            $inv->set('code_trans', 0);
            $inv->set('all_data', '');
            $inv->set('userid', $user_id);
            $inv->set('notes', 'add MAG: ' . $mac . ' Days:' . $pkg['inv_notes']);
            $inv->Save();
        }
        if( in_array($period, $array['free']) && $this->adminRow['num_free'] > 0 && $success > 0 ) 
        {
            $intro->db->query('UPDATE ' . PREFIX . ('_admin SET num_free=num_free-' . $success . ' WHERE num_free>0 AND adminid=' . $adminid . ';'));
            if( $this->adminRow['father'] > 0 ) 
            {
                $intro->db->query('UPDATE ' . PREFIX . ('_admin SET num_free=num_free-' . $success . ' WHERE num_free>0 AND adminid=' . $this->adminRow['father'] . ';'));
            }
            $intro->db->query('UPDATE ' . PREFIX . '_admin SET num_free=0 WHERE num_free<-1;');
        }
        $intro->redirect($this->appname);
    }
    public function random_number($length)
    {
        $random = substr(number_format(time() * rand(), 0, '', ''), 0, $length);
        return $random;
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        global $error;
        $userid = intval($intro->input->get_post('user_id'));
        $mag_id = intval($intro->input->get_post('mag_id'));
        $fullname = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('fullname'), ' {ar}');
        $mobile = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('mobile'), '\+');
        $mac = strtoupper(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('mac'), ':'));
        $username = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('username'));
        $password = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('password'));
        $period = intval($intro->input->post('period'));
        $adminid = intval($intro->input->post('adminid'));
        $bypass_ua = intval($intro->input->post('bypass_ua'));
        $is_isplock = intval($intro->input->post('is_isplock'));
        $is_stalker = intval($intro->input->post('is_stalker'));
        $lock_device = intval($intro->input->post('lock_device'));
        $free_days = intval($intro->input->post('free_days'));
        $db_mac = trim($intro->input->post('db_mac'));
        $exp_date = trim($intro->input->post('exp_date'));
        $forced_country = trim($intro->input->post('forced_country'));
        $allowed_ua = trim($intro->input->post('allowed_ua'));
        $allowed_ips = trim($intro->input->post('allowed_ips'));
        $admin_notes = $intro->db->escape($intro->input->post('admin_notes'));
        $reseller_notes = $intro->db->escape($intro->input->post('reseller_notes'));
        $bouquets = $intro->input->post('bouquets');
        $data = $data2 = $MAG = [];
        if( $db_mac != $mac ) 
        {
            $sql = $intro->db->query_fast('SELECT mag_id,mac FROM `mag_devices`   WHERE mac LIKE \'' . base64_encode($mac) . '\' /*AND mac NOT LIKE \'' . base64_encode($db_mac) . '\'*/ LIMIT 1;');
            $row_check = $intro->db->fetch_assoc($sql);
            if( intval($row_check['mag_id']) > 0 ) 
            {
                _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Error: the MAC ' . $mac . ' is already exists.', 'danger');
                $error['mac'] = '<span class=\'error\'>your new MAC (' . $mac . ') already used.</span>';
                $this->Form('edit');
                exit();
            }
            $MAG['mac'] = base64_encode($mac);
        }
        if( $bouquets == null ) 
        {
            $error['bouquets'] = '<span class=error>Please choose at least one Bouquets/PACKAGE</span>';
            $this->Form('edit');
            exit();
        }
        $data2['userid'] = $userid;
        $data2['fullname'] = $fullname;
        $data2['mobile'] = $mobile;
        if( $this->admin['level'] == 1 ) 
        {
            $data['created_by'] = intval($intro->input->post('adminid'));
            $data['member_id'] = intval($intro->input->post('adminid'));
            $data['exp_date'] = strtotime($exp_date);
            $data2['period'] = $period;
            $data2['free_days'] = $free_days;
            $data['admin_notes'] = $admin_notes;
            $data['is_trial'] = intval($intro->input->post('is_trial'));
        }
        $data['bouquet'] = '[' . implode(',', $bouquets) . ']';
        $data['forced_country'] = $forced_country;
        $data['allowed_ips'] = _obf_0D2A1F0B1D22240D3D103E2A0D32125C5C013F192C3632($allowed_ips, 'save');
        $data['is_isplock'] = $is_isplock;
        $data['reseller_notes'] = $reseller_notes;
        $qry = '';
        if( $this->admin['level'] != 1 && $this->admin['level'] != 9 ) 
        {
            $qry = ' and member_id=' . $this->admin['adminid'];
        }
        $intro->db->update('users', $data, 'id=' . $userid . ' ' . $qry);
        $intro->db->insert_update('' . PREFIX . '_users_data', $data2, $data2);
        $MAG['lock_device'] = $lock_device;
        $intro->db->update('mag_devices', $MAG, 'mag_id=' . $mag_id);
        $intro->redirect($this->appname);
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $mag_id = intval($intro->input->get_post('id'));
        $user_id = intval($intro->input->get_post('u'));
        $db = intval($intro->input->get_post('db'));
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');
        $sql = $intro->db->query('SELECT * from `users`  INNER JOIN mag_devices mag ON users.id=mag.user_id  LEFT JOIN ' . PREFIX . '_users_data ud on users.id=ud.userid  ' . (' where users.is_mag=1 AND mag.mag_id=' . $mag_id . ' ' . $this->qry_admin));
        $row = $intro->db->fetch_assoc($sql);
        if( intval($row['id']) == 0 ) 
        {
            echo '<h1>Not authorized! Or You don\'t have permisions to delete this MAG.</h1>';
        }
        $mag_id = intval($row['mag_id']);
        $user_id = intval($row['id']);
        if( $this->admin['level'] == 1 || $this->admin['can_delete'] == 1 ) 
        {
            $intro->db->query('delete from mag_devices WHERE mag_id=' . $mag_id . ';');
            $intro->db->query('delete from users WHERE id=' . $user_id . ';');
            $intro->db->query('delete from ' . PREFIX . ('_users_data WHERE userid=' . $user_id . ';'));
            $intro->db->query('delete from mag_devices where user_id not in (select id from users)');
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('MAG deleted form database!', 'success');
            echo "<script>\r\n\t\t\t\$(function () {\r\n\t\t\t   setTimeout(function()\r\n\t\t\t   {\r\n\t\t\t\t\t\$('#m3u-modal').modal('hide');\r\n\t\t\t\t\t\$('#tr_" . $user_id . "').fadeOut();\r\n\t\t\t   }, 1000);\r\n\t\t\t   \r\n\t\t\t});</script>";
        }
        else
        {
            echo '<h1>Not authorized!</h1>';
        }
    }
}
