<?php 
class Movies_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $msg = null;
    public $success = false;

    // Remote Database Operations (204.188.233.170)
    private function remoteDbExecute($sql)
    {
        $remote_host = '204.188.233.170';
        $remote_user = 'root';
        $remote_pass = 'R7nMi4KCzZv920pG';
        $remote_db = 'midnight_iptv';

        $tmp_file = '/tmp/remote_movie_sql_' . uniqid() . '.sql';
        file_put_contents($tmp_file, $sql);

        $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " . $remote_user . "@" . $remote_host . " \"mysql " . $remote_db . " -N\" < " . escapeshellarg($tmp_file) . " 2>&1";

        $result = shell_exec($cmd);
        @unlink($tmp_file);

        error_log("Remote Movie DB Execute: $sql - Result: $result");
        return $result;
    }

    private function addMovieToRemote($name, $urls)
    {
        $name_esc = addslashes($name);
        $urls_json = is_array($urls) ? json_encode($urls) : $urls;
        $urls_esc = addslashes($urls_json);

        // type=1 for VOD in remote panel
        // VOD/Movies use 'files' field instead of 'urls' in external panel
        $sql = "INSERT INTO streams (name, type, files) VALUES ('$name_esc', 1, '$urls_esc');";
        $result = $this->remoteDbExecute($sql);
        return (empty($result) || strpos($result, 'ERROR') === false);
    }

    private function updateMovieInRemote($old_name, $new_name, $urls)
    {
        $old_name_esc = addslashes($old_name);
        $new_name_esc = addslashes($new_name);
        $urls_json = is_array($urls) ? json_encode($urls) : $urls;
        $urls_esc = addslashes($urls_json);

        // VOD/Movies use 'files' field instead of 'urls' in external panel
        $sql = "UPDATE streams SET name='$new_name_esc', files='$urls_esc' WHERE name='$old_name_esc' AND type=1;";
        $result = $this->remoteDbExecute($sql);
        return (empty($result) || strpos($result, 'ERROR') === false);
    }

    private function deleteMovieFromRemote($name)
    {
        $name_esc = addslashes($name);
        $sql = "DELETE FROM streams WHERE name='$name_esc' AND type=1;";
        $result = $this->remoteDbExecute($sql);
        return (empty($result) || strpos($result, 'ERROR') === false);
    }

    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        global $array;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "\r\n\t\t<div class=\"app_nav\">\r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . "/index\"><icon class=\"icon-list\"></icon>Movies</a> \r\n\t\t<a class=\"btn btn-") . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="' . $this->base . '/Form?t=add"><icon class="icon-plus-squared"></icon>') . $intro->lang['movies_add'] . "</a>  \t\t \t\t \r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('MassAdd') . (' p_add" href="' . $this->base . "/MassAdd\"><icon class=\"icon-magic\"></icon>Mass Add</a>  \t\t \t\t \r\n\t\t<a class=\"btn btn-") . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('AddByM3u') . (' p_add" href="' . $this->base . "/AddByM3u\"><icon class=\"icon-upload\"></icon>Add by M3U</a>  \t\t \t\t \r\n\t\t\t\t \t\t \r\n\t\t<a class=\"btn btn-default\" href=\"" . $intro->app_url('categories', 'index') . '?category_type=movie"><icon class="icon-folder"></icon>Movies Categories</a> ');
        if( $this->admin['level'] == 1 ) 
        {
            echo '<a class="btn btn-default" href="' . $this->base . '/ChangeMoviesURL"><icon class="icon-edit"></icon>Change URL/DNS</a> ';
            echo '<a class="btn btn-default" href="' . $this->base . '/ImageDl"><icon class="icon-download"></icon>IMG DL</a> ';
        }
        echo '</div>';
        $result = $intro->db->query('SELECT `task_id` FROM `solus_tasks` WHERE `task_for`=\'movies\';');
        $totrows = $intro->db->returned_rows;
        if( $totrows > 0 ) 
        {
            echo "<div class=\"app_nav\">\r\n\t\t\t\t<a class=\"btn btn-success btn-lg blinking\" href=\"" . $this->base . "/StartTask\">\r\n\t\t\t\t\t<icon class=\"icon-run\"></icon>\r\n\t\t\t\t\tYou have (" . $totrows . ") Movies waiting to run Task, click here \r\n\t\t\t\t</a>  \t \r\n\t\t\t\t<a class=\"btn btn-danger btn-lg\" href=\"" . $this->base . "/ClearTask\" OnClick=\"return confirm('Are yuo sure?');\">\r\n\t\t\t\t\t<icon class=\"icon-run\"></icon>\r\n\t\t\t\t\tClear Task\r\n\t\t\t\t</a>\t\t\t\t\r\n\t\t\t</div>";
        }
    }
    public function index()
    {
        global $intro;
        global $array;
        $qry = $params = '';
        $category_id = intval($intro->input->get_post('category_id'));
        $page = intval($intro->input->get_post('page'));
        $status = intval($intro->input->get_post('status'));
        $order = trim($intro->input->get_post('order'));
        $stream_display_name = trim($intro->input->get_post('stream_display_name'));
        $x3 = trim($intro->input->get_post('x3'));
        $server = intval($intro->input->get_post('server'));
        $duplicated = intval($intro->input->get_post('duplicated'));
        $this->nav();
        if( $stream_display_name != '' ) 
        {
            $qry .= (' and  s.stream_display_name  LIKE \'%' . $stream_display_name . '%\' ');
            $params .= ('&stream_display_name=' . $stream_display_name);
        }
        if( $category_id != 0 ) 
        {
            $qry .= (' and s.category_id=' . $category_id . ' ');
            $params .= ('&category_id=' . $category_id);
        }
        if( $status != 0 ) 
        {
            $qry .= $array['encode_status_qry'][$status];
            $params .= ('&status=' . $status);
        }
        if( $server != 0 ) 
        {
            $qry .= (' and sys.server_id=' . $server . ' ');
            $params .= ('&server=' . $server);
        }
        if( $duplicated == 1 ) 
        {
            $qry = ' GROUP BY s.stream_display_name HAVING COUNT(*)  > 1';
            $params = '';
        }
        if( $order == '' ) 
        {
            $order = 's.id:desc';
        }
        $qry_order = str_replace(':', ' ', $order);
        $rows_per_page = 30;
        if( $page == 0 ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $sql = 'SELECT * ,(SELECT GROUP_CONCAT(server_name SEPARATOR \', \') FROM streaming_servers WHERE id=sys.server_id LIMIT 1) as server_name ,(SELECT category_name from stream_categories WHERE id=category_id) AS catname  from `streams` s LEFT JOIN `streams_sys` sys ON (s.id=sys.stream_id) ' . (' WHERE s.type=2 AND s.id NOT IN (SELECT stream_id FROM series_episodes) ' . $qry . ' order by ' . $qry_order . '  limit ' . $nexlimit . ',' . $rows_per_page);
        $result = $intro->db->query($sql);
        $totrows = $intro->db->returned_rows;
        $sql_all_rows = $intro->db->query('SELECT id from `streams`  s ' . (' LEFT JOIN `streams_sys` sys ON (s.id=sys.stream_id) where s.type=2 AND s.id NOT IN (SELECT stream_id FROM series_episodes) ' . $qry . ' '));
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-list"></i> ' . $intro->lang['movies_cur'] . (' (' . $totalrows . ')'), 'info');
        echo "\r\n\t\t\r\n\t\t\t\r\n\t\t<form class=\"form-inline\" action=\"\" method=\"post\">\r\n\t\t\t<div class=\"form-group\">\r\n\t\t\t\t<label >Type a text :</label>\r\n\t\t\t\t<input type=\"text\" class=\"form-control\"  name=\"stream_display_name\" value=\"" . $stream_display_name . "\" >\r\n\t\t\t</div>\r\n\t\t\t<div class=\"form-group\">\r\n\t\t\t\t<label >Category:</label>\r\n\t\t\t\t" . $this->form_select_category('category_id', $category_id) . "\r\n\t\t\t</div>\r\n\t\t\t<div class=\"form-group\">\r\n\t\t\t\t<label >Server:</label>\r\n\t\t\t\t" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('server', 'All Servers', 'streaming_servers', 0, 'id', 'server_name', 'bouquet_status', 'where `status`=1', 'order by server_name asc') . "\r\n\t\t\t</div>\r\n\t\t\t<div class=\"form-group\">\r\n\t\t\t\t<label >Encoding Status:</label>\r\n\t\t\t\t" . _obf_0D1029270D2B062E351F39253F1B39061037400E130401('status', $array['encode_status'], $status, 'All', 0) . "\r\n\t\t\t\r\n\t\t\t</div>\r\n\t\t\t<div class=\"form-group\">\r\n\t\t\t\t<input class=\"form-check-input\" type=\"checkbox\" value=\"1\" name=\"duplicated\" id=\"duplicated\" " . (($duplicated == 1 ? 'checked' : '')) . ">\r\n\t\t\t\t<label class=\"form-check-label\" for=\"duplicated\">\r\n\t\t\t\t\tFind Duplicated\r\n\t\t\t\t</label>\r\n\t\t\t</div>\r\n\t\t\t<button type=\"submit\" class=\"btn btn-info\">" . $intro->lang['search'] . "</button>\r\n\t\t</form>\r\n\r\n\t\t\r\n\t\t<br>\r\n\t\t<form method=\"post\" name=\"VodsForm\"  id=\"VodsForm\">\r\n\t\t<table class=\"table table-bordered table-hover table-striped\"   >\r\n        <thead>\r\n\t    <tr >\r\n\t\t\t<th><input type='checkbox' class='checkAll' /></th>\r\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index') . "</th>\r\n\t\t\t<th>Status</th>\r\n\t\t\t<th>" . $intro->lang['movies_catid'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('category_id', 'index') . " </th>\r\n\t\t\t<th>" . $intro->lang['movies_title'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('stream_display_name', 'index') . " </th>\r\n\t\t\t<th>" . $intro->lang['movies_view_order'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('`order`', 'index') . " </th>\r\n\t\t\t<th>Poster " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('stream_icon', 'index') . " </th>\r\n\t\t\t<th>Server</th>\r\n\t\t\t<th>Bitrate</th>\r\n\t\t\t<th>" . $intro->lang['options'] . "</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $icon = $stream_icon;
            $subtitle = $movie_subtitles;
            if( $icon != '' ) 
            {
                if( strpos($icon, 'http') === 0 ) 
                {
                    $icon = '<img src=\'' . $icon . '\' style=\'max-height:70px;\'>';
                }
                else
                {
                    $icon = '<img src=\'' . admin_path . ($icon . '\' style=\'max-height:70px;\'>');
                }
            }
            echo "\r\n\t\t\t<tr  class=\"" . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\r\n\t\t\t\t<td class=\"center\"><input type=\"checkbox\" class=\"checkAllIds\" value=\"" . $id . "\" name=\"ids[]\"></td>\r\n\t\t\t\t<td class=\"center\">" . $id . "</td>\r\n\t\t\t\t<td class=\"center\" id=\"vod_" . $id . '"><span id=\'loadvod_' . $id . '\'></span> ') . _obf_0D01250828283822072939021F5B09051E1F2B2A073411($id, $myrow) . ("</td>\r\n\t\t\t\t<td class=\"center\" >" . $catname . "</td>\r\n\t\t\t\t<td id='" . $id . '\' name=\'title\' class=\'center editable2\'>' . $stream_display_name . "</td>\r\n\t\t\t\t<td class=\"center\">" . $order . "</td>\r\n\t\t\t\t<td class=\"center\" >" . $icon . "</td>\r\n\t\t\t\t<td class=\"center\">" . $server_name . "</td>\r\n\t\t\t\t<td class=\"center\">" . $bitrate . " Kbps</td>\r\n\t\t\t\t\r\n\t\t\t\t<td class=\"center\"> \r\n\t\t\t\t\t<a class=\"btn btn-info p_edit\" href=\"" . $this->base . '/Form?t=edit&amp;id=' . $id . '" title="') . $intro->lang['edit'] . ("\"><i class=\"icon-edit\"></i></a>\r\n\t\t\t\t\t<a class=\"btn btn-danger p_del intro_ui_del\" href=\"" . $this->base . '/Del?id=' . $id . '" OnClick="return false;" title="') . $intro->lang['del'] . "\"><i class=\"icon-cancel-circled2\"></i></a>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        echo '</tbody>';
        $qry_order = str_replace(' ', ':', $qry_order);
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411('<div class=\'text-center\'>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?order=' . $qry_order . $params, $totalrows, $rows_per_page, $page) . '</div>');
        echo "<script>\r\n\t\t\$(function(){\r\n\t\t\t\r\n\t\t\t\$(\"#encode,#delete\").on( \"click\", function( event ) {\r\n\t\t\t\tif(!confirm('Are You sure?'))\r\n\t\t\t\treturn false;\r\n\t\t\t});\r\n\t\t\t\$(\".triggerEncode\").on( \"click\", function( event ) {\r\n\t\t\t\t\r\n\t\t\t\tvar a_obj = \$(this);\r\n\t\t\t\tvar vodID = \$(this).data('id');\r\n\t\t\t\tvar url_start = \$(this).attr('href');\r\n\t\t\t\tvar vodTdObj = \$('#'+vodID);\r\n\t\t\t\tvar vodStatusObj = \$('#load'+vodID);\r\n\t\t\t\tvodStatusObj.addClass('loading_style').addClass('loading');\r\n\t\t\t\t\r\n\t\t\t\t\$.ajax({\r\n\t\t\t\t\turl: url_start,\r\n\t\t\t\t\tcache: false,\r\n\t\t\t\t\ttimeout: 3000\r\n\t\t\t\t})\r\n\t\t\t\t.done(function( data ,status ) {\r\n\t\t\t\t\t\t\r\n\t\t\t\t\tif(data == 'success'){\r\n\t\t\t\t\t\ta_obj.html('Started').addClass('btn btn-success');\r\n\t\t\t\t\t}else{\r\n\t\t\t\t\t\ta_obj.html(data);\r\n\t\t\t\t\t}\r\n\t\t\t\t\t\r\n\t\t\t\t}).fail(function(xhr, textStatus, errorThrown) {\r\n\t\t\t\t\talert( \"error: \" + xhr.statusText );\r\n\t\t\t\t\t\r\n\t\t\t\t}).always(function() {\r\n\t\t\t\t\tvodStatusObj.removeClass('loading').removeClass('loading_style');\r\n\t\t\t\t});\r\n\t\t\t\t\r\n\t\t\t\treturn false;\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\tvar checkboxes = \$('.checkAllIds');\r\n\t\t\t\t\r\n\t\t\t\$(\".checkAll\").change(function () {\r\n\t\t\t\t\$(\".checkAllIds\").prop('checked', \$(this).prop(\"checked\"));\r\n\t\t\t\tvar c = checkboxes.filter(':checked').length;\r\n\t\t\t\t\$('#checked_count').html(c);\r\n\t\t\t\t\r\n\t\t\t\tif(c > 0)\r\n\t\t\t\t\t\$('#VodsFormButtons').show();\r\n\t\t\t\telse\r\n\t\t\t\t\t\$('#VodsFormButtons').hide();\r\n\t\t\t});\r\n\r\n\t\t\tcheckboxes.change(function()\r\n\t\t\t{\r\n\t\t\t\tvar c = checkboxes.filter(':checked').length;\r\n\t\t\t\t\$('#checked_count').html(c);\r\n\t\t\t\t\r\n\t\t\t\tif(c > 0)\r\n\t\t\t\t\t\$('#VodsFormButtons').show();\r\n\t\t\t\telse\r\n\t\t\t\t\t\$('#VodsFormButtons').hide();\r\n\t\t\t\t\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$(\"#VodsForm\").submit( function () {   \r\n\t\t\t\t\$('#resultCMD').html('loading...');\r\n\t\t\t\t\$.post('" . $this->base . "/doCMD?NH=1',\$(this).serialize(),function(data){\r\n\t\t\t\t\t\r\n\t\t\t\t\t\$(\"#resultCMD\").html(data)\r\n\t\t\t\t}\r\n\t\t\t  );\r\n\t\t\t  return false;   \r\n\t\t\t});\r\n\t\t\t\r\n\t\t });\r\n\t\t</script>";
    }
    public function doCMD()
    {
        global $intro;
        $mode = trim($intro->input->post('mode'));
        $ids = $intro->input->post('ids');
        $x = new XtreamApi('EmptyFunc');
        if( $mode == 'encode' ) 
        {
            echo $x->VodMulti('start', $ids);
        }
        if( $mode == 'delete' ) 
        {
            $Success = 0;
            foreach( $ids as $id ) 
            {
                $rep = $x->DelVod($id);
                $intro->db->query_fast('DELETE FROM `series_episodes` WHERE stream_id=' . $id . '; ');
                $intro->db->query_fast('DELETE FROM `streams_sys` WHERE stream_id=' . $id . '; ');
                $intro->db->query_fast('DELETE FROM `streams` WHERE id=' . $id . '; ');
                $Success++;
            }
            echo 'Total Deleted VOD = ' . $Success;
        }
    }
    public function youtube($movie = '', $year = '', $return = 'echo')
    {
        global $intro;
        if( $movie == '' ) 
        {
            $movie = trim(urldecode($intro->input->get_post('movie')));
        }
        if( $year == '' ) 
        {
            $year = trim($intro->input->get_post('year'));
        }
        $movieName = str_replace(' ', '+', $movie);
        $movieName = str_replace('.', '+', $movieName);
        $movieYear = $year;
        $page = file_get_contents('http://www.youtube.com/results?search_query=' . $movieName . '+' . $movieYear . '+trailer&aq=1&hl=en');
        if( $page != '' && preg_match('~<a .*?href="/watch\?v=(.*?)".*?</div>~s', $page, $matches) ) 
        {
            if( $return == 'echo' ) 
            {
                echo $matches[1];
            }
            else
            {
                return $matches[1];
            }
        }
    }
    public function start()
    {
        global $intro;
        $stream = intval($intro->input->get_post('id'));
        $server = intval($intro->input->get_post('server'));
        $act = trim($intro->input->get_post('act'));
        $x = new XtreamApi('EmptyFunc');
        echo $x->StartVod($act, $stream, $server);
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $stream_source;
        global $stream_720p;
        global $stream_480p;
        global $stream_360p;
        global $stream_1080p;
        global $stream_4k;
        global $category_id;
        global $youtube_trailer;
        global $stream_display_name;
        global $movie_subtitles;
        global $youtube_trailer;
        global $genre;
        global $plot;
        global $cast;
        global $rating;
        global $director;
        global $releasedate;
        global $duration_secs;
        global $duration;
        global $bitrate;
        global $movie_image;
        global $backdrop_path;
        global $tmdb_id;
        global $order;
        global $stream_icon;
        global $year;
        global $mpaa;
        global $target_container;
        global $direct_source;
        global $redirect_stream;
        global $movie_location;
        global $movie_symlink;
        global $remove_subtitles;
        global $load_balancer_servers;
        global $read_native;
        global $transcode_profile_id;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $id = intval($intro->input->get_post('id'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        $this->nav();
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * FROM `streams` WHERE id=' . $id . ';');
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $btn['legend_name'] = $intro->lang['movies_edit'] . (' <b>' . $id . '</b>');
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
            $movie_propeties = json_decode($row['movie_propeties'], true);
            @extract($movie_propeties);
            $sys = _obf_0D1E2701171B3D1C36152B2D2512305C1003175B1E3E11($stream_source, $id);
            $movie_location = $sys['movie_location'];
            $stream_source = $sys['stream_source'];
            $load_balancer_servers = $sys['load_balancer_servers'];
            if( is_array($movie_propeties['backdrop_path']) && count($movie_propeties['backdrop_path']) > 0 ) 
            {
                $backdrop_path = implode("\n", $movie_propeties['backdrop_path']);
            }
            else
            {
                $backdrop_path = '';
            }
            $target_container = json_decode($target_container);
            if( $stream_icon == '' ) 
            {
                $stream_icon = $movie_image;
            }
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = $intro->lang['movies_add'];
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = $intro->lang['save'];
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            if( !is_array($target_container) ) 
            {
                $target_container = [];
            }
            if( isset($_POST['target_container']) ) 
            {
            }
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ', 'info');
        echo _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911();
        if( intval($intro->input->get('success')) == 1 ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Movie File Added Success!.', 'success');
        }
        $star = '<span style="color:red">*</span>';
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\r\n\t\t\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t<tr>\r\n\t\t\t<td>" . $intro->lang['movies_catid'] . " :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td colspan=2>" . $this->form_select_category('category_id', $category_id) . (' ' . $this->error('category_id') . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>TMDB ID or Title: </td>\r\n\t\t\t<td colspan=2>\r\n\t\t\t") . _obf_0D303E153F1434130E373D01173C280D3E14021B012832('tmdb_lang', _obf_0D303E153F1434130E373D01173C280D3E14021B012832('tmdb_default')) . (" \r\n\t\t\t\t<input  type=\"text\" placeholder=\"Movie ID like: 19995\" name=\"tmdb_id\" value=\"" . $tmdb_id . "\" size=\"50\"> \r\n\t\t\t\t<button type='button' id='re_fetch_btn'>Fech from TMDB</button> \r\n\t\t\t\t<div id=\"fetchStatus\" class=\"loading_style\" /></div>\r\n\t\t\t\t" . $this->error('icon') . "\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Title : " . $star . "</td>\r\n\t\t\t<td colspan=2><input type=\"text\" name=\"stream_display_name\" id=\"stream_display_name\" value=\"" . $stream_display_name . '" size="70"> ' . $this->error('stream_display_name') . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Movie Location:</td>\r\n\t\t\t<td colspan=2>\r\n\t\t\t\t") . _obf_0D12262623113F1D022A011A3E1D1B253D294027090E01('movie_location', $movie_location) . (' ' . $this->error('movie_location') . " \r\n\t\t\t\t<span id=\"local\" style=\"display: none;\">\r\n\t\t\t\t\t<button type=\"button\" class=\"btn btn-danger\" id=\"PickFile\">Pick</button>\r\n\t\t\t\t</span>\r\n\t\t\t</td>\r\n\t\t</tr>");
        echo "\r\n\t\t<tr id=\"movie_source_form\" " . (($t == 'addX' ? 'style=\'display:none\'' : '')) . (">\r\n\t\t\t<td>Movie Source : " . $star . "</td>\r\n\t\t\t<td colspan=2><input  type=\"text\" name=\"stream_source\" id=\"stream_source\" value=\"" . $stream_source . '" class=\'form-control\'>' . $this->error('stream_source') . "</td>\r\n\t\t</tr>\r\n\t\t<tr class=\"movie_symlink\" style=\"display: none;\">\r\n\t\t\t<td>") . tooltip('tooltip_streams', 'movie_symlink') . " Do not encode the VOD, use the source: </td>\r\n\t\t\t<td colspan=2>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('movie_symlink', $movie_symlink, 'yes') . "\r\n\t\t\t<div style='color:#888'>  If you choose No - Remote VOD will be downloaded to Server Or Local VOD will be copied to /movies/ folder.\r\n\t\t\t\t<br/>If you choose Yes for Remote VOD it will use Direct Source.</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr class=\"direct_source\" style=\"display: none;\">\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'direct_source') . " Use Direct Source & don't restream it: </td>\r\n\t\t\t<td colspan=2>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('direct_source', $direct_source, 'yes') . "</td>\r\n\t\t</tr>\r\n\t\t<tr class=\"redirect_stream\" style=\"display: none;\">\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'redirect_stream') . " Redirect Stream to the Original Source:  </td>\r\n\t\t\t<td colspan=2>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('redirect_stream', $redirect_stream, 'yes') . "</td>\r\n\t\t</tr>\r\n\t\t\r\n\t\t<tr id=\"load_balancer\">\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'load_balancer_servers') . ('Select Load Balancer Servers : ' . $star . "</td>\r\n\t\t\t<td><div>") . _obf_0D31033702041D1F0B1015180339183714070C36032811('load_balancer_servers[]', $load_balancer_servers) . ($this->error('load_balancer_servers') . "</div></td>\r\n\t\t\t<td rowspan=2><a id='image1href' class=\"AjaxModal\" data-img=\"true\" href=\"" . $stream_icon . '"><img id=\'image1\' src=\'' . $stream_icon . "' style=\"max-height:200px;\"></a></td>\r\n\t\t</tr>\r\n\t\t<tr class=\"read_native\" style=\"display: none;\">\r\n\t\t\t<td>") . tooltip('tooltip_streams', 'read_native') . " Read Input Source in Native Frames:  </td>\r\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('read_native', $read_native, 'yes') . ("</td>\t\t\t\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Movie Poster : " . $star . "</td>\r\n\t\t\t<td><input  type=\"text\" name=\"stream_icon\" id=\"stream_icon\" value=\"" . $stream_icon . '" class=\'form-control\'>' . $this->error('stream_icon') . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Backdrop Images :</td>\r\n\t\t\t<td><textarea  class=\"form-control\" style=\"height:90px;\" name=\"backdrop_path\" id=\"backdrop_path\">" . $backdrop_path . '</textarea>' . $this->error('backdrop_path') . "</td>\r\n\t\t\t<td rowspan=3 width=300><a id='image2href' class=\"AjaxModal\" data-img=\"true\" href=\"" . $backdrop_path . '"><img id=\'image2\' src=\'' . $backdrop_path . "' style=\"max-height:200px;max-width:300px;\"></a></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Target containers:  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td>") . _obf_0D042827394002382E07271E152934171C2F1B331B0C11('target_container[]', $array['target_container'], $target_container, $txt = '') . ($this->error('target_container') . "</td>\r\n\t\t</tr>\t\r\n\t\t<tr>\r\n\t\t\t<td>Youtube trailer: <span class='icon-youtube'></span></td>\r\n\t\t\t<td><input  name=\"youtube_trailer\" id=\"youtube_trailer\" class='form-control' value=\"" . $youtube_trailer . "\" placeholder='Examplde: lD41XdWcmbY' ></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Movie Genres : </td>\r\n\t\t\t<td colspan=2><input name=\"genre\" id=\"genre\" class='form-control' value=\"" . $genre . "\" ></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Movie Plot : </td>\r\n\t\t\t<td colspan=2><textarea name=\"plot\" id=\"plot\" class='form-control'>" . $plot . "</textarea></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Movie Cast : </td>\r\n\t\t\t<td colspan=2><input class='form-control' type=\"text\" id=\"cast\" name=\"cast\" value=\"" . $cast . "\"></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Movie Rating : </td>\r\n\t\t\t<td colspan=2><input class='form-control' type=\"text\" id=\"rating\" name=\"rating\" value=\"" . $rating . "\"></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>MPAA Rate : </td>\r\n\t\t\t<td colspan=2><input class='form-control' type=\"text\" id=\"mpaa\" name=\"mpaa\" value=\"" . $mpaa . "\"></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Director : </td>\r\n\t\t\t<td colspan=2><input class='form-control' type=\"text\" id=\"director\" name=\"director\" value=\"" . $director . "\"></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Movie Year: </td>\r\n\t\t\t<td colspan=2><input class='form-control' type=\"text\" id=\"year\" name=\"year\" value=\"" . $year . "\"></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Release Date: </td>\r\n\t\t\t<td colspan=2><input class='form-control' type=\"text\" id=\"releasedate\" name=\"releasedate\" value=\"" . $releasedate . "\"></td>\r\n\t\t</tr>\r\n\t\t\r\n\t\t<tr>\r\n\t\t\t<td>Movie Runtime (duration): </td>\r\n\t\t\t<td colspan=2><input class='form-control' type=\"text\" id=\"duration\" name=\"duration\" value=\"" . $duration . "\"></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Movie Runtime (duration): Seconds </td>\r\n\t\t\t<td colspan=2><input class='form-control' type=\"text\" id=\"duration_secs\" name=\"duration_secs\" value=\"" . $duration_secs . "\"></td>\r\n\t\t</tr>");
        echo "\r\n\t\t<tr class='subtitles'>\r\n\t\t\t<th colspan=\"3\">Subtitles</th>\r\n\t\t</tr>\r\n\t\t<tr class='subtitles'>\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'remove_subtitles') . " Delete Existing Subtitles: </td>\r\n\t\t\t<td colspan=2>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('remove_subtitles', $remove_subtitles, 'yes') . "</td>\r\n\t\t</tr>\r\n\t\t<tr class='subtitles'>\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'subtitles_location') . " </td>\r\n\t\t\t<td colspan=2> Soon ... </td>\r\n\t\t</tr>";
        echo "\r\n\t\t<tr class='transcode'>\r\n\t\t\t<th colspan=\"2\">Transcode Movie</th>\r\n\t\t</tr>\r\n\t\t<tr class='transcode'>\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'transcode_profile_id') . " Select Transcode Profile: </td>\r\n\t\t\t<td colspan=2>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('transcode_profile_id', 'No Transcode', 'transcoding_profiles', $transcode_profile_id, 'profile_id', 'profile_name', '', ' order by profile_name ASC') . "\r\n\t\t\t\t<a href=\"" . $intro->app_url('transcode_profiles', 'index') . "\" target=\"_blank\" class=\"btn btn-default\">Manage</a>\r\n\t\t\t</td>\r\n\t\t</tr>";
        if( $t == 'add' ) 
        {
            echo "\r\n\t\t<tr>\r\n\t\t\t\t<td>Optional: Add  to Bouquet: </td>\r\n\t\t\t\t<td colspan=2>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('bouqet_id', 'Choose bouquet', 'bouquets', 0, 'id', 'bouquet_name', ' where bouquet_status=1', ' order by bouquet_name asc') . "</td>\r\n\t\t</tr>";
        }
        if( $t == 'edit' ) 
        {
            echo "\r\n\t\t<tr>\r\n\t\t\t<td> </td>\r\n\t\t\t<td colspan=2><input  type=\"checkbox\" name=\"reEncode\" value=\"1\"> Re-Encode after edit? </td>\r\n\t\t</tr>";
        }
        echo "\t\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td colspan=2>\r\n\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\r\n\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\r\n\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $id . "\">\r\n\t\t\t\t<button class=\"btn btn-success\" type=\"submit\" name=\"app_action\" value=\"" . $btn['action'] . "\">\r\n\t\t\t\t\t<i class=\"" . $btn['img_icon'] . '"></i> ' . $btn['name'] . " \r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        if( $movie_location == 'remote' ) 
        {
            $js = "\$('#local').hide();\r\n            \$('#fetch_options').hide();\r\n            \$('.direct_source').show();\r\n            \$('.movie_symlink').show();\r\n\t\t\t\$('#load_balancer_servers').prop('required', false);";
        }
        else if( is_numeric($movie_location) ) 
        {
            $js = "\$('#local').show();\r\n            \$('#fetch_options').hide();\r\n            \$('.direct_source').hide();\r\n\r\n            \$('#read_native').show();\r\n            \$('#load_balancer').show();\r\n            \$('.movie_symlink').show();\r\n            \$('#movie_container').show();\r\n            \$('#subtitles').show();\r\n  \r\n            \$('input:radio[name=direct_source][value=0]').click();\r\n            \$('#load_balancer_servers').prop('required', true);\r\n\r\n\t\t\t\$('#firstChosenSelect').chosen();\r\n\t\t\t\$('#load_balancer_servers').addClass('chosen').chosen({search_contains: true});";
        }
        else
        {
            $js = '';
        }
        echo "<script>\r\n\t\tfunction cleanString(input) {\r\n\t\t\tvar output = '';\r\n\t\t\tfor (var i=0; i<input.length; i++) {\r\n\t\t\t\tif (input.charCodeAt(i) <= 127) {\r\n\t\t\t\t\toutput += input.charAt(i);\r\n\t\t\t\t}\r\n\t\t\t}\r\n\t\t\treturn output;\r\n\t\t}\r\n\t\t\$(function(){\r\n\t\t\t\r\n\t\t\t\$('select[name=category_id]').addClass('chosen').chosen({search_contains: true,width:335});\r\n\t\t\t\r\n\t\t\t" . $js . "\r\n\t\t\t\r\n\t\t\t\$(\"#re_fetch_btn\").on( \"click\", function( event ) {\r\n\t\t\t\t\r\n\t\t\t\tvar MovieID = \$(\"input[name='tmdb_id']\").val();\r\n\t\t\t\tvar tmdb_lang = \$(\"select[name='tmdb_lang']\").val();\r\n\t\t\t\t\r\n\t\t\t\t\$('#fetchStatus').addClass('loading');\r\n\t\t\t\t\r\n\t\t\t\t  \r\n\t\t\t\t\$.ajax({\r\n\t\t\t\t\turl: '" . $this->base . "/tmdb/?tmdb_id='+encodeURIComponent(MovieID)+'&NH=1&tmdb_lang='+tmdb_lang,\r\n\t\t\t\t\tcache: false,\r\n\t\t\t\t\ttimeout: 5000\r\n\t\t\t\t})\r\n\t\t\t\t.done(function( data ,status ) {\r\n\t\t\t\t\t\t\r\n\t\t\t\t\tvar json = jQuery.parseJSON(cleanString(data));\r\n\t\t\t\t\t/*var json = JSON.parse(data);*/\r\n\t\t\t\t\t\$.each(json, function(key, value) {\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\tif(key == 'error'){\r\n\t\t\t\t\t\t\talert(value);\r\n\r\n\t\t\t\t\t\t\treturn false;\r\n\t\t\t\t\t\t}\r\n\t\t\t\t\t\tif(key == 'movie_image' && value != ''){\r\n\t\t\t\t\t\t\t\$(\"input[name='stream_icon']\").val(value);\r\n\t\t\t\t\t\t\t\$('#image1').attr('src', value);\r\n\t\t\t\t\t\t\t\$('#image1href').attr('href', value);\r\n\t\t\t\t\t\t}\r\n\t\t\t\t\t\telse if(key == 'backdrop_path' && value != ''){\r\n\t\t\t\t\t\t\t/*\r\n\t\t\t\t\t\t\tif(\$('#backdrop_path').val().indexOf(value) == -1)\r\n\t\t\t\t\t\t\t\t\$('#backdrop_path').val(\$('#backdrop_path').val() + '" . '\n' . "' + value);\r\n\t\t\t\t\t\t\t*/\r\n\t\t\t\t\t\t\t\$('#backdrop_path').val(value);\r\n\t\t\t\t\t\t\t\$('#image2').attr('src', value);\r\n\t\t\t\t\t\t\t\t\$('#image2href').attr('href', value);\r\n\t\t\t\t\t\t}else{\r\n\t\t\t\t\t\t\t\$(\"#\"+key).val(value);\r\n\t\t\t\t\t\t}\r\n\r\n\t\t\t\t\t});\r\n\t\t\t\t\t\r\n\t\t\t\t}).fail(function(xhr, textStatus, errorThrown) {\r\n\t\t\t\t\talert( \"error: \" + xhr.statusText );\r\n\t\t\t\t\t\r\n\t\t\t\t}).always(function() {\r\n\t\t\t\t\t\$('#fetchStatus').removeClass('loading');\r\n\t\t\t\t});\r\n\r\n\t\t\t});\r\n\t\t\t\r\n\t\t });\r\n\t\t</script>";
        echo "\r\n\t\t<script>var base = '" . $this->base . "/brws/'; var type='single';</script>\r\n\t\t<link rel=\"stylesheet\" href=\"" . admin_path . "style/tree/proton/proton.min.css\">\r\n\t\t<script src=\"" . admin_path . "style/tree/jstree.min.js\"></script>\r\n\t\t<script src=\"" . admin_path . 'style/js/vod.js?v=1"></script>';
    }
    public function tmdb()
    {
        global $intro;
        global $error;
        $json = [];
        $tmdb_id = trim($intro->input->get_post('tmdb_id'));
        $tmdb_lang = trim($intro->input->get_post('tmdb_lang'));
        $_SER = intval($intro->input->get_post('ser'));
        if( $tmdb_id == '' ) 
        {
            $json['error'] = 'Please input Title or TMDB ID.';
            exit( json_encode($json) );
        }
        $tmdb = new IntroTmdb($tmdb_id, $tmdb_lang, $_SER);
        echo json_encode($tmdb->json, JSON_UNESCAPED_SLASHES);
    }
    public function removeLines($str)
    {
        return str_replace([
            "\n", 
            "\t", 
            "\r"
        ], '', $str);
    }
    public function backdrop_path($backdrop_path)
    {
        if( $backdrop_path == '' ) 
        {
            return [];
        }
        $x = explode("\n", $backdrop_path);
        if( count($x) > 0 ) 
        {
            return $x;
        }
        return [];
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        $movie_location = trim($intro->input->post('movie_location'));
        $movie_symlink = intval($intro->input->post('movie_symlink'));
        $redirect_stream = intval($intro->input->post('redirect_stream'));
        $direct_source = intval($intro->input->post('direct_source'));
        $bouqet_id = intval($intro->input->post('bouqet_id'));
        $category_id = intval($intro->input->post('category_id'));
        $order = intval($intro->input->post('order'));
        $stream_icon = trim($intro->input->post('stream_icon'));
        $stream_source = trim($intro->input->post('stream_source'));
        $movie_subtitles = trim($intro->input->post('movie_subtitles'));
        $stream_display_name = trim($intro->input->post('stream_display_name'));
        $t = trim($intro->input->post('t'));
        $target_container = $intro->input->post('target_container');
        $backdrop_path = $intro->input->post('backdrop_path');
        $load_balancer_servers = $intro->input->post('load_balancer_servers');
        $tmdb_id = trim($intro->input->post('tmdb_id'));
        if( $category_id == 0 || $stream_display_name == '' || $stream_source == '' || $stream_icon == '' || $movie_location != 'remote' && $direct_source == 0 && !isset($load_balancer_servers[0]) || $movie_location == 'remote' && $movie_symlink == 0 && !isset($load_balancer_servers[0]) || !isset($target_container[0]) ) 
        {
            if( $category_id == 0 ) 
            {
                $error['category_id'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $stream_source == '' ) 
            {
                $error['stream_source'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $stream_icon == '' ) 
            {
                $error['stream_icon'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $stream_display_name == '' ) 
            {
                $error['stream_display_name'] = '<span class=error>Please input title</span>';
            }
            if( $movie_location != 'remote' && $direct_source == 0 && !isset($load_balancer_servers[0]) ) 
            {
                $error['load_balancer_servers'] = '<span class=error>Please choose LB server</span>';
            }
            if( $movie_location == 'remote' && $movie_symlink == 0 && !isset($load_balancer_servers[0]) ) 
            {
                $error['load_balancer_servers'] = '<span class=error>Please choose LB server</span>';
            }
            if( !isset($target_container[0]) ) 
            {
                $error['target_container'] = '<span class=error>Please choose Traget Container</span>';
            }
            $this->Form($t);
            exit();
        }
        $data = [];
        $data['type'] = 2;
        $data['category_id'] = $category_id;
        if( $t == 'add' ) 
        {
            $data['added'] = time();
        }
        $data['stream_display_name'] = $stream_display_name;
        $data['stream_icon'] = $stream_icon;
        $data['movie_subtitles'] = $movie_subtitles;
        if( $movie_location == 'remote' ) 
        {
            if( $movie_symlink == 1 ) 
            {
                $direct_source = 1;
            }
            $data['direct_source'] = $direct_source;
            $data['redirect_stream'] = $redirect_stream;
        }
        else if( intval($movie_location) > 0 ) 
        {
            $stream_source = 's:' . $movie_location . ':' . $stream_source;
            $data['movie_symlink'] = intval($intro->input->post('movie_symlink'));
            $data['read_native'] = intval($intro->input->post('read_native'));
        }
        $data['transcode_profile_id'] = intval($intro->input->post('transcode_profile_id'));
        $data['stream_source'] = json_encode([$stream_source], JSON_UNESCAPED_SLASHES);
        $json = [];
        $json['movie_image'] = $stream_icon;
        $json['backdrop_path'] = $this->backdrop_path($backdrop_path);
        $json['tmdb_id'] = $tmdb_id;
        $json['youtube_trailer'] = trim($intro->input->post('youtube_trailer'));
        $json['genre'] = trim($intro->input->post('genre'));
        $json['plot'] = trim($intro->input->post('plot'));
        $json['cast'] = trim($intro->input->post('cast'));
        $json['rating'] = trim($intro->input->post('rating'));
        $json['director'] = trim($intro->input->post('director'));
        $json['releasedate'] = trim($intro->input->post('releasedate'));
        $json['duration_secs'] = trim($intro->input->post('duration_secs'));
        $json['duration'] = trim($intro->input->post('duration'));
        $json['video'] = [];
        $json['audio'] = [];
        $json['bitrate'] = trim($intro->input->post('bitrate'));
        $json['year'] = trim($intro->input->post('year'));
        $json['mpaa'] = trim($intro->input->post('mpaa'));
        $data['target_container'] = json_encode($target_container);
        $data['movie_propeties'] = json_encode($json);
        if( $direct_source == 1 ) 
        {
            $load_balancer_servers[0] = 0;
        }
        if( $t == 'add' )
        {
            $intro->db->insert('streams', $data);
            $id = $stream_id = $intro->db->insert_id();

            // Sync to remote panel
            $this->addMovieToRemote($stream_display_name, [$stream_source]);

            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Movie added successfully  : ' . $stream_display_name, 'success');
            _obf_0D152E0528111E401A021F33243837101D0A2D23141711($t, $stream_id, $load_balancer_servers[0], $direct_source);
            if( $bouqet_id != 0 )
            {
                $sql = $intro->db->query('SELECT * FROM bouquets WHERE id=' . $bouqet_id . ';');
                $row = $intro->db->fetch_assoc($sql);
                $bouquet_channels = json_decode($row['bouquet_channels'], true);
                array_unshift($bouquet_channels, $id);
                $data2 = [];
                $data2['bouquet_channels'] = json_encode($bouquet_channels);
                $intro->db->update('bouquets', $data2, 'id=' . $bouqet_id);
            }
        }
        else if( $t == 'edit' )
        {
            $stream_id = intval($intro->input->post('id'));

            // Get old movie name for remote sync
            $old_movie_sql = $intro->db->query('SELECT stream_display_name FROM streams WHERE id=' . $stream_id);
            $old_movie_row = $intro->db->fetch_assoc($old_movie_sql);
            $old_movie_name = $old_movie_row['stream_display_name'];

            _obf_0D152E0528111E401A021F33243837101D0A2D23141711($t, $stream_id, $load_balancer_servers[0], $direct_source);
            $intro->db->update('streams', $data, 'id=' . $stream_id);

            // Sync to remote panel
            $this->updateMovieInRemote($old_movie_name, $stream_display_name, [$stream_source]);

            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Movie changes saved! : ' . $stream_display_name, 'success');
        }
        $intro->redirect($this->appname, 'index/?success=1');
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        $_POST['t'] = 'edit';
        $this->doAdd();
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');
        $sql = $intro->db->query('SELECT * FROM `streams` WHERE id=' . $id . ';');
        $row = $intro->db->fetch_assoc($sql);

        // Get movie name for remote sync
        $movie_name = $row['stream_display_name'];

        $x = new XtreamApi('EmptyFunc');
        $x->DelVod($id);
        $intro->db->query('DELETE FROM `streams` WHERE id=' . $id . '; ');
        $intro->db->query('DELETE FROM `streams_sys` WHERE stream_id=' . $id . '; ');
        $intro->db->query('DELETE FROM `streams_sys` WHERE stream_id NOT IN (select `id` from `streams`); ');

        // Sync delete to remote panel
        $this->deleteMovieFromRemote($movie_name);

        $intro->redirect($this->appname);
    }
    public function viewsubtitle()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $result = $intro->db->query('SELECT * from `streams` where id=' . $id . ' ');
        $myrow = $intro->db->fetch_assoc($result);
        @extract($myrow);
        echo "\r\n\t\t<h2>Subtitle For : " . $stream_display_name . "</h2>\r\n\t\t<textarea style='width:100%;height:250px'>" . $movie_subtitles . '</textarea>';
    }
    public function form_select_category($html_name, $cat_value)
    {
        global $intro;
        $dyn_menu = "\r\n\t\t<select name=\"" . $html_name . "\" class=\"chosen searchable\">\n";
        $dyn_menu .= "\r\n\t\t\t<option value=\"0\" selected> Choose Category </option>\n";
        $result = $intro->db->query('SELECT * from `stream_categories` where category_type=\'movie\' AND parent_id=0  order by category_name ASC');
        while( $row = $intro->db->fetch_assoc($result) ) 
        {
            $cat_name = $row['category_name'];
            $dyn_menu .= ("\r\n\t\t\t<option " . (($cat_value == $row['id'] ? 'selected ' : '')) . (' value="' . $row['id'] . '" style=\'background-color: #CEDEFB\'>') . $cat_name . '</option>');
            $dyn_menu .= $this->form_select_sub($row['id'], $cat_value);
        }
        $dyn_menu .= "\r\n\t\t</select>\n\n ";
        return (string)$dyn_menu;
    }
    public function form_select_sub($father, $cat_value, $bar = '')
    {
        global $intro;
        $father = intval($father);
        $dyn_menu = '';
        $result = $intro->db->query('SELECT * from `stream_categories` where parent_id=' . $father . ' order by category_name ASC');
        while( $row = $intro->db->fetch_assoc($result) ) 
        {
            $dyn_menu .= ("\r\n\t\t\t<option " . (($cat_value == $row['id'] ? 'selected ' : '')) . (' value="' . $row['id'] . '" style=\'background-color: #CEDEFB\'>' . $bar . '--------|' . $row['category_name'] . '</option>'));
            $dyn_menu .= $this->form_select_sub($row['id'], $cat_value, '--------');
        }
        return ' ' . $dyn_menu;
    }
    public function txt_substr($text, $num_chars)
    {
        $text = strip_tags($text);
        $total_chars = strlen($text);
        $after_substr = substr($text, 0, $num_chars);
        $last_pos_after_substr = strrpos($after_substr, ' ');
        if( $total_chars < $num_chars ) 
        {
            return $text;
        }
        else if( $num_chars == $total_chars ) 
        {
            return $text;
        }
        else if( $num_chars < $total_chars ) 
        {
            return substr($text, 0, $last_pos_after_substr);
        }
    }
    public function getEpisodes($sid)
    {
        global $intro;
        $sid = intval($sid);
        $ar = [];
        $qry = ' SELECT * ,TRIM(TRAILING CONCAT(\'/\', SUBSTRING_INDEX(stream_480p, \'/\', -1)) FROM stream_480p) as S480 ,TRIM(TRAILING CONCAT(\'/\', SUBSTRING_INDEX(stream_720p, \'/\', -1)) FROM stream_720p) as S720 ,TRIM(TRAILING CONCAT(\'/\', SUBSTRING_INDEX(stream_1080p, \'/\', -1)) FROM stream_1080p) as S1080 ,TRIM(TRAILING CONCAT(\'/\', SUBSTRING_INDEX(stream_4k, \'/\', -1)) FROM stream_4k) as S4k  from ' . PREFIX . "_seriesepisodes where seasonid \r\n\t\tIN (SELECT seasonid from " . PREFIX . ('_series_seasons where seriesid=' . $sid . ") \r\n\t\t group by S480,S720,S1080,S4k /*order by epnum ASC LIMIT 0,2*/;");
        $sql = $intro->db->query($qry);
        $data = '';
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            if( $S480 != '' ) 
            {
                $data .= ('<li>' . $S480 . '</li>');
            }
            if( $S720 != '' ) 
            {
                $data .= ('<li>' . $S720 . '</li>');
            }
            if( $S1080 != '' ) 
            {
                $data .= ('<li>' . $S1080 . '</li>');
            }
            if( $S4k != '' ) 
            {
                $data .= ('<li>' . $S4k . '</li>');
            }
        }
        return $data;
    }
    public function ChangeMoviesURL()
    {
        global $intro;
        $mov = $se = '';
        $result = $intro->db->query('SELECT   TRIM(TRAILING CONCAT(\'/\', SUBSTRING_INDEX(stream_source, \'/\', -1)) FROM stream_source) as stream_url  from streams where type in (2,5) group by stream_url   /*order by id desc LIMIT 0,5*/');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            if( $stream_url != '' ) 
            {
                $mov .= ('<li>' . $stream_url . '</li>');
            }
        }
        $result = $intro->db->query('SELECT * from ' . PREFIX . '_series order by sid DESC LIMIT 0,5');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $se .= $this->getEpisodes($sid);
        }
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Change Movies & Series URL ', 'primary');
        if( $this->msg != '' ) 
        {
            echo $this->msg;
        }
        echo "\r\n\t\t\t<h2>Warning: this could damage your links!!!  </h2>\r\n\t\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doChangeMoviesURL\">\r\n\t\t\t<table class=\"table table-bordered table-hover\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Movies URLs:</td>\r\n\t\t\t\t<td><div class=\"json\" style=\"height:100px;overflow: scroll;\">" . $mov . "</div></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Series URLs:</td>\r\n\t\t\t\t<td><div class=\"json\" style=\"height:100px;overflow: scroll;\">" . $se . "</div></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>OLD Host:</td>\r\n\t\t\t\t<td><input dir=ltr type=\"text\" name=\"old_host\" value=\"\" class=\"form-control\" \r\n\t\t\t\t\tplaceholder=\"like: http://www.example-host.net or http://www.example-host.net/folder1\" /></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>NEW Host:</td>\r\n\t\t\t\t<td><input dir=ltr type=\"text\" name=\"new_host\" value=\"\" class=\"form-control\" \r\n\t\t\t\t\tplaceholder=\"Like: http://www.host.com or http://www.example-host.net/folder2\" /></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t\t<button class=\"btn btn-success\" type=\"submit\" name=\"app_action\" value=\"doEdit\"><i class=\"icon-floppy\"> </i> Go </button>\t\t\t\t\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        $mov = $se = '';
        $result = $intro->db->query('SELECT   TRIM(TRAILING CONCAT(\'/\', SUBSTRING_INDEX(stream_icon, \'/\', -1)) FROM stream_icon) as icon_url  FROM `streams` group by icon_url ');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            if( $icon_url != '' ) 
            {
                $mov .= ('<li>' . $icon_url . '</li>');
            }
        }
        $result = $intro->db->query('SELECT  TRIM(TRAILING CONCAT(\'/\', SUBSTRING_INDEX(s_photo, \'/\', -1)) FROM s_photo) as icon_url  FROM ' . PREFIX . '_series group by icon_url');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            if( $icon_url != '' ) 
            {
                $se .= ('<li>' . $icon_url . '</li>');
            }
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Change Icons for Movies & Series ', 'primary');
        if( $this->msg != '' ) 
        {
            echo $this->msg;
        }
        echo "\r\n\t\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doChangeIconsURL\">\r\n\t\t\t<table class=\"table table-bordered table-hover\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Movies Icons:</td>\r\n\t\t\t\t<td><div class=\"json\" style=\"height:100px;overflow: scroll;\">" . $mov . "</div></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Series Icons:</td>\r\n\t\t\t\t<td><div class=\"json\" style=\"height:100px;overflow: scroll;\">" . $se . "</div></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Icon OLD Host:</td>\r\n\t\t\t\t<td><input dir=ltr type=\"text\" name=\"old_host\" value=\"\" class=\"form-control\" \r\n\t\t\t\t\tplaceholder=\"like: http://www.example-host.net or http://www.example-host.net/folder1\" /></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Icon NEW Host:</td>\r\n\t\t\t\t<td><input dir=ltr type=\"text\" name=\"new_host\" value=\"\" class=\"form-control\" \r\n\t\t\t\t\tplaceholder=\"Like: http://www.host.com or http://www.example-host.net/folder2\" /></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t\t<button class=\"btn btn-success\" type=\"submit\"><i class=\"icon-floppy\"> </i> Change Icons </button>\t\t\t\t\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function doChangeMoviesURL()
    {
        global $intro;
        $tot_se = $tot_mv = 0;
        $old_host = preg_replace("/\r\n|\r|\n/", '', trim($intro->input->post('old_host')));
        $new_host = preg_replace("/\r\n|\r|\n/", '', trim($intro->input->post('new_host')));
        if( strlen($old_host) < 10 || strlen($new_host) < 10 ) 
        {
            exit( '<h1 style=\'color:red\'>error: old host and new host must be more than 10 chars long.' );
        }
        $ar = [
            'stream_480p', 
            'stream_720p', 
            'stream_1080p', 
            'stream_4k'
        ];
        foreach( $ar as $stream ) 
        {
            $intro->db->query('UPDATE ' . PREFIX . '_seriesepisodes SET ' . (' ' . $stream . ' = REPLACE( ' . $stream . ', \'' . $old_host . '\', \'' . $new_host . '\' ) ') . (' WHERE `' . $stream . '` LIKE \'' . $old_host . '%\';'));
            $tot_se += $intro->db->affected_rows;
        }
        $intro->db->query('UPDATE `streams` SET ' . (' stream_source = REPLACE( stream_source, \'' . $old_host . '\', \'' . $new_host . '\' ) ') . (' WHERE `stream_source` LIKE \'%' . $old_host . '%\';'));
        $tot_mv += $intro->db->affected_rows;
        $this->msg = _obf_0D3D40321528110F062A0B0321102712170C15030F2232(" <h1>\r\n\t\tSuccess: <br/>\r\n\t\tTotcal Changed Movies = " . $tot_mv . " <br/>\r\n\t\tTotcal Changed Series = " . $tot_se . " <br/>\r\n\t\t</h1>", 'success');
        $this->ChangeMoviesURL();
    }
    public function doChangeIconsURL()
    {
        global $intro;
        $tot_se = $tot_mv = 0;
        $old_host = preg_replace("/\r\n|\r|\n/", '', trim($intro->input->post('old_host')));
        $new_host = preg_replace("/\r\n|\r|\n/", '', trim($intro->input->post('new_host')));
        if( strlen($old_host) < 10 || strlen($new_host) < 10 ) 
        {
            exit( '<h1 style=\'color:red\'>error: old host and new host must be more than 10 chars long.' );
        }
        $intro->db->query('UPDATE ' . PREFIX . '_series SET ' . (' `s_photo` = REPLACE( `s_photo`, \'' . $old_host . '\', \'' . $new_host . '\' ) ') . (' WHERE `s_photo` LIKE \'%' . $old_host . '%\';'));
        $tot_se += $intro->db->affected_rows;
        $intro->db->query('UPDATE `streams` SET ' . (' stream_icon = REPLACE( stream_icon, \'' . $old_host . '\', \'' . $new_host . '\' ) ') . (' WHERE `stream_icon` LIKE \'%' . $old_host . '%\';'));
        $tot_mv += $intro->db->affected_rows;
        $this->msg = _obf_0D3D40321528110F062A0B0321102712170C15030F2232(" <h1>\r\n\t\tSuccess: <br/>\r\n\t\tTotal Changed Movies Icons = " . $tot_mv . " <br/>\r\n\t\tTotal Changed Series Icons = " . $tot_se . " <br/>\r\n\t\t</h1>", 'success');
        $this->ChangeMoviesURL();
    }
    public function brws()
    {
        global $intro;
        $server_id = intval($intro->input->get('server'));
        $dir = trim($intro->input->get('id'));
        $video_ext = [
            'mp4', 
            'mkv', 
            'mov', 
            'avi', 
            'mpg', 
            'mpeg', 
            'flv', 
            'wmv', 
            'ts', 
            'mp3'
        ];
        if( $dir == '' || $dir == '#' ) 
        {
            $dir = '/';
        }
        $res = $this->brwsDir($server_id, str_replace('//', '/', $dir . '/'), $video_ext);
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode($res);
    }
    public function brwsDir($server_id, $dir, $defined_ext = null)
    {
        global $intro;
        $rData = _obf_0D3015381834391534383C26052A360C113F3E3D383B32([
            'for' => 'viewDir', 
            'server_id' => $server_id, 
            'dir' => $dir
        ]);
        if( $rData == '' ) 
        {
            return $this->treeReply('error: empty reply form server: ' . $row['server_name']);
        }
        $rDocument = new DOMDocument();
        $rDocument->loadHTML($rData);
        $rFiles = $rDocument->getElementsByTagName('li');
        $res = [];
        foreach( $rFiles as $rFile ) 
        {
            if( stripos($rFile->getAttribute('class'), 'directory') !== false ) 
            {
                if( $dir != '/' || $dir == '/' && !in_array($rFile->nodeValue, [
                    'bin', 
                    'etc', 
                    'dev', 
                    'lib', 
                    'lib64', 
                    'boot', 
                    'run', 
                    'sbin', 
                    'sys', 
                    'usr', 
                    'tmp', 
                    'mnt', 
                    'opt', 
                    'proc', 
                    'srv'
                ]) ) 
                {
                    $res[] = [
                        'text' => $rFile->nodeValue, 
                        'children' => true, 
                        'id' => (string)$dir . $rFile->nodeValue, 
                        'icon' => 'icon-folder-2'
                    ];
                }
            }
            else if( stripos($rFile->getAttribute('class'), 'file') !== false ) 
            {
                $rExt = strtolower(pathinfo($rFile->nodeValue)['extension']);
                if( is_array($defined_ext) && in_array($rExt, $defined_ext) || !$defined_ext ) 
                {
                    $res[] = [
                        'text' => $rFile->nodeValue, 
                        'children' => false, 
                        'id' => (string)$dir . $rFile->nodeValue, 
                        'type' => 'file', 
                        'icon' => 'icon-file-video'
                    ];
                }
            }
        }
        return $res;
    }
    public function treeReply($txt)
    {
        return [
            'text' => $txt, 
            'children' => true, 
            'id' => 'error', 
            'icon' => 'icon-folder-2'
        ];
    }
    public function AddByM3u($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $category_id;
        global $stream_display_name;
        global $stream_icon;
        global $target_container;
        global $movie_symlink;
        global $direct_source;
        global $redirect_stream;
        global $bouqet_id;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $this->nav();
        $direct_source = ($direct_source == '' ? 0 : $direct_source);
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-video"></i> Add Movies from M3U file ', 'info');
        echo _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911();
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Note: when u add Movies by m3u file, it will use direct source.', 'warning');
        if( intval($intro->input->get('success')) == 1 ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Movie File Added Success!.', 'success');
        }
        echo "\r\n\t\t<script>var base = '" . $this->base . "/brws/'; var type='multi';</script>\r\n\t\t<script src=\"" . admin_path . 'style/js/vod.js?v=1"></script>';
        $star = '<span style="color:red">*</span>';
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doAddByM3u\" enctype=\"multipart/form-data\">\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t\r\n\t\t<tr>\r\n\t\t\t<td>Upload m3u file: " . $star . "</td>\r\n\t\t\t<td><input  type=\"file\" name=\"m3u_file\"  size=\"50\"> <td>\r\n\t\t</tr>\r\n\t\t\r\n\t\t<tr>\r\n\t\t\t<td>" . $intro->lang['movies_catid'] . " :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td>" . $this->form_select_category('category_id', $category_id) . (' ' . $this->error('category_id') . "</td>\r\n\t\t</tr>");
        echo "\r\n\t\t<tr class=\"direct_source\" stXXXyle=\"display: none;\">\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'direct_source') . " Use Direct Source & don't restream it: </td>\r\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('direct_source', $direct_source, 'yes') . "</td>\r\n\t\t</tr>\r\n\t\t<tr class=\"redirect_stream\" stXXyle=\"display: none;\">\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'redirect_stream') . " Redirect Stream to the Original Source:  </td>\r\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('redirect_stream', $redirect_stream, 'yes') . "</td>\r\n\t\t</tr>\r\n\r\n\t\t<tr>\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'load_balancer_servers') . ('Select Load Balancer Servers : ' . $star . "</td>\r\n\t\t\t<td>\r\n\t\t\t") . _obf_0D311A13371B215B013B112303362D1032353D2E344022('server', 'Choose Server', 'streaming_servers', 0, 'id', 'server_name', 'where status=1') . "\r\n\t\t\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Optional: Add  to Bouquet: </td>\r\n\t\t\t<td>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('bouqet_id', 'Choose bouquet', 'bouquets', $bouqet_id, 'id', 'bouquet_name', ' where bouquet_status=1', ' order by bouquet_name asc') . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\t<button class=\"btn btn-success\" type=\"submit\">\r\n\t\t\t\t\t<i class=\"icon-plus-squared\"></i> Add by M3U\r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function doAddByM3u()
    {
        global $intro;
        global $array;
        $msg = '';
        $time = time();
        $date = date('Y-m-d H:i:s');
        $category_id = intval($intro->input->post('category_id'));
        $direct_source = intval($intro->input->post('direct_source'));
        $redirect_stream = intval($intro->input->post('redirect_stream'));
        $movie_symlink = intval($intro->input->post('movie_symlink'));
        $server = intval($intro->input->post('server'));
        $bouqet_id = intval($intro->input->post('bouqet_id'));
        $m3u_file = $_FILES['m3u_file'];
        $success_count = $duplicated_count = 0;
        if( $category_id == 0 || $server == 0 || !is_uploaded_file($m3u_file['tmp_name']) ) 
        {
            if( $category_id == 0 ) 
            {
                $msg .= '<li>Category is required! </li>';
            }
            if( $server == 0 ) 
            {
                $msg .= '<li>Please Choose Server!</li>';
            }
            if( !is_uploaded_file($m3u_file['tmp_name']) ) 
            {
                $msg .= '<li>Please upload m3u file!</li>';
            }
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011($msg, 'danger');
            $this->AddByM3u('add');
            exit();
        }
        if( is_uploaded_file($m3u_file['tmp_name']) ) 
        {
            $strms = new M3uParse($m3u_file['tmp_name']);
            if( !is_array($strms->found_titles) ) 
            {
                _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('<li>Error: nothing found in the uploaded m3u file!</li>', 'danger');
                $this->AddByM3u('add');
                exit();
            }
            $bouquet_channels = [];
            if( $bouqet_id != 0 ) 
            {
                $sql = $intro->db->query('SELECT * FROM bouquets WHERE id=' . $bouqet_id . ';');
                $row = $intro->db->fetch_assoc($sql);
                $bouquet_channels = json_decode($row['bouquet_channels'], true);
            }
            $ar_strm_ids = [];
            $ar_strm_ids = [];
            foreach( $strms->found_titles as $sn => $row ) 
            {
                if( isset($row['title']) && isset($row['url']) ) 
                {
                    $file_ext = strtolower(pathinfo($row['url'], PATHINFO_EXTENSION));
                    $stream_display_name = trim($row['title']);
                    $url = trim($row['url']);
                    $intro->db->query('SELECT stream_display_name FROM streams where type=2 AND stream_display_name=\'' . $stream_display_name . '\'');
                    if( $intro->db->returned_rows > 0 ) 
                    {
                        $msg .= _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Duplicated: ' . $stream_display_name, 'danger');
                        $duplicated_count++;
                    }
                    else
                    {
                        $data = [];
                        $data['category_id'] = $category_id;
                        $data['stream_display_name'] = $stream_display_name;
                        $data['stream_source'] = json_encode([$url]);
                        $data['stream_icon'] = '';
                        $data['added'] = $time;
                        $data['movie_symlink'] = $movie_symlink;
                        $data['redirect_stream'] = $redirect_stream;
                        $data['direct_source'] = $direct_source;
                        $data['type'] = 2;
                        $data['target_container'] = json_encode([$file_ext]);
                        $intro->db->insert('streams', $data);
                        $stream_id = $intro->db->insert_id();
                        _obf_0D152E0528111E401A021F33243837101D0A2D23141711('add', $stream_id, $server, $direct_source);
                        $task = [];
                        $task['task_for'] = 'movies';
                        $task['task_name'] = 'Add New Movies';
                        $task['task_table'] = 'streams';
                        $task['task_keyid'] = $stream_id;
                        $task['task_date'] = $date;
                        $task['cmd_start'] = 1;
                        $task['cmd_fetch'] = 1;
                        $task['task_status'] = -1;
                        $task['task_reply'] = '';
                        $intro->db->insert('' . PREFIX . '_tasks', $task);
                        array_unshift($bouquet_channels, $stream_id);
                        $success_count++;
                        $msg .= _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Success: ' . $stream_display_name, 'success');
                    }
                }
            }
            if( $bouqet_id != 0 && count($bouquet_channels) > 0 && $success_count > 0 ) 
            {
                $data2 = [];
                $data2['bouquet_channels'] = json_encode($bouquet_channels);
                $intro->db->update('bouquets', $data2, 'id=' . $bouqet_id);
            }
        }
        if( $success_count > 0 || $duplicated_count > 0 ) 
        {
            $this->nav();
            echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('m3u upload results');
            echo '<h1>Total added Streams = ' . $success_count . "</h1>\r\n\t\t\t<h1>Total duplicated Streams = " . $duplicated_count . '</h1>' . $msg;
            echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
            unset($msg);
            exit();
        }
        _obf_0D103C08311F24242D2F281F0B3E28333032320A031011($msg, 'success');
        $intro->redirect($this->appname, 'AddByM3u', '?t=add');
    }
    public function MassAdd()
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $stream_source;
        global $stream_720p;
        global $stream_480p;
        global $stream_360p;
        global $stream_1080p;
        global $stream_4k;
        global $category_id;
        global $youtube_trailer;
        global $stream_display_name;
        global $movie_subtitles;
        global $youtube_trailer;
        global $genre;
        global $plot;
        global $cast;
        global $rating;
        global $director;
        global $releasedate;
        global $duration_secs;
        global $duration;
        global $bitrate;
        global $movie_image;
        global $backdrop_path;
        global $tmdb_id;
        global $order;
        global $stream_icon;
        global $year;
        global $mpaa;
        global $target_container;
        global $direct_source;
        global $redirect_stream;
        global $movie_location;
        global $movie_symlink;
        global $remove_subtitles;
        global $load_balancer_servers;
        global $read_native;
        global $transcode_profile_id;
        global $bouqet_id;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-plus-squared"></i> Mass add Movies ', 'info');
        echo _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911();
        $star = '<span style="color:red">*</span>';
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doMassAdd\" enctype=\"multipart/form-data\">\r\n\t\tNote: Currently support adding vod from local server. Don't use Remote in other server now.<br/>\r\n\t\tto select multiple files use Shift Key for range select or Keep pressing Ctrl Key and click on files. \r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t<tr>\r\n\t\t\t<td>" . $intro->lang['movies_catid'] . " :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td>" . $this->form_select_category('category_id', $category_id) . (' ' . $this->error('category_id') . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Movie Location:</td>\r\n\t\t\t<td>\r\n\t\t\t\t") . _obf_0D12262623113F1D022A011A3E1D1B253D294027090E01('movie_location', $movie_location) . (' ' . $this->error('stream_display_name') . " \r\n\t\t\t\t<span id=\"local\">\r\n\t\t\t\t\t<button type=\"button\" class=\"btn btn-danger\" id=\"PickFile\">Pick Files</button>\r\n\t\t\t\t</span>\r\n\t\t\t</td>\r\n\t\t</tr>");
        echo "\r\n\t\t<tr id=\"movie_source_form\">\r\n\t\t\t<td>Movie Source : " . $star . " <span id='total_selected_from_tree'></span></td>\r\n\t\t\t<td><input  type=\"text\" name=\"stream_source\" id=\"stream_source\" value=\"" . $stream_source . '" class=\'form-control\'>' . $this->error('stream_source') . "</td>\r\n\t\t</tr>\r\n\t\t<tr class=\"movie_symlink\" style=\"display: none;\">\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'movie_symlink') . " Do not encode the VOD, use the source: </td>\r\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('movie_symlink', $movie_symlink, 'yes') . "\r\n\t\t\t\t<div style='color:#888'>  If you choose No - VOD will be downloaded to Server.</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr class=\"direct_source\" style=\"display: none;\">\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'direct_source') . " Use Direct Source & don't restream it: </td>\r\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('direct_source', $direct_source, 'yes') . "</td>\r\n\t\t</tr>\r\n\t\t<tr class=\"redirect_stream\" style=\"display: none;\">\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'redirect_stream') . " Redirect Stream to the Original Source:  </td>\r\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('redirect_stream', $redirect_stream, 'yes') . "</td>\r\n\t\t</tr>\r\n\t\t\r\n\t\t<tr id=\"load_balancer\">\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'load_balancer_servers') . ('Select Load Balancer Servers : ' . $star . "</td>\r\n\t\t\t<td><div>") . _obf_0D31033702041D1F0B1015180339183714070C36032811('load_balancer_servers[]', $load_balancer_servers) . ($this->error('load_balancer_servers') . "</div></td>\r\n\t\t</tr>\r\n\t\t<tr class=\"read_native\" style=\"display: none;\">\r\n\t\t\t<td>") . tooltip('tooltip_streams', 'read_native') . " Read Input Source in Native Frames:  </td>\r\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('read_native', $read_native, 'yes') . "</td>\r\n\t\t</tr>";
        echo "\r\n\t\t<tr class='transcode'>\r\n\t\t\t<th colspan=\"2\">Transcode Movie</th>\r\n\t\t</tr>\r\n\t\t<tr class='transcode'>\r\n\t\t\t<td>" . tooltip('tooltip_streams', 'transcode_profile_id') . " Select Transcode Profile: </td>\r\n\t\t\t<td>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('transcode_profile_id', 'No Transcode', 'transcoding_profiles', $transcode_profile_id, 'profile_id', 'profile_name', '', ' order by profile_name ASC') . "\r\n\t\t\t\t<a href=\"" . $intro->app_url('transcode_profiles', 'index') . "\" target=\"_blank\" class=\"btn btn-default\">Manage</a>\r\n\t\t\t</td>\r\n\t\t</tr>";
        echo "\r\n\t\t<tr class='transcode'>\r\n\t\t\t<th colspan=\"2\">Bouquet</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t\t<td>Optional: Add  to Bouquet: </td>\r\n\t\t\t\t<td>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('bouqet_id', 'Choose bouquet', 'bouquets', $bouqet_id, 'id', 'bouquet_name', ' where bouquet_status=1', ' order by bouquet_name asc') . "</td>\r\n\t\t</tr>";
        echo "\t\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\t<button class=\"btn btn-success\" type=\"submit\">\r\n\t\t\t\t\t<i class=\"icon-plus-squared\"></i> Mass add movies\r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        if( $movie_location == 'remote' ) 
        {
            $js = "\$('#local').hide();\r\n            \$('#fetch_options').hide();\r\n            \$('.direct_source').show();\r\n            \$('.movie_symlink').hide();\r\n\t\t\t\$('#load_balancer_servers').prop('required', false);";
        }
        else if( is_numeric($movie_location) ) 
        {
            $js = "\$('#local').show();\r\n            \$('#fetch_options').hide();\r\n            \$('.direct_source').hide();\r\n\r\n            \$('#read_native').show();\r\n            \$('#load_balancer').show();\r\n            \$('.movie_symlink').show();\r\n            \$('#movie_container').show();\r\n            \$('#subtitles').show();\r\n  \r\n            \$('input:radio[name=direct_source][value=0]').click();\r\n            \$('#load_balancer_servers').prop('required', true);\r\n\r\n\t\t\t\$('#firstChosenSelect').chosen();\r\n\t\t\t\$('#load_balancer_servers').addClass('chosen').chosen({search_contains: true});";
        }
        else
        {
            $js = '';
        }
        echo "<script>\r\n\t\tfunction cleanString(input) {\r\n\t\t\tvar output = '';\r\n\t\t\tfor (var i=0; i<input.length; i++) {\r\n\t\t\t\tif (input.charCodeAt(i) <= 127) {\r\n\t\t\t\t\toutput += input.charAt(i);\r\n\t\t\t\t}\r\n\t\t\t}\r\n\t\t\treturn output;\r\n\t\t}\r\n\t\t\$(function(){\r\n\t\t\t\r\n\t\t\t\$('select[name=category_id]').addClass('chosen').chosen({search_contains: true,width:335});\r\n\t\t\t\r\n\t\t\t" . $js . "\r\n\t\t\t\r\n\r\n\t\t\t\r\n\t\t });\r\n\t\t</script>";
        echo "\r\n\t\t<script>var base = '" . $this->base . "/brws/'; var type='multi';</script>\r\n\t\t<link rel=\"stylesheet\" href=\"" . admin_path . "style/tree/proton/proton.min.css\">\r\n\t\t<script src=\"" . admin_path . "style/tree/jstree.min.js\"></script>\r\n\t\t<script src=\"" . admin_path . 'style/js/vod.js?v=1"></script>';
    }
    public function doMassAdd()
    {
        global $intro;
        global $error;
        $movie_location = intval($intro->input->post('movie_location'));
        $redirect_stream = intval($intro->input->post('redirect_stream'));
        $direct_source = intval($intro->input->post('direct_source'));
        $bouqet_id = intval($intro->input->post('bouqet_id'));
        $category_id = intval($intro->input->post('category_id'));
        $order = intval($intro->input->post('order'));
        $movie_symlink = intval($intro->input->post('movie_symlink'));
        $read_native = intval($intro->input->post('read_native'));
        $transcode_profile_id = trim($intro->input->post('transcode_profile_id'));
        $stream_source = trim($intro->input->post('stream_source'));
        $movie_subtitles = trim($intro->input->post('movie_subtitles'));
        $stream_display_name = trim($intro->input->post('stream_display_name'));
        $t = trim($intro->input->post('t'));
        $target_container = $intro->input->post('target_container');
        $backdrop_path = $intro->input->post('backdrop_path');
        $load_balancer_servers = $intro->input->post('load_balancer_servers');
        $tmdb_id = trim($intro->input->post('tmdb_id'));
        if( $category_id == 0 || $movie_location == 0 || $stream_source == '' || !isset($load_balancer_servers[0]) ) 
        {
            if( $category_id == 0 ) 
            {
                $error['category_id'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $movie_location == 0 ) 
            {
                $error['movie_location'] = '<span class=error>Please choose files from LB server. Don\'t use remote.</span>';
            }
            if( $stream_source == '' ) 
            {
                $error['stream_source'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( !isset($load_balancer_servers[0]) ) 
            {
                $error['load_balancer_servers'] = '<span class=error>Please choose LB server</span>';
            }
            $this->MassAdd();
            exit();
        }
        $added = time();
        $date = date('Y-m-d H:i:s');
        $VodNames = [];
        $ex = explode(',', $stream_source);
        foreach( $ex as $file ) 
        {
            $fileName = pathinfo($file, PATHINFO_FILENAME);
            $file_ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
            preg_match_all('/^.+?(?=\s*[(.]?(\d{4}))/mi', $fileName, $matches);
            $movie_name = (isset($matches[0][0]) ? str_replace('.', ' ', $matches[0][0]) : '');
            $movie_name .= (isset($matches[1][0]) ? ' ' . $matches[1][0] : '');
            if( $movie_name == '' ) 
            {
                $movie_name = $fileName;
            }
            if( $movie_name != '' ) 
            {
                $VodNames[] = [
                    'type' => 2, 
                    'added' => $added, 
                    'category_id' => $category_id, 
                    'stream_display_name' => $movie_name, 
                    'stream_source' => json_encode(['s:' . $movie_location . ':' . $file], JSON_UNESCAPED_SLASHES), 
                    'target_container' => json_encode([$file_ext]), 
                    'movie_symlink' => $movie_symlink, 
                    'read_native' => $read_native, 
                    'transcode_profile_id' => $transcode_profile_id
                ];
            }
        }
        $bouquet_channels = [];
        if( $bouqet_id != 0 ) 
        {
            $sql = $intro->db->query('SELECT * FROM bouquets WHERE id=' . $bouqet_id . ';');
            $row = $intro->db->fetch_assoc($sql);
            $bouquet_channels = json_decode($row['bouquet_channels'], true);
        }
        $data = [];
        $i = 0;
        foreach( $VodNames as $key => $data ) 
        {
            $i++;
            $intro->db->insert('streams', $data);
            $stream_id = $intro->db->insert_id();
            _obf_0D152E0528111E401A021F33243837101D0A2D23141711('add', $stream_id, $load_balancer_servers[0], $direct_source);
            $task = [];
            $task['task_for'] = 'movies';
            $task['task_name'] = 'Add New Movies';
            $task['task_table'] = 'streams';
            $task['task_keyid'] = $stream_id;
            $task['task_date'] = $date;
            $task['cmd_start'] = 1;
            $task['cmd_fetch'] = 1;
            $task['task_status'] = -1;
            $task['task_reply'] = '';
            $intro->db->insert('' . PREFIX . '_tasks', $task);
            array_unshift($bouquet_channels, $stream_id);
        }
        if( $bouqet_id != 0 && count($bouquet_channels) > 0 ) 
        {
            $data2 = [];
            $data2['bouquet_channels'] = json_encode($bouquet_channels);
            $intro->db->update('bouquets', $data2, 'id=' . $bouqet_id);
        }
        _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Success : Total added movies (' . $i . ')', 'success');
        $intro->redirect($this->appname, 'index/?success=1&from=mass');
    }
    public function StartTask()
    {
        global $intro;
        $intro->db->query('DELETE from `solus_tasks` where task_for=\'movies\' AND cmd_start_status=1 AND cmd_fetch_status=1;');
        $this->nav();
        $page = intval($intro->input->get_post('page'));
        $rows_per_page = 10;
        if( $page == 0 ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $query = 'SELECT * FROM `solus_tasks` task  LEFT JOIN `streams` st ON task.task_keyid=st.id  LEFT JOIN `streams_sys` sys ON task.task_keyid=sys.stream_id  WHERE task_for=\'movies\'';
        $result = $intro->db->query($query . ' limit ' . $nexlimit . ',' . $rows_per_page);
        $intro->db->query(' ' . $query . ' ');
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-list"></i> Mass Add Movies Task (' . $totalrows . ')', 'info');
        echo "\r\n\t\t<h4>Note: Please don't refresh page , Page will auto refresh.</h4>\r\n\t\t<table class=\" table table-bordered table-hover table-striped\"   >\r\n        <thead>\r\n\t    <tr >\r\n\t\t\t<th>#</th>\r\n\t\t\t<th>ID</th>\r\n\t\t\t<th>Task Name</th>\r\n\t\t\t<th>Task Date</th>\r\n\t\t\t\r\n\t\t\t<th>Movie Title</th>\r\n\t\t\t<th>Commands</th>\r\n\t\t\t<th>TMDB Reuslt</th>\r\n\t\t\t<th>Encode</th>\r\n\t\t\t<th>" . $intro->lang['options'] . "</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = $server_id = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td class=\"center\">" . $i . "</td>\r\n\t\t\t\t<td class=\"center\">" . $task_id . "</td>\r\n\t\t\t\t<td class=\"center\">" . $task_name . "</td>\r\n\t\t\t\t<td class=\"center\">" . $task_date . "</td>\r\n\t\t\t\t<td class=\"center\">" . $stream_display_name . "</td>\r\n\t\t\t\t<td class=\"center\">" . (($cmd_start == 1 ? 'Encode' : '')) . ' ' . (($cmd_fetch == 1 ? '| Fetch TMDB' : '')) . "</td>\r\n\t\t\t\t<td class=\"center\">";
            if( $cmd_fetch == 1 && $cmd_fetch_status == 0 ) 
            {
                echo $this->TaskFetchTmdb($task_keyid, $stream_display_name, $task_id, 'cmd_fetch_status');
            }
            echo "</td>\r\n\t\t\t\t<td class=\"center\">";
            if( $cmd_start == 1 && $cmd_start_status == 0 ) 
            {
                echo $this->TaskStratEncode('start', $task_keyid, $server_id, $task_id, 'cmd_start_status');
            }
            echo "</td>\r\n\t\t\t\t<td class=\"center\"> \t\t\t\t\t\r\n\t\t\t\t\t<a class=\"btn btn-danger p_del intro_ui_del\" href=\"" . $this->base . '/DelTask?id=' . $task_id . "\" OnClick=\"return false;\" title=\"Delete Task\"><i class=\"icon-trash\"></i></a>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        echo "</tbody>\r\n\t\t</table>";
        $maxPage = ceil($totalrows / $rows_per_page);
        $pageNum = $page;
        if( $pageNum > 1 ) 
        {
            $page = $pageNum - 1;
        }
        if( $pageNum < $maxPage ) 
        {
            $page = $pageNum + 1;
            $url = '?&page=' . $page;
            $next = ' <a href="' . $url . "\"> Run Next </a>\r\n\t\t\t<meta http-equiv=Refresh content=2;url=\"" . $url . '">';
        }
        else
        {
            $next = ' <h2 style="color:#004000"> All tasks Completed. <h2>';
        }
        echo '<center>Completed: <strong>' . $pageNum . '</strong> From <strong>' . $maxPage . '</strong>  ' . $next . ' </center>';
    }
    public function ImageDl()
    {
        global $intro;
        global $poster;
        global $name;
        $this->nav();
        if( $intro->option['VodRemoteServer'] != 1 ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('to use this page, please set remote server api in Tools-> Codes Options [Movies/Series Posters]', 'danger');
            exit();
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-download"></i> Download Poster/Image to Remote Server', 'info');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\" id=\"form_add\"  action=\"" . $this->base . "/doImageDl\" enctype=\"multipart/form-data\">\r\n\t\t<div class=\"table-responsive\">\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t<tr>\r\n\t\t\t<td>URL : * </td>\r\n\t\t\t<td><input  type=\"text\" name=\"poster\" value=\"" . $poster . '" class="form-control"> ' . $this->error('url') . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Rename : </td>\r\n\t\t\t<td><input  type=\"text\" name=\"name\" value=\"" . $name . '" class="form-control"> ' . $this->error('name') . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\t<button type=\"submit\">\r\n\t\t\t\t\t<i class=\"icon-download\"></i> Download to Remote Server\r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t<div id=\"result\"></div>\r\n\t\t</div>\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\$(document).ready(function(){\r\n\t\t\t\$(\"#form_add\").submit( function () {   \r\n\t\t\t\t\r\n\t\t\t\t\$('#result').html('loading...');\r\n\t\t\t\t\r\n\t\t\t\t\$.post('" . $this->base . "/doImageDl?NH=1',\$(this).serialize(),function(data){\r\n\t\t\t\t\t\$(\"#result\").html(data)\r\n\t\t\t\t}\r\n\t\t\t\t\r\n\t\t\t  );\r\n\t\t\t  return false;   \r\n\t\t\t});   \r\n\t\t});\r\n\t\t</script>";
    }
    public function doImageDl()
    {
        global $intro;
        global $poster;
        global $name;
        $poster = trim($intro->input->post('poster'));
        $name = trim($intro->input->post('name'));
        if( strlen($poster) < 10 ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Please input poster url', 'danger') );
        }
        if( strlen($intro->option['VodRemoteServerAPI']) < 10 ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Please set API url in Tools->  Codes Options [Movies/Series Posters]', 'danger') );
        }
        if( strlen($intro->option['VodRemoteUloadPath']) < 10 ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Please set [Upload Path:] in Tools->  Codes Options [Movies/Series Posters]', 'danger') );
        }
        if( !filter_var($intro->option['VodRemoteUloadPath'], FILTER_VALIDATE_URL) ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Please set correct [Upload Path:] in Tools->  Codes Options [Movies/Series Posters]', 'danger') );
        }
        $ex = explode('.', $poster);
        $extension = end($ex);
        $name = str_replace([
            ' ', 
            ',', 
            '"', 
            '\'', 
            '`', 
            '~', 
            ':', 
            '*', 
            '?', 
            '\\', 
            '/'
        ], '_', $name);
        if( $name == '' ) 
        {
            $name = date('Y-m-d_H-i-s') . microtime(true);
        }
        $fileName = 'vod_' . $name . '.' . $extension;
        $curl = new IntroCurl($intro->option['VodRemoteServerAPI']);
        $rep = $curl->post('', [
            'fileName' => $fileName, 
            'fileData' => $poster
        ]);
        if( $rep == 'Success' ) 
        {
            $img = $intro->option['VodRemoteUloadPath'] . $fileName;
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Success. <input class=\'form-control\' value=\'' . $img . '\'/>', 'success');
        }
        else
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: ' . $rep . ' ', 'danger');
        }
    }
    public function TaskStratEncode($vodStratStopEncode, $stream_id, $server_id, $task_id, $field)
    {
        global $intro;
        global $error;
        $XC = new XtreamApi('EmptyFunc');
        $reply = $XC->StartVod($vodStratStopEncode, $stream_id, $server_id);
        if( $reply == 'success' ) 
        {
            $intro->db->query('update solus_tasks set ' . $field . '=1 WHERE task_id=' . $task_id . ';');
            return 'success';
        }
        else
        {
            return 'faild: (' . $reply . ')';
        }
    }
    public function TaskFetchTmdb($stream_id, $stream_display_name, $task_id, $field)
    {
        global $intro;
        global $error;
        $movieID = $stream_display_name;
        $tmdb_lang = '';
        $_SER = 0;
        if( $movieID == '' ) 
        {
            return 'empty tmdb id';
        }
        $return_data = '';
        $VodData = new IntroTmdb($movieID, $tmdb_lang, $_SER);
        if( count($VodData) < 10 ) 
        {
            return 'TMDB fetch Faild. (' . $return_data . ')';
        }
        $json = [];
        $json['movie_image'] = $VodData['movie_image'];
        $json['backdrop_path'] = $this->backdrop_path($VodData['backdrop_path']);
        $json['tmdb_id'] = $VodData['tmdb_id'];
        $json['youtube_trailer'] = $VodData['youtube_trailer'];
        $json['plot'] = $VodData['plot'];
        $json['cast'] = $VodData['cast'];
        $json['rating'] = $VodData['rating'];
        $json['director'] = $VodData['director'];
        $json['releasedate'] = $VodData['releasedate'];
        $json['duration_secs'] = $VodData['duration_secs'];
        $json['duration'] = $VodData['duration'];
        $json['video'] = [];
        $json['audio'] = [];
        $json['bitrate'] = (isset($VodData['bitrate']) ? $VodData['bitrate'] : '');
        $json['year'] = $VodData['year'];
        $json['mpaa'] = $VodData['mpaa'];
        $intro->db->update('streams', [
            'stream_icon' => $json['movie_image'], 
            'movie_propeties' => json_encode($json)
        ], 'id=' . $stream_id);
        $this->success = true;
        $intro->db->query('update solus_tasks set ' . $field . '=1 WHERE task_id=' . $task_id . ';');
        return 'tmdb success ' . $VodData['tmdb_id'];
    }
    public function DelTask()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('DELETE FROM `solus_tasks` WHERE task_id=' . $id . '; ');
    }
    public function ClearTask()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $sql = $intro->db->query('DELETE FROM `solus_tasks` WHERE task_for=\'movies\'; ');
        $intro->redirect($this->appname, 'index');
    }
}
