<?php 
class Online_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry = '';
    public $was = false;
    public $show_in_red_online = 0;
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $for = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('for'));
        if( $for == 'mag' ) 
        {
            $for = 'user';
        }
        $this->admin = $intro->auth->sess_admin();
        $adminid = intval($this->admin['adminid']);
        if( $this->admin['level'] != 1 ) 
        {
            if( $for == 'code' ) 
            {
                $this->qry = 'and (codes.adminid=' . $adminid . ' OR adminid IN (select adminid from ' . PREFIX . ('_admin WHERE father=' . $adminid . ' OR  main_father=' . $adminid . '))');
            }
            else if( $for == 'user' ) 
            {
                $this->qry = 'and (users.member_id=' . $adminid . ' OR member_id IN (select adminid from ' . PREFIX . ('_admin WHERE father=' . $adminid . ' OR  main_father=' . $adminid . '))');
            }
            else
            {
                $this->qry = 'and (codes.adminid=' . $adminid . ' OR adminid IN (select adminid from ' . PREFIX . ('_admin WHERE father=' . $adminid . ' OR  main_father=' . $adminid . '))');
            }
        }
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
    }
    public function nav()
    {
        global $cur_file;
        echo "<div class=\"app_nav\">\n\t\t<a class=\"btn btn-success\" href=\"" . $this->base . '/index"><icon class="icon-globe"> Online Now (Local) </icon> </a> ';
        echo '<a class="btn btn-primary" href="' . $this->base . '/remote"><icon class="icon-globe"> Online Now (Remote Panel) </icon> </a> ';
        if( $this->admin['level'] == 1 )
        {
            echo '<a class="btn btn-danger" href="' . $this->base . '/was"><icon class="icon-list"> Was Online </icon> </a> ';
        }
        echo "\n\t\t</div>";
    }
    public function was()
    {
        global $intro;
        $this->was = true;
        $this->index('user_activity', 'Was Online');
    }

    public function remote()
    {
        global $intro;

        error_log("REMOTE FUNCTION CALLED");

        // Load remote configuration
        require_once('/var/www/html/iptv/V6APK/api_cfg_v6.php');

        if(!isset($_CFG['remote_panel_enabled']) || !$_CFG['remote_panel_enabled']) {
            echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Remote Panel Disabled', 'danger');
            error_log("REMOTE PANEL DISABLED");
            return;
        }

        error_log("REMOTE PANEL ENABLED - proceeding");

        $remote_host = $_CFG['remote_host'];
        $remote_user = $_CFG['remote_ssh_user'];
        $remote_pass = $_CFG['remote_ssh_pass'];
        $remote_db = $_CFG['remote_db_name'];

        echo "<div dir=ltr>\n";
        $this->nav();

        // Query remote server for active connections (where disconnect = 0 means still connected)
        // Write query to temp file to avoid backtick escaping hell
        $query = "SELECT ll.id, ll.lid, ll.sid, ll.IP_address, ll.user_agent, ll.country, ll.isp, ll.connection_time, ll.server_id, ll.speed, ll.disconnect, l.username, s.name as stream_name, s.type as stream_type FROM lines_log ll LEFT JOIN `lines` l ON ll.lid = l.id LEFT JOIN streams s ON ll.sid = s.id WHERE ll.disconnect = 0 ORDER BY ll.connection_time DESC LIMIT 200";

        $tmpfile = '/tmp/remote_query_' . time() . '.sql';
        file_put_contents($tmpfile, $query);

        $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " . $remote_user . "@" . $remote_host . " 'mysql " . $remote_db . " -N' < " . $tmpfile . " 2>&1";

        $output = shell_exec($cmd);
        @unlink($tmpfile);

        error_log("REMOTE QUERY OUTPUT: " . substr($output, 0, 200));

        $lines = explode("\n", trim($output));
        error_log("REMOTE LINE COUNT: " . count($lines));

        $totalrows = 0;
        $results = [];
        foreach($lines as $line) {
            if(empty($line)) continue;
            $parts = explode("\t", $line);
            error_log("REMOTE PARTS COUNT: " . count($parts));
            if(count($parts) >= 13) {
                $results[] = [
                    'id' => $parts[0],
                    'lid' => $parts[1],
                    'sid' => $parts[2],
                    'IP_address' => $parts[3],
                    'user_agent' => $parts[4],
                    'country' => $parts[5],
                    'isp' => $parts[6],
                    'connection_time' => $parts[7],
                    'server_id' => $parts[8],
                    'speed' => isset($parts[9]) ? $parts[9] : '0',
                    'disconnect' => isset($parts[10]) ? $parts[10] : '0',
                    'username' => isset($parts[11]) ? $parts[11] : 'N/A',
                    'stream_name' => isset($parts[12]) ? $parts[12] : 'N/A',
                    'stream_type' => isset($parts[13]) ? $parts[13] : '0'
                ];
                $totalrows++;
            }
        }

        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Online Now - Remote Panel (' . $totalrows . ')', 'primary');

        echo "\n\t  <table dir=ltr class=\"table table-bordered table-condensed table-hover\">\n            <tr>\n\t\t\t\t<th class='c'>User</th>\n\t\t\t\t<th class='c'>Stream</th>\n\t\t\t\t<th class='c'>Server</th>\n\t\t\t\t<th class='c'>UserAgent</th>\n\t\t\t\t<th class='c'></th>\n\t\t\t\t<th class='c'>IP</th>\n\t\t\t\t<th class='c'>ISP</th>\n\t\t\t\t<th class='c'>Watching</th>\n\t\t\t\t<th class='c'>Uptime</th>\n\t\t\t\t<th class='c'>Status</th>\n\t    </tr>";

        $now = new DateTime('now');
        foreach($results as $row) {
            $elapsed = new DateTime(date('Y-m-d H:i:s', $row['connection_time']));
            $diff = $now->diff($elapsed);
            $ago = $diff->format('%H:%I:%S');

            // Determine what client is watching
            $watching = '';
            if($row['stream_type'] == 0) {
                $watching = '<span class="label label-info">Live Channel</span>';
            } else if($row['stream_type'] == 1) {
                $watching = '<span class="label label-warning">VOD</span>';
            } else {
                $watching = '<span class="label label-default">Unknown</span>';
            }

            // Status
            $status = ($row['disconnect'] == 0) ? '<span class="label label-success">Online</span>' : '<span class="label label-danger">Offline</span>';

            echo "<tr>\n\t\t\t\t\t<td class=\"center\">" . htmlspecialchars($row['username']) . '</td>';
            echo "\n\t\t\t\t\t<td class=\"c\">" . htmlspecialchars($row['stream_name']) . "</td>\n                     <td class=\"c\">" . htmlspecialchars($row['server_id']) . "</th>\n                     <td class=\"c\"><a title=\"" . htmlspecialchars($row['user_agent']) . '">' . substr(htmlspecialchars($row['user_agent']), 0, 15) . "</a></th>\n\t\t\t\t\t <td class=\"c\"><img src=\"" . admin_path . 'style/css/flags/blank.gif" class="flag flag-' . strtolower($row['country']) . ("\" /></th>\n                     <td class=\"c\"><a href='https://www.ip2location.com/demo/" . $row['IP_address'] . "' target='_blank' title=\"" . htmlspecialchars($row['isp']) . '">' . htmlspecialchars($row['IP_address']) . "</a> </th>\n                     <td class=\"c\">" . htmlspecialchars($row['isp']) . "</th>\n                     <td class=\"c\">" . $watching . "</th>\n                     <td class=\"c\">" . $ago . "</th>\n                     <td class=\"c\">" . $status . '</th>');
            echo "\n\t\t\t\t</tr>";
        }

        echo "\n\t\t</table>\n\t\t</div>";
    }

    public function index($table = 'user_activity_now', $text = 'Online Now')
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $for = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('for'));
        echo "<div dir=ltr>\n";
        if( $id == 0 ) 
        {
            $this->nav();
        }
        $qry = $params = $divergence = $last_ts_read = $last_ts = '';
        $code = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('code'));
        $fullname = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('fullname'), '{ar} ');
        $mac = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('mac'), ':');
        $serial = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('serial'), '.-_');
        $order = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('order'), ':. _-');
        $page = intval($intro->input->get_post('page'));
        $user = intval($intro->input->get_post('user'));
        $username = $intro->db->escape($intro->input->get_post('username'));
        if( $code != '' ) 
        {
            $qry .= (' AND codes.code  LIKE \'%' . $code . '%\' ');
            $params .= ('&code=' . $code);
        }
        if( $id != 0 ) 
        {
            $qry .= (' AND users.id=' . $id . ' ');
            $params .= ('&id=' . $id);
        }
        if( $username != '' ) 
        {
            $qry .= (' AND users.username  LIKE \'' . str_replace('*', '%', $username) . '\' ');
            $params .= ('&username=' . $username);
        }
        if( $serial != '' ) 
        {
            $qry .= (' AND codes.serial  LIKE \'%' . $serial . '%\' ');
            $params .= ('&serial=' . $serial);
        }
        if( $mac != '' ) 
        {
            $qry .= (' AND codes.mac  LIKE \'%' . $mac . '%\' ');
            $params .= ('&mac=' . $mac);
        }
        if( $fullname != '' ) 
        {
            $qry .= (' AND codes.fullname  LIKE \'%' . $fullname . '%\' ');
            $params .= ('&fullname=' . $fullname);
        }
        if( $order == '' ) 
        {
            $order = 'activity_id_desc';
        }
        $order = str_replace('_desc', ' desc', $order);
        $order = str_replace('_asc', ' asc', $order);
        $rows_per_page = '200';
        if( intval($page) == 0 ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $fields = [
            'users.id,users.username,users.created_by,streams.stream_display_name', 
            'online.activity_id', 
            'online.user_id', 
            'online.stream_id', 
            'online.server_id', 
            'online.user_agent', 
            'online.user_ip', 
            'online.container', 
            'online.date_start', 
            'online.date_end', 
            'online.geoip_country_code', 
            'online.isp'
        ];
        if( !$this->was ) 
        {
            $fields[] = 'online.pid';
        }
        if( $for == 'code' || $for == '' ) 
        {
            array_push($fields, 'codes.mac,codes.serial,codes.inputBy,codes.adminid');
            $FIELDS = implode(',', $fields);
            $sql = 'SELECT {FIELDS} from `' . $table . '` online, streams  , users, solus_codes codes ' . ' where online.stream_id=streams.id AND online.user_id=users.id AND users.id=codes.userid ' . (' ' . $this->qry . ' ' . $qry . ' ');
            $result = $intro->db->query(str_replace('{FIELDS}', $FIELDS, $sql) . (' order by ' . $order . '  limit ' . $nexlimit . ',' . $rows_per_page));
            $resultnumm = $intro->db->query(str_replace('{FIELDS}', 'activity_id', $sql));
        }
        else
        {
            $SQL = 'SELECT ' . implode(',', $fields) . (' from `' . $table . '` online, streams  , users ') . ' where online.stream_id=streams.id AND online.user_id=users.id ' . (' ' . $this->qry . '  ' . $qry);
            $result = $intro->db->query($SQL . ' order by ' . $order . '  limit ' . $nexlimit . ',' . $rows_per_page);
            $resultnumm = $intro->db->query($SQL);
        }
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22($text . (' (' . $totalrows . ')'), ($this->was ? 'danger' : 'success'));
        if( $id == 0 ) 
        {
            echo "\n\t\t<form action=\"\" method=\"post\" class=''>\n\t\t\t<input type=\"text\" name=\"code\" value=\"" . $code . "\" size=\"15\" placeholder=\"Code\">\n\t\t\t<input type=\"text\" name=\"serial\" value=\"" . $serial . "\" size=\"20\" placeholder=\"Serial\">\n\t\t\t<input type=\"text\" name=\"mac\" value=\"" . $mac . "\" size=\"20\" placeholder=\"Mac\">\t\t\t\n\t\t\t<input type=\"text\" name=\"user\" value=\"" . $user . "\" size=\"20\" placeholder=\"Username\">\t\t\t\n\t\t\t<input  name=\"name\" value=\"Search\" type=\"submit\" class=\"btn btn-" . (($this->was ? 'danger' : 'success')) . "\">\n\t\t</form><hr/>";
        }
        if( $this->admin['level'] == 1 ) 
        {
        }
        echo "\n\t  <table dir=ltr class=\"table table-bordered table-condensed table-hover\">\n            <tr>\n\t\t\t\t<th class='c'>User</th>";
        if( $this->admin['level'] == 1 ) 
        {
            echo '<th class=\'c\'>Resel</th>';
        }
        echo "\n\t\t\t\t<th class='c'>Stream</th>\n\t\t\t\t<th class='c'>Server</th>\n\t\t\t\t<th class='c'>UserAgent</th>\n\t\t\t\t<th class='c'></th>\n\t\t\t\t<th class='c'>IP</th>\n\t\t\t\t<th class='c'>Container</th>\n\t\t\t\t<th class='c'>Uptime</th>";
        if( $for == 'code' ) 
        {
            echo "<th class='c'>MAC</th>\n\t\t\t\t<th class='c'>Serial</th>";
        }
        echo "\n\t    </tr>";
        $i = 0;
        $now = new DateTime('now');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $elapsed = new DateTime(date('Y-m-d H:i:s', $date_start));
            $diff = $now->diff($elapsed);
            $ago = $diff->format('%H:%I:%S');
            if( $for != 'code' ) 
            {
                $adminid = $created_by;
            }
            if( isset($array['admins'][$adminid]) ) 
            {
                $admin = $array['admins'][$adminid];
            }
            else
            {
                $admin = '-';
            }
            echo "<tr>\n\t\t\t\t\t<td class=\"center\">" . $username . '</td>';
            if( $this->admin['level'] == 1 ) 
            {
                echo '<td class=\'c\'>' . $admin . '</td>';
            }
            echo "\n\t\t\t\t\t<td class=\"c\">" . $stream_display_name . "</td>\n                     <td class=\"c\">" . $server_id . "</th>\n                     <td class=\"c\"><a title=\"" . $user_agent . '">' . substr($user_agent, 0, 15) . "</a></th>\n\t\t\t\t\t <td class=\"c\"><img src=\"" . admin_path . 'style/css/flags/blank.gif" class="flag flag-' . strtolower($geoip_country_code) . ("\" /></th>\n                     <td class=\"c\"><a href='https://www.ip2location.com/demo/" . $user_ip . '\' target=\'_blank\' title="' . $isp . '">' . $user_ip . "</a> </th>\n                     <td class=\"c\">" . $container . "</th>\n                     <td class=\"c\">" . $ago . '</th>');
            if( $for == 'code' ) 
            {
                echo '<td class="c">' . $mac . "</th>\n                     <td class=\"c\">" . $serial . '</th>';
            }
            echo "\n\t\t </tr>";
        }
        echo '</table>';

        // Add remote panel online users if enabled
        if(!$this->was && $table == 'user_activity_now') {
            $this->showRemoteOnlineUsers();
        }

        $order = str_replace(' desc', '_desc', $order);
        $order = str_replace(' asc', '_asc', $order);
        echo '<center>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?order=' . $order . '&for=' . $for . $params, $totalrows, $rows_per_page, $page) . '</center>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function WasOnline()
    {
        $this->was = true;
        $this->Online('user_activity');
    }
    public function Online($table = 'user_activity_now')
    {
        global $intro;
        global $array;
        $qry = $params = '';
        if( $table == 'user_activity_now' ) 
        {
            $fields = 'uan.pid,';
        }
        else
        {
            $fields = '';
        }
        $user_name = $username = $intro->db->escape($intro->input->get_post('user_name'));
        $stream_name = trim($intro->db->escape($intro->input->get_post('stream_name')));
        $servername = trim($intro->db->escape($intro->input->get_post('servername')));
        $useragent = trim($intro->db->escape($intro->input->get_post('useragent')));
        $userip = trim($intro->db->escape($intro->input->get_post('userip')));
        $order = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('order'), ' -_.:');
        $page = intval($intro->input->get_post('page'));
        $stream_id = intval($intro->input->get_post('stream_id'));
        $server_id = intval($intro->input->get_post('server_id'));
        $restream = intval($intro->input->get_post('restream'));
        if( $user_name != '' ) 
        {
            $qry .= (' AND usr.username  LIKE \'%' . $user_name . '%\' ');
            $params .= ('&user_name=' . $user_name);
        }
        if( $stream_id != 0 ) 
        {
            $qry .= (' AND str.id =' . $stream_id . ' ');
            $params .= ('&stream_id=' . $stream_id);
        }
        if( $server_id != 0 ) 
        {
            $qry .= (' AND srv.id =' . $server_id . ' ');
            $params .= ('&server_id=' . $server_id);
        }
        if( $restream != 0 ) 
        {
            if( $restream == 10 ) 
            {
                $qry .= ' AND usr.is_restreamer=0 ';
            }
            if( $restream == 11 ) 
            {
                $qry .= ' AND usr.is_restreamer=1 ';
            }
            $params .= ('&restream=' . $restream);
        }
        if( $stream_name != '' ) 
        {
            $qry .= (' AND str.stream_display_name  LIKE \'%' . $stream_name . '%\' ');
            $params .= ('&stream_name=' . $stream_name);
        }
        if( $servername != '' ) 
        {
            $qry .= (' AND srv.server_name  LIKE \'%' . $servername . '%\' ');
            $params .= ('&servername=' . $servername);
        }
        if( $useragent != '' ) 
        {
            $qry .= (' AND uan.user_agent  LIKE \'%' . $useragent . '%\' ');
            $params .= ('&useragent=' . $useragent);
        }
        if( $userip != '' ) 
        {
            $qry .= (' AND uan.user_ip  LIKE \'%' . $userip . '%\' ');
            $params .= ('&userip=' . $userip);
        }
        $order = str_replace(':', ' ', $order);
        if( $order == '' ) 
        {
            $order = 'uan.activity_id DESC';
        }
        $rows_per_page = '100';
        if( intval($page) == 0 ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        echo "<div class=\"app_nav\">\n\t\t<a class=\"btn btn-success\" href=\"" . $this->base . "/Online\"><icon class=\"icon-globe\"> Online Now </icon> </a> \n\t\t<a class=\"btn btn-danger\" href=\"" . $this->base . "/WasOnline\"><icon class=\"icon-globe\"> Was Online </icon> </a> \n\t\t</div>";
        if( $this->admin['level'] != 1 ) 
        {
            $adminid = intval($this->admin['adminid']);
            $this->qry = 'and (users.member_id=' . $adminid . ' OR member_id IN (select adminid from ' . PREFIX . ('_admin WHERE father=' . $adminid . ' OR  main_father=' . $adminid . '))');
        }
        $result = $intro->db->query(' select usr.username as user_name ,str.stream_display_name as stream_name' . (',srv.server_name  as server_name,' . $fields . 'uan.divergence,uan.user_id,uan.stream_id,uan.server_id') . ',uan.user_agent,uan.user_ip,uan.container,uan.date_start,uan.date_end,uan.geoip_country_code,uan.isp' . (' FROM  ' . $table . '  uan ') . ' LEFT JOIN users usr on uan.user_id=usr.id ' . ' LEFT JOIN streams str on uan.stream_id=str.id ' . (' LEFT JOIN streaming_servers srv on uan.server_id=srv.id where true ' . $qry . ' ') . (' ORDER BY ' . $order . ' ' . $this->qry . '  limit ' . $nexlimit . ',' . $rows_per_page . ' '));
        $totrows = $intro->db->returned_rows;
        $resultnumm = $intro->db->query(' select activity_id FROM ' . $table . ' uan ' . ' LEFT JOIN users usr on uan.user_id=usr.id ' . ' LEFT JOIN streams str on uan.stream_id=str.id ' . ' LEFT JOIN streaming_servers srv on uan.server_id=srv.id ' . (' where true ' . $qry . ' ' . $this->qry));
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22((($this->was ? 'Was' : 'All')) . ' Online Users' . ' (' . number_format($totalrows) . ')', ($this->was ? 'danger' : 'success'));
        echo "\n\t\t<form action=\"\" method=\"post\" class=''>\n\t\t\t<input type=\"text\" value=\"" . $user_name . "\" name=\"user_name\" size=\"15\" placeholder=\"User Name\">\n\t\t\t<input type=\"text\" value=\"" . $stream_name . '" name="stream_name" size="20" placeholder="Stream Name">';
        if( $this->admin['level'] == 1 ) 
        {
            echo '<input type="text" value="' . $servername . "\" name=\"servername\" size=\"20\" placeholder=\"Server Name\">\t\t\t\n\t\t\t\t<input type=\"text\" value=\"" . $useragent . '" name="useragent" size="20" placeholder="User Ggent">';
        }
        echo '<input type="text" value="' . $userip . '" name="userip" size="20" placeholder="User IP">';
        if( $this->admin['level'] == 1 ) 
        {
            echo _obf_0D25032D2B210E1538102515291B2D08111A1816070622('restream', [
                '10' => 'Users Only', 
                '11' => 'Restreamers Only'
            ], $restream, 'All Users');
        }
        echo '<input  name="name" value="Search" type="submit" class="btn btn-' . (($this->was ? 'danger' : 'success')) . "\">\n\t\t\t\n\t\t</form><hr/>";
        echo "\n\t\t<table dir=ltr class=\"table table-bordered table-condensed table-hover\">\n            <tr>\n\t\t\t\t<th class='c'>#</th>\n\t\t\t\t<th class='c'>User</th>";
        if( $table == 'user_activity_now' ) 
        {
            echo '<th class=\'c\'>Kill</th>';
        }
        echo "\n\t\t\t\t<th class='c'></th>\n\t\t\t\t<th class='c'>Stream " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('str.stream_display_name', 'Online', $params) . '</th>';
        if( $this->admin['level'] == 1 ) 
        {
            echo "\n\t\t\t\t<th class='c'>Server " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('srv.server_name', 'Online', $params) . '</th>';
        }
        echo "\n\t\t\t\t<th class='c'>UserAgent " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('uan.user_agent', 'Online', $params) . "</th>\n\t\t\t\t<th class='c'>User IP " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('uan.user_ip', 'Online', $params) . "</th>\n\t\t\t\t<th class='c'>Flag</th>\n\t\t\t\t<th class='c'>ISP " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('uan.isp', 'Online', $params) . "</th>\n\t\t\t\t<th class='c'>container " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('uan.container', 'Online', $params) . '</th>';
        echo "\n\t\t\t\t<th class='c'>Uptime " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('date_start', 'Online', $params) . "</th>\t\n\t\t</tr>";
        $pid = '';
        $now = new DateTime('now');
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $date_start = ($date_start != '' ? date('Y-m-d H:i:s', $date_start) : '');
            $date_end = ($date_end != '' ? date('Y-m-d H:i:s', $date_end) : '');
            if( $date_start != '' ) 
            {
                if( $table == 'user_activity' ) 
                {
                    $datetime1 = new DateTime($date_start);
                    $datetime2 = new DateTime($date_end);
                    $diff = $datetime1->diff($datetime2);
                }
                else
                {
                    $elapsed = new DateTime($date_start);
                    $diff = $now->diff($elapsed);
                }
                $ago = $diff->format('%H:%I:%S');
            }
            else
            {
                $ago = '-';
            }
            echo "<tr>\n\t\t\t\t\t\t<td class=\"c\">" . $i . "</th>\n\t\t\t\t\t\t<td class=\"center\">" . (($user_name == '' ? '<span class=\'label label-danger\'>' . $user_id . '</span>' : '<a href="?user_name=' . $user_name . '">' . $user_name . '</a>')) . '</td>';
            if( $table == 'user_activity_now' ) 
            {
                echo '<td class="c" id=\'status_' . $user_id . '\'><a class="AjaxConfirm red" href="' . $intro->app_url('users', 'Kill') . ('?&uid=' . $user_id . '" title="Kill Connection!"><span class="icon-emo-shoot"></span></a></li></td>');
            }
            echo "\n\t\t\t\t\t\t<td class=\"c\">" . $divergence . "</th>\n\t\t\t\t\t\t<td class=\"c\">" . (($stream_name == '' ? '<span class=\'label label-danger\'>' . $stream_id . '</span>' : '<a href="?stream_id=' . $stream_id . '">' . $stream_name . '</a>')) . '</td>';
            if( $this->admin['level'] == 1 ) 
            {
                echo '<td class="c">' . (($server_name == '' ? '<span class=\'label label-danger\'>' . $server_id . '</span>' : '<a href="?server_id=' . $server_id . '">' . $server_name . '</a>')) . '</th>';
            }
            echo "\n\t\t\t\t\t\t<td class=\"c\"><a  href=\"?useragent=" . urlencode($user_agent) . ('" title="' . $user_agent . '">') . substr($user_agent, 0, 15) . ("</a></th>\n\t\t\t\t\t\t<td class=\"c\"><a href='https://www.ip2location.com/demo/" . $user_ip . '\' target=\'_blank\' title="' . $isp . '">' . $user_ip . "</a> </th>\n\t\t\t\t\t\t<td class=\"c\"><img src=\"") . admin_path . 'style/css/flags/blank.gif" class="flag flag-' . strtolower($geoip_country_code) . ("\" /></th>\n\t\t\t\t\t\t<td class=\"c\">" . $isp . "</th>\n\t\t\t\t\t\t<td class=\"c\">" . $container . '</th>');
            echo '<td class="c">' . $ago . "</th>\n\t\t\t\t\t</tr>";
        }
        $order = str_replace(' ', ':', $order);
        echo '</table>';

        // Add remote panel online users if enabled and viewing current activity
        if(!$this->was && $table == 'user_activity_now') {
            $this->showRemoteOnlineUsers();
        }

        echo '<center>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/' . (($this->was ? 'WasOnline' : 'Online')) . ('?order=' . $order . $params), $totalrows, $rows_per_page, $page) . '</center>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function FindRestreamers($table = 'user_activity')
    {
        global $intro;
        global $array;
        $qry = $params = '';
        $user_name = _obf_0D162C393D0808073D1A062223322C0919102C28242A11(trim($intro->input->get_post('user_name')), '@.:-_');
        $stream_name = _obf_0D162C393D0808073D1A062223322C0919102C28242A11(trim($intro->input->get_post('stream_name')), '\]-_:\[');
        $servername = _obf_0D162C393D0808073D1A062223322C0919102C28242A11(trim($intro->input->get_post('servername')), '-_:');
        $useragent = _obf_0D162C393D0808073D1A062223322C0919102C28242A11(trim($intro->input->get_post('useragent')), '.');
        $userip = _obf_0D162C393D0808073D1A062223322C0919102C28242A11(trim($intro->input->get_post('userip')), '.:-');
        $order = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('order'), '');
        $page = intval($intro->input->get_post('page'));
        if( $user_name != '' ) 
        {
            $qry .= (' AND usr.username  LIKE \'%' . $user_name . '%\' ');
            $params .= ('&user_name=' . $user_name);
        }
        if( $stream_name != '' ) 
        {
            $qry .= (' AND str.stream_display_name  LIKE \'%' . $stream_name . '%\' ');
            $params .= ('&stream_name=' . $stream_name);
        }
        if( $servername != '' ) 
        {
            $qry .= (' AND srv.server_name  LIKE \'%' . $servername . '%\' ');
            $params .= ('&servername=' . $servername);
        }
        if( $useragent != '' ) 
        {
            $qry .= (' AND uan.user_agent  LIKE \'%' . $useragent . '%\' ');
            $params .= ('&useragent=' . $useragent);
        }
        if( $userip != '' ) 
        {
            $qry .= (' AND uan.user_ip  LIKE \'%' . $userip . '%\' ');
            $params .= ('&userip=' . $userip);
        }
        $order = str_replace('desc', ' desc', $order);
        $order = str_replace('asc', ' asc', $order);
        echo "<div class=\"app_nav\">\n\t\t<a class=\"btn btn-danger\" href=\"" . $this->base . "/FindRestreamers\"><icon class=\"icon-globe\"> Find Restreamers </icon> </a> \n\t\t</div>";
        $past1day = time() - 86400;
        $result = $intro->db->query(" select GROUP_CONCAT(DISTINCT uan.user_ip),usr.username as user_name \n\t\t,str.stream_display_name as stream_name,srv.server_name,\n\t\tuan.user_agent,uan.user_ip,uan.container,uan.date_start,uan.date_end,uan.geoip_country_code,uan.isp \n\t\tFROM  " . $table . "  uan\n\t\tleft JOIN users usr on uan.user_id=usr.id\n\t\tleft JOIN streams str on uan.stream_id=str.id\n\t\tleft JOIN streaming_servers srv on uan.server_id=srv.id WHERE usr.is_restreamer=0 AND date_start>= '" . $past1day . '\'  ' . $qry . "\n\t\tGROUP BY usr.username \n\t\tHAVING COUNT(DISTINCT uan.user_ip) > 1\n\t\tORDER BY COUNT(DISTINCT uan.user_ip) DESC ");
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Users connected form different IPs in short time (Last 24 hours).' . (' (' . $totalrows . ')'), 'danger');
        echo "\n\t\t<form action=\"\" method=\"post\" class=''>\n\t\t\t<input type=\"text\" value=\"" . $user_name . "\" name=\"user_name\" size=\"15\" placeholder=\"User Name\">\n\t\t\t<input type=\"text\" value=\"" . $stream_name . "\" name=\"stream_name\" size=\"20\" placeholder=\"Stream Name\">\n\t\t\t<input type=\"text\" value=\"" . $servername . "\" name=\"servername\" size=\"20\" placeholder=\"Server Name\">\t\t\t\n\t\t\t<input type=\"text\" value=\"" . $useragent . "\" name=\"useragent\" size=\"20\" placeholder=\"User Ggent\">\t\t\t\n\t\t\t<input type=\"text\" value=\"" . $userip . "\" name=\"userip\" size=\"20\" placeholder=\"User IP\">\t\t\t\n\t\t\t<input  name=\"name\" value=\"Search\" type=\"submit\" class=\"btn btn-" . (($this->was ? 'danger' : 'success')) . "\">\n\t\t</form><hr/>";
        echo "\n\t\t<table dir=ltr class=\"table table-bordered table-condensed table-hover\">\n            <tr>\n\t\t\t\t<th class='c'>#</th>\n\t\t\t\t<th class='c'>User</th>\n\t\t\t\t<th class='c'>Stream</th>\n\t\t\t\t<th class='c'>Server</th>\n\t\t\t\t<th class='c'>UserAgent</th>\n\t\t\t\t<th class='c'>User IP</th>\n\t\t\t\t<th class='c'>ISP</th>\n\t\t\t\t<th class='c'>container</th>\n\t\t\t\t<th class='c'>pid</th>\n\t\t\t\t<th class='c'>Start</th>\n\t\t\t\t<th class='c'>End</th>\n\t\t\t\t<th class='c'>Flag</th>\n\t\t\t\t\n\t\t</tr>";
        $pid = '';
        $now = new DateTime('now');
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $date_start = ($date_start != '' ? date('Y-m-d H:i:s', $date_start) : '');
            $date_end = ($date_end != '' ? date('Y-m-d H:i:s', $date_end) : '');
            if( $date_start != '' ) 
            {
                $elapsed = new DateTime($date_start);
                $diff = $now->diff($elapsed);
                $ago = $diff->format('%H:%I:%S');
            }
            else
            {
                $ago = '-';
            }
            echo "<tr>\n\t\t\t\t\t\t<td class=\"center\">" . $i . "</td>\n\t\t\t\t\t\t<td class=\"center\"><a class=\"AjaxModal\" href=\"" . $this->base . '/Online?user_name=' . $user_name . '">' . $user_name . "</a></td>\n\t\t\t\t\t\t<td class=\"c\">" . $stream_name . "</td>\n\t\t\t\t\t\t<td class=\"c\">" . $server_name . "</th>\n\t\t\t\t\t\t<td class=\"c\"><a title=\"" . $user_agent . '">' . substr($user_agent, 0, 15) . ("</a></th>\n\t\t\t\t\t\t<td class=\"c\"><a href='https://www.ip2location.com/demo/" . $user_ip . '\' target=\'_blank\' title="' . $isp . '">' . $user_ip . "</a> </th>\n\t\t\t\t\t\t<td class=\"c\">" . $isp . "</th>\n\t\t\t\t\t\t<td class=\"c\">" . $container . "</th>\n\t\t\t\t\t\t<td class=\"c\">" . $pid . "</th>\n\t\t\t\t\t\t<td class=\"c\">" . $date_start . "</th>\n\t\t\t\t\t\t<td class=\"c\">" . $ago . "</th>\n\t\t\t\t\t\t<td class=\"c\"><img src=\"") . admin_path . 'style/css/flags/blank.gif" class="flag flag-' . strtolower($geoip_country_code) . "\" /></th>\n\n\t\t\t\t\t</tr>";
        }
        echo '</table>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function UsersConnectSameIP()
    {
        global $intro;
        global $array;
        $this->nav();
        $fields = [
            'COUNT(user_ip) AS cnt,users.id,users.username,users.created_by,streams.stream_display_name', 
            'online.activity_id', 
            'online.user_id', 
            'online.stream_id', 
            'online.server_id', 
            'online.user_agent', 
            'online.user_ip', 
            'online.container', 
            'online.date_start', 
            'online.date_end', 
            'online.geoip_country_code', 
            'online.isp'
        ];
        $SQL = 'SELECT ' . implode(',', $fields) . ' from `user_activity_now` online, streams  , users ' . ' where online.stream_id=streams.id AND online.user_id=users.id AND users.is_restreamer=0 AND users.max_connections<100 ' . '  GROUP BY user_ip HAVING cnt >1 ';
        $result = $intro->db->query($SQL . '  order by cnt DESC');
        $resultnumm = $intro->db->query($SQL);
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' Abusers with more than one ip (' . $totalrows . ')', 'success');
        echo "\n\t  <table dir=ltr class=\"table table-bordered table-condensed table-hover\">\n            <tr>\n\t\t\t\t<th class='c'>User</th>\n\t\t\t\t<th class='c'>Count</th>\n\t\t\t\t<th class='c'>Resel</th>\n\t\t\t\t<th class='c'>Stream</th>\n\t\t\t\t<th class='c'>Server</th>\n\t\t\t\t<th class='c'>UserAgent</th>\n\t\t\t\t<th class='c'></th>\n\t\t\t\t<th class='c'>IP</th>\n\t\t\t\t<th class='c'>Container</th>\n\t\t\t\t<th class='c'>Uptime</th>\n\t\t\t\t\n\t\t\t</tr>";
        $i = 0;
        $now = new DateTime('now');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $elapsed = new DateTime(date('Y-m-d H:i:s', $date_start));
            $diff = $now->diff($elapsed);
            $ago = $diff->format('%H:%I:%S');
            if( isset($array['admins'][$created_by]) ) 
            {
                $admin = $array['admins'][$created_by];
            }
            else
            {
                $admin = '-';
            }
            echo "<tr>\n\t\t\t\t\t<td class=\"center\">" . $username . "</td>\n\t\t\t\t\t<td class=\"center\">" . $cnt . "</td>\n\t\t\t\t\t<td class='c'>" . $admin . "</td>\n\t\t\t\t\t<td class=\"c\">" . $stream_display_name . "</td>\n                     <td class=\"c\">" . $server_id . "</th>\n                     <td class=\"c\"><a title=\"" . $user_agent . '">' . substr($user_agent, 0, 15) . "</a></th>\n\t\t\t\t\t <td class=\"c\"><img src=\"" . admin_path . 'style/css/flags/blank.gif" class="flag flag-' . strtolower($geoip_country_code) . ("\" /></th>\n                     <td class=\"c\"><a href='https://www.ip-tracker.org/locator/ip-lookup.php?ip=" . $user_ip . '\' target=\'_blank\' title="' . $isp . '">' . $user_ip . "</a> </th>\n                     <td class=\"c\">" . $container . "</th>\n                     <td class=\"c\">" . $ago . "</th>\n\t\t </tr>");
        }
        echo '</table>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }

    private function showRemoteOnlineUsers()
    {
        // Load remote configuration
        require_once('/var/www/html/iptv/V6APK/api_cfg_v6.php');

        if(!isset($_CFG['remote_panel_enabled']) || !$_CFG['remote_panel_enabled']) {
            return; // Remote panel disabled, don't show
        }

        $remote_host = $_CFG['remote_host'];
        $remote_user = $_CFG['remote_ssh_user'];
        $remote_pass = $_CFG['remote_ssh_pass'];
        $remote_db = $_CFG['remote_db_name'];

        // Query remote server for active connections
        $query = "SELECT ll.id, ll.lid, ll.sid, ll.IP_address, ll.user_agent, ll.country, ll.isp, ll.connection_time, ll.server_id, ll.speed, ll.disconnect, l.username, s.name as stream_name, s.type as stream_type FROM lines_log ll LEFT JOIN `lines` l ON ll.lid = l.id LEFT JOIN streams s ON ll.sid = s.id WHERE ll.disconnect = 0 ORDER BY ll.connection_time DESC LIMIT 200";

        $tmpfile = '/tmp/remote_query_' . time() . '.sql';
        file_put_contents($tmpfile, $query);

        $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " . $remote_user . "@" . $remote_host . " 'mysql " . $remote_db . " -N' < " . $tmpfile . " 2>&1";

        $output = shell_exec($cmd);
        @unlink($tmpfile);

        $lines = explode("\n", trim($output));

        $totalrows = 0;
        $results = [];
        foreach($lines as $line) {
            if(empty($line)) continue;
            $parts = explode("\t", $line);
            if(count($parts) >= 13) {
                $results[] = [
                    'id' => $parts[0],
                    'lid' => $parts[1],
                    'sid' => $parts[2],
                    'IP_address' => $parts[3],
                    'user_agent' => $parts[4],
                    'country' => $parts[5],
                    'isp' => $parts[6],
                    'connection_time' => $parts[7],
                    'server_id' => $parts[8],
                    'speed' => isset($parts[9]) ? $parts[9] : '0',
                    'disconnect' => isset($parts[10]) ? $parts[10] : '0',
                    'username' => isset($parts[11]) ? $parts[11] : 'N/A',
                    'stream_name' => isset($parts[12]) ? $parts[12] : 'N/A',
                    'stream_type' => isset($parts[13]) ? $parts[13] : '0'
                ];
                $totalrows++;
            }
        }

        if($totalrows == 0) {
            return; // No remote users, don't show table
        }

        echo "<br/><br/>";
        echo '<style>
        .remote-table tbody tr:hover {
            background-color: #f0f0f0 !important;
        }
        </style>';
        echo '<script>
        function killRemoteConnection(logId, username) {
            if(!confirm("Kill connection for user: " + username + "?")) {
                return;
            }

            var row = document.getElementById("remote-row-" + logId);
            if(row) {
                row.style.opacity = "0.5";
            }

            fetch("' . $this->base . '/KillRemoteConnection", {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded",
                },
                body: "log_id=" + logId
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    if(row) {
                        row.style.transition = "all 0.5s ease";
                        row.style.backgroundColor = "#ffebee";
                        setTimeout(function() {
                            row.remove();
                        }, 1000);
                    }
                    alert("Connection killed successfully!");
                } else {
                    if(row) {
                        row.style.opacity = "1";
                    }
                    alert("Error: " + (data.message || "Failed to kill connection"));
                }
            })
            .catch(error => {
                if(row) {
                    row.style.opacity = "1";
                }
                alert("Network error: " + error);
            });
        }
        </script>';
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Remote Panel Online (' . $totalrows . ')', 'info');

        echo "\n\t  <table dir=ltr class=\"table table-bordered table-condensed table-hover remote-table\">\n            <tr>\n\t\t\t\t<th class='c'>User</th>\n\t\t\t\t<th class='c'>Stream</th>\n\t\t\t\t<th class='c'>Server</th>\n\t\t\t\t<th class='c'>UserAgent</th>\n\t\t\t\t<th class='c'></th>\n\t\t\t\t<th class='c'>IP</th>\n\t\t\t\t<th class='c'>ISP</th>\n\t\t\t\t<th class='c'>Speed</th>\n\t\t\t\t<th class='c'>Watching</th>\n\t\t\t\t<th class='c'>Uptime</th>\n\t\t\t\t<th class='c'>Status</th>\n\t\t\t\t<th class='c'>Kill</th>\n\t    </tr>";

        $now = new DateTime('now');
        foreach($results as $row) {
            $elapsed = new DateTime(date('Y-m-d H:i:s', $row['connection_time']));
            $diff = $now->diff($elapsed);
            $ago = $diff->format('%H:%I:%S');

            // Determine what client is watching
            $watching = '';
            if($row['stream_type'] == 0) {
                $watching = '<span class="label label-info">Live</span>';
            } else if($row['stream_type'] == 1) {
                $watching = '<span class="label label-warning">VOD</span>';
            } else {
                $watching = '<span class="label label-default">Unknown</span>';
            }

            // Status
            $status = ($row['disconnect'] == 0) ? '<span class="label label-success">Online</span>' : '<span class="label label-danger">Offline</span>';

            // Calculate speed display - connection quality from client to server
            $speed_value = trim($row['speed']);
            if(!empty($speed_value) && $speed_value != 'NULL' && $speed_value > 0) {
                $speed_kb = round($speed_value, 2);
                if($speed_kb >= 1024) {
                    // Convert to MB/s if >= 1024 KB/s
                    $speed_display = round($speed_kb / 1024, 2) . ' MB/s';
                } else {
                    $speed_display = $speed_kb . ' KB/s';
                }

                // Color code based on speed quality
                if($speed_kb >= 2048) {
                    $speed = '<span class="label label-success">' . $speed_display . '</span>'; // Good speed
                } elseif($speed_kb >= 512) {
                    $speed = '<span class="label label-info">' . $speed_display . '</span>'; // Medium speed
                } else {
                    $speed = '<span class="label label-warning">' . $speed_display . '</span>'; // Low speed
                }
            } else {
                $speed = '-';
            }

            // Kill connection button
            $kill_btn = '<a class="btn btn-mini btn-danger" onclick="return killRemoteConnection(' . $row['id'] . ', \'' . addslashes(htmlspecialchars($row['username'])) . '\')" title="Kill Connection"><i class="icon-remove-sign"></i></a>';

            echo "<tr id=\"remote-row-" . $row['id'] . "\">\n\t\t\t\t\t<td class=\"center\">" . htmlspecialchars($row['username']) . '</td>';
            echo "\n\t\t\t\t\t<td class=\"c\">" . htmlspecialchars($row['stream_name']) . "</td>\n                     <td class=\"c\">" . htmlspecialchars($row['server_id']) . "</td>\n                     <td class=\"c\"><a title=\"" . htmlspecialchars($row['user_agent']) . '">' . substr(htmlspecialchars($row['user_agent']), 0, 15) . "</a></td>\n\t\t\t\t\t <td class=\"c\"><img src=\"" . admin_path . 'style/css/flags/blank.gif" class="flag flag-' . strtolower($row['country']) . '" /></td>';
            echo "\n                     <td class=\"c\"><a href='https://www.ip2location.com/demo/" . $row['IP_address'] . "' target='_blank' title=\"" . htmlspecialchars($row['isp']) . '">' . htmlspecialchars($row['IP_address']) . "</a> </td>\n                     <td class=\"c\">" . htmlspecialchars($row['isp']) . "</td>\n                     <td class=\"c\">" . $speed . "</td>\n                     <td class=\"c\">" . $watching . "</td>\n                     <td class=\"c\">" . $ago . "</td>\n                     <td class=\"c\">" . $status . "</td>\n                     <td class=\"c\">" . $kill_btn . '</td>';
            echo "\n\t\t\t\t</tr>";
        }

        echo "\n\t\t</table>";
    }

    public function KillRemoteConnection()
    {
        global $intro;

        // Set JSON response header
        header('Content-Type: application/json');

        $log_id = intval($intro->input->get_post('log_id'));

        if($log_id <= 0) {
            echo json_encode(['success' => false, 'message' => 'Invalid log ID']);
            return;
        }

        // Load remote configuration
        require_once('/var/www/html/iptv/V6APK/api_cfg_v6.php');

        if(!isset($_CFG['remote_panel_enabled']) || !$_CFG['remote_panel_enabled']) {
            echo json_encode(['success' => false, 'message' => 'Remote panel is disabled']);
            return;
        }

        $remote_host = $_CFG['remote_host'];
        $remote_user = $_CFG['remote_ssh_user'];
        $remote_pass = $_CFG['remote_ssh_pass'];
        $remote_db = $_CFG['remote_db_name'];

        // Execute remote kill command - set disconnect=1 for the connection
        $query = "UPDATE lines_log SET disconnect = 1, disconnect_time = UNIX_TIMESTAMP() WHERE id = " . $log_id;

        $tmpfile = '/tmp/remote_kill_' . time() . '.sql';
        file_put_contents($tmpfile, $query);

        $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " . $remote_user . "@" . $remote_host . " 'mysql " . $remote_db . "' < " . $tmpfile . " 2>&1";

        $output = shell_exec($cmd);
        @unlink($tmpfile);

        // Check if command was successful
        if(empty($output) || strpos($output, 'ERROR') === false) {
            echo json_encode(['success' => true, 'message' => 'Connection killed successfully']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to kill connection: ' . $output]);
        }
    }
}
