<?php 
class Rtmp_ips_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $qry_admin_where = '';
    public $admin = [];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        if( !in_array($this->admin['level'], [
            1, 
            9
        ]) ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "<div class=\"app_nav\">\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . "/index\"><icon class=\"icon-building\">RTMP IPs</icon></a> \n\t\t<a class=\"btn btn-") . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . ('" href="' . $this->base . "/Form?t=add\"><icon class=\"icon-plus-squared\">Add RTMP IP</icon></a> \n\t\t\n\t\t</div>");
    }
    public function index()
    {
        global $intro;
        global $array;
        $qry = $queryadmin = $params = $txt = '';
        $order = trim($intro->input->get_post('order'));
        $this->nav();
        $rows_per_page = 50;
        if( $order == '' ) 
        {
            $order = 'id:ASC';
        }
        $order = str_replace(':', ' ', $order);
        $result = $intro->db->query('SELECT * from rtmp_ips order by ' . $order);
        $totrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<h4 style=\'display:inline\'><i class="icon-globe"></i> RTMP IPs (' . $totrows . ') ' . $txt . '</h4>');
        echo "\n\t\t<table class=\"table table-hover table-bordered\" id=\"table_codes\">\n        <thead>\n\t    <tr>\n\t\t\n\t\t\t<th>ID</th>\n\t\t\t<th> IP </th>\n\t\t\t<th> Notes </th>\n\t\t\t<th> Options </th>\n\t\t\t\n\t    </tr>\n\t\t</thead>\n\t\t\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            echo "\n\t\t\t<tr>\n\t\t\t\t<td class=\"center\">" . $id . "</td>\n\t\t\t\t<td class=\"center\">" . $ip . "</td>\n\t\t\t\t<td class=\"center\">" . $notes . "</td>\n\t\t\t\t<td class=\"center\">\n\t\t\t\t\t<a class=\"btn btn-info\" href=\"" . $this->base . '/Form?t=edit&amp;id=' . $id . '" title="' . $intro->lang['edit'] . ("\"><i class=\"icon-edit\"></i></a>\n\t\t\t\t\t<a class=\"btn btn-danger p_del intro_ui_del\" href=\"" . $this->base . '/Del?id=' . $id . '" OnClick="return false;" title="') . $intro->lang['del'] . "\"><i class=\"icon-cancel-circled2\"></i></a>\n\t\t\t\t</td>\n\t\t\t</tr>";
        }
        echo "</tbody>\n\t\t\t</table>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $ip;
        global $notes;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $id = intval($intro->input->get_post('id'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        $this->nav();
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * FROM rtmp_ips WHERE id=' . $id . ';');
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $btn['legend_name'] = 'Edit IP   <b>' . $id . '</b>';
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = 'Add New';
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = $intro->lang['save'];
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ', 'info');
        echo "\n\t\t" . _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911() . ("\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\n\t\t<table class=\"table table-bordered table-hover table-striped\">\n\t\t\n\t\t<tr>\n\t\t\t<td style='width:20%;'>IP  : </td>\n\t\t\t<td ><input type=text name='ip' value='" . $ip . "' class='form-control'></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td style='width:20%;'>Notes  : </td>\n\t\t\t<td ><textarea class='form-control' name='notes'>" . $notes . "</textarea></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td></td>\n\t\t\t<td>\n\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\n\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\n\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $id . "\">\n\t\t\t\t<button type=\"submit\" name=\"app_action\" value=\"" . $btn['action'] . "\">\n\t\t\t\t\t<i class=\"" . $btn['img_icon'] . '"></i> ' . $btn['name'] . " \n\t\t\t\t</button>\n\t\t\t</td>\n\t\t</tr>\n\t\t</table>\n\t\n\t\t</form>");
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        $msg = '';
        $ip = trim($intro->input->post('ip'));
        $notes = trim($intro->input->post('notes'));
        if( $ip == '' ) 
        {
            $msg .= '<li>ip is required </li>';
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011($msg, 'danger');
            $this->Form('add');
            exit();
        }
        $data = [];
        $data['ip'] = $ip;
        $data['notes'] = $notes;
        $intro->db->insert('rtmp_ips', $data);
        $id = $intro->db->insert_id();
        $intro->redirect($this->appname);
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        global $s_title;
        $msg = '';
        $id = intval($intro->input->post('id'));
        $ip = trim($intro->input->post('ip'));
        $notes = trim($intro->input->post('notes'));
        if( $ip == '' ) 
        {
            if( $ip == '' ) 
            {
                $msg .= '<li>ip is required </li>';
            }
            $t = 'edit';
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011($msg, 'danger');
            $this->Form('edit');
            exit();
        }
        $data = [];
        $data['ip'] = $ip;
        $data['notes'] = $notes;
        $intro->db->update('rtmp_ips', $data, 'id=' . $id);
        $intro->redirect($this->appname);
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');
        $sql = $intro->db->query('DELETE FROM rtmp_ips WHERE id =' . $id . ' ');
        $intro->redirect($this->appname);
    }
}
