<?php 
class Sat2iptv_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $qry_admin_where = '';
    public $admin = [];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        if( $this->admin['level'] != 1 ) 
        {
            $this->qry_admin = ' and adminid=' . intval($this->admin['adminid']);
            $this->qry_admin_where = ' where adminid=' . intval($this->admin['adminid']);
        }
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "\n\t\t<div class=\"app_nav\">\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . "/index\">\n\t\t\t<icon class=\"icon-list\">STB to IPTV</icon>\n\t\t</a>\n\t\t<a class=\"btn btn-success\" href=\"" . $this->base . "/Form?t=add\">Add New Channel</a>\n\t\t\n\t\t<a class=\"btn btn-") . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Groups') . (' icon-list" href="' . $this->base . "/Groups?t=add\">STB/SAT Groups </a> &nbsp;&nbsp; \t\t \t\t \n\t\t\n\t\t</div>");
    }
    public function index()
    {
        global $intro;
        global $array;
        $this->nav();
        $result = $intro->db->query('SELECT *, (SELECT stream_display_name from `streams` WHERE streams.id=stb.ch_id) as stream_name,  (SELECT stb_gname from `' . PREFIX . '_stb_groups` WHERE stb_gid=stb.stb_group) as stb_group_name ' . ' FROM ' . PREFIX . '_stb_to_iptv stb ORDER BY stb_group_name ASC, stream_name ASC ;');
        $totrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Current STB to IPTV Channels (' . $totrows . ')');
        echo "\n\t\t<table class=\"DataTable table-striped table-bordered table-hover\" id=\"table_codes\">\n        <thead>\n\t    <tr>\n\t\t\n\t\t\t<th class='c'>#</th>\n\t\t\t<th class='c'>ID</th>\n\t\t\t<th class='c'> STB/SAT Group </th>\n\t\t\t<th class='c'> Local Channel </th>\n\t\t\t<th class='c'> STB Channel Name </th>\n\t\t\t<th class='c'> Angle </th>\n\t\t\t<th class='c'> Pol. H/V </th>\n\t\t\t<th class='c'> Transponder </th>\n\t\t\t<th class='c'> SID </th>\n\t\t\n\t\t\t<th class='c'> Options </th>\n\t\t\t\n\t    </tr>\n\t\t</thead>\n\t\t\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            echo "\n\t\t\t<tr class=\"" . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\n\t\t\t\t<td class=\"center\">" . $i . "</td>\n\t\t\t\t<td class=\"center\">" . $id . "</td>\n\t\t\t\t<td class=\"center\"><span class=\"editableSTBgroup\" data-type=\"select\" data-pk=\"" . $id . '" data-name="stb_group">' . $stb_group_name . "</span></td>\n\t\t\t\t<td class=\"center\">" . $stream_name . "</td>\n\t\t\t\t<td class=\"center\">\n\t\t\t\t\t<span class=\"editInPlace\" data-type=\"text\" data-pk=\"" . $id . "\" data-name=\"stb_ch_name\">\n\t\t\t\t\t" . $stb_ch_name . "\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td class=\"center\">\n\t\t\t\t\t<span class=\"editInPlace\" data-type=\"text\" data-pk=\"" . $id . "\" data-name=\"angle\">\n\t\t\t\t\t" . $angle . "\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td class=\"center\">\n\t\t\t\t\t<span class=\"editInPlace\" data-type=\"text\" data-pk=\"" . $id . "\" data-name=\"pol\">\n\t\t\t\t\t" . $pol . "\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td class=\"center\">\n\t\t\t\t\t<span class=\"editInPlace\" data-type=\"text\" data-pk=\"" . $id . "\" data-name=\"tp\">\n\t\t\t\t\t" . $tp . "\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td class=\"center\">\n\t\t\t\t\t<span class=\"editInPlace\" data-type=\"text\" data-pk=\"" . $id . "\" data-name=\"sid\">\n\t\t\t\t\t" . $sid . "\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t\n\t\t\t\t<td class=\"center\">");
            echo "\n\t\t\t\t\t<a class=\"btn btn-info p_edit\" href=\"" . $this->base . '/Form?t=edit&amp;id=' . $id . '" title="' . $intro->lang['edit'] . ("\"><i class=\"icon-edit\"></i></a>\n\t\t\t\t\t\n\t\t\t\t\t<a class=\"btn btn-danger StbDel\" id=\"" . $id . '" href="' . $this->base . '/Del?NH=1&id=' . $id . "\" OnClick=\"return false;\">\n\t\t\t\t\t<icon class=\"icon-trash\"></icon>\n\t\t\t\t\t</a>");
            echo "\n\t\t\t\t</td>\n\t\t\t</tr>";
        }
        echo "</tbody>\n\t\t\t</table>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\n\t\t\$(document).ready(function() {\n\t\t\t\n\t\t\t\n\t\t\t\$('.StbDel').click(function(e){\n\t\t\t\te.preventDefaults;\n\t\t\t\t\n\t\t\t\tif(!confirm('Are you sure you want to Delete?')) return false;\n\t\t\t\t\n\t\t\t\tvar link_tr = \$(this).closest('tr');\n\t\t\t\t\n\t\t\t\t\$.get( \$(this).attr('href'), function( data ) {\n\t\t\t\t\t\n\t\t\t\t\tlink_tr.fadeOut();\n\t\t\t\t});\n\t\t\t\treturn false;\n\t\t\t});\n\t\t\t\n\t\t\t\$(\".FixAll\").on(\"click\", function(e) {\n\t\t\t\t\n\t\t\t\te.preventDefault();\n\t\t\t\tvar id = \$(this).attr('id');\n\n\t\t\t\t\$.get( \$(this).attr('href') , function( data ) { \n\t\t\t\t\t\$(\"#RES\" + id).html(data);\n\t\t\t\t});\n\t\t\t\t\n\t\t\t\treturn false;\n\t\t\t});\n\t\t\t\n\t\t});\n\t\t</script>";
        if( $this->admin['level'] == 1 ) 
        {
            echo "<script>\n\t\t\t\$.fn.editable.defaults.mode = 'pop';     \n\t\t\t\$('.editInPlace').editable({\n\t\t\t\turl: '";
            echo $this->base;
            echo "/EditStbCh?NH=1',\n\t\t\t\tsuccess: function(response) {\n\t\t\t\t//alert(response);\n\t\t\t\t}\n\t\t\t});\n\t\t\t\n\t\t\t\n\t\t\t\$('.editableSTBgroup').editable({\n\t\t\t\turl: '";
            echo $this->base;
            echo "/EditStbCh?NH=1',\n\t\t\t\tsuccess: function(response) {\n\t\t\t\t//alert(response);\n\t\t\t\t},\n\t\t\t\t/*value: 2,*/\n\t\t\t\tsource: [";
            echo $this->js_stb_groups();
            echo "]\n\t\t\t});\n\t\t\t\n\t\t\t</script>\n\t\t";
        }
    }
    public function EditStbCh()
    {
        global $intro;
        $data = [];
        $id = intval($intro->input->get_post('pk'));
        $name = trim($intro->input->get_post('name'));
        $value = trim($intro->input->get_post('value'));
        $data[$name] = $value;
        if( $this->admin['level'] == 1 ) 
        {
            $intro->db->update('' . PREFIX . '_stb_to_iptv', $data, 'id=' . $id);
        }
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $intro->db->query('delete from ' . PREFIX . ('_stb_to_iptv WHERE id=' . $id . ' '));
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $ch_id;
        global $stb_ch_name;
        global $stb_group;
        if( $_GET != null ) 
        {
            @extract($_GET);
        }
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $btn = [];
        $qryLoc = $qryRem = '';
        if( $this->admin['level'] != 1 ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
        $id = intval($intro->input->get_post('id'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        $this->nav();
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * FROM ' . PREFIX . ('_stb_to_iptv where id=' . $id . ';'));
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $btn['legend_name'] = ' Edit <b>' . $id . ' | ' . $stb_ch_name . '</b>';
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = 'Add New Sat2IPTV channel';
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = 'Add New';
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            $qryLoc = ' WHERE type=1 AND `id` NOT IN (SELECT ch_id FROM ' . PREFIX . '_stb_to_iptv) ';
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ', 'primary');
        echo "\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\n\t\t<table class=\"table table-bordered\">\n\t\t\n\t\t<tr>\n\t\t\t<td class=\"success\">Local Channel : </td>\n\t\t\t<td class=\"warning\">STB Channel Name: </td>\n\t\t\t<td class=\"warning\">STB Group: </td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td class=\"success\">" . $this->ch_local($ch_id, $qryLoc) . ('  ' . $this->error('ch_id') . "</td>\n\t\t\t<td class=\"warning\"><input type=\"text\" name=\"stb_ch_name\"  value=\"" . $stb_ch_name . '" class="form-control">   ' . $this->error('stb_ch_name') . "</td>\n\t\t\t<td class=\"warning\"> ") . $this->selGroup($stb_group) . ('   ' . $this->error('stb_group') . "</td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t<td colspan=\"3\">\n\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\n\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $id . "\">\n\t\t\t\t<button type=\"submit\" class=\"btn btn-success\">\n\t\t\t\t<span class=\"" . $btn['img_icon'] . '"></span> ' . $btn['name'] . " \n\t\t\t\t</button>\n\t\t\t\t\n\t\t\t</td>\n\t\t</tr>\n\t\t</table>\n\t\t</form>");
    }
    public function ch_local($ch_id, $qry = '')
    {
        global $intro;
        $html = '<select name="ch_id">';
        $sql = $intro->db->query('SELECT id,stream_display_name from `streams` ' . $qry . ' ORDER BY stream_display_name ASC;');
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $i++;
            $id = $row['id'];
            $stream_display_name = $row['stream_display_name'];
            $html .= ('<option value="' . $id . '" ' . (($ch_id == $id ? 'selected="selected"' : '')) . ('>' . $stream_display_name . '</option>'));
        }
        $html .= '</select>';
        return $html;
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        $ch_id = intval($intro->input->post('ch_id'));
        $stb_ch_name = trim($intro->input->post('stb_ch_name'));
        $stb_group = intval($intro->input->post('stb_group'));
        if( $ch_id == 0 || $stb_group == 0 || $stb_ch_name == '' ) 
        {
            if( $ch_id == 0 ) 
            {
                $error['ch_id'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $stb_group == 0 ) 
            {
                $error['stb_group'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $stb_ch_name == '' ) 
            {
                $error['stb_ch_name'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            $this->Form('add');
            exit();
        }
        $data = [];
        $data['ch_id'] = $ch_id;
        $data['stb_ch_name'] = $stb_ch_name;
        $data['stb_group'] = $stb_group;
        $intro->db->insert(PREFIX . '_stb_to_iptv', $data);
        $intro->redirect($this->appname);
    }
    public function doEdit()
    {
        global $intro;
        global $error;
        $ch_id = intval($intro->input->post('ch_id'));
        $stb_ch_name = trim($intro->input->post('stb_ch_name'));
        $id = intval($intro->input->post('id'));
        $stb_group = intval($intro->input->post('stb_group'));
        if( $ch_id == 0 || $stb_group == 0 || $stb_ch_name == '' || $id == 0 ) 
        {
            if( $ch_id == 0 ) 
            {
                $error['ch_id'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $stb_group == 0 ) 
            {
                $error['stb_group'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $stb_ch_name == '' ) 
            {
                $error['stb_ch_name'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $id == 0 ) 
            {
                $error['ch_id'] = '<span class=error>Error with ID!!!</span>';
                $error['stb_ch_name'] = '<span class=error>Error with ID!!!</span>';
            }
            $this->Form('edit');
            exit();
        }
        $data = [];
        $data['ch_id'] = $ch_id;
        $data['stb_ch_name'] = $stb_ch_name;
        $data['stb_group'] = $stb_group;
        $intro->db->update(PREFIX . '_stb_to_iptv', $data, 'id=' . $id);
        $intro->redirect($this->appname);
    }
    public function Groups()
    {
        global $intro;
        global $array;
        $this->nav();
        $search_txt = trim($intro->input->get_post('search_txt'));
        $qry = '';
        if( $search_txt != '' ) 
        {
            $qry = ' where stb_gname  LIKE \'%' . $search_txt . '%\' ';
        }
        $text = 'SAT to IPTV Groups';
        $order = trim($intro->input->get('order'));
        $page = trim($intro->input->get('page'));
        if( !isset($order) || $order == '' ) 
        {
            $order = 'stb_gid_asc';
        }
        $order = str_replace('_desc', ' desc', $order);
        $order = str_replace('_asc', ' asc', $order);
        $rows_per_page = 50;
        if( !isset($page) || $page == '' ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $result = $intro->db->query('SELECT * from ' . PREFIX . ('_stb_groups ' . $qry . ' order by ' . $order . '  limit ' . $nexlimit . ',' . $rows_per_page));
        $resultnumm = $intro->db->query('SELECT stb_gid from ' . PREFIX . ('_stb_groups ' . $qry));
        $totrows = mysqli_num_rows($result);
        $totalrows = mysqli_num_rows($resultnumm);
        echo "\n\t\t<fieldset><legend> Add new STB to IPTV Group</legend>\n\t\t\t<form action=\"" . $this->base . "/doAddGroup\" id=\"frmAddGroup\" method=\"post\">\n\t\t\t\tGoup Name: <input type=\"text\" name=\"stb_gname\" value=\"\" size=\"20\">\n\t\t\t\t<input name=\"name\" value=\" Add \" type=\"submit\">\n\t\t\t</form>\n\t\t</fieldset>";
        echo '<fieldset><legend> ' . $text . ' (' . $totalrows . ')</legend>';
        echo "\n\t\t<form action=\"" . $this->base . "/index\" method=\"post\">\n\t\t\t<input type=\"text\" name=\"search_txt\" value=\"" . $search_txt . "\" size=\"20\" placeholder=\"Goup Name\">\n\t\t\t<input type=\"hidden\" name=\"maa\" value=\"Main\">\n\t\t\t<input name=\"name\" value=\" Search \" type=\"submit\">\n\t\t</form>";
        echo "<script>\n\t\t\$(document).ready(function(){\n\t\t\t\n\t\t\t\$(\"#frmAddGroup\").submit( function(e) {   \n\t\t\t\te.preventDefault();\n\t\t\t\t\n\t\t\t\t\$.post('" . $this->base . "/doAddGroup?NH=1',\$(this).serialize(),function(data){\n\n\t\t\t\t\talert(data);\n\t\t\t\t\tlocation.reload();\n\t\t\t\t});\n\t\t\t\treturn false;   \n\t\t\t});\n\t\t});\n\t\t</script>";
        echo "<table class=\"DataTable table table-bordered table-condensed\">\n\t\t<thead>\n\t\t\t<tr>\n\t\t\t\t<th class=\"center\"><b>ID</b> \n\t\t\t\t<th><b>Group Name</b></th>\n\t\t\t\t<th class=\"center\"><b>Options</b></th>\n\t\t\t</tr>\n\t\t</thead>\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            extract($myrow);
            $i++;
            echo "\n\t\t\t<tr class=\"" . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\n\t\t\t\t<td class=\"c\">" . $stb_gid . "</td>\n\t\t\t\t<td><span class=\"editableGroup\" data-type=\"text\" data-pk=\"" . $stb_gid . '" data-name="stb_gname">') . $stb_gname . ("</span></th>\n\n\t\t\t\t<td class=\"center\"> \n\t\t\t\t\n\t\t\t\t<!--\n\t\t\t\t\t<a class=\"btn btn-danger p_del intro_ui_del\" href=\"" . $this->base . '/Del?stb_gid=' . $stb_gid . '"  title="') . $intro->lang['del'] . "\"><i class=\"icon-cancel-circled2\"></i></a>\n\t\t\t\t-->\n\t\t\t\t</td>\n\t\t\t</tr>";
        }
        echo "\n\t\t</tbody>\n\t\t</table>";
        $order = str_replace(' desc', '_desc', $order);
        $order = str_replace(' asc', '_asc', $order);
        echo '<center>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?search_txt=' . $search_txt . '&order=' . $order, $totalrows, $rows_per_page, $page) . '</center>';
        echo '</fieldset>';
        echo "<script>\n\t\t\$.fn.editable.defaults.mode = 'inline';     \n\t\t\$('.editableGroup').editable({\n\t\t\turl: '" . $this->base . "/EditInPlaceGroup?NH=1',\n\t\t\tsuccess: function(response) {\n\t\t\talert(response);\n\t\t\t}\n\t\t});\n\t\t</script>";
    }
    public function EditInPlaceGroup()
    {
        global $intro;
        $id = intval($intro->input->get_post('pk'));
        $name = trim($intro->input->get_post('name'));
        $value = trim($intro->input->get_post('value'));
        $data = [];
        $data[$name] = $value;
        $intro->db->update(PREFIX . '_stb_groups', $data, 'stb_gid=' . $id);
        echo " \n Update Success!";
    }
    public function selGroup($comp = 0)
    {
        global $intro;
        $html = "<select name=\"stb_group\" id=\"stb_group\" style=\"width:250px;\">\n\n\t\t<option value=\"0\" selected='selected'> Choose </options>\n";
        $sql = $intro->db->query('SELECT * from ' . PREFIX . '_stb_groups order by stb_gname ASC');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $html .= ('<option value="' . $stb_gid . '" ' . (($comp == $stb_gid ? 'selected=\'selected\'' : '')) . ('>' . $stb_gname . "</options>\n"));
        }
        $html .= "</select>\n";
        return $html;
    }
    public function js_stb_groups()
    {
        global $intro;
        $js_data = [];
        $sql = $intro->db->query('SELECT * from ' . PREFIX . '_stb_groups order by stb_gname ASC');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $js_data[] = '{value: \'' . $stb_gid . '\', text: \'' . $stb_gname . '\'}';
        }
        return implode(',', $js_data);
    }
    public function doAddGroup()
    {
        global $intro;
        $stb_gname = trim($intro->input->post('stb_gname'));
        if( $stb_gname == '' ) 
        {
            exit( '<span class="label label-danger">Required!</label>' );
        }
        $data = [];
        $data['stb_gname'] = $stb_gname;
        $intro->db->insert(PREFIX . '_stb_groups', $data);
        echo 'Success!';
    }
}
