<?php
/**
 * Bulk Actions Handler for Streams
 * This file handles bulk actions (Delete, Restart, Stop, Disable) without modifying original code
 */

// Include the main configuration
define('_CHECK_X_ME', true);
require_once(dirname(__FILE__) . '/../load2.php');
require_once(dirname(__FILE__) . '/../includes/AdminStreams.php');

// Get the action from the request
$action = isset($_GET['action']) ? trim($_GET['action']) : '';

// Initialize the AdminStreams class
$adminStreams = new AdminStreams();
$adminStreams->appname = 'streams';
$adminStreams->base = admin_path . 'index.php/streams';
$adminStreams->type = 1;

// Handle the action
switch($action) {
    case 'BulkDelete':
        $adminStreams->BulkDelete();
        break;

    case 'BulkRestart':
        $adminStreams->BulkRestart();
        break;

    case 'BulkStop':
        $adminStreams->BulkStop();
        break;

    case 'BulkDisable':
        $adminStreams->BulkDisable();
        break;

    default:
        echo '<span class="text-danger">Invalid action</span>';
        break;
}
exit;
