<?php 
class Streams_created_AppAdmin extends AdminStreams
{
    public $type = 3;
    public $adminRow = [];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->admin = $intro->auth->sess_admin();
        $this->adminRow = $intro->auth->admin_data($this->admin['adminid']);
        if( !in_array($this->admin['level'], [
            1, 
            5, 
            8, 
            9
        ]) && $this->adminRow['manage_streams'] != 1 ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->app_name = 'Created Channels';
        $this->app_add = 'Add new Created Channel';
        $this->app_edit = 'Edit Created Channel';
        $this->app_color = 'danger';
        $this->app_icon = 'icon-edit-1';
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        $missing = $intro->db->dcount('id', 'streams', 'type=3 AND id NOT IN (select stream_id from streams_sys)');
        echo "<div class=\"app_nav\">\r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . '/index"><icon class="icon-list"></icon>' . $this->app_name . '</a> ');
        if( $this->admin['level'] == 1 ) 
        {
            echo '<a class="btn btn-' . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="' . $this->base . '/Form?t=add"><icon class="icon-plus-squared"></icon>' . $this->app_add . '</a>');
        }
        if( $missing > 0 ) 
        {
            echo '<br/><br/><a class="btn btn-danger blinking" href="' . $this->base . '/index?view=missing"> <icon class="icon-list"></icon> Streams Missing Server (' . $missing . ')</a>';
        }
        echo '</div>';
    }
}
