<?php 
class Tools_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $counter = 0;
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->admin = $intro->auth->sess_admin();
        if( !in_array($this->admin['level'], [
            1, 
            9
        ]) ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->time5ago = strtotime('-5 day');
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function CleanDB()
    {
        global $intro;
        global $sess_admin;
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "<div class=\"app_nav\">\r\n\t\t\r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . "/quick\"><icon class=\"icon-cog\"> Tools </icon></a> \r\n\t\t</div>");
    }
    public function index()
    {
        global $intro;
        global $array;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' Quick Tools ', 'info');
        echo "\r\n\t\t<table class=\"table table-bordered table-hover\">\r\n\t\t<tr>\r\n\t\t\t<td>  :</td>\r\n\t\t\t<td> </td>\r\n\t\t</tr>\r\n\t\t</table>";
        _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function quick()
    {
        global $intro;
        global $array;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' Quick Tools ', 'info');
        $ago3 = strtotime('-3 day');
        $trial_user = $intro->db->dcount('id', 'users', 'is_trial=1 and exp_date < \'' . $ago3 . '\'');
        $expire_user = $intro->db->dcount('id', 'users', 'exp_date < \'' . $this->time5ago . '\' AND exp_date !=\'\' AND exp_date!=0 AND is_restreamer=0');
        $is_isplock = $intro->db->dcount('id', 'users', 'is_isplock=1');
        $isp_desc = $intro->db->dcount('id', 'users', 'is_isplock=1 AND (isp_desc!=\'\' OR isp_desc IS NOT NULL) ');
        echo "\r\n\t\t<table class=\"table table-bordered table-hover\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td align=center class='col-md-3'><span class=\"icon-users\"></span> Trial Accounts :</td>\r\n\t\t\t\t<td align=center class='col-md-3'>\r\n\t\t\t\t\t<div class=\"form-inline\">Passed Days: <input class=\"form-control\" type=\"number\" name=\"days\" id=\"days_trials\" value=\"3\" max=\"10\" min=\"0\" style=\"width:70px;\"></div>\r\n\t\t\t\t\t<a class=\"btn btn-danger icon-trash runAjaxQickTools\" data-target=\"result_1\" url=\"" . $this->base . "/delete_trial?NH=1\" id='delete_trial'>\r\n\t\t\t\t\t\tDelete Trial Accounts (" . $trial_user . ")\r\n\t\t\t\t\t\t</a>\r\n\t\t\t\t<div id=\"result_1\"></div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td align=center class='col-md-3' >\r\n\t\t\t\t\t<span style='color:#666666'>\r\n\t\t\t\t\tThis will delete all expired trials who has been expired for 3 days.<br>\r\n\t\t\t\t\tSet Passed Days: 0 to delete all now.</span>\r\n\t\t\t\t</td>\r\n\t\t\t\t\r\n\t\t\t</tr>\t\r\n\t\t\t<tr>\r\n\t\t\t\t<td align=center class='col-md-3'><span class=\"icon-users\"></span> Delete expired users :</td>\r\n\t\t\t\t<td align=center class='col-md-3'>\r\n\t\t\t\t\t<div class=\"form-inline\">Passed Days: <input class=\"form-control\" type=\"number\" name=\"days\" id=\"days_offi\" value=\"5\" max=\"10\" min=\"0\" style=\"width:70px;\"></div>\r\n\t\t\t\t\t<a class=\"btn btn-danger icon-trash runAjaxQickTools\" data-target=\"result_954\" url=\"" . $this->base . "/delete_expired?NH=1\" id='delete_expire'>\r\n\t\t\t\t\t\tDelete Expired Users (" . $expire_user . ")\r\n\t\t\t\t\t</a>\r\n\t\t\t\t\t\r\n\t\t\t\t\t<div id=\"result_954\"></div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td align=center class='col-md-3' ><span style='color:#666666'>This will delete all expired users who has been expired for 5 days.\r\n\t\t\t\t<br>\r\n\t\t\t\tif the user is expired today, after 5 days of expiry you can delete it.<br/>\r\n\t\t\t\tso users have 5 days to decide renewal.\r\n\t\t\t\t</span></td>\r\n\t\t\t\t\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td align=center class='col-md-3'><span class=\"icon-globe\"></span>Remove ISP Lock :</td>\r\n\t\t\t\t<td align=center class='col-md-3'><a class=\"btn btn-warning icon-check-empty runAjaxQickTools\" data-target=\"result_2\" url=\"" . $this->base . '/removeisp?NH=1" id=\'remove_isp\' >Remove ISP Lock (' . $isp_desc . ")</a>\r\n\t\t\t\t<div id=\"result_2\"></div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td align=center class='col-md-3' ><span style='color:#666666'>Remove Current ISP Lock for users.\r\n\t\t\t\t<br>Users can connect from new ISP.</span></td>\r\n\t\t\t\t\r\n\t\t\t</tr>\t\r\n\t\t\t\r\n\t\t\t<tr>\r\n\t\t\t\t<td align=center class='col-md-3'><span class=\"icon-lock-open\"></span>Disable ISP Lock :</td>\r\n\t\t\t\t<td align=center class='col-md-3'><a class=\"btn btn-warning icon-lock-open runAjaxQickTools\" data-target=\"result_3\" url=\"" . $this->base . '/Disableisp?NH=1" id=\'Disable_isp\'>Disable ISP Lock (' . $is_isplock . ")</a>\r\n\t\t\t\t<div id=\"result_3\"></div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td align=center class='col-md-3' ><span style='color:#666666'>Disable ISP Lock Option for all users.\r\n\t\t\t\t<br>Users will no longer be ISP locked and they will be free to connect from everywhere.</span></td>\r\n\t\t\t\t\r\n\t\t\t</tr>\t\r\n\t\t\t<tr>\r\n\t\t\t\t<td align=center class='col-md-3'><span class=\"icon-bug\"></span>Fix User Out Put (ts|hls|rtmp) :</td>\r\n\t\t\t\t<td align=center class='col-md-3'><a class=\"btn btn-info icon-bug runAjaxQickTools\" data-target=\"result_99\" url=\"" . $this->base . "/fixOutPut?NH=1\">Fix User Out Put</a>\r\n\t\t\t\t<div id=\"result_99\"></div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td align=center class='col-md-3' ><span style='color:#666666'>This will set the missing user out put like(ts|hls|rtmp).\r\n\t\t\t\t<br/> and also cleans unsed ones from database.</td>\r\n\t\t\t\t\r\n\t\t\t</tr>\r\n\t\t\t\r\n\t\t\t<tr>\r\n\t\t\t\t<td align=center class='col-md-3'><span class=\"icon-bug\"></span>Fix Resellers With Users :</td>\r\n\t\t\t\t<td align=center class='col-md-3'><a class=\"btn btn-primary icon-bug runAjaxQickTools\" data-target=\"result_100\" url=\"" . $this->base . "/fixReselUser?NH=1\">Fix Resellers With Users</a>\r\n\t\t\t\t<div id=\"result_100\"></div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td align=center class='col-md-3' >\r\n\t\t\t\t\t<span style='color:#666666'>\r\n\t\t\t\t\t\tThis will fix users to resellers when copying users from other panels.\r\n\t\t\t\t</td>\r\n\t\t\t\t\r\n\t\t\t</tr>\r\n\t\t\t\r\n\t\t\t<tr>\r\n\t\t\t\t<td align=center class='col-md-3'><span class=\"icon-lock-open-2\"></span>Remove Lock on MAG Devices:</td>\r\n\t\t\t\t<td align=center class='col-md-3'>\r\n\t\t\t\t\t<a class=\"btn btn-primary icon-lock-open-2 runAjaxQickTools\" data-target=\"result_101\"\r\n\t\t\t\t\t\turl=\"" . $this->base . "/removeMagLockDevice?NH=1\">Remove Lock On MAG</a>\r\n\t\t\t\t<div id=\"result_101\"></div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td align=center class='col-md-3' >\r\n\t\t\t\t\t<span style='color:#666666'>\r\n\t\t\t\t\t\tThis will Remove Lock On ALL MAG Devices.\r\n\t\t\t\t</td>\r\n\t\t\t\t\r\n\t\t\t</tr>\r\n\t\t\r\n\t\t\t<tr>\r\n\t\t\t\t<td align=center class='col-md-3'><span class=\"icon-reply\"></span>Transfer Streams :</td>\r\n\t\t\t\t<td align=center class='col-md-3'>\r\n\t\t\t\t\t<form method=post id='transfer' action='' >\r\n\t\t\t\t\t\t<div class='col-md-4'>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('from', 'From server', 'streaming_servers', 0, 'id', 'server_name', 'bouquet_status', 'where `status`=1', 'order by server_name asc') . "</div>\r\n\t\t\t\t\t\t<div class='col-md-4'>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('to', 'To server', 'streaming_servers', 0, 'id', 'server_name', 'bouquet_status', 'where `status`=1', 'order by server_name asc') . "\r\n\t\t\t\t\t\t\t</div>\r\n\t\t\t\t\t\t<div class='col-md-4'><button class=\"btn btn-info icon-server\" >Transfer</button></div>\r\n\t\t\t\t\t</form>\r\n\t\t\t\t\t<div id=\"result_4\"></div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td align=center class='col-md-3' ><span style='color:#888888'>\r\n\t\t\t\tThis will change the streams server LB to new one you select.\r\n\t\t\t\t<br/> you need to restart streams on target server.\r\n\t\t\t\t</td>\r\n\t\t\t\t\r\n\t\t\t</tr>\r\n\t\t\t\r\n\t\t\t<tr>\r\n\t\t\t\t<td align=center class='col-md-3'><span class=\"icon-spin3\"></span>Swap Streams :</td>\r\n\t\t\t\t<td align=center class='col-md-3'>\r\n\t\t\t\t\t<form method=post id='swap' action='' >\r\n\t\t\t\t\t\t<div class='col-md-4'>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('from', 'From server', 'streaming_servers', 0, 'id', 'server_name', 'bouquet_status', 'where `status`=1', 'order by server_name asc') . "</div>\r\n\t\t\t\t\t\t<div class='col-md-4'>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('to', 'To server', 'streaming_servers', 0, 'id', 'server_name', 'bouquet_status', 'where `status`=1', 'order by server_name asc') . "\r\n\t\t\t\t\t\t\t</div>\r\n\t\t\t\t\t\t<div class='col-md-4'><button class=\"btn btn-info icon-server\" >Swap</button></div>\r\n\t\t\t\t\t</form>\r\n\t\t\t\t\t<div id=\"result_5\"></div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td align=center class='col-md-3' ><span style='color:#888888'>\r\n\t\t\t\t\tThis will Swap streams between the servers.\r\n\t\t\t\t\t<br/>You need to restart streams on both servers.</td>\r\n\t\t\t\t\r\n\t\t\t</tr>\r\n\t\t</table>";
        _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "\t\t<script>\r\n\t\tvar spin = \"<span class='icon-spin5 animate-spin'></span>\";\r\n\t\t\$(document).ready(function() {\r\n\t\t\t\r\n\t\t\t\$( \".runAjaxQickTools\" ).click(function() {\r\n\t\t\t\tvar target = \$(this).data('target');\r\n\t\t\t\tvar resultDiv = \$(\"#\" + target );\r\n\t\t\t\tvar days_trial = \$(\"#days_trials\").val();\r\n\t\t\t\tvar days_offi = \$(\"#days_offi\").val();\r\n\t\t\t\tresultDiv.html(spin);\r\n\t\t\t\tvar url = \$(this).attr('url');\r\n\t\t\t\t\$.get( url + '&days_trial=' + days_trial+ '&days_offi=' + days_offi, function( data ) {\r\n\t\t\t\t\tresultDiv.html(data);\r\n\t\t\t\t});\t\r\n\t\t\t});\r\n\t\t\t\$( \"#transfer\" ).submit(function( event ) {\r\n\t\t\t\t\tevent.preventDefault();\r\n\t\t\t\t\tvar resultDiv = \$(\"#result_4\" );\r\n\t\t\t\t\tresultDiv.html(spin);\r\n\t\t\t\t\tvar url ='";
        echo $this->base . '/transfer?NH=1';
        echo "';\r\n\t\t\t\t\t\$.post(url ,\$(this).serialize(),\r\n\t\t\t\t\t\tfunction(data){\r\n\t\t\t\t\t\t\tresultDiv.html(data);\r\n\t\t\t\t\t\t}\r\n\t\t\t\t\t);\r\n\t\t\t});\t\t\r\n\t\t\t\$( \"#swap\" ).submit(function( event ) {\r\n\t\t\t\t\tevent.preventDefault();\r\n\t\t\t\t\tvar resultDiv = \$(\"#result_5\" );\r\n\t\t\t\t\tresultDiv.html(spin);\r\n\t\t\t\t\tvar url ='";
        echo $this->base . '/swap?NH=1';
        echo "';\r\n\t\t\t\t\t\$.post(url ,\$(this).serialize(),\r\n\t\t\t\t\t\tfunction(data){\r\n\t\t\t\t\t\t\tresultDiv.html(data);\r\n\t\t\t\t\t\t}\r\n\t\t\t\t\t);\r\n\t\t\t});\r\n\r\n\t\r\n\t\t});\r\n\t\t\r\n\t\t</script>\r\n\t\t";
    }
    public function delete_expired()
    {
        global $intro;
        $days_offi = intval($intro->input->get_post('days_offi'));
        $ago = strtotime('-' . $days_offi . ' day');
        $aff = 0;
        $expire_user = $intro->db->query('delete from users where exp_date < \'' . $ago . '\' AND exp_date !=\'\' AND exp_date!=0 AND is_restreamer=0;');
        $aff = $intro->db->affected_rows;
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Affected rows (' . $aff . ')');
    }
    public function fixReselUser()
    {
        global $intro;
        $aff = 0;
        $intro->db->query('UPDATE users set member_id=created_by WHERE member_id=0;');
        $aff = $intro->db->affected_rows;
        $intro->db->query('UPDATE users set created_by=member_id WHERE created_by=0;');
        $aff += $intro->db->affected_rows;
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Affected rows (' . $aff . ')');
    }
    public function fixOutPut()
    {
        global $intro;
        $sql = $intro->db->query('SELECT id FROM users WHERE id NOT IN (SELECT user_id from user_output WHERE access_output_id=1);');
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $i++;
            $intro->db->insert('user_output', [
                'user_id' => $row['id'], 
                'access_output_id' => 1
            ]);
        }
        $sql = $intro->db->query('SELECT id FROM users WHERE id NOT IN (SELECT user_id from user_output WHERE access_output_id=2);');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $i++;
            $intro->db->insert('user_output', [
                'user_id' => $row['id'], 
                'access_output_id' => 2
            ]);
        }
        $sql = $intro->db->query('DELETE FROM `user_output` WHERE user_id NOT IN (SELECT id FROM users)');
        $aff = $intro->db->affected_rows;
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<li> Fixed [user_output] = (' . $i . ")</li>\r\n\t\t\t<li> Cleaned [user_output] = (" . $aff . ')');
    }
    public function delete_trial()
    {
        global $intro;
        global $array;
        $aff = 0;
        $days_trial = intval($intro->input->get_post('days_trial'));
        $ago = strtotime('-' . $days_trial . ' day');
        $intro->db->query('DELETE FROM `mag_devices` where user_id IN (SELECT id FROM users where is_trial=1 and exp_date < \'' . $ago . '\' )');
        $aff += $intro->db->affected_rows;
        $intro->db->query('DELETE FROM `enigma2_devices` where user_id IN (SELECT id FROM users where is_trial=1 and exp_date < \'' . $ago . '\' )');
        $aff += $intro->db->affected_rows;
        $intro->db->query('DELETE from `users` where is_trial=1 and exp_date < \'' . $ago . '\' ');
        $aff += $intro->db->affected_rows;
        $intro->db->query(' DELETE FROM `enigma2_actions` WHERE device_id NOT IN (SELECT device_id FROM enigma2_devices) ');
        $aff += $intro->db->affected_rows;
        $intro->db->query('DELETE FROM `' . PREFIX . '_codes` where ' . (' period IN (101,103,107,110) AND status=4 AND date_expire < \'' . $ago . '\';'));
        $aff += $intro->db->affected_rows;
        $intro->db->query('DELETE FROM `' . PREFIX . '_codes` where ' . (' pkg IN (SELECT id FROM packages WHERE is_trial=1) AND status=4 AND date_expire < \'' . $ago . '\';'));
        $aff += $intro->db->affected_rows;
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Deleted rows (' . $aff . ')');
    }
    public function removeisp()
    {
        global $intro;
        global $array;
        $aff = '';
        $intro->db->query('update users set isp_desc=null;');
        $aff = $intro->db->affected_rows;
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Removed ISP Lock (' . $aff . ')');
    }
    public function removeMagLockDevice()
    {
        global $intro;
        global $array;
        $aff = '';
        $intro->db->query('update mag_devices set lock_device=0;');
        $aff = $intro->db->affected_rows;
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Removed Lock (' . $aff . ')');
    }
    public function Disableisp()
    {
        global $intro;
        global $array;
        $aff = '';
        $intro->db->query('update users set is_isplock=0  ');
        $aff = $intro->db->affected_rows;
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Disabled ISP Lock (' . $aff . ')');
    }
    public function transfer()
    {
        global $intro;
        global $array;
        $to = intval($intro->input->post('to'));
        $from = intval($intro->input->post('from'));
        $aff = '';
        if( $from == 0 || $to == 0 ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Please choose both sides', 'danger');
            exit();
        }
        if( $from == $to ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Both sides are equal!!! Choose different values.', 'danger');
            exit();
        }
        $intro->db->query('update streams_sys set server_id=\'' . $to . '\'  where server_id=\'' . $from . '\' ' . ' AND stream_id IN (select id from streams where type=1)');
        $aff = $intro->db->affected_rows;
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Transfered Streams (' . $aff . ')');
    }
    public function swap()
    {
        global $intro;
        global $array;
        $to = intval($intro->input->post('to'));
        $from = intval($intro->input->post('from'));
        $aff = '';
        if( $from == 0 || $to == 0 ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Please choose both sides', 'danger');
            exit();
        }
        if( $from == $to ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Both sides are equal!!! Choose different values.', 'danger');
            exit();
        }
        $intro->db->query('UPDATE streams_sys SET  ' . (' server_id = CASE server_id WHEN \'' . $to . '\' THEN \'' . $from . '\' WHEN \'' . $from . '\' THEN \'' . $to . '\' END ') . (' WHERE  server_id IN ( \'' . $to . '\', \'' . $from . '\' ) AND stream_id IN (select id from streams where type=1)'));
        $aff = $intro->db->affected_rows;
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Swaped Streams (' . $aff . ')');
    }
    public function String2MAC()
    {
        global $intro;
        global $array;
        $this->nav();
        $html_new_macs = '';
        $macs = $intro->input->post('macs');
        if( $macs != '' ) 
        {
            $all = explode("\n", $macs);
            foreach( $all as $oldMAC ) 
            {
                $oldMAC = preg_replace("/\r|\n/", '', trim($oldMAC));
                $split = str_split($oldMAC, 2);
                $mac = implode(':', $split);
                $html_new_macs .= ($mac . "\n");
            }
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h3>Convert Done.</h3>', 'success');
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('String to MAC', 'info');
        echo "\r\n\t\t<h3>Convert MAC from (3034D20A9630) to (30:34:D2:0A:96:30)</h3>\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/String2MAC\" enctype=\"multipart/form-data\">\r\n\t\t<table class=\"table table-bordered table-hover\">\r\n\t\t<tr>\r\n\t\t\t<td>Paste MACs Here:\r\n\t\t\t\t<br/>example\r\n\t\t\t\t<br/>3034D20A9630\r\n\t\t\t\t<br>2024D20A9632\r\n\t\t\t\t<br>5034D20A9639\r\n\t\t\t</td>\r\n\t\t\t<td style='width:70%'><textarea name='macs' style='width:95%;height:200px'>" . $html_new_macs . "</textarea></td>\r\n\t\t</tr>\r\n\r\n\t\t<tr>\r\n\t\t\t<td>\r\n\t\t\t</td>\r\n\t\t\t<td>\r\n\t\t\t\t\r\n\t\t\t\t<button class=\"btn btn-success\" type=\"submit\">\r\n\t\t\t\t\t<i class=\"icon-floppy\"> </i> Convert\r\n\t\t\t\t</button>\t\t\t\t\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>";
        echo "\t\t<script>\r\n\t\t\$(document).on('keyup', \"input[name='master_code']\", function(e) {\r\n\t\t\t\$('#mc_counter').html(\$(this).val().length);\r\n\t\t});\r\n\t\t</script>\r\n\t\t";
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('String to MAC By TransID', 'warning');
        echo "\r\n\t\t<h3>Convert MAC from (3034D20A9630) to (30:34:D2:0A:96:30) By TransID</h3>\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/byTransID\" enctype=\"multipart/form-data\">\r\n\t\t<table class=\"table table-bordered table-hover\">\r\n\t\t<tr>\r\n\t\t\t<td>By TransID\r\n\t\t\t</td>\r\n\t\t\t<td style='width:70%'><input type=\"text\" name=\"transid\" /></td>\r\n\t\t</tr>\r\n\r\n\t\t<tr>\r\n\t\t\t<td>\r\n\t\t\t</td>\r\n\t\t\t<td>\r\n\t\t\t\t\r\n\t\t\t\t<button class=\"btn btn-success\" type=\"submit\">\r\n\t\t\t\t\t<i class=\"icon-floppy\"> </i> Convert by TransID\r\n\t\t\t\t</button>\t\t\t\t\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>";
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' MAC to String By TransID', 'warning');
        echo "\r\n\t\t<h3>Convert MAC from (30:34:D2:0A:96:30) to (3034D20A9630) By TransID</h3>\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/byTransID_mac2str\" enctype=\"multipart/form-data\">\r\n\t\t<table class=\"table table-bordered table-hover\">\r\n\t\t<tr>\r\n\t\t\t<td>By TransID\r\n\t\t\t</td>\r\n\t\t\t<td style='width:70%'><input type=\"text\" name=\"transid\" /></td>\r\n\t\t</tr>\r\n\r\n\t\t<tr>\r\n\t\t\t<td>\r\n\t\t\t</td>\r\n\t\t\t<td>\r\n\t\t\t\t\r\n\t\t\t\t<button class=\"btn btn-success\" type=\"submit\">\r\n\t\t\t\t\t<i class=\"icon-floppy\"> </i> Convert by TransID MAC to String\r\n\t\t\t\t</button>\t\t\t\t\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>";
    }
    public function CheckLine()
    {
        global $intro;
        global $array;
        $this->nav();
        $html_new_macs = '';
        $m3u = $intro->input->post('url');
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Check m3u Streaming Line', 'info');
        echo "\r\n\t\t<h3> This will give you full info of the m3u line. </h3>\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/CheckLine\" >\r\n\t\t<table class=\"table table-bordered table-hover\">\r\n\t\t<tr>\r\n\t\t\t<td>m3u url:</td>\r\n\t\t\t<td><input type=\"text\" name=\"url\" value=\"" . $m3u . "\" class=\"form-control\" /></td>\r\n\t\t</tr>";
        if( $intro->input->post('url') != '' ) 
        {
            $url = parse_url($intro->input->post('url'));
            $scheme = (isset($url['scheme']) ? $url['scheme'] : '');
            $host = (isset($url['host']) ? $url['host'] : '');
            $port = (isset($url['port']) ? $url['port'] : 80);
            $path = (isset($url['path']) ? $url['path'] : '');
            $query = (isset($url['query']) ? $url['query'] : '');
            parse_str($query, $params);
            $u = (isset($params['username']) ? $params['username'] : '');
            $p = (isset($params['password']) ? $params['password'] : '');
            if( $u == '' && $p == '' ) 
            {
                $ex = explode('/', $path);
                if( count($ex) > 3 ) 
                {
                    $pos_u = count($ex) - 3;
                    $pos_p = count($ex) - 2;
                    $u = $ex[$pos_u];
                    $p = $ex[$pos_p];
                }
            }
            if( $u != '' && $p != '' ) 
            {
                $full_url = $scheme . '://' . $host . ':' . $port . ('/panel_api.php?username=' . $u . '&password=' . $p);
                $json = @file_get_contents($full_url, false, @stream_context_create([
                    'http' => ['timeout' => 2]
                ]));
                if( strlen($json) > 200 ) 
                {
                    $data = json_decode($json, true);
                    if( is_array($data) ) 
                    {
                        $auth = $data['user_info']['auth'];
                        $status = $data['user_info']['status'];
                        $exp_date = $data['user_info']['exp_date'];
                        $is_trial = $data['user_info']['is_trial'];
                        $active_cons = $data['user_info']['active_cons'];
                        $max_connections = $data['user_info']['max_connections'];
                        echo "\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>Login Success:</td>\r\n\t\t\t\t\t\t<td>" . (($auth == 1 ? '<span class=\'label label-success\'>Yes</span>' : '<span class=\'label label-danger\'>No</span>')) . "</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>Status:</td>\r\n\t\t\t\t\t\t<td>" . ((preg_match('/Active/i', $status) ? '<span class=\'label label-success\'>Active</span>' : '<span class=\'label label-danger\'>' . $status . '</span>')) . ("</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>Max Connections:</td>\r\n\t\t\t\t\t\t<td>" . $max_connections . "</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>Active Connections:</td>\r\n\t\t\t\t\t\t<td>" . $active_cons . "</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>Expire:</td>\r\n\t\t\t\t\t\t<td>") . (($exp_date == '' ? '<span style="color:#59b300">Unlimited</span>' : date('Y-m-d H:i:s', $exp_date))) . "</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>Trial:</td>\r\n\t\t\t\t\t\t<td>" . (($is_trial == 1 ? 'Yes' : 'No')) . "</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td> </td>\r\n\t\t\t\t\t\t<td> <a href=\"" . str_replace('panel_api', 'get', $full_url) . "&type=m3u&output=ts\" class=\"btn btn-info\"> Click here to Download m3u list</a></td>\r\n\t\t\t\t\t</tr>";
                    }
                }
            }
        }
        echo "\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\t<button class=\"btn btn-success\" type=\"submit\">\r\n\t\t\t\t\t<i class=\"icon-floppy\"> </i> Check Line\r\n\t\t\t\t</button>\t\t\t\t\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function str_split_unicode($str, $length = 1)
    {
        $tmp = preg_split('~~u', $str, -1, PREG_SPLIT_NO_EMPTY);
        if( $length > 1 ) 
        {
            $chunks = array_chunk($tmp, $length);
            foreach( $chunks as $i => $chunk ) 
            {
                $chunks[$i] = join('', (array)$chunk);
            }
            $tmp = $chunks;
        }
        return $tmp;
    }
    public function byTransID_mac2str()
    {
        global $intro;
        global $array;
        $this->nav();
        $id = intval($intro->input->get_post('transid'));
        $sql = $intro->db->query('select id,mac from solus_codes where transid=' . $id . ' and inputBy=1;');
        $tot = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' <h3>By TransID (' . $id . ') , Total (' . $tot . ') </h3>', 'info');
        $i = $total = 0;
        echo '<textarea name=\'macs\' style=\'width:95%;height:200px\'>';
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $id = intval($row['id']);
            $oldMAC = preg_replace("/\r|\n/", '', trim($row['mac']));
            if( preg_match('/:/', $oldMAC) ) 
            {
                $mac = str_replace(':', '', $oldMAC);
                $intro->db->query('update solus_codes set mac=\'' . $mac . '\' where id=' . $id . ';');
                $aff = $intro->db->affected_rows;
                $total += $aff;
                echo $oldMAC . " \t " . $mac . " \t result=" . $aff . "\n";
                continue;
            }
            echo $oldMAC . " \t \t Already Done. \n";
        }
        echo '</textarea>';
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h1>Success! total updated (' . $total . ') </h1>', 'success');
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function byTransID()
    {
        global $intro;
        global $array;
        $this->nav();
        $id = intval($intro->input->get_post('transid'));
        $sql = $intro->db->query('select id,mac from solus_codes where transid=' . $id . ' and inputBy=1;');
        $tot = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' <h3>By TransID (' . $id . ') , Total (' . $tot . ') </h3>', 'info');
        $i = 0;
        echo '<textarea name=\'macs\' style=\'width:95%;height:200px\'>';
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $id = intval($row['id']);
            $oldMAC = preg_replace("/\r|\n/", '', trim($row['mac']));
            if( preg_match('/:/', $oldMAC) ) 
            {
                echo $oldMAC . " \t \t Already Done. \n";
                continue;
            }
            $split = str_split($oldMAC, 2);
            $mac = implode(':', $split);
            $intro->db->query('update solus_codes set mac=\'' . $mac . '\' where id=' . $id . ';');
            $aff = $intro->db->affected_rows;
            echo $oldMAC . " \t " . $mac . " \t result=" . $aff . "\n";
        }
        echo '</textarea>';
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h1>Success!</h1>', 'success');
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function UpdateAPK()
    {
        global $intro;
        global $array;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' Update Android APK ', 'info');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/xxxx\" enctype=\"multipart/form-data\">\r\n\t\t<table class=\"table table-bordered table-hover\">\r\n\t\t<tr>\r\n\t\t\t<td>APK URL:</td>\r\n\t\t\t<td><input dir=ltr type=\"text\" name=\"vod_kids\" value=\"xxxx\" class=\"form-control\" /> \r\n\t\t\t\t<br/> Example:\r\n\t\t\t\t<br/> يمكن اضافة رابط من play store\r\n\t\t\t\t<br/> <span style='color:gray'>https://play.google.com/store/apps/details?id=org.videolan.vlc</span>\r\n\t\t\t\t<br/> يمكن اضافة رابط تحميل التطبيق المباشر\r\n\t\t\t\t<br/> <span style='color:gray'>https://hostname.com/appname.apk</span>\r\n\t\t\t\t<br/> او رابط لصفحة مشروح بها طريقة تحديث التطبيق بالتفصيل\r\n\t\t\t\t<br> <span style='color:gray'>https://hostname.com/how_to_update_your_android_app</span>\r\n\t\t\t\t</td>\r\n\t\t</tr>\r\n\r\n\t\t<tr>\r\n\t\t\t<td>\r\n\t\t\t</td>\r\n\t\t\t<td>\r\n\t\t\t\t\r\n\t\t\t\t<button class=\"btn btn-success\" type=\"submit\">\r\n\t\t\t\t\t<i class=\"icon-floppy\"> </i> Send\r\n\t\t\t\t</button>\t\t\t\t\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>";
        echo "\t\t<script>\r\n\t\t\$(document).on('keyup', \"input[name='master_code']\", function(e) {\r\n\t\t\t\$('#mc_counter').html(\$(this).val().length);\r\n\t\t});\r\n\t\t</script>\r\n\t\t";
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        foreach( $_POST as $key => $val ) 
        {
            if( $key != 'maa' && $key != 'B1' && $key != 'app_name' && $key != 'app_action' ) 
            {
                $val = $intro->input->post($key);
                $val = addslashes($val);
                $val = trim($val);
                $this->OptionsCheckNew($key);
                $intro->db->query('update ' . PREFIX . ('_options set val=\'' . $val . '\' where name=\'' . $key . '\''));
            }
        }
        $intro->redirect($this->appname);
    }
    public function OptionsCheckNew($name)
    {
        global $intro;
        $sql = $intro->db->query('select * from ' . PREFIX . ('_options where name=\'' . $name . '\''));
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $intro->db->insert(PREFIX . '_options', ['name' => $name]);
        }
    }
    public function ImportCode2()
    {
        global $intro;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' codes2', 'info');
        $sql = $intro->db->query("select * from solus_codes2 WHERE \r\n\t\tcode NOT IN (select code from solus_codes) \r\n\t\tAND `status`!=4\r\n\t\torder by `status` ASC");
        echo "<table border=1>\r\n\t\t<tr>\r\n\t\t\t\t<td>#</td>\r\n\t\t\t\t<td>code</td>\r\n\t\t\t\t<td>code username</td>\r\n\t\t\t\t<td>status</td>\r\n\t\t\t\t<td>expire</td>\r\n\t\t\t\t<td>media star expired</td>\r\n\t\t\t\t<td>MACs</td>\r\n\t\t\t\t<td>SERIALs</td>\r\n\t\t\t</tr>";
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $i++;
            $status = $row['status'];
            unset($row['id']);
            $intro->db->insert('solus_codes', $row);
            $insertedID = $intro->db->insert_id();
            $sql2 = $intro->db->query('select * from solus_codes WHERE code=\'' . $row['code'] . '\'');
            $row2 = $intro->db->fetch_assoc($sql2);
            $expire = (time() <= $row['date_expire'] ? date('Y-m-d', $row['date_expire']) : '');
            $media_expire = (time() <= $row2['date_expire'] ? date('Y-m-d', $row2['date_expire']) : '');
            echo "<tr>\r\n\t\t\t\t\t\t<td>" . $i . "</td>\r\n\t\t\t\t\t\t<td>" . $row['code'] . "</td>\r\n\t\t\t\t\t\t<td>" . $row['username'] . "</td>\r\n\t\t\t\t\t\t<td>" . $intro->status[$status] . "</td>\r\n\t\t\t\t\t\t<td>" . (($expire != $media_expire ? $expire : 'ok')) . "</td>\r\n\t\t\t\t\t\t<td>" . (($expire != $media_expire ? $media_expire : 'ok')) . "</td>\r\n\t\t\t\t\t\t<td>" . (($row['mac'] != $row2['mac'] ? $row['mac'] . '|' . $row2['mac'] : 'ok')) . "</td>\r\n\t\t\t\t\t\t<td>" . (($row['serial'] != $row2['serial'] ? $row['serial'] . '|' . $row2['serial'] : 'ok')) . ("</td>\r\n\t\t\t\t\t\t<td>" . $insertedID . "</td>\r\n\t\t\t</tr>");
        }
        echo '</table>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function ImportUsers2()
    {
        global $intro;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' users2', 'info');
        $sql = $intro->db->query("select * from users2 WHERE \r\n\t\tusername NOT IN (select username from users) \r\n\t\torder by `id` ASC");
        echo "<table border=1>\r\n\t\t<tr>\r\n\t\t\t\t<td>#</td>\r\n\t\t\t\t<td>username</td>\r\n\t\t\t\t<td> </td>\r\n\t\t\t\t<td></td>\r\n\t\t\t\t<td>expire</td>\r\n\t\t\t</tr>";
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $i++;
            $id = $row['id'];
            unset($row['id']);
            $insertedID = $intro->db->insert_id();
            echo "<tr>\r\n\t\t\t\t\t\t<td>" . $i . "</td>\r\n\t\t\t\t\t\t<td>" . $row['username'] . "</td>\r\n\t\t\t\t\t\t<td>" . ((time() <= $row['exp_date'] ? date('Y-m-d', $row['exp_date']) : '')) . ("</td>\r\n\t\t\t\t\t\t<td></td>\r\n\t\t\t\t\t\t<td>" . $insertedID . "</td>\r\n\t\t\t</tr>");
        }
        echo '</table>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function ClearCache()
    {
        global $intro;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Clear Cache ... ', 'info');
        $this->deleteAll('./cache/');
        $this->deleteAll('./includes/cache/', '(txt|cache)');
        $this->deleteAll('./V3APK/cache/');
        $this->deleteAll('./V4APK/cache/');
        $this->deleteAll('./V5APK/cache/');
        $this->deleteAll('./V6APK/cache/');
        $this->deleteAll('./V5/cache/');
        $this->deleteAll('./V6/cache/');
        echo '<br/>';
        echo '<h3> All Cache Cleared! Total deleted files (' . $this->counter . ').</h3>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function deleteAll($str, $ext = '(txt|log)')
    {
        if( is_file($str) && preg_match('/^.+\.' . $ext . '$/', $str) ) 
        {
            $this->counter++;
            return @unlink($str);
        }
        else if( is_dir($str) ) 
        {
            $scan = glob(rtrim($str, '/') . '/*');
            foreach( $scan as $index => $path ) 
            {
                $this->deleteAll($path, $ext);
            }
        }
    }
    public function upgrade()
    {
        global $intro;
        $intro->db->query('ALTER TABLE `users` CHANGE `forced_country` `forced_country` VARCHAR(3) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL; ');
        echo '<h1> = affected_rows ' . $intro->db->affected_rows . '</h1>';
    }
    public function linux()
    {
        global $intro;
        echo $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Linux commands');
        echo "\r\n\t\tList all IPs with total opened connections:\r\n\t\t<pre>netstat -tn 2>/dev/null | grep ':25461' | awk '{print \$5}' | cut -d: -f1 | sort | uniq -c | sort -nr | head</pre>\r\n\t\tNote: if you want to see other port, change 25461";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function utf8()
    {
        global $intro;
        echo $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' Convert database to UTF8 ');
        echo '<ul>';
        foreach( $intro->db->get_tables() as $table ) 
        {
            echo '<li>' . $table . '</li>';
            $intro->db->query_fast('ALTER TABLE `' . $table . '` CONVERT TO CHARACTER SET utf8 COLLATE utf8_general_ci;');
        }
        echo '</ul>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
}
