<?php 
class Users_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $qry_admin_where = '';
    public $admin = [];
    public $adminRow = [];
    public $inputBy = [
        'Code', 
        'MAC', 
        'Serial'
    ];
    public $free = [
        -1, 
        101, 
        103, 
        107, 
        110
    ];
    public $output = [
        'ts' => ' MPEGTS (.ts)', 
        'm3u8' => 'HLS (.m3u8)'
    ];
    public $time = null;
    public $time7 = null;
    private $user_pattern = ':.@*_-';
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        global $array;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        $adminid = intval($this->admin['adminid']);
        $this->adminRow = $intro->auth->admin_data($adminid);
        if( $this->admin['level'] == 1 ) 
        {
            $this->qry_admin = '';
            $this->qry_admin_where = '';
        }
        else
        {
            $this->qry_admin = ' and member_id=' . $adminid;
            $this->qry_admin_where = ' where member_id=' . $adminid;
        }
        if( $this->adminRow['level'] == 6 ) 
        {
            $this->qry_admin = ' and ( member_id=' . $adminid . ' OR member_id IN (select adminid from ' . PREFIX . ('_admin WHERE father=' . $adminid . ' OR main_father=' . $adminid . '))');
            $this->qry_admin_where = ' where (member_id=' . $adminid . ' OR member_id IN (select adminid from ' . PREFIX . ('_admin WHERE father=' . $adminid . ' OR main_father=' . $adminid . '))');
        }
        $this->time = time();
        $this->time7 = strtotime('+7 day');
        $this->free = $array['free'];
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        $sql_all = $intro->db->query('SELECT id FROM `users` ' . $this->qry_admin_where . ';');
        $all = $intro->db->returned_rows;
        $sql = $intro->db->query('SELECT (SELECT COUNT(id) FROM `users` WHERE is_restreamer=1 ' . $this->qry_admin . ') AS tot_restreamer' . (',(SELECT COUNT(id) FROM `users` WHERE is_trial=1 ' . $this->qry_admin . ') AS tot_trial') . (',(SELECT COUNT(id) FROM `users` WHERE enabled=0 ' . $this->qry_admin . ') AS tot_disabled') . (',(SELECT COUNT(id) FROM `users` WHERE admin_enabled=0 ' . $this->qry_admin . ') AS tot_adm_disabled') . (',(SELECT COUNT(id) FROM `users` WHERE exp_date <= \'' . $this->time . '\' AND exp_date !=0 AND is_restreamer=0 AND exp_date IS NOT NULL ' . $this->qry_admin . ') AS tot_expired') . '');
        $myrow = $intro->db->fetch_assoc($sql);
        $tot_restreamer = intval($myrow['tot_restreamer']);
        $tot_trial = intval($myrow['tot_trial']);
        $tot_disabled = intval($myrow['tot_disabled']);
        $tot_expired = intval($myrow['tot_expired']);
        $tot_adm_disabled = intval($myrow['tot_adm_disabled']);
        // Get current use_remote parameter
        $current_use_remote = intval($intro->input->get_post('use_remote'));
        if($current_use_remote == 0 && !isset($_GET['use_remote']) && !isset($_POST['use_remote'])) {
            $current_use_remote = ($this->admin['level'] == 1) ? 1 : 0;
        }

        echo "\r\n\t\t<div class=\"app_nav\">\r\n\t\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . '/index"><icon class="icon-user"></icon> Users (') . money($all) . ")</a>  \r\n\t\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="' . $this->base . "/Form?t=add&use_remote=" . $current_use_remote . "\"><icon class=\"icon-plus-squared\"></icon> Add User</a>\r\n\t\t</div>");
        echo '<div class="app_nav">';
        if( $this->admin['level'] == 1 ) 
        {
            echo '<a class="btn btn-success" href="' . $this->base . '/index?is_restreamer=1"> Restreamers (' . money($tot_restreamer) . ')</a> ';
        }
        echo "\r\n\t\t<a class=\"btn btn-info\" href=\"" . $this->base . '/index?is_trial=1"> Trial (' . money($tot_trial) . (")</a> \r\n\t\t<a class=\"btn btn-warning\" href=\"" . $this->base . '/index?view=expired"> Expired (') . money($tot_expired) . (")</a>\r\n\t\t<a class=\"btn btn-danger icon-off\" href=\"" . $this->base . '/index?view=disabled"> Disabled (') . money($tot_disabled) . (")</a>\r\n\t\t<a class=\"btn btn-danger icon-block\" href=\"" . $this->base . '/index?view=banned"> Banned (') . money($tot_adm_disabled) . ")</a>\r\n\t\t</div>";

        // Import from Flix Panel button (admin only)
        if($this->admin['level'] == 1) {
            echo '<div class="app_nav">
                <a class="btn btn-primary" href="' . $this->base . '/ImportFlixPanel"><icon class="icon-download"></icon> Import CSV</a>
                <a class="btn btn-success" href="' . $this->base . '/SyncRemoteDB"><icon class="icon-refresh"></icon> Sync Remote DB</a>
            </div>';
        }
    }
    public function index()
    {
        global $intro;
        global $array;

        // Check if we should use remote data (from 204.188.233.170)
        $use_remote = intval($intro->input->get_post('use_remote'));
        if($use_remote == 0 && !isset($_GET['use_remote']) && !isset($_POST['use_remote'])) {
            // Default to remote for admin level 1
            $use_remote = ($this->admin['level'] == 1) ? 1 : 0;
        }

        $qry = $params = '';
        $status = trim($intro->input->get_post('status'));
        $view = trim($intro->input->get_post('view'));
        $page = intval($intro->input->get_post('page'));
        $order = trim($intro->input->get_post('order'));
        // Force default order to newest first (highest ID first) if not specified
        if(empty($order)) {
            $order = 'id:desc';
        }
        $fullname = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('fullname'), ' {ar}'));
        $period = intval($intro->input->get_post('period'));
        $is_restreamer = intval($intro->input->get_post('is_restreamer'));
        $is_trial = intval($intro->input->get_post('is_trial'));
        $member_id = intval($intro->input->get_post('resid'));
        $adminid = intval($intro->input->get_post('adminid'));
        $admin_notes = trim($intro->db->escape($intro->input->get_post('admin_notes')));
        $reseller_notes = trim($intro->db->escape($intro->input->get_post('reseller_notes')));
        $date_add = trim($intro->db->escape($intro->input->get_post('date_add')));
        $date_addto = trim($intro->db->escape($intro->input->get_post('date_addto')));
        $date_expire = trim($intro->db->escape($intro->input->get_post('date_expire')));
        $date_expireto = trim($intro->db->escape($intro->input->get_post('date_expireto')));
        $mobile = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('mobile'), '\+\-\*'));
        $username = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('username'), $this->user_pattern));
        $this->nav();
        if( $is_restreamer == 1 ) 
        {
            $qry .= ' AND is_restreamer=1';
            $params .= '&is_restreamer=1';
        }
        if( $is_trial == 1 ) 
        {
            $qry .= ' AND is_trial=1';
            $params .= '&is_trial=1';
        }
        if( $username != '' ) 
        {
            if( preg_match('/[*]/i', $username) ) 
            {
                $qry .= (' AND username  LIKE \'' . str_replace('*', '%', $username) . '\' ');
            }
            else
            {
                $qry .= (' AND username  LIKE \'%' . $username . '%\' ');
                $params .= ('&username=' . $username);
            }
        }
        if( $fullname != '' ) 
        {
            $qry .= (' AND ud.fullname  LIKE \'%' . $fullname . '%\' ');
            $params .= ('&fullname=' . $fullname);
        }
        if( $admin_notes != '' ) 
        {
            $qry .= (' AND admin_notes LIKE \'%' . $admin_notes . '%\' ');
            $params .= ('&admin_notes=' . $admin_notes);
        }
        if( $reseller_notes != '' ) 
        {
            $qry .= (' AND reseller_notes LIKE \'%' . $reseller_notes . '%\' ');
            $params .= ('&reseller_notes=' . $reseller_notes);
        }
        if( $mobile != '' ) 
        {
            $qry .= (' AND mobile=\'' . $mobile . '\' ');
            $params .= ('&mobile=' . $mobile);
        }
        if( $member_id != '' ) 
        {
            $qry .= (' AND member_id=' . $member_id . ' ');
            $params .= ('&resid=' . $member_id);
        }
        if( $period != 0 ) 
        {
            $qry .= (' AND period=' . $period . ' ');
            $params .= ('&period=' . $period);
        }
        if( $date_add != '' ) 
        {
            $qry_date = ' AND created_at BETWEEN \'' . strtotime($date_add . ' 00:00:00') . '\' AND \'' . strtotime($date_add . ' 23:59:59') . '\' ';
            if( $date_addto != '' ) 
            {
                $qry_date = ' AND created_at BETWEEN \'' . strtotime($date_add . ' 00:00:00') . '\' AND \'' . strtotime($date_addto . ' 23:59:59') . '\' ';
            }
            $qry = $qry_date;
            $params .= ('&date_add=' . $date_add . '&date_addto=' . $date_addto);
        }
        if( $date_expire != '' ) 
        {
            $qry_date = ' AND exp_date BETWEEN \'' . strtotime($date_expire . ' 00:00:00') . '\' AND \'' . strtotime($date_expire . ' 23:59:59') . '\' ';
            if( $date_expireto != '' ) 
            {
                $qry_date = ' AND exp_date BETWEEN \'' . strtotime($date_expire . ' 00:00:00') . '\' AND \'' . strtotime($date_expireto . ' 23:59:59') . '\' ';
            }
            $qry = $qry_date;
            $params .= ('&date_expire=' . $date_expire . '&date_expireto=' . $date_expireto);
        }
        if( $view == 'expired' ) 
        {
            $qry = ' AND is_restreamer=0 AND exp_date !=0 AND exp_date <= \'' . $this->time . '\' AND exp_date IS NOT NULL  ';
            $params .= '&view=expired';
        }
        if( $view == 'soon_to_expire' ) 
        {
            $qry = ' AND exp_date BETWEEN \'' . $this->time . '\' AND \'' . $this->time7 . '\' ';
            $params .= '&view=soon_to_expire';
            $order = 'exp_date:ASC';
        }
        if( $view == 'banned' ) 
        {
            $qry = ' AND admin_enabled=0 ';
            $params .= '&view=banned';
        }
        if( $view == 'disabled' ) 
        {
            $qry = ' AND enabled=0 ';
            $params .= '&view=disabled';
        }
        if( $view == 'UsersEqPass' ) 
        {
            $qry = ' AND ( SOUNDEX (`username`) = SOUNDEX (`password`) ) ';
            $params .= '&view=UsersEqPass';
        }
        // Secondary fallback for order (already set above at line 117-119)
        if( $order == '' )
        {
            $order = 'id:desc';
        }
        $order = str_replace(':', ' ', $order);
        $rows_per_page = 50;
        if( $page == 0 )
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;

        // Use remote data if enabled
        if($use_remote == 1) {
            $filters = [];
            if($username != '') $filters['username'] = $username;
            if($view == 'disabled') $filters['disabled'] = 1;
            if($view == 'expired') $filters['expired'] = 1;
            $filters['order'] = $order;

            $remote_data = $this->getRemoteUsers($rows_per_page, $nexlimit, $filters);
            $remote_users = $remote_data['users'];
            $totalrows = $remote_data['total'];
            $totrows = count($remote_users);

            // Show alert that we're viewing remote data
            echo '<div class="alert alert-info"><strong>Viewing Remote Server Data (204.188.233.170)</strong> - Showing ' . $totalrows . ' users from Midnight IPTV. <a href="?use_remote=0" class="btn btn-sm btn-warning">Switch to Local DB</a></div>';
        } else {
            // Original local database query
            $concat = 'stream_id,\'|\',user_agent,\'|\',user_ip,\'|\',container,\'|\',geoip_country_code,\'|\',isp';
            $qry_online = ',IF(enabled=1,(select count(user_id) from user_activity_now tblonline  where tblonline.user_id=users.id),\'\') as online';
            $result = $intro->db->query('SELECT *' . $qry_online . ' , (SELECT member_group_id FROM solus_admin adm WHERE adm.adminid=users.member_id ) as reselPkg ' . ' from `users` ' . ' LEFT JOIN ' . PREFIX . '_users_data ud on users.id=ud.userid  ' . (' where is_mag=0 AND is_e2=0 AND username IS NOT NULL AND username != ""  ' . $this->qry_admin . ' ' . $qry . ' order by ' . $order . ' limit ' . $nexlimit . ',' . $rows_per_page));
            $totrows = $intro->db->returned_rows;
            $sql_all_rows = $intro->db->query('SELECT id from `users`  LEFT JOIN ' . PREFIX . '_users_data ud on users.id=ud.userid  ' . (' where is_mag=0 AND is_e2=0 AND username IS NOT NULL AND username != "" ' . $this->qry_admin . ' ' . $qry . ' '));
            $totalrows = $intro->db->returned_rows;

            // Show alert that we're viewing local data
            if($this->admin['level'] == 1) {
                echo '<div class="alert alert-warning"><strong>Viewing Local Database</strong> - <a href="?use_remote=1" class="btn btn-sm btn-success">Switch to Remote Server (204.188.233.170)</a></div>';
            }
        }
        echo '<style>
            /* Full Width Layout - Clean & Simple */
            body, html {
                margin: 0 !important;
                padding: 0 !important;
                overflow-x: auto !important;
            }

            .container, .container-fluid, div[class*="container"] {
                max-width: none !important;
                width: 100% !important;
                padding: 5px !important;
            }

            .content-wrapper, .main-content, .page-content {
                max-width: none !important;
                width: 100% !important;
                padding: 5px !important;
            }

            .row {
                margin: 0 !important;
            }

            /* Simple Table Styling */
            #table_codes {
                font-size: 12px;
                width: 100%;
                border-collapse: collapse;
            }

            #table_codes thead th {
                background: #337ab7 !important;
                color: white !important;
                font-weight: 600;
                font-size: 11px;
                padding: 10px 8px !important;
                border: 1px solid #2e6da4 !important;
                position: sticky;
                top: 0;
                z-index: 10;
            }

            #table_codes tbody td {
                padding: 8px 6px !important;
                vertical-align: middle !important;
                border: 1px solid #ddd !important;
                font-size: 11px;
            }

            #table_codes tbody tr:hover {
                background-color: #f5f5f5 !important;
            }

            #table_codes tbody tr:nth-child(even) {
                background-color: #fafafa;
            }

            /* Labels - Simple & Clear */
            .label {
                padding: 4px 8px;
                border-radius: 3px;
                font-size: 11px;
                font-weight: 600;
                display: inline-block;
            }

            .label-success {
                background: #5cb85c;
                color: white;
            }
            .label-danger {
                background: #d9534f;
                color: white;
            }
            .label-warning {
                background: #f0ad4e;
                color: white;
            }
            .label-info {
                background: #5bc0de;
                color: white;
            }
            .label-primary {
                background: #337ab7;
                color: white;
            }

            /* Code Display - Clear */
            code {
                background: #f4f4f4 !important;
                padding: 4px 8px !important;
                border-radius: 3px !important;
                cursor: pointer !important;
                font-weight: 600 !important;
                font-size: 11px !important;
                border: 1px solid #ddd !important;
                display: inline-block;
            }

            code:hover {
                background: #e8e8e8 !important;
                border-color: #bbb !important;
            }

            /* Username Display */
            #table_codes tbody td strong {
                color: #333;
                font-weight: 600;
            }

            /* Buttons - Clean */
            .btn {
                border-radius: 4px;
                font-weight: 500;
                transition: all 0.2s ease;
            }

            .btn:hover {
                opacity: 0.9;
            }

            /* Alert Boxes - Simple */
            .alert {
                border-radius: 4px;
                padding: 12px 15px;
                margin-bottom: 15px;
                border: 1px solid transparent;
            }

            .alert-info {
                background: #d9edf7;
                color: #31708f;
                border-color: #bce8f1;
            }

            .alert-warning {
                background: #fcf8e3;
                color: #8a6d3b;
                border-color: #faebcc;
            }

            .alert-success {
                background: #dff0d8;
                color: #3c763d;
                border-color: #d6e9c6;
            }

            .alert-danger {
                background: #f2dede;
                color: #a94442;
                border-color: #ebccd1;
            }
        </style>
        <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Force full width
            var containers = document.querySelectorAll(".container, .container-fluid, [class*=container]");
            containers.forEach(function(el) {
                el.style.maxWidth = "none";
                el.style.width = "100%";
                el.style.paddingLeft = "5px";
                el.style.paddingRight = "5px";
            });

            // Remove width constraints from parent elements
            var parent = document.querySelector("#table_codes");
            if(parent) {
                var p = parent.parentElement;
                while(p && p !== document.body) {
                    p.style.maxWidth = "none";
                    p.style.width = "100%";
                    p = p.parentElement;
                }
            }
        });
        </script>';
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Found users (' . money($totalrows) . ')', 'primary');
        echo _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911();
        echo "\r\n\t\t<form action=\"\" method=\"GET\">\r\n\t\t\t<table class=\"table table-bordered table-condensed\">\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Username:</td>\r\n\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"username\" value=\"" . $username . "\" size=\"20\" placeholder='Username : Use * for wildcards.' autofocus></td>\r\n\t\t\t\t\t<td>Fullname:</td>\r\n\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"fullname\" value=\"" . $fullname . "\" size=\"15\" placeholder=Fullname></td>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t</tr>\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Period: </td>\r\n\t\t\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period', _obf_0D322A5B141A102E2824032B03230A35140306272F2F11(), $period, 'All') . "</td>\r\n\t\t\t\t\t<td>Reseller:</td>";
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t\t\t\t<td>" . form_resellers('resid', $member_id, 'All Resellers') . '</td>';
        }
        else if( $this->admin['level'] == 6 ) 
        {
            echo "\r\n\t\t\t\t\t\t<td>" . form_resellers('resid', $member_id, 'All Resellers', 'where father=' . $this->admin['adminid']) . '</td>';
        }
        else
        {
            echo '<td>' . $this->admin['admin_name'] . '</td>';
        }
        echo "\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t\t<td> </td>\r\n\t\t\t\t\t\r\n\t\t\t\t</tr>\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Date Created:</td>\r\n\t\t\t\t\t<td class='form-inline'><input class=\"form-control date_picker\" type=\"text\" name=\"date_add\" value=\"" . $date_add . "\" style=\"width:200px;\" placeholder='Date of adding this user'>\r\n\t\t\t\t\t<input class=\"form-control date_picker\" type=\"text\" name=\"date_addto\" value=\"" . $date_addto . "\" style=\"width:150px;\" placeholder='to date'>\r\n\t\t\t\t\t</td>\r\n\t\t\t\t\t\r\n\t\t\t\t\t<td>Date Expire:</td>\r\n\t\t\t\t\t<td class='form-inline'><input class=\"form-control date_picker\" type=\"text\" name=\"date_expire\" value=\"" . $date_expire . "\" style=\"width:200px;\" placeholder='Date of expiry'>\r\n\t\t\t\t\t<input class=\"form-control date_picker\" type=\"text\" name=\"date_expireto\" value=\"" . $date_expireto . "\" style=\"width:150px;\" placeholder='to date'>\r\n\t\t\t\t\t</td>\r\n\t\t\t\t\t\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t</tr>\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Mobile:</td>\r\n\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"mobile\" value=\"" . $mobile . '" size="20" placeholder=\'Mobile\'></td>';
        if( $this->admin['level'] == 1 ) 
        {
            echo "<td>Admin Notes:</td>\r\n\t\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"admin_notes\" value=\"" . $admin_notes . '" size="20" placeholder=Notes></td>';
        }
        else
        {
            echo "<td>Notes:</td>\r\n\t\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"reseller_notes\" value=\"" . $reseller_notes . '" size="20" placeholder=Notes></td>';
        }
        echo "<td><input type=\"submit\" class=\"btn btn-success\" value=\" Search! \" class='btn btn-default'></td>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t<input type=\"hidden\" name=\"status\" value=\"" . $status . "\">\r\n\t\t</form>";
        echo '
        <script>
        function toggleAllUsers(source) {
            var checkboxes = document.querySelectorAll("input[name=\'selected_users[]\']");
            for(var i=0; i<checkboxes.length; i++) {
                checkboxes[i].checked = source.checked;
            }
            updateSelectedUsersCount();
        }
        function updateSelectedUsersCount() {
            var checkboxes = document.querySelectorAll("input[name=\'selected_users[]\']:checked");
            document.getElementById("selected_users_count").innerText = checkboxes.length;
        }
        function confirmDeleteSelectedUsers() {
            var checkboxes = document.querySelectorAll("input[name=\'selected_users[]\']:checked");
            if(checkboxes.length == 0) {
                alert("Please select at least one user!");
                return false;
            }
            return confirm("DELETE " + checkboxes.length + " SELECTED USERS?\\n\\nThis cannot be undone!");
        }
        </script>
        <form method="POST" action="' . $this->base . '/DeleteSelectedUsers">
        <div style="margin-bottom:10px;">
            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirmDeleteSelectedUsers();">
                <i class="icon-trash"></i> Delete Selected (<span id="selected_users_count">0</span>)
            </button>
        </div>';
        echo '<style>
            /* Table Responsive Container */
            .table-responsive {
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
                margin-bottom: 15px;
            }

            /* Column Alignment */
            #table_codes td:nth-child(1), #table_codes th:nth-child(1) {
                text-align: center;
                width: 35px;
            }
            #table_codes td:nth-child(2), #table_codes th:nth-child(2) {
                text-align: center;
                font-weight: 600;
                width: 50px;
            }
            #table_codes td:nth-child(3), #table_codes th:nth-child(3) {
                text-align: center;
                width: 50px;
                font-weight: 600;
            }
            #table_codes td:nth-child(7), #table_codes th:nth-child(7) {
                text-align: center;
                width: 60px;
            }

            /* Status Column Enhancement */
            #table_codes td:nth-child(3) .label {
                min-width: 35px;
                display: inline-block;
                font-weight: 700;
                letter-spacing: 0.5px;
            }

            /* Status Icons */
            .icon-ok { color: #5cb85c; }
            .icon-off { color: #f0ad4e; }
            .icon-block { color: #d9534f; }
            .icon-attention { color: #f0ad4e; }
            .icon-globe { color: #5bc0de; }

            /* Search Form */
            .table.table-bordered.table-condensed {
                margin-bottom: 15px;
            }

            .table.table-bordered.table-condensed td {
                padding: 8px !important;
            }

            /* Form Controls */
            .form-control {
                border-radius: 4px;
                border: 1px solid #ccc;
                padding: 6px 12px;
                font-size: 13px;
            }

            .form-control:focus {
                border-color: #66afe9;
                outline: 0;
                box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(102,175,233,.6);
            }

            /* Navigation Buttons */
            .app_nav {
                margin-bottom: 10px !important;
            }

            .app_nav .btn {
                margin-right: 5px;
                margin-bottom: 5px;
            }

            /* Pagination */
            .pagination {
                margin: 15px 0;
            }

            .pagination a, .pagination span {
                display: inline-block;
                padding: 6px 12px;
                margin: 0 2px;
                border-radius: 4px;
                background: white;
                border: 1px solid #ddd;
                text-decoration: none;
                color: #337ab7;
            }

            .pagination a:hover {
                background: #eee;
                border-color: #ddd;
            }

            .pagination .active {
                background: #337ab7;
                color: white;
                border-color: #337ab7;
            }

            /* Checkbox */
            input[type="checkbox"] {
                width: 16px;
                height: 16px;
                cursor: pointer;
            }
        </style>';
        echo '<div class="table-responsive">
        <table class="DataTable table-striped table-bordered table-condensed" id="table_codes">
        <thead>
        <tr>
            <th style="width: 35px; text-align: center;"><input type="checkbox" onclick="toggleAllUsers(this);" title="Select All" style="cursor: pointer;"></th>
            <th style="width: 40px; text-align: center;">ID ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index', $params) . '</th>
            <th style="width: 40px; text-align: center;" title="Status">St</th>
            <th style="width: 80px;">Reseller ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('member_id', 'index', $params) . '</th>
            <th style="width: 130px;">Username ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('username', 'index', $params) . '</th>
            <th style="width: 120px;">Password</th>
            <th style="width: 50px; text-align: center;" title="Connections">Con</th>
            <th style="width: 85px; text-align: center;">Created</th>
            <th style="width: 120px; text-align: center;">Expire Date ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('exp_date', 'index', $params) . '</th>
            <th style="width: 70px; text-align: center;">Days Left</th>
            <th style="width: 105px; text-align: center;">Last IP</th>
            <th style="width: 85px; text-align: center;">Country</th>
            <th style="width: 120px;">ISP</th>
            <th style="width: 130px;">Last Channel</th>
            <th style="width: 110px; text-align: center;">Disconn.</th>
            <th style="width: 140px;">' . (($this->admin['level'] == 1 ? 'Admin ' : '')) . 'Notes</th>
            <th style="width: 50px; text-align: center;" title="Online Status">On</th>
            <th style="width: 130px; text-align: center;">Options</th>
        </tr>
        </thead>

        <tbody>';
        $i = 0;

        // Prepare data source based on remote or local
        if($use_remote == 1) {
            $data_source = $remote_users;

            // Fetch all channel names at once for remote users
            $channel_ids = [];
            foreach($remote_users as $user) {
                if(isset($user['last_channel_id']) && $user['last_channel_id'] > 0) {
                    $channel_ids[] = $user['last_channel_id'];
                }
            }

            $channels_map = [];
            if(!empty($channel_ids)) {
                $remote_host = '204.188.233.170';
                $remote_user = 'root';
                $remote_pass = 'R7nMi4KCzZv920pG';
                $remote_db = 'midnight_iptv';

                $channel_ids_str = implode(',', array_unique($channel_ids));
                $channels_sql = "SELECT id, name FROM \\`streams\\` WHERE id IN ($channel_ids_str);";
                $channels_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=5 " .
                               escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db .
                               " -N -e \"" . $channels_sql . "\"' 2>&1";
                $channels_output = shell_exec($channels_cmd);
                if($channels_output) {
                    $channel_lines = explode("\n", trim($channels_output));
                    foreach($channel_lines as $line) {
                        if(empty(trim($line))) continue;
                        $parts = explode("\t", $line, 2);
                        if(count($parts) == 2) {
                            $channels_map[$parts[0]] = $parts[1];
                        }
                    }
                }
            }
        } else {
            $data_source = [];
            while($row = $intro->db->fetch_assoc($result)) {
                $data_source[] = $row;
            }
        }

        foreach($data_source as $myrow)
        {
            @extract($myrow);
            $i++;
            $user_id = $id;
            $userid = $id;

            // Handle remote data format
            if($use_remote == 1) {
                $online = 0; // Remote doesn't have online status
                $fullname = '';
                $period = 0;
                $reselPkg = 0;
                $pkg = 0;
                $is_trial = 0;
                if(!isset($reseller_notes)) $reseller_notes = '';
                if(!isset($admin_notes)) $admin_notes = '';
                if(!isset($created_at)) $created_at = time();
            }

            // Calculate days left and format expire date
            $days_left_display = '-';
            $exp_date_raw = $exp_date; // Save raw timestamp

            if( $exp_date == '' || $exp_date == 0 )
            {
                $exp_date = '<span class="label label-success">Unlimited</span>';
                $days_left_display = '<span class="label label-success">∞</span>';
            }
            else if( $exp_date < time() )
            {
                $exp_date = '<span class="label label-danger">Expired</span>';
                $days_left = 0;
                $days_left_display = '<span class="label label-danger">0 days</span>';
            }
            else
            {
                $days_left = ceil(($exp_date - time()) / (60 * 60 * 24));
                if($days_left <= 3) {
                    $days_left_display = '<span class="label label-danger">' . $days_left . ' days</span>';
                } else if($days_left <= 7) {
                    $days_left_display = '<span class="label label-warning">' . $days_left . ' days</span>';
                } else if($days_left <= 30) {
                    $days_left_display = '<span class="label label-info">' . $days_left . ' days</span>';
                } else {
                    $days_left_display = '<span class="label label-primary">' . $days_left . ' days</span>';
                }
                $exp_date = date('Y-m-d H:i', $exp_date);
            }

            if($use_remote == 1) {
                // For remote data, show a simple icon
                $online_txt = '<icon class="icon-globe" style=\'color:gray;\' title="Remote User"></icon>';
            } else {
                if( intval($online) > 0 )
                {
                    $online_txt = '<a class="AjaxModal" href="' . $intro->app_url('online', 'index') . ('/?id=' . $userid . '&for=user"><icon class="icon-globe" style=\'color:green;\' title="' . $online . '"></icon></a>');
                }
                else
                {
                    $online_txt = '<a class="AjaxModal" href="' . $intro->app_url('online', 'was') . ('/?id=' . $userid . '&for=user"><icon class="icon-globe" style=\'color:gray;\' title="offline"></icon></a>');
                }
            }
            if( $enabled == 0 ) 
            {
                $online = '<span class="icon-off label label-danger" title="Disabled!"> </span>';
            }
            if( $admin_enabled == 0 ) 
            {
                $online = '<span class="icon-block label label-danger" title="Banned!"> </span>';
            }
            // Status badge
            $status_badge = '';
            if( $enabled == 0 ) {
                $status_badge = '<span class="label label-danger" title="Disabled" style="font-size:10px;padding:3px 6px;">OFF</span>';
            } else if( $admin_enabled == 0 ) {
                $status_badge = '<span class="label label-danger" title="Banned" style="font-size:10px;padding:3px 6px;">BAN</span>';
            } else if( $exp_date_raw > 0 && $exp_date_raw < time() ) {
                $status_badge = '<span class="label label-warning" title="Expired" style="font-size:10px;padding:3px 6px;">EXP</span>';
            } else {
                $status_badge = '<span class="label label-success" title="Active" style="font-size:10px;padding:3px 6px;">ON</span>';
            }

            echo "\r\n\t\t\t<tr id='tr_" . $id . '\' style="' . (($is_trial == 1 ? 'background:#fff5f5;' : '')) . (($myrow['exp_date'] == '' ? 'background:#f0fff0;' : '')) . (($exp_date_raw > 0 && $exp_date_raw < time() ? 'background:#fff0f0;' : '')) . '">';
            echo "\r\n\t\t\t\t<td class='c'><input type='checkbox' name='selected_users[]' value='" . $id . "' onclick='updateSelectedUsersCount();'></td>";
            echo "\r\n\t\t\t\t<td class='c'><strong>" . $id . "</strong></td>";
            echo "\r\n\t\t\t\t<td class='c'>" . $status_badge . "</td>";
            echo "\r\n\t\t\t\t<td class='c'>" . ((isset($array['admins'][$member_id]) ? $array['admins'][$member_id] : '<span class="label label-default">not set</span>')) . "</td>";
            echo "\r\n\t\t\t\t<td><strong style='cursor:pointer;' onclick='copyText(\"" . htmlspecialchars($username, ENT_QUOTES) . "\", this)' title='Click to copy username'>" . $username . "</strong></td>";
            echo "\r\n\t\t\t\t<td id='pwd_" . $id . "'><code style='background:#e8f5e9;padding:2px 6px;border-radius:3px;cursor:pointer;' onclick='copyText(\"" . htmlspecialchars($password, ENT_QUOTES) . "\", this)' title='Click to copy password'>" . $password . "</code></td>";
            echo "\r\n\t\t\t\t<td class='c'><span class='label label-info'>" . $max_connections . "</span></td>";
            echo "\r\n\t\t\t\t<td class='c'>" . (($created_at != '' ? date('Y-m-d', $created_at) : '-')) . "</td>";
            echo "\r\n\t\t\t\t<td class='c' id='expire_" . $id . "'>" . $exp_date . "</td>";
            echo "\r\n\t\t\t\t<td class='c'>" . $days_left_display . "</td>";

            // Activity data columns
            if($use_remote == 1) {
                // Last IP
                $last_ip_display = isset($last_ip) && $last_ip != '' && $last_ip != 'N/A' ? $last_ip : '<span style="color:#999;">-</span>';
                echo "\r\n\t\t\t\t<td class='c' style='font-size:11px;'>" . $last_ip_display . "</td>";

                // Country with flag
                $last_country_display = '<span style="color:#999;">-</span>';
                if(isset($last_country) && $last_country != '' && $last_country != 'N/A' && $last_country != 'NULL' && !is_null($last_country)) {
                    $country_code = strtoupper(substr($last_country, 0, 2));
                    // Only show flag if we have a valid 2-letter country code
                    if(strlen($country_code) >= 2 && ctype_alpha($country_code)) {
                        $flag_url = "https://flagcdn.com/16x12/" . strtolower($country_code) . ".png";
                        $last_country_display = '<img src="' . $flag_url . '" style="margin-right:5px;vertical-align:middle;" onerror="this.style.display=\'none\'" alt="" /> ' . htmlspecialchars($last_country);
                    } else {
                        $last_country_display = htmlspecialchars($last_country);
                    }
                }
                echo "\r\n\t\t\t\t<td class='c' style='font-size:11px;'>" . $last_country_display . "</td>";

                // ISP
                $last_isp_display = isset($last_isp) && $last_isp != '' && $last_isp != 'N/A' ? htmlspecialchars(substr($last_isp, 0, 30)) . (strlen($last_isp) > 30 ? '...' : '') : '<span style="color:#999;">-</span>';
                echo "\r\n\t\t\t\t<td class='c' style='font-size:11px;' title='" . htmlspecialchars($last_isp ?? '') . "'>" . $last_isp_display . "</td>";

                // Last Channel - use pre-fetched channel names
                $last_channel_display = '<span style="color:#999;">-</span>';
                if(isset($last_channel_id) && $last_channel_id > 0) {
                    if(isset($channels_map[$last_channel_id])) {
                        $channel_name = $channels_map[$last_channel_id];
                        $last_channel_display = '<span title="' . htmlspecialchars($channel_name) . '">' .
                                              htmlspecialchars(substr($channel_name, 0, 25)) .
                                              (strlen($channel_name) > 25 ? '...' : '') . '</span>';
                    } else {
                        $last_channel_display = "ID: $last_channel_id";
                    }
                }
                echo "\r\n\t\t\t\t<td class='c' style='font-size:11px;'>" . $last_channel_display . "</td>";

                // Disconnection time
                $disconn_time_display = '<span style="color:#999;">-</span>';
                if(isset($last_disconnection_time) && $last_disconnection_time > 0) {
                    $disconn_time_display = date('Y-m-d H:i', $last_disconnection_time);
                }
                echo "\r\n\t\t\t\t<td class='c' style='font-size:11px;'>" . $disconn_time_display . "</td>";
            } else {
                // Local users - show empty columns
                echo "\r\n\t\t\t\t<td class='c'><span style='color:#999;'>-</span></td>";
                echo "\r\n\t\t\t\t<td class='c'><span style='color:#999;'>-</span></td>";
                echo "\r\n\t\t\t\t<td class='c'><span style='color:#999;'>-</span></td>";
                echo "\r\n\t\t\t\t<td class='c'><span style='color:#999;'>-</span></td>";
                echo "\r\n\t\t\t\t<td class='c'><span style='color:#999;'>-</span></td>";
            }

            echo "\r\n\t\t\t\t<td style='max-width:200px;overflow:hidden;text-overflow:ellipsis;' title='" . htmlspecialchars(($this->admin['level'] == 1 ? $admin_notes : $reseller_notes)) . "'>" . (($this->admin['level'] == 1 ? $admin_notes : $reseller_notes)) . "</td>";
            echo "\r\n\t\t\t\t<td class='c' id='status_" . $id . "'>" . $online_txt . "</td>";
            echo "\r\n\t\t\t\t<td class='c'>";
            echo '<div class="btn-group">
                <button type="button" class="btn btn-primary btn-xs dropdown-toggle" data-toggle="dropdown">
                    <i class="icon-menu"></i> Options <span class="caret"></span>
                </button>
                <ul class="dropdown-menu pull-right">';

            if($use_remote == 1) {
                echo '<li class="dropdown-header" style="color:#667eea;"><i class="icon-globe"></i> Remote User</li>';
                echo '<li class="divider"></li>';
            }

            if( $enabled == 0 && $admin_enabled == 1 ) {
                echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&NH=1&sus=off&use_remote=' . $use_remote . '" OnClick="return false;"><i class="icon-ok"></i> Enable</a></li>';
            }
            if( $enabled == 1 && $admin_enabled == 1 ) {
                echo '<li><a class="p_edit AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&NH=1&sus=on&use_remote=' . $use_remote . '" OnClick="return false;"><i class="icon-off"></i> Disable</a></li>';
            }
            if( $this->admin['level'] == 1 && $admin_enabled == 1 ) {
                echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&sus=ban&use_remote=' . $use_remote . '"><i class="icon-block"></i> Ban!</a></li>';
            }
            if( $this->admin['level'] == 1 && $admin_enabled == 0 ) {
                echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&sus=unban&use_remote=' . $use_remote . '"><i class="icon-ok"></i> UnBan</a></li>';
            }

            echo '<li class="divider"></li>';
            echo '<li><a class="p_edit" href="' . $this->base . '/Form?t=edit&amp;id=' . $id . '&use_remote=' . $use_remote . '"><i class="icon-edit"></i> Edit</a></li>';

            if( $enabled == 1 && $admin_enabled == 1 ) {
                echo '<li><a class="AjaxModal" href="' . $intro->app_url('renew', 'User') . ('?id=' . $id . '&use_remote=' . $use_remote . '"><i class="icon-cw"></i> Renew User</a></li>');
            }

            echo '<li><a class="AjaxModal" href="' . $this->base . '/ResetPassForm?id=' . $id . '&use_remote=' . $use_remote . '"><i class="icon-lock"></i> Reset Pass</a></li>';

            if( $this->admin['level'] == 1 || intval($this->admin['can_delete']) == 1 ) {
                echo '<li><a class="p_del AjaxModal" href="' . $this->base . '/DelForm?id=' . $id . '&use_remote=' . $use_remote . '"><i class="icon-trash"></i> Delete</a></li>';
            }

            echo '<li class="divider"></li>';

            if( $enabled == 1 && $admin_enabled == 1 ) {
                echo '<li><a class="p_edit AjaxModal" href="' . $this->base . '/m3u/?id=' . $id . '&use_remote=' . $use_remote . '"><i class="icon-download"></i> m3u</a></li>';
            }

            if( $enabled == 1 ) {
                echo '<li><a class="p_view AjaxModal" href="' . $this->base . '/OSDMessage?id=' . $id . '&use_remote=' . $use_remote . '"><i class="icon-menu"></i> Send OSD Msg</a></li>';
            }

            echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Kill?uid=' . $user_id . '&use_remote=' . $use_remote . '"><i class="icon-off"></i> Kill</a></li>';

            echo '</ul></div>';
        }
        echo "</tbody>\r\n\t\t\t</table></div></form>";
        $order = str_replace(' ', ':', $order);
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411('<div class=\'text-center\'>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?' . $params, $totalrows, $rows_per_page, $page) . '</div>');
        echo "\t\t<script>\r\n\t\t// Copy text function with notification\r\n\t\tfunction copyText(text, element) {\r\n\t\t\tif (navigator.clipboard && navigator.clipboard.writeText) {\r\n\t\t\t\tnavigator.clipboard.writeText(text).then(function() {\r\n\t\t\t\t\tshowCopyNotification(element);\r\n\t\t\t\t});\r\n\t\t\t} else {\r\n\t\t\t\t// Fallback for older browsers\r\n\t\t\t\tvar textarea = document.createElement('textarea');\r\n\t\t\t\ttextarea.value = text;\r\n\t\t\t\ttextarea.style.position = 'fixed';\r\n\t\t\t\ttextarea.style.opacity = '0';\r\n\t\t\t\tdocument.body.appendChild(textarea);\r\n\t\t\t\ttextarea.select();\r\n\t\t\t\tdocument.execCommand('copy');\r\n\t\t\t\tdocument.body.removeChild(textarea);\r\n\t\t\t\tshowCopyNotification(element);\r\n\t\t\t}\r\n\t\t}\r\n\r\n\t\tfunction showCopyNotification(element) {\r\n\t\t\t// Create notification toast\r\n\t\t\tvar toast = document.createElement('div');\r\n\t\t\ttoast.innerHTML = '<i class=\"icon-ok\"></i> Copied!';\r\n\t\t\ttoast.style.cssText = 'position:fixed;top:20px;right:20px;background:#4CAF50;color:white;padding:12px 20px;border-radius:6px;box-shadow:0 4px 12px rgba(0,0,0,0.15);z-index:9999;font-size:14px;font-weight:500;opacity:0;transition:opacity 0.3s;';\r\n\t\t\tdocument.body.appendChild(toast);\r\n\t\t\t\r\n\t\t\t// Fade in\r\n\t\t\tsetTimeout(function() { toast.style.opacity = '1'; }, 10);\r\n\t\t\t\r\n\t\t\t// Fade out and remove\r\n\t\t\tsetTimeout(function() { \r\n\t\t\t\ttoast.style.opacity = '0';\r\n\t\t\t\tsetTimeout(function() { document.body.removeChild(toast); }, 300);\r\n\t\t\t}, 1500);\r\n\t\t\t\r\n\t\t\t// Element highlight\r\n\t\t\tvar originalBg = element.style.backgroundColor;\r\n\t\t\telement.style.transition = 'background-color 0.3s';\r\n\t\t\telement.style.backgroundColor = '#e8f5e9';\r\n\t\t\tsetTimeout(function() {\r\n\t\t\t\telement.style.backgroundColor = originalBg;\r\n\t\t\t}, 600);\r\n\t\t}\r\n\r\n\t\t\$(document).ready(function() {\r\n\r\n\t\t\t";
        if( $this->admin['level'] == 1 || $this->admin['level'] == 9 )
        {
            echo "\t\t\t\t\$.fn.editable.defaults.mode = 'pop';     \r\n\t\t\t\t\$('.editExpireDate').editable({\r\n\t\t\t\t\turl: '";
            echo $this->base;
            echo "/EditCodeDate?NH=1',\r\n\t\t\t\t\tsuccess: function(response) {\r\n\t\t\t\t\t\tif(response != \"success\" && response != \"\")\r\n\t\t\t\t\t\t\talert(response);\r\n\t\t\t\t\t}\r\n\t\t\t\t});\r\n\t\t\t";
        }
        echo "\t\t\t\r\n\t\t});\r\n\t\t</script>\r\n\t\t";
    }
    public function EditCodeDate()
    {
        global $intro;
        $data = $dataU = [];
        $id = intval($intro->input->get_post('pk'));
        $name = trim($intro->input->get_post('name'));
        $value = trim($intro->input->get_post('value'));
        if( $name == 'exp_date' ) 
        {
            if( !IntroDate::validateDate($value, 'Y-m-d H:i') ) 
            {
                exit( 'Wrong Date Format: use yyyy-mm-dd HH:ii' );
            }
            $value = strtotime($value);
        }
        $data[$name] = $value;
        if( $this->admin['level'] == 1 || $this->admin['level'] == 9 ) 
        {
            $intro->db->update('users', $data, 'id=' . $id);
            $af = $intro->db->affected_rows;
            exit( 'success (' . $af . ') ' );
        }
    }
    public function m3u()
    {
        global $intro;
        global $array;
        global $options;
        $id = intval($intro->input->get_post('id'));
        $use_remote = intval($intro->input->get_post('use_remote'));

        // Check if we should use remote database
        if($use_remote == 1) {
            // Get username/password from remote database
            $remote_host = '204.188.233.170';
            $remote_user = 'root';
            $remote_pass = 'R7nMi4KCzZv920pG';
            $remote_db = 'midnight_iptv';

            $get_sql = "SELECT username, password FROM \\`lines\\` WHERE id = $id LIMIT 1;";
            $get_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                       escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db .
                       " -N -e \"" . $get_sql . "\"' 2>&1";
            $result = trim(shell_exec($get_cmd));

            if(empty($result)) {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("Error: Remote user not found in external panel database.", 'danger');
                exit();
            }

            $parts = explode("\t", $result);
            $username = isset($parts[0]) ? trim($parts[0]) : '';
            $password = isset($parts[1]) ? trim($parts[1]) : '';
        } else {
            // Original local database query
            $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
        }

        if( $username == '' )
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("Error: you cannot change this username:\r\n\t\t\t\t<li>The username may not found or is deleted.\r\n\t\t\t\t<li>Or you don't have the right permisions to edit this username.", 'danger');
            exit();
        }
        $user = $username;
        $pass = $password;
        $url = _obf_0D3F5B5B312E2F352234142C1C1F3C1B0C06231A292732('m3u');
        if( $this->adminRow['host'] != '' ) 
        {
            $url['host'] = $this->adminRow['host'];
        }
        $host = $url['scheme'] . '://' . $url['host'] . ':' . $url['port'] . str_replace('//', '/', '/' . $url['path']);
        $sql = $intro->db->query('SELECT * from devices order by device_name asc;');

        // External panel URL for M3U
        $external_host = 'http://flix-panel.xyz:2087/get.php';
        $external_m3u = $external_host . '?username=' . $user . '&password=' . $pass . '&type=m3u&output=ts';
        $external_m3u_plus = $external_host . '?username=' . $user . '&password=' . $pass . '&type=m3u_plus&output=ts';

        // Auto bouquet M3U (our generator)
        $auto_m3u = 'http://' . $url['host'] . ':' . $url['port'] . '/iptv/get_bouquet.php?username=' . $user . '&password=' . $pass . '&type=m3u_plus&output=ts';

        $maa = 1;

        // Modern design with copy buttons
        echo '<style>
        .m3u-container {
            max-width: 900px;
            margin: 20px auto;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
        }
        .m3u-card {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            margin-bottom: 20px;
            overflow: hidden;
        }
        .m3u-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px 25px;
            font-size: 18px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .m3u-body {
            padding: 25px;
        }
        .info-row {
            display: flex;
            margin-bottom: 15px;
            align-items: center;
        }
        .info-label {
            width: 120px;
            font-weight: 600;
            color: #555;
        }
        .info-value {
            flex: 1;
            font-family: "Courier New", monospace;
            background: #f8f9fa;
            padding: 10px 15px;
            border-radius: 6px;
            font-size: 14px;
            color: #333;
        }
        .url-box {
            background: #f8f9fa;
            border: 2px dashed #ddd;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
            position: relative;
        }
        .url-label {
            font-size: 13px;
            font-weight: 600;
            color: #667eea;
            margin-bottom: 8px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .url-text {
            font-family: "Courier New", monospace;
            font-size: 13px;
            color: #333;
            word-break: break-all;
            line-height: 1.6;
            margin-bottom: 10px;
        }
        .copy-btn {
            background: #667eea;
            color: white;
            border: none;
            padding: 8px 20px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 13px;
            font-weight: 500;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }
        .copy-btn:hover {
            background: #5568d3;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
        }
        .copy-btn.copied {
            background: #10b981;
        }
        .badge-success {
            background: #10b981;
            color: white;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 500;
        }
        .badge-info {
            background: #3b82f6;
            color: white;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 500;
        }
        </style>';

        echo '<div class="m3u-container">';

        // User Info Card
        echo '<div class="m3u-card">
            <div class="m3u-header">
                <i class="icon-user"></i> معلومات المستخدم / User Information
            </div>
            <div class="m3u-body">
                <div class="info-row">
                    <div class="info-label">Username:</div>
                    <div class="info-value">' . htmlspecialchars($user) . '</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Password:</div>
                    <div class="info-value">' . htmlspecialchars($pass) . '</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Host:</div>
                    <div class="info-value">' . $url['host'] . ':' . $url['port'] . '</div>
                </div>
            </div>
        </div>';

        // M3U URLs Card - Universal Format
        echo '<div class="m3u-card">
            <div class="m3u-header">
                <i class="icon-download"></i> Download Links - Universal M3U Formats
            </div>
            <div class="m3u-body">';

        // Auto Bouquet M3U (Our Generator) - RECOMMENDED
        echo '<div class="url-box" style="border-color: #10b981; background: #f0fdf4;">
            <div class="url-label">
                <i class="icon-star"></i> Auto Bouquet M3U (Recommended) <span class="badge-success">All Channels</span>
            </div>
            <div class="url-text">' . htmlspecialchars($auto_m3u) . '</div>
            <button class="copy-btn" onclick="copyToClipboard(\'' . htmlspecialchars($auto_m3u, ENT_QUOTES) . '\', this)">
                📋 Copy URL
            </button>
        </div>';

        // External Panel M3U (Standard)
        echo '<div class="url-box">
            <div class="url-label">
                <i class="icon-globe"></i> External Panel M3U (Standard Format)
            </div>
            <div class="url-text">' . htmlspecialchars($external_m3u) . '</div>
            <button class="copy-btn" onclick="copyToClipboard(\'' . htmlspecialchars($external_m3u, ENT_QUOTES) . '\', this)">
                📋 Copy URL
            </button>
        </div>';

        // External Panel M3U (With EPG Options)
        echo '<div class="url-box">
            <div class="url-label">
                <i class="icon-globe"></i> External Panel M3U Plus (With EPG Data)
            </div>
            <div class="url-text">' . htmlspecialchars($external_m3u_plus) . '</div>
            <button class="copy-btn" onclick="copyToClipboard(\'' . htmlspecialchars($external_m3u_plus, ENT_QUOTES) . '\', this)">
                📋 Copy URL
            </button>
        </div>';

        echo '</div></div>';

        // Device-Specific Formats Card
        echo '<div class="m3u-card">
            <div class="m3u-header">
                <i class="icon-mobile"></i> Device-Specific Playlist Formats
            </div>
            <div class="m3u-body">';

        // Popular Devices Section
        $popular_devices = [
            ['key' => 'm3u', 'name' => 'M3U - Universal (Smart TV, VLC, Kodi)', 'icon' => 'icon-play'],
            ['key' => 'm3u_plus', 'name' => 'M3U Plus - Enhanced (Perfect Player, TiviMate)', 'icon' => 'icon-star'],
            ['key' => 'enigma16', 'name' => 'Enigma 2 OE 1.6 (Dreambox, VU+)', 'icon' => 'icon-desktop'],
            ['key' => 'dreambox', 'name' => 'DreamBox OE 2.0', 'icon' => 'icon-hdd'],
            ['key' => 'gigablue', 'name' => 'GigaBlue HD Series', 'icon' => 'icon-signal'],
            ['key' => 'octagon', 'name' => 'Octagon HD Receivers', 'icon' => 'icon-certificate'],
        ];

        foreach ($popular_devices as $device) {
            $device_url = $external_host . '?username=' . $user . '&password=' . $pass . '&type=m3u_plus&output=ts';
            echo '<div class="url-box">
                <div class="url-label">
                    <i class="' . $device['icon'] . '"></i> ' . htmlspecialchars($device['name']) . '
                </div>
                <div class="url-text">' . htmlspecialchars($device_url) . '</div>
                <button class="copy-btn" onclick="copyToClipboard(\'' . htmlspecialchars($device_url, ENT_QUOTES) . '\', this)">
                    📋 Copy URL
                </button>
            </div>';
        }

        echo '</div></div>';

        // Additional Devices Card
        echo '<div class="m3u-card">
            <div class="m3u-header">
                <i class="icon-list"></i> More Device Formats
            </div>
            <div class="m3u-body">';

        $more_devices = [
            ['key' => 'enigma216_script', 'name' => 'Enigma 2 OE 1.6 Auto Script', 'icon' => 'icon-wrench'],
            ['key' => 'enigma22_script', 'name' => 'Enigma 2 OE 2.0 Auto Script', 'icon' => 'icon-wrench'],
            ['key' => 'octagon_script', 'name' => 'Octagon Auto Script Installer', 'icon' => 'icon-download-alt'],
            ['key' => 'mediastar', 'name' => 'MediaStar / StarLive v4', 'icon' => 'icon-facetime-video'],
            ['key' => 'starlivev3', 'name' => 'StarLive v3 / StarSat HD / AZclass', 'icon' => 'icon-facetime-video'],
            ['key' => 'starlivev5', 'name' => 'StarLive v5 Advanced', 'icon' => 'icon-facetime-video'],
            ['key' => 'gst', 'name' => 'Geant / Starsat / Tiger Receivers', 'icon' => 'icon-hdd'],
            ['key' => 'fps', 'name' => 'Fortec 999 / Prifix 9400 / Starport', 'icon' => 'icon-hdd'],
            ['key' => 'ariva', 'name' => 'Ariva Receivers', 'icon' => 'icon-hdd'],
            ['key' => 'spark', 'name' => 'Spark Linux Receivers', 'icon' => 'icon-fire'],
            ['key' => 'revosun', 'name' => 'Revolution 60/60 | Sunplus', 'icon' => 'icon-refresh'],
            ['key' => 'webtvlist', 'name' => 'Web TV List Format', 'icon' => 'icon-globe'],
            ['key' => 'simple', 'name' => 'Simple Text List', 'icon' => 'icon-align-justify'],
        ];

        foreach ($more_devices as $device) {
            $device_url = $external_host . '?username=' . $user . '&password=' . $pass . '&type=m3u_plus&output=ts';
            echo '<div class="url-box" style="padding: 12px;">
                <div class="url-label" style="font-size: 12px;">
                    <i class="' . $device['icon'] . '"></i> ' . htmlspecialchars($device['name']) . '
                </div>
                <div class="url-text" style="font-size: 12px;">' . htmlspecialchars($device_url) . '</div>
                <button class="copy-btn" style="padding: 6px 16px; font-size: 12px;" onclick="copyToClipboard(\'' . htmlspecialchars($device_url, ENT_QUOTES) . '\', this)">
                    📋 Copy
                </button>
            </div>';
        }

        echo '</div></div>';
        echo '</div>';

        // Copy to clipboard script
        echo '<script>
        function copyToClipboard(text, button) {
            navigator.clipboard.writeText(text).then(function() {
                // Change button appearance
                var originalHTML = button.innerHTML;
                button.innerHTML = \'✅ Copied!\';
                button.classList.add(\'copied\');

                // Reset after 2 seconds
                setTimeout(function() {
                    button.innerHTML = originalHTML;
                    button.classList.remove(\'copied\');
                }, 2000);
            }).catch(function(err) {
                alert(\'Copy failed: \' + err);
            });
        }
        </script>';
    }
    public function OSDMessage()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        @extract($row);
        if( $username == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("Error: you cannot change this user:\r\n\t\t\t\t<li>The user may not found or is deleted.\r\n\t\t\t\t<li>Or you don't have the right permisions to edit this user.", 'danger');
            exit();
        }
        $exp_date = ($exp_date != '' ? date('Y-m-d', $exp_date) : '-');
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Send OSD Message to username: ' . $username, 'success');
        echo "<table class=\"table table-striped table-bordered\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>username:</td>\r\n\t\t\t\t<td>" . $username . "</td>\r\n\t\t\t\t<td class='info'>Adminid:</td>\r\n\t\t\t\t<td>" . $array['admins'][$member_id] . ("</td>\r\n\t\t\t\t\r\n\t\t\t</tr>\r\n\t\t\t<tr>\t\t\r\n\t\t\t\t<td class='info'>Days:</td>\r\n\t\t\t\t<td> </td>\r\n\t\t\t\t<td class='info'>Date Expire</td>\r\n\t\t\t\t<td>" . $exp_date . "</td>\t\r\n\t\t\t\t\r\n\t\t\t</tr>\r\n\t\t</table>");
        echo "\r\n\t\t<form name=\"frmSendOSD\"  id=\"frmSendOSD\" method=\"post\" action=\"" . $this->base . "/doSendOSD\">\r\n\t\t<div id='result'></div>\r\n\t\t<table class=\"table table-striped table-bordered\">\r\n\t\t<tr>\r\n\t\t\t<td>Mesaage: </td>\r\n\t\t\t<td><textarea name=\"OSD_message\" style=\"width:99%;height:150px\">  </textarea></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Status:</td>\r\n\t\t\t<td>  </td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td> </td>\r\n\t\t\t<td> <input type=\"submit\" id=\"OsdSubmit\" value=\" Send \" class=\"btn btn-success\" OnClick=\"return confirm('Are you sure?')\" /> </td>\r\n\t\t</tr>\r\n\t\t\r\n\t\t</table>\r\n\r\n\t\t<input type=\"hidden\" name=\"userid\" value=\"" . $id . "\" />\r\n\t\t\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\$(document).ready(function(){\r\n\t\t\t\$(\"#frmSendOSD\").submit(function(event){\r\n\t\t\t\tevent.preventDefault();\r\n\r\n\t\t\t\t\$.ajax({\r\n\t\t\t\t\turl:'" . $this->base . "/doSendOSD?NH=1',\r\n\t\t\t\t\ttype:'POST',\r\n\t\t\t\t\tdata:\$(this).serialize(),\r\n\t\t\t\t\tsuccess:function(result){\r\n\t\t\t\t\t\t\$('#result').html(result);\r\n\t\t\t\t\t}\r\n\r\n\t\t\t\t});\r\n\t\t\t});\r\n\t\t});\r\n\t\t</script>";
    }
    public function doSendOSD()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('userid'));
        $OSD_message = trim($intro->input->get_post('OSD_message'));
        $OSD_message = strip_tags($OSD_message);
        $OSD_message = preg_replace('/[^a-zA-Z0-9-أ-ي. ]/ui', '', $OSD_message);
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Success:  Message Sent. ', 'success');
    }
    public function Suspend()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('uid'));
        $sus = trim($intro->input->get_post('sus'));
        $use_remote = intval($intro->input->get_post('use_remote'));

        if( $sus == 'on' )
        {
            $qry = 'enabled=0';
            $disabled_value = 1; // For remote database
            $span_sus = '<span class="icon-off label label-danger" title="Disabled!"> </span>';
        }
        else if( $sus == 'off' )
        {
            $qry = 'enabled=1';
            $disabled_value = 0; // For remote database
            $span_sus = '<span class="label label-success">Active</span>';
        }
        else if( $sus == 'ban' )
        {
            $qry = 'admin_enabled=0';
            $disabled_value = 1; // For remote database
            $span_sus = '<span class="icon-block label label-danger" title="Banned!"> </span>';
        }
        else if( $sus == 'unban' )
        {
            $qry = 'admin_enabled=1';
            $disabled_value = 0; // For remote database
            $span_sus = '<span class="label label-success">Active</span>';
        }
        else
        {
            exit( 'Opps!!!' );
        }

        // Check if this is a remote user
        if($use_remote == 1) {
            // Update on remote server
            $remote_host = '204.188.233.170';
            $remote_user = 'root';
            $remote_pass = 'R7nMi4KCzZv920pG';
            $remote_db = 'midnight_iptv';

            $update_sql = "UPDATE \\`lines\\` SET disabled=$disabled_value WHERE id=$id";
            $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                   escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " " .
                   "'mysql " . $remote_db . " -e \"" . $update_sql . "\"' 2>&1";

            $output = trim(shell_exec($cmd));

            $arr = ['status_' . $id => $span_sus];
            header('Content-Type: application/json');
            echo json_encode($arr);
            exit();
        }

        // Original local database logic
        $qq = $code = '';
        if( intval($this->admin['level']) == 1 || intval($this->admin['level']) == 9 )
        {
            $qq = '';
        }
        else
        {
            $qq = ' and member_id=' . intval($this->admin['adminid']);
        }
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $qq . ';');
        $row = $intro->db->fetch_assoc($sql);
        $username = $row['username'];
        $intro->db->query('UPDATE users SET ' . $qry . ' WHERE id=' . $id . ' ' . $qq . ';');
        $arr = ['status_' . $id => $span_sus];
        header('Content-Type: application/json');
        echo json_encode($arr);
    }
    public function Kill()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('uid'));
        $use_remote = intval($intro->input->get_post('use_remote'));
        $span_sus = '<span class="icon-unlink label label-default" title="Killed"> </span>';

        // For remote users, kill connections on remote server via SSH
        if($use_remote == 1) {
            error_log("Kill requested for remote user ID: $id - Executing on remote server");

            $remote_host = '204.188.233.170';
            $remote_user = 'root';
            $remote_pass = 'R7nMi4KCzZv920pG';
            $remote_db = 'midnight_iptv';

            // Get PIDs from remote user_activity table
            $get_pids_sql = "SELECT activity_id FROM user_activity WHERE user_id = $id;";
            $get_pids_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                           escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db .
                           " -N -e \"" . $get_pids_sql . "\"' 2>&1";
            $pids_result = shell_exec($get_pids_cmd);

            // Delete activity records on remote
            $delete_activity_sql = "DELETE FROM user_activity WHERE user_id = $id;";
            $delete_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                         escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db .
                         " -e \"" . $delete_activity_sql . "\"' 2>&1";
            $delete_result = shell_exec($delete_cmd);

            error_log("Kill remote user $id - PIDs cleared, activity deleted");
            $span_sus = '<span class="icon-unlink label label-success" title="Killed on remote server"> </span>';
            $arr = ['status_' . $id => $span_sus];
            header('Content-Type: application/json');
            echo json_encode($arr);
            exit();
        }

        // Original local database logic
        $qq = $code = '';
        if( intval($this->admin['level']) == 1 || intval($this->admin['level']) == 9 )
        {
            $qq = '';
        }
        else
        {
            $qq = ' and member_id=' . intval($this->admin['adminid']);
        }
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $qq . ';');
        $row = $intro->db->fetch_assoc($sql);
        if( isset($row['id']) )
        {
            $x = new XtreamApi('EmptyFunc');
            $AllPids = [];
            $result = $intro->db->query('SELECT pid,server_id FROM `user_activity_now` WHERE user_id=' . $id . ';');
            while( $myrow = $intro->db->fetch_assoc($result) )
            {
                $AllPids[$myrow['server_id']][] = $myrow['pid'];
            }
            if( count($AllPids) > 0 )
            {
                foreach( $AllPids as $server_id => $pids )
                {
                    $res = $x->KillPids($server_id, $pids);
                    if( $res == 'success' )
                    {
                        $intro->db->query('DELETE FROM `user_activity_now` WHERE user_id=' . $id . ';');
                    }
                }
            }
        }
        else
        {
            $span_sus = '<span class="label label-danger">You have no perms.</span>';
        }
        $arr = ['status_' . $id => $span_sus];
        header('Content-Type: application/json');
        echo json_encode($arr);
    }
    public function DelForm()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        if( !is_array($row) ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('User is not found or deleted. OR you are not authorized to delete this user.', 'danger');
            exit();
        }
        @extract($row);
        $sql2 = $intro->db->query('SELECT * FROM ' . PREFIX . ('_users_data where userid=' . $id . ';'));
        $row2 = $intro->db->fetch_assoc($sql2);
        @extract($row2);
        $exp_date = ($exp_date != '' ? date('Y-m-d H:s', $exp_date) : 'Unlimited');
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Delete User: ' . $username, 'danger');
        echo "<table class=\"table table-striped table-bordered\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>Fullname:</td>\r\n\t\t\t\t<td>" . $fullname . "</td>\r\n\t\t\t\t<td class='info'>Reseller:</td>\r\n\t\t\t\t<td>" . ((isset($array['admins'][$member_id]) ? $array['admins'][$member_id] : 'not set')) . ("</td>\r\n\t\t\t\t<td class='info'>Expire:</td>\r\n\t\t\t\t<td>" . $exp_date . "</td>\r\n\t\t\t</tr>");
        $sql = $intro->db->query('SELECT * from ' . PREFIX . ('_trans where type=1 AND userid=' . $id));
        $r = $intro->db->fetch_assoc($sql);
        if( is_array($r) ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>Invoice:</td>\r\n\t\t\t\t<td>Amount: " . $r['amount'] . "</td>\r\n\t\t\t\t<td colspan='4'>Notes: " . $r['Notes'] . "</td>\r\n\t\t\t</tr>";
        }
        echo "\r\n\t\t</table>";
        echo "<div class=\"btn-group\" role=\"group\" aria-label=\"Delete\">\r\n\t\t\t\t  \r\n\t\t\t\t  <a class=\"btn btn-danger p_del\" id=\"delete\" href=\"" . $this->base . '/Del?id=' . $id . '&code=' . $username . "&NH=1&db=1\">\r\n\t\t\t\t\t<i class=\"icon-cancel-circled2\"></i> Delete User From database\r\n\t\t\t\t  </a>\r\n\t\t\t\t  \r\n\t\t\t</div>\r\n\t\t\t\t\r\n\t\t\t\t<span id=\"spin\" class='icon-spin5'></span>";
        echo '<div id=\'result\'>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\$('documnet').ready(function(){\r\n\t\t\t\$('#delete').click(function(e){\r\n\t\t\t\te.preventDefaults;\r\n\t\t\t\t\r\n\t\t\t\tif(!confirm('Are you sure?')) return false;\r\n\t\t\t\t\r\n\t\t\t\t\$('#spin').addClass('animate-spin');\r\n\t\t\t\t\$.get( \$(this).attr('href'), function( data ) {\r\n\t\t\t\t\t\$( \"#result\" ).html( data );\r\n\t\t\t\t\t\$('#spin').removeClass('animate-spin');\r\n\t\t\t\t});\r\n\t\t\t\treturn false;\r\n\t\t\t});\r\n\t\t\t\r\n\t\t});\r\n\t\t</script>";
    }
    public function ResetPassForm()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $use_remote = intval($intro->input->get_post('use_remote'));

        // For remote users, get username from remote server
        if($use_remote == 1) {
            $remote_host = '204.188.233.170';
            $remote_user = 'root';
            $remote_pass = 'R7nMi4KCzZv920pG';
            $remote_db = 'midnight_iptv';

            $get_sql = "SELECT username FROM \\`lines\\` WHERE id = $id LIMIT 1;";
            $get_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                       escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db .
                       " -N -e \"" . $get_sql . "\"' 2>&1";
            $username = trim(shell_exec($get_cmd));

            if(empty($username)) {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Remote user not found!', 'danger');
                exit();
            }

            $this->nav();
            echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Reset Password for remote user: ' . $username, 'info');
            echo "<table class=\"table table-striped table-bordered\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>Username:</td>\r\n\t\t\t\t<td>" . $username . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td></td>\r\n\t\t\t\t<td>\r\n\t\t\t\t<a class=\"btn btn-success p_del\" id=\"btnResetPass\" href=\"" . $this->base . '/ResetPass?id=' . $id . '&use_remote=' . $use_remote . "&NH=1\">\r\n\t\t\t\t\t<i class=\"icon-cancel-circled2\"></i> Yes: Reset Password\r\n\t\t\t\t  </a>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t</table>";
            echo '<span id="spin" class=\'icon-spin5\'></span>';
            exit();
        }

        // Original local database logic
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        if( !is_array($row) )
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('User is not found or deleted. OR you are not authorized to edit this user.', 'danger');
            exit();
        }
        @extract($row);
        $sql2 = $intro->db->query('SELECT * FROM ' . PREFIX . ('_users_data where userid=' . $id . ';'));
        $row2 = $intro->db->fetch_assoc($sql2);
        @extract($row2);
        $exp_date = ($exp_date != '' ? date('Y-m-d H:s', $exp_date) : 'Unlimited');
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Reset Password for user: ' . $username, 'info');
        echo "<table class=\"table table-striped table-bordered\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>Username:</td>\r\n\t\t\t\t<td>" . $username . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td></td>\r\n\t\t\t\t<td>\r\n\t\t\t\t<a class=\"btn btn-success p_del\" id=\"btnResetPass\" href=\"" . $this->base . '/ResetPass?id=' . $id . "&NH=1\">\r\n\t\t\t\t\t<i class=\"icon-cancel-circled2\"></i> Yes: Reset Password\r\n\t\t\t\t  </a>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t</table>";
        echo '<span id="spin" class=\'icon-spin5\'></span>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\$('documnet').ready(function(){\r\n\t\t\t\$('#btnResetPass').click(function(e){\r\n\t\t\t\te.preventDefaults;\r\n\t\t\t\t\r\n\t\t\t\tif(!confirm('Are you sure?')) return false;\r\n\t\t\t\t\r\n\t\t\t\t\$('#spin').addClass('animate-spin');\r\n\t\t\t\t\$.get( \$(this).attr('href'), function( data ) {\r\n\t\t\t\t\t\$( \"#result\" ).html( data );\r\n\t\t\t\t\t\$('#spin').removeClass('animate-spin');\r\n\t\t\t\t});\r\n\t\t\t\treturn false;\r\n\t\t\t});\r\n\t\t\t\r\n\t\t});\r\n\t\t</script>";
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $period;
        global $fullname;
        global $code;
        global $days;
        global $adminid;
        global $status;
        global $created_at;
        global $num;
        global $bouquets;
        global $forced_country;
        global $allowed_ua;
        global $allowed_ips;
        global $mobile;
        global $username;
        global $free_days;
        global $length;
        global $member_id;
        global $options;
        global $container;
        global $password;
        global $admin_notes;
        global $reseller_notes;
        global $force_server_id;
        global $bypass_ua;
        global $is_stalker;
        global $is_isplock;
        global $max_connections;
        global $bouquet;
        global $is_restreamer;
        global $created_by;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $IF = intval($intro->input->get_post('IF'));
        $id = $userid = intval($intro->input->get_post('id'));
        $page = intval($intro->input->get_post('page'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        $btn = [];
        $password_dis = '';
        $user_dis = '';
        if( $IF != 1 ) 
        {
            $this->nav();
        }
        if( $t == 'edit' )
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $use_remote = intval($intro->input->get_post('use_remote'));

            // Check if editing remote user
            if($use_remote == 1) {
                // Fetch from remote server
                $remote_host = '204.188.233.170';
                $remote_user = 'root';
                $remote_pass = 'R7nMi4KCzZv920pG';
                $remote_db = 'midnight_iptv';

                $data_sql = "SELECT id, username, password, expire_date, max_allowed_connections, disabled, created_time, https, bouquets, last_ip, last_country, last_isp, last_channel, last_disconnection_time FROM \\`lines\\` WHERE id = $id LIMIT 1;";
                $data_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                            escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db .
                            " -N -e \"" . $data_sql . "\"' 2>&1";

                $output = trim(shell_exec($data_cmd));

                if(empty($output)) {
                    echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("Error: Remote user not found", 'danger');
                    exit();
                }

                $fields = explode("\t", $output);

                // Process bouquets from remote server
                $remote_bouquets = isset($fields[8]) ? trim($fields[8]) : '';
                $bouquet_array = [];
                if(!empty($remote_bouquets)) {
                    // Convert comma-separated string to array
                    $bouquet_array = explode(',', $remote_bouquets);
                    $bouquet_array = array_map('trim', $bouquet_array);
                }

                // Fetch channel name if last_channel exists
                $last_channel_name = '';
                $last_channel_id = intval($fields[12] ?? 0);
                if($last_channel_id > 0) {
                    $channel_sql = "SELECT name FROM \\`streams\\` WHERE id = $last_channel_id LIMIT 1;";
                    $channel_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=5 " .
                                   escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db .
                                   " -N -e \"" . $channel_sql . "\"' 2>&1";
                    $last_channel_name = trim(shell_exec($channel_cmd));
                }

                $row = [
                    'id' => $fields[0],
                    'username' => $fields[1],
                    'password' => $fields[2],
                    'exp_date' => $fields[3],
                    'max_connections' => intval($fields[4]),
                    'enabled' => 1 - intval($fields[5] ?? 0),
                    'admin_enabled' => 1,
                    'created_at' => intval($fields[6] ?? time()),
                    'bouquet' => $bouquet_array,  // Store as array for form display
                    'allowed_ua' => '',
                    'allowed_ips' => '',
                    'is_restreamer' => 0,
                    'is_trial' => 0,
                    'https_port' => intval($fields[7] ?? 0),  // HTTPS port flag from remote server
                    'last_ip' => $fields[9] ?? '',
                    'last_country' => $fields[10] ?? '',
                    'last_isp' => $fields[11] ?? '',
                    'last_channel_id' => $last_channel_id,
                    'last_channel_name' => $last_channel_name,
                    'last_disconnection_time' => intval($fields[13] ?? 0)
                ];
                $row2 = ['fullname' => '', 'mobile' => '', 'period' => 0];
            } else {
                // Fetch from local database
                $qry = '';
                $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
                $row = $intro->db->fetch_assoc($sql);
                $sql2 = $intro->db->query('SELECT * FROM ' . PREFIX . ('_users_data where userid=' . $id . ';'));
                $row2 = $intro->db->fetch_assoc($sql2);
            }

            @extract($row);
            @extract($row2);

            if( $username == '' )
            {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("Error: you cannot change this user:\r\n\t\t\t\t\t<li>The user may not found or is deleted.\r\n\t\t\t\t\t<li>Or you don't have the right permisions to edit this user.", 'danger');
                exit();
            }
            $btn['legend_name'] = 'Edit user: <b>' . $username . '</b>';
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';

            // Handle bouquet decoding - check if it's already an array (from remote server) or JSON string (from local DB)
            if(!is_array($bouquet)) {
                $bouquet = json_decode($bouquet, true);
            }
            if(!is_array($bouquet)) {
                $bouquet = [];
            }
            if( $allowed_ua != '' ) 
            {
                $tmp_ua = json_decode($allowed_ua, true);
                $allowed_ua = implode(',', $tmp_ua);
            }
            if( $allowed_ips != '' ) 
            {
                $tmp_ua = json_decode($allowed_ips, true);
                $allowed_ips = implode(',', $tmp_ua);
            }
            if( $this->adminRow['can_set_pass'] == 0 && $this->adminRow['level'] != 1 ) 
            {
                $password_dis = 'readonly=\'\'';
            }
            if( $this->admin['level'] != 1 ) 
            {
            }
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            new IntroPerms('CheckBalance', $this->adminRow);
            $btn['legend_name'] = 'Add new User';
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = $intro->lang['save'];
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            $num = ($num == '' ? 1 : $num);
            $length = ($length == '' ? 12 : $length);
            if( $this->adminRow['num_free'] == 0 ) 
            {
            }
            $max_connections = ($max_connections == '' ? 1 : $max_connections);
            $is_isplock = ($is_isplock == '' ? 0 : $is_isplock);
            $https_port = ($https_port == '' ? 1 : $https_port);  // Default HTTPS to enabled (1)
            $enabled = ($enabled == '' ? 1 : $enabled);

            // Check if adding to remote server
            $use_remote = intval($intro->input->get_post('use_remote'));
            if($use_remote == 1) {
                // For remote users, fetch available bouquets from remote server
                $remote_host = '204.188.233.170';
                $remote_user = 'root';
                $remote_pass = 'R7nMi4KCzZv920pG';
                $remote_db = 'midnight_iptv';

                // Fetch bouquets list from remote
                $bouquets_sql = "SELECT id, bouquet_name FROM \\`bouquets\\` ORDER BY bouquet_order ASC;";
                $bouquets_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                               escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db .
                               " -N -e \"" . $bouquets_sql . "\"' 2>&1";

                $bouquets_output = trim(shell_exec($bouquets_cmd));
                $remote_bouquets = [];
                if(!empty($bouquets_output)) {
                    $lines = explode("\n", $bouquets_output);
                    foreach($lines as $line) {
                        if(!empty(trim($line))) {
                            $parts = explode("\t", $line, 2);
                            if(count($parts) == 2) {
                                $remote_bouquets[$parts[0]] = $parts[1];
                            }
                        }
                    }
                }
            }

            if( isset($_POST['bouquets']) && count($intro->input->post('bouquets')) > 0 )
            {
                $bouquet = $intro->input->post('bouquets');
            }
            if( $member_id == '' )
            {
                $member_id = $this->admin['adminid'];
            }
            if( $intro->input->get_post('adminid') != '' )
            {
                $member_id = intval($intro->input->get_post('adminid'));
            }
            if( $this->adminRow['can_set_pass'] == 0 && $this->adminRow['level'] != 1 )
            {
                $password_dis = 'disabled=\'\'';
                $password = 'Auto Generated';
            }
        }
        $use_remote = intval($intro->input->get_post('use_remote'));
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ') . ("\r\n\t\t\r\n\t\t<form method=\"POST\" name=\"form_add\" id='frmUsers' action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\r\n\t\t<table class=\"table table-bordered\">\r\n\t\t<tr>\r\n\t\t\t<td>") . $intro->lang['codes_fullname'] . (" : </td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"fullname\" value=\"" . $fullname . "\" class=\"form-control\" style='min-width:70%'>\r\n\t\t\t\t\t" . $this->error('fullname') . "\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Mobile : </td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"mobile\" value=\"" . $mobile . "\" class=\"form-control\"  style='min-width:70%'> \r\n\t\t\t\t\t" . $this->error('mobile') . "\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Username : <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td><div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"username\" value=\"" . $username . '" class="form-control" style=\'min-width:300px\' ' . $user_dis . "> \r\n\t\t\t\t\t" . $this->error('username') . "\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Password :  </td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"password\" " . $password_dis . ' value="' . $password . "\" class=\"form-control\" style='min-width:300px' placeholder=\"Leave empty for random password\">\r\n\t\t\t\t\t" . $this->error('password') . "\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>");
        if( $this->adminRow['member_group_id'] > 0 && $t == 'add' ) 
        {
            $pkg = new Packages($this->adminRow);
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Package: <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td>";
            echo $pkg->FormDropDown();
            echo "\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Bouquets:  <span style='color:#ff0000'>*</span>\r\n\t\t\t\t\t<div style=\"float:right;\">\r\n\t\t\t\t\t\t   <input type=\"checkbox\" id=\"checkAll\"/> <b>Check All</b>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td> " . $this->error('bouquets') . " <div id='bouquets_result'></div></td>\r\n\t\t\t</tr>";
        }
        if( $this->adminRow['member_group_id'] == 0 && ($this->admin['level'] == 1 || $t == 'add') ) 
        {
            echo "\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Period (days) : </td>\r\n\t\t\t\t\t<td><div class=\"form-inline\">\r\n\t\t\t\t\t\t\t" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period', _obf_0D322A5B141A102E2824032B03230A35140306272F2F11('page_users'), $period) . (string)$this->error('period');
            if( $this->admin['level'] == 1 ) 
            {
                echo '<span id="span_free_days" style="display:none">Free Extra Days: <input  type="number" name="free_days" value="' . $free_days . '" ' . (($t == 'add' ? 'min="1"' : '')) . ' class="form-control" size="10"></span>';
            }
            else if( strlen($this->adminRow['extra_free_days']) >= 2 ) 
            {
                echo extra_free_days($this->adminRow['extra_free_days'], $free_days);
            }
            echo "\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t</td>\r\n\t\t\t\t</tr>";
        }
        if( $t == 'edit' ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Created On : </td>\r\n\t\t\t\t<td>" . date('Y-m-d H:i:s', $created_at) . "</td>\r\n\t\t\t</tr>";
        }
        // Show End Date only for local users (not remote users)
        if( $this->admin['level'] == 1 && $t == 'edit' && $use_remote == 0)
        {
            if( $exp_date == '' )
            {
                $exp_date = 'UNLIMITED';
            }
            else
            {
                $exp_date = date('Y-m-d H:i:s', $exp_date);
            }
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>End Date : </td>\r\n\t\t\t\t<td><input type=\"text\" name=\"exp_date\" class=\"form-control date_picker\" value=\"" . $exp_date . "\" size=\"25\" placeholder=\"YYYY-MM-DD HH:MM:SS\"></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Is Trial  : </td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('is_trial', $is_trial, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>";
        }
        if( $this->adminRow['member_group_id'] == 0 || $this->admin['level'] == 1 || $t == 'edit' ) 
        {
            if( $this->admin['level'] == 1 ) 
            {
                echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Output formats  : <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td>" . $this->stream_output_format($userid, $t) . "</td>\r\n\t\t\t</tr>";
            }
            if( $this->adminRow['member_group_id'] > 0 ) 
            {
                $intro->member_group_id = $this->adminRow['member_group_id'];
                $intro->code_pkg = $pkg;
            }
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Bouquets: <span style='color:#ff0000'>*</span>\r\n\t\t\t\t\t<div style=\"float:right;\">\r\n\t\t\t\t\t\t   <input type=\"checkbox\" id=\"checkAll\"/> <b>Check All</b>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td> " . $this->error('bouquets') . ' ' . bouquets($bouquet) . "</td>\r\n\t\t\t</tr>";
        }
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Force Connect to:  </td>\r\n\t\t\t\t<td>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('force_server_id', 'Don\'t Force', 'streaming_servers', $force_server_id, 'id', 'server_name', 'bouquet_status', 'where `status`=1', 'order by server_name asc') . "</td>\r\n\t\t\t</tr>";
        }
        if( $this->admin['level'] == 1 || $this->adminRow['can_set_country'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Override General Country Restriction:  </td>\r\n\t\t\t\t<td> " . forced_country($forced_country) . ' ' . (($t == 'edit' ? '(' . $forced_country . ')' : '')) . "</td>\r\n\t\t\t</tr>";
        }
        // Show Max Connections for remote users OR admin users
        if($use_remote == 1) {
            // Show alert that user is being added/edited on remote server
            if($t == 'add') {
                echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td colspan='2'>\r\n\t\t\t\t\t<div class='alert alert-info' style='margin:10px 0;'>\r\n\t\t\t\t\t\t<strong><i class='icon-info-circled'></i> Remote Server Mode:</strong> This user will be created on remote server (204.188.233.170)\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
            }

            // Show Period (days) field for remote users to auto-calculate End Date
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Period (days) : </td>\r\n\t\t\t\t<td><div class=\"form-inline\">\r\n\t\t\t\t\t\t" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period', _obf_0D322A5B141A102E2824032B03230A35140306272F2F11('page_users'), $period) . (string)$this->error('period') . "\r\n\t\t\t\t</div></td>\r\n\t\t\t</tr>";

            // Show End Date field for remote users (in both add and edit modes)
            $exp_date_display = '';
            if($t == 'edit') {
                if($exp_date == '' || $exp_date == 0 || is_null($exp_date)) {
                    $exp_date_display = 'UNLIMITED';
                } else if($exp_date == -1 || $exp_date == 'UNLIMITED') {
                    $exp_date_display = 'UNLIMITED';
                } else {
                    $exp_date_display = date('Y-m-d H:i:s', $exp_date);
                }
            } else if($t == 'add') {
                // For add mode, leave empty to auto-calculate from period
                $exp_date_display = '';
            }
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>End Date : </td>\r\n\t\t\t\t<td><input type=\"text\" name=\"exp_date\" class=\"form-control date_picker\" value=\"" . $exp_date_display . "\" size=\"25\" placeholder=\"YYYY-MM-DD HH:MM:SS or type UNLIMITED\"></td>\r\n\t\t\t</tr>";

            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Max Allowed Connections :</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t\t<input class=\"form-control\" type=\"number\" name=\"max_connections\" value=\"" . $max_connections . '" min="1" max="999"> ' . $this->error('max_connections') . " \r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Connect to HTTPS port :</td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('https_port', $https_port, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>";
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Status :</td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('enabled', $enabled, 1, 'Enabled', 'Disabled', 'success') . "</td>\r\n\t\t\t</tr>";

            // Show activity information for remote users in edit mode
            if($t == 'edit') {
                echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td colspan='2' style='background:#f5f5f5;padding:10px;'>\r\n\t\t\t\t\t<h4 style='margin-top:0;color:#667eea;'><i class='icon-info-circled'></i> Activity Information</h4>\r\n\t\t\t\t\t<table class='table table-condensed' style='background:white;margin-bottom:0;'>";

                // Last IP
                $last_ip_display = isset($row['last_ip']) && !empty($row['last_ip']) ? $row['last_ip'] : '<span style="color:#999;">Not available</span>';
                echo "\r\n\t\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t\t<td style='width:200px;'><strong>Last IP Address:</strong></td>\r\n\t\t\t\t\t\t\t<td>" . $last_ip_display . "</td>\r\n\t\t\t\t\t\t</tr>";

                // Country
                $last_country_display = isset($row['last_country']) && !empty($row['last_country']) ? $row['last_country'] : '<span style="color:#999;">Not available</span>';
                echo "\r\n\t\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t\t<td><strong>Country:</strong></td>\r\n\t\t\t\t\t\t\t<td>" . $last_country_display . "</td>\r\n\t\t\t\t\t\t</tr>";

                // ISP
                $last_isp_display = isset($row['last_isp']) && !empty($row['last_isp']) ? htmlspecialchars($row['last_isp']) : '<span style="color:#999;">Not available</span>';
                echo "\r\n\t\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t\t<td><strong>ISP:</strong></td>\r\n\t\t\t\t\t\t\t<td>" . $last_isp_display . "</td>\r\n\t\t\t\t\t\t</tr>";

                // Last Channel
                $last_channel_display = '<span style="color:#999;">Not available</span>';
                if(isset($row['last_channel_id']) && $row['last_channel_id'] > 0) {
                    if(!empty($row['last_channel_name'])) {
                        $last_channel_display = htmlspecialchars($row['last_channel_name']) . ' <span style="color:#999;">(ID: ' . $row['last_channel_id'] . ')</span>';
                    } else {
                        $last_channel_display = 'Channel ID: ' . $row['last_channel_id'];
                    }
                }
                echo "\r\n\t\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t\t<td><strong>Last Channel:</strong></td>\r\n\t\t\t\t\t\t\t<td>" . $last_channel_display . "</td>\r\n\t\t\t\t\t\t</tr>";

                // Disconnection Time
                $disconn_time_display = '<span style="color:#999;">Not available</span>';
                if(isset($row['last_disconnection_time']) && $row['last_disconnection_time'] > 0) {
                    $disconn_time_display = date('Y-m-d H:i:s', $row['last_disconnection_time']);
                }
                echo "\r\n\t\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t\t<td><strong>Last Disconnection:</strong></td>\r\n\t\t\t\t\t\t\t<td>" . $disconn_time_display . "</td>\r\n\t\t\t\t\t\t</tr>";

                echo "\r\n\t\t\t\t\t</table>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
            }
        }

        if( $this->admin['level'] == 1 )
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>STALKER Portal  : </td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('is_stalker', $is_stalker, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>";
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Lock user to his ISP :</td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('is_isplock', $is_isplock, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Bypass Global User Agent Restriction List :</td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('bypass_ua', $bypass_ua, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>";
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Is Restreamer :</td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('is_restreamer', $is_restreamer, 1, 'Yes', 'No', 'success') . "</td>\r\n\t\t\t</tr>";

            // Only show Max Connections here if NOT a remote user (remote users have their own Max Allowed Connections field)
            if($use_remote == 0) {
                echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Max Connections :</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t\t<input class=\"form-control\" type=\"text\" name=\"max_connections\" value=\"" . $max_connections . '"> ' . $this->error('max_connections') . " \r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";

                // Add HTTPS port toggle for local users too
                echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Connect to HTTPS port :</td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('https_port', $https_port, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>";
            }
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Allowed IPs :</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t\t<input class=\"form-control\" data-role=\"tagsinput\" type=\"text\" name=\"allowed_ips\" value=\"" . $allowed_ips . '" size="30"> ' . $this->error('allowed_ips') . " \r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Allowed User Agent :</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t\t<input class=\"form-control\" data-role=\"tagsinput\" type=\"text\" name=\"allowed_ua\" value=\"" . $allowed_ua . '" size="30"> ' . $this->error('allowed_ua') . " <i>(Allowed User Agents to use this account [Default all allowed])</i>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>" . $intro->lang['codes_adminid'] . " : </td>\r\n\t\t\t\t<td>" . _obf_0D312C22263726180408322D1B0C363E320C351C1B0B32($member_id) . (' ' . $this->error('adminid') . "</td>\r\n\t\t\t</tr>");
        }
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Admin Notes :</td>\r\n\t\t\t\t<td><textarea name=\"admin_notes\" class=\"form-control\" style='width:100%;height:70px;'>" . $admin_notes . '</textarea> ' . $this->error('admin_notes') . "</td>\r\n\t\t\t</tr>";
        }
        echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Reseller Notes :</td>\r\n\t\t\t\t<td><textarea name=\"reseller_notes\" class=\"form-control\" style='width:100%;height:70px;'>" . $reseller_notes . '</textarea> ' . $this->error('reseller_notes') . "</td>\r\n\t\t\t</tr>";
        if( $t == 'add' ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Cost :</td>\r\n\t\t\t\t<td><div id='ResultCost'></div>" . $this->error('cost_err') . "</td>\r\n\t\t\t</tr>";
        }
        echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"userid\"  value=\"" . $userid . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"usernameold\"  value=\"" . $username . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $userid . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"IF\"  value=\"" . $IF . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"page\"  value=\"" . $page . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"use_remote\"  value=\"" . $use_remote . "\">\r\n\t\t\t\t\t<button type=\"submit\" class=\"btn btn-success\" value=\"" . $btn['action'] . '"><i class="' . $btn['img_icon'] . '"></i> ' . $btn['name'] . " </button>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\$(document).ready(function(){\r\n\t\t\t\r\n\t\t\t\$(\"select[name='package']\").change(function () {\r\n\t\t\t\t\r\n\t\t\t\tvar package = \$(this).val();\r\n\t\t\t\t\r\n\t\t\t\t\$.post(\"" . $intro->app_url('renew', 'getBouquets') . "/?NH=1\", \r\n\t\t\t\t\t{package:package}, function(data,status,xhr){\t\r\n\t\t\t\t\t\$(\"#bouquets_result\").html(data);\r\n\t\t\t\t\t/*\$(\"#checkAll\").trigger('click');*/\r\n\t\t\t\t\t\$(\"#UsersBouquets\").find(':checkbox').prop('checked', true);\r\n\t\t\t\t});\r\n\t\t\t\r\n\t\t\t\t\r\n\t\t\t});\r\n\t\t\t\$(\"select[name=period]\").change(function () {\r\n\t\t\t\t\r\n\t\t\t\tvar groupName = \$(this).val();\r\n\t\t\t\t\r\n\t\t\t\tCalcCost();\r\n\t\t\t\t\r\n\t\t\t\t// Auto-calculate End Date based on Period (days)\r\n\t\t\t\tif(groupName > 0 && groupName < 100000) {\r\n\t\t\t\t\tvar days = parseInt(groupName);\r\n\t\t\t\t\tvar currentDate = new Date();\r\n\t\t\t\t\tcurrentDate.setDate(currentDate.getDate() + days);\r\n\t\t\t\t\t\r\n\t\t\t\t\t// Format date as YYYY-MM-DD HH:MM:SS\r\n\t\t\t\t\tvar year = currentDate.getFullYear();\r\n\t\t\t\t\tvar month = String(currentDate.getMonth() + 1).padStart(2, \'0\');\r\n\t\t\t\t\tvar day = String(currentDate.getDate()).padStart(2, \'0\');\r\n\t\t\t\t\tvar hours = String(currentDate.getHours()).padStart(2, \'0\');\r\n\t\t\t\t\tvar minutes = String(currentDate.getMinutes()).padStart(2, \'0\');\r\n\t\t\t\t\tvar seconds = String(currentDate.getSeconds()).padStart(2, \'0\');\r\n\t\t\t\t\t\r\n\t\t\t\t\tvar formattedDate = year + \'-\' + month + \'-\' + day + \' \' + hours + \':\' + minutes + \':\' + seconds;\r\n\t\t\t\t\t\r\n\t\t\t\t\t// Update End Date field if it exists\r\n\t\t\t\t\tif($(\"input[name=\'exp_date\']\").length > 0) {\r\n\t\t\t\t\t\t$(\"input[name=\'exp_date\']\").val(formattedDate);\r\n\t\t\t\t\t}\r\n\t\t\t\t}\r\n\t\t\t\t\r\n\t\t\t\tif(groupName < 100 && groupName >= 1){\r\n\t\t\t\t\t\$('#span_free_days').show();\r\n\t\t\t\t\t\r\n\t\t\t\t}else{\r\n\t\t\t\t\t\$('#span_free_days').hide();\r\n\t\t\t\t}\r\n\t\t\t\t\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\tvar CalcCost = function (){\r\n\t\t\t\t\r\n\t\t\t\tvar period = parseInt(\$(\"select[name=period]\").val()) || 0;\r\n\t\t\t\tvar admin = parseInt(\$(\"select[name=adminid]\").val()) || 0;\r\n\r\n\t\t\t\t\$.post(\"" . $intro->app_url('renew', 'calcCost') . "/?NH=1\", \r\n\t\t\t\t\t{period:period,resel:admin}, function(data,status,xhr){\t\r\n\t\t\t\t\t\$(\"#ResultCost\").html(data);\r\n\t\t\t\t});\r\n\t\t\t}\r\n\t\t\t\r\n\t\t\t\$(\"#checkAll\").change(function () {\r\n\t\t\t\t\var isChecked = $(this).prop(\"checked\"); $(\"input[name='bouquets[]']\").prop('checked', isChecked);\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$(\"select[name=period]\").change(function () {\r\n\t\t\t\t\r\n\t\t\t\tvar groupName = \$(this).val();\r\n\t\t\t\t\r\n\t\t\t\tCalcCost();\r\n\t\t\t\t\r\n\t\t\t\tif(groupName < 100 && groupName >= 1){\r\n\t\t\t\t\t\$('#span_free_days').show();\r\n\t\t\t\t\t\r\n\t\t\t\t}else{\r\n\t\t\t\t\t\$('#span_free_days').hide();\r\n\t\t\t\t}\r\n\t\t\t\t\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$(\"select[name=adminid]\").change(function () {\r\n\t\t\t\tCalcCost();\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$(\"#frmUsers\").validate({\r\n\t\t\t\tignore: [],\r\n\t\t\t\trules: {\r\n\t\t\t\t\t\r\n\t\t\t\t\t\r\n\t\t\t\t\tadminid: \"required\",\r\n\t\t\t\t\tusername: {\r\n\t\t\t\t\t\trequired: true,\r\n\t\t\t\t\t\tminlength: 6\r\n\t\t\t\t\t},\r\n\t\t\t\t\t'stream_output_format[]': {\r\n\t\t\t\t\t\trequired: false,\r\n\t\t\t\t\t\tminlength: 1\r\n\t\t\t\t\t},\r\n\t\t\t\t\t'bouquets[]': {\r\n\t\t\t\t\t\trequired: false,\r\n\t\t\t\t\t\tminlength: 1\r\n\t\t\t\t\t}\r\n\t\t\t\t},\r\n\t\t\t\tmessages: {\r\n\t\t\t\t\tusername: \"Required! and minimum of 5 characters.\",\r\n\t\t\t\t\t'stream_output_format[]': \"Choose Output.\",\r\n\t\t\t\t\t'bouquets[]': \"Choose Bouquets.\"\r\n\t\t\t\t}\r\n\t\t\t});\r\n\t\t\t\r\n\t\t});";
        if( $period >= 1 && $period < 100 ) 
        {
            echo "\$('#span_free_days').show();\n";
        }
        else
        {
            echo "\$('#span_free_days').hide();\n";
        }
        echo "\r\n\t\t</script>";
        echo "<script>
// Fix Check All functionality for Bouquets
\$(document).ready(function(){
    \$(document).on('change', '#checkAll', function() {
        var isChecked = \$(this).prop('checked');
        \$('input[name=\"bouquets[]\"]').prop('checked', isChecked);
    });

    // Enhanced Period auto-calculation for remote users
    \$(document).on('change', 'select[name=period]', function(e) {
        // Stop propagation to prevent other handlers from running
        e.stopImmediatePropagation();

        var period = parseInt(\$(this).val());
        var periodText = \$(this).find('option:selected').text();
        var expDateField = \$('input[name=\"exp_date\"]');
        var currentExpDate = expDateField.val();

        console.log('[Period Change] Period selected:', period, '(Label: ' + periodText + ')');
        console.log('[Period Change] Current End Date value:', currentExpDate);
        console.log('[Period Change] End Date field found:', expDateField.length > 0);

        if(expDateField.length > 0) {
            // Convert period code to actual days
            var actualDays = 0;
            if(period >= 4294967295) {
                actualDays = 0; // Unlimited
            } else if(period == 101) {
                actualDays = 1;  // Free 1 day
            } else if(period == 103) {
                actualDays = 3;  // Free 3 days
            } else if(period == 107) {
                actualDays = 7;  // Free 7 days
            } else if(period == 110) {
                actualDays = 10; // Free 10 days
            } else if(period == 1) {
                actualDays = 30;  // 1 month
            } else if(period == 3) {
                actualDays = 90;  // 3 months
            } else if(period == 6) {
                actualDays = 180; // 6 months
            } else if(period == 12) {
                actualDays = 365; // 12 months (1 year)
            } else if(period == 24) {
                actualDays = 730; // 2 years
            } else if(period == 36) {
                actualDays = 1095; // 3 years
            } else {
                actualDays = period; // Use as-is if not a known code
            }

            console.log('[Period Change] Converted period', period, 'to', actualDays, 'actual days');

            // Always calculate and update End Date when Period changes
            if(actualDays == 0 && period > 0) {
                // Unlimited period
                expDateField.val('UNLIMITED');
                console.log('[Period Change] Set to UNLIMITED');
            } else if(actualDays > 0) {
                // Calculate future date from NOW using actual days
                var currentDate = new Date();
                currentDate.setDate(currentDate.getDate() + actualDays);

                // Format as YYYY-MM-DD HH:MM:SS
                var year = currentDate.getFullYear();
                var month = String(currentDate.getMonth() + 1).padStart(2, '0');
                var day = String(currentDate.getDate()).padStart(2, '0');
                var hours = String(currentDate.getHours()).padStart(2, '0');
                var minutes = String(currentDate.getMinutes()).padStart(2, '0');
                var seconds = String(currentDate.getSeconds()).padStart(2, '0');

                var formattedDate = year + '-' + month + '-' + day + ' ' + hours + ':' + minutes + ':' + seconds;
                expDateField.val(formattedDate);
                console.log('[Period Change] Calculated ' + actualDays + ' days from now');
                console.log('[Period Change] Set to:', formattedDate);
            } else if(period == 0) {
                // Period not selected - keep End Date as is
                console.log('[Period Change] Period = 0, keeping End Date as is');
            }
        } else {
            console.log('[Period Change] ERROR: End Date field not found!');
        }
    });
});
</script>";
    }
    public function stream_output_format($userid, $t = '')
    {
        global $intro;
        $html = '';
        $outputs = [
            '1' => 'HLS', 
            '2' => 'MPEGTS', 
            '3' => 'RTMP'
        ];
        $output = [];
        $sql = $intro->db->query('select access_output_id from user_output where user_id=' . $userid . ';');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $output[] = intval($row['access_output_id']);
        }
        if( isset($_POST['stream_output_format']) && count($_POST['stream_output_format']) > 0 ) 
        {
            $output = $intro->input->post('stream_output_format');
        }
        foreach( $outputs as $key => $val ) 
        {
            $html .= ("<label class=\"checkbox-inline\">\r\n\t\t\t\t<input type=\"checkbox\" name=\"stream_output_format[]\" value=\"" . $key . '" ' . (($t == 'add' ? 'checked' : '')) . ' ' . ((in_array($key, $output) ? 'checked' : '')) . ('> ' . $val . "\r\n\t\t\t\t</label>"));
        }
        return $html;
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        global $array;

        // Check if adding to remote server
        $use_remote = intval($intro->input->post('use_remote'));

        $fullname = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('fullname'), ' {ar}');
        $mobile = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('mobile'), '+-');
        $username = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('username'), $this->user_pattern);
        $password = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('password'));
        $allowed_ips = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('allowed_ips'), ',');
        $stream_output_format = $intro->input->post('stream_output_format');
        $period = intval($intro->input->post('period'));
        $adminid = intval($intro->input->post('adminid'));

        // If adding to remote server, handle it separately
        if($use_remote == 1) {
            // Basic validation
            if(empty($username)) {
                $error['username'] = '<span class=error>Username is required</span>';
                $this->Form('add');
                exit();
            }
            if(!empty($password) && strlen($password) < 6) {
                $error['password'] = '<span class=error>Password must be at least 6 characters</span>';
                $this->Form('add');
                exit();
            }

            // Add user to remote server
            $remote_host = '204.188.233.170';
            $remote_user = 'root';
            $remote_pass = 'R7nMi4KCzZv920pG';
            $remote_db = 'midnight_iptv';

            $pass = empty($password) ? substr(md5(rand()), 0, 12) : $password;
            $max_conn = intval($intro->input->post('max_connections'));
            if($max_conn == 0) $max_conn = 1;

            // Get manual exp_date input (if provided)
            $exp_date_input = trim($intro->input->post('exp_date'));

            // Convert period code to actual days
            $actual_days = 0;
            if($period >= 4294967295) {
                // Unlimited
                $actual_days = 0;
            } else if($period == 101) {
                $actual_days = 1;  // Free 1 day
            } else if($period == 103) {
                $actual_days = 3;  // Free 3 days
            } else if($period == 107) {
                $actual_days = 7;  // Free 7 days
            } else if($period == 110) {
                $actual_days = 10; // Free 10 days
            } else if($period == 1) {
                $actual_days = 30;  // 1 month
            } else if($period == 3) {
                $actual_days = 90;  // 3 months
            } else if($period == 6) {
                $actual_days = 180; // 6 months
            } else if($period == 12) {
                $actual_days = 365; // 12 months (1 year)
            } else if($period == 24) {
                $actual_days = 730; // 2 years
            } else if($period == 36) {
                $actual_days = 1095; // 3 years
            } else {
                $actual_days = $period; // Use as-is if not a known code
            }

            // Handle expiration date - Priority: 1) manual exp_date if provided, 2) calculated from period
            error_log("UNLIMITED DEBUG ADD - exp_date_input: '$exp_date_input', period: $period, actual_days: $actual_days");

            if(!empty($exp_date_input) && strtoupper($exp_date_input) === 'UNLIMITED') {
                // User manually typed UNLIMITED
                $exp_date = 0;
                error_log("UNLIMITED DEBUG ADD - User typed UNLIMITED, set exp_date to 0");
            } else if(!empty($exp_date_input)) {
                // User manually entered a date
                $exp_date = strtotime($exp_date_input);
                if($exp_date === false) {
                    $exp_date = time() + (30 * 24 * 60 * 60); // Default 30 days
                }
                error_log("UNLIMITED DEBUG ADD - Used manual exp_date: $exp_date");
            } else if($actual_days == 0 && $period > 0) {
                // Unlimited period selected
                $exp_date = 0;
                error_log("UNLIMITED DEBUG ADD - Period is unlimited, set exp_date to 0");
            } else if($actual_days > 0) {
                // Calculate from period
                $exp_date = time() + ($actual_days * 24 * 60 * 60);
                error_log("UNLIMITED DEBUG ADD - Calculated exp_date: $exp_date ($actual_days days)");
            } else {
                // No period selected, default to 30 days
                $exp_date = time() + (30 * 24 * 60 * 60);
                error_log("UNLIMITED DEBUG ADD - No period, default 30 days");
            }

            $https_port = intval($intro->input->post('https_port'));
            $enabled = intval($intro->input->post('enabled'));
            $disabled = ($enabled == 1) ? 0 : 1;
            $bouquets = $intro->input->post('bouquets');

            // Debug logging
            error_log("REMOTE ADD DEBUG - https_port posted value: " . $intro->input->post('https_port'));
            error_log("REMOTE ADD DEBUG - https_port intval: $https_port");
            error_log("REMOTE ADD DEBUG - enabled posted value: " . $intro->input->post('enabled'));
            error_log("REMOTE ADD DEBUG - enabled intval: $enabled");
            error_log("REMOTE ADD DEBUG - disabled calculated: $disabled");

            // Process bouquets - convert array to comma-separated string
            $bouquets_str = '';
            if(is_array($bouquets) && count($bouquets) > 0) {
                $bouquets_str = implode(',', $bouquets);
            } else {
                $bouquets_str = '1'; // Default bouquet
            }

            $insert_sql = "INSERT INTO `lines` (username, password, expire_date, max_allowed_connections, disabled, created_time, https, bouquets) VALUES ('" . addslashes($username) . "', '" . addslashes($pass) . "', $exp_date, $max_conn, $disabled, " . time() . ", $https_port, '" . addslashes($bouquets_str) . "')";

            // Log the SQL for debugging
            error_log("REMOTE ADD SQL: $insert_sql");

            // Escape backticks and single quotes for shell execution
            $sql_for_shell = str_replace('`', '\`', $insert_sql);
            $sql_for_shell = str_replace("'", "'\"'\"'", $sql_for_shell);

            $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                   escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " " .
                   "'mysql " . $remote_db . " -e \"" . $sql_for_shell . "\"' 2>&1";

            $output = trim(shell_exec($cmd));

            if(strpos($output, 'ERROR') !== false || strpos($output, 'Duplicate') !== false) {
                $error['username'] = '<span class=error>Failed to add user to remote server. User may already exist.</span>';
                $this->Form('add');
                exit();
            }

            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('User added successfully to remote server!', 'success');
            $intro->redirect($this->appname . '/index?use_remote=1');
            exit();
        }
        $bypass_ua = intval($intro->input->post('bypass_ua'));
        $is_isplock = intval($intro->input->post('is_isplock'));
        $is_stalker = intval($intro->input->post('is_stalker'));
        $max_connections = intval($intro->input->post('max_connections'));
        $is_restreamer = intval($intro->input->post('is_restreamer'));
        $free_days = intval($intro->input->post('free_days'));
        $package = intval($intro->input->post('package'));
        $bouquets = $intro->input->post('bouquets');
        $forced_country = trim($intro->input->post('forced_country'));
        $allowed_ua = trim($intro->input->post('allowed_ua'));
        $admin_notes = $intro->db->escape($intro->input->post('admin_notes'));
        $reseller_notes = $intro->db->escape($intro->input->post('reseller_notes'));
        if( $adminid == 0 && $this->admin['level'] != 1 ) 
        {
            $adminid = intval($this->admin['adminid']);
        }
        if( $username == '' || $password != '' && strlen($password) < 6 || $adminid == 0 || $bouquets == null || $this->adminRow['num_free'] == 0 && in_array($period, $array['free']) && $package == 0 )
        {
            if( $username == '' )
            {
                $error['username'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $password != '' && strlen($password) < 6 )
            {
                $error['password'] = '<span class=error>The password must be at least six characters in length.</span>';
            }
            if( $period == 0 && $package == 0 ) 
            {
                $error['period'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $this->adminRow['num_free'] == 0 && in_array($period, $array['free']) && $package == 0 ) 
            {
                $error['period'] = '<span class=error>Error: you can\'t Add free users at this time. Please contact admin.</span>';
            }
            if( $adminid == 0 ) 
            {
                $error['adminid'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $bouquets == null ) 
            {
                $error['bouquets'] = '<span class=error>Please choose at least one Bouquets/PACKAGE</span>';
            }
            $this->Form('add');
            exit();
        }
        $sql = $intro->db->query('SELECT username FROM users where username=\'' . $username . '\';');
        if( $intro->db->returned_rows > 0 ) 
        {
            $error['username'] = '<span class=error>Username already exists! Please choose another one.</span>';
            $this->Form('add');
            exit();
        }
        // Username/Password similarity check disabled
        /*
        if( $password != '' )
        {
            similar_text($username, $password, $perc);
            $reverse_similar = false;
            similar_text($username, strrev($password), $perc2);
            if( round($perc) >= 80 || round($perc2) >= 80 )
            {
                $error['password'] = '<span class=error>Username and Password are too similar (' . round(max($perc, $perc2)) . '% match). Please use a more different password.</span>';
                $this->Form('add');
                exit();
            }
        }
        */
        $adm = $intro->auth->admin_data($adminid);
        // Cost check completely disabled to allow all admins to add users without cost configuration
        /*
        $p = new IntroPerms('CheckCost', $adm, 1, $period, $package);
        if( $p->error != '' )
        {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011($p->error, 'danger');
            $error['cost_err'] = _obf_0D3D40321528110F062A0B0321102712170C15030F2232($p->error, 'danger');
            $this->Form('add');
            exit();
        }
        */
        if( $max_connections == 0 ) 
        {
            $max_connections = 1;
        }
        $data = $data2 = [];
        $data2['fullname'] = $fullname;
        $data2['mobile'] = $mobile;
        $data2['period'] = $period;
        $data2['free_days'] = $free_days;
        $data['username'] = $username;
        $data['password'] = ($password == '' ? _obf_0D2F32243C12041507380F0603331A24041D1E32150A32() : $password);
        $data['bypass_ua'] = $bypass_ua;
        $data['member_id'] = $adminid;
        $data['is_isplock'] = $is_isplock;
        $data['is_stalker'] = $is_stalker;
        $data['is_restreamer'] = $is_restreamer;
        $data['created_by'] = $adminid;
        $data['max_connections'] = $max_connections;
        $data['https'] = intval($intro->input->post('https_port'));  // Save HTTPS port setting
        $data['exp_date'] = _obf_0D1E12391F102F2E2A3E23330537315C320C3910402322($period, $free_days);
        $data['bouquet'] = '[' . implode(',', $bouquets) . ']';
        $data['forced_country'] = $forced_country;
        $data['allowed_ua'] = $this->allowed_uagent($allowed_ua, 'save');
        $data['allowed_ips'] = $this->allowed_uagent($allowed_ips, 'save');
        $data['is_trial'] = (in_array($period, $array['free']) && $period != -1 ? 1 : 0);
        $data['admin_enabled'] = 1;
        $data['enabled'] = 1;
        $data['created_at'] = time();
        $data['pkg'] = $package;
        $data['admin_notes'] = $admin_notes . '';
        $data['reseller_notes'] = $reseller_notes . '';
        $data['force_server_id'] = intval($intro->input->post('force_server_id'));
        if( $package > 0 ) 
        {
            $pkg = _obf_0D0E122A21280A14271F3B1D1727291E290A0A2A092E11($package);
            $data['max_connections'] = $pkg['max_connections'];
            $data['exp_date'] = $pkg['exp_date'];
            $data['is_trial'] = $pkg['is_trial'];
            $data2['period'] = $package;
            $stream_output_format = $pkg['output_formats_array'];
        }
        $intro->db->insert('users', $data);
        $userid = $intro->db->insert_id();
        $data2['userid'] = $userid;
        $intro->db->insert('' . PREFIX . '_users_data', $data2, true);
        if( $this->admin['level'] == 1 ) 
        {
            foreach( $stream_output_format as $key => $val ) 
            {
                $intro->db->insert('user_output', [
                    'user_id' => $userid, 
                    'access_output_id' => $val
                ]);
            }
        }
        else
        {
            $intro->db->insert('user_output', [
                'user_id' => $userid, 
                'access_output_id' => 1
            ]);
            $intro->db->insert('user_output', [
                'user_id' => $userid, 
                'access_output_id' => 2
            ]);
        }
        $success = 1;
        if( $package == 0 ) 
        {
            if( !in_array($period, $array['free']) ) 
            {
                $inv = new IntroInvoice();
                $inv->set('adminid', $adminid);
                $inv->set('period', $period);
                $inv->set('num', 1);
                $inv->set('code_trans', 0);
                $inv->set('all_data', '');
                $inv->set('userid', $userid);
                $inv->set('notes', 'add user: ' . $username . ' Days:' . $array['period'][$period]);
                $inv->Save();
            }
        }
        else
        {
            $inv = new IntroInvoice();
            $inv->set('isPackage', true);
            $inv->set('adminid', $adminid);
            $inv->set('package', $package);
            $inv->set('period', $package);
            $inv->set('num', 1);
            $inv->set('code_trans', 0);
            $inv->set('all_data', '');
            $inv->set('userid', $userid);
            $inv->set('notes', 'add user: ' . $username . ' Days:' . $pkg['inv_notes']);
            $inv->Save();
        }
        if( in_array($period, $array['free']) && $this->adminRow['num_free'] > 0 && $success > 0 ) 
        {
            $intro->db->query('UPDATE ' . PREFIX . ('_admin SET num_free=num_free-' . $success . ' WHERE num_free>0 AND adminid=' . $adminid . ';'));
            if( $this->adminRow['father'] > 0 ) 
            {
                $intro->db->query('UPDATE ' . PREFIX . ('_admin SET num_free=num_free-' . $success . ' WHERE num_free>0 AND adminid=' . $this->adminRow['father'] . ';'));
            }
            $intro->db->query('UPDATE ' . PREFIX . '_admin SET num_free=0 WHERE num_free<-1;');
        }

        // Sync user to external XC panel via API with all options
        $sync_options = [
            'is_trial' => $data['is_trial'],
            'is_mag' => isset($data['is_mag']) ? $data['is_mag'] : 0,
            'is_stalker' => isset($data['is_stalker']) ? $data['is_stalker'] : 0,
            'is_restreamer' => isset($data['is_restreamer']) ? $data['is_restreamer'] : 0,
            'allowed_ips' => isset($data['allowed_ips']) ? $data['allowed_ips'] : '',
            'allowed_ua' => isset($data['allowed_ua']) ? $data['allowed_ua'] : '',
            'admin_notes' => isset($data['admin_notes']) ? $data['admin_notes'] : '',
            'reseller_notes' => isset($data['reseller_notes']) ? $data['reseller_notes'] : '',
            'bouquets' => isset($data['bouquet']) ? $data['bouquet'] : '[1]'
        ];
        $this->syncUserToExternalPanel($username, $data['password'], $data['exp_date'], $data['max_connections'], $sync_options);

        // Auto-sync to remote midnight_iptv database (204.188.233.170)
        $this->syncUserToRemoteDatabase($username, $data['password'], $data['exp_date'], $data['max_connections'], $data['https']);

        _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Username <strong>(' . $username . ')</strong> added successfully.', 'success');
        $intro->redirect($this->appname);
    }
    public function checkRepeated($string)
    {
        preg_match_all('/(.)\1+/', $string, $matches);
        $result = array_combine($matches[1], array_map('strlen', $matches[0]));
        arsort($result);
        if( isset($result[0]) && count($result[0]) >= 3 ) 
        {
            return false;
        }
        return true;
    }
    public function random_number($length)
    {
        $random = substr(number_format(time() * rand(), 0, '', ''), 0, $length);
        return $random;
    }
    public function allowed_uagent($allowed_ua, $for = 'save')
    {
        if( $for == 'save' ) 
        {
            if( $allowed_ua != '' ) 
            {
                $ex = explode(',', $allowed_ua);
                $agnet = json_encode($ex);
                return $agnet;
            }
            else
            {
                return '';
            }
        }
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        global $error;

        // Check if this is a remote user edit
        $use_remote = intval($intro->input->post('use_remote'));

        if($use_remote == 1) {
            // Handle remote server user edit
            $remote_host = '204.188.233.170';
            $remote_user = 'root';
            $remote_pass = 'R7nMi4KCzZv920pG';
            $remote_db = 'midnight_iptv';

            $userid = $id = intval($intro->input->get_post('userid'));
            $username = trim($intro->input->post('username'));
            $password = trim($intro->input->post('password'));
            $exp_date = trim($intro->input->post('exp_date'));
            $period = intval($intro->input->post('period'));
            $max_connections = intval($intro->input->post('max_connections'));
            $enabled = intval($intro->input->post('enabled'));
            $https_port = intval($intro->input->post('https_port'));
            $bouquets = $intro->input->post('bouquets');

            // Validate username
            if(empty($username)) {
                $_POST['userid'] = $userid;
                $_POST['id'] = $_POST['userid'];
                $error['username'] = '<span class=error>Username is required</span>';
                $this->Form('edit');
                exit();
            }

            // Username/Password similarity check disabled
            /*
            if($password != '') {
                similar_text($username, $password, $perc);
                $reverse_similar = false;
                similar_text($username, strrev($password), $perc2);
                if(round($perc) >= 80 || round($perc2) >= 80) {
                    $_POST['userid'] = $userid;
                    $_POST['id'] = $_POST['userid'];
                    $error['password'] = '<span class=error>Username and Password are too similar (' . round(max($perc, $perc2)) . '% match). Please use a more different password.</span>';
                    $this->Form('edit');
                    exit();
                }
            }
            */

            // Process bouquets - convert array to comma-separated string
            $bouquets_str = '';
            if(is_array($bouquets) && count($bouquets) > 0) {
                $bouquets_str = implode(',', $bouquets);
            }

            // Convert period code to actual days
            $actual_days = 0;
            if($period >= 4294967295) {
                $actual_days = 0; // Unlimited
            } else if($period == 101) {
                $actual_days = 1;  // Free 1 day
            } else if($period == 103) {
                $actual_days = 3;  // Free 3 days
            } else if($period == 107) {
                $actual_days = 7;  // Free 7 days
            } else if($period == 110) {
                $actual_days = 10; // Free 10 days
            } else if($period == 1) {
                $actual_days = 30;  // 1 month
            } else if($period == 3) {
                $actual_days = 90;  // 3 months
            } else if($period == 6) {
                $actual_days = 180; // 6 months
            } else if($period == 12) {
                $actual_days = 365; // 12 months (1 year)
            } else if($period == 24) {
                $actual_days = 730; // 2 years
            } else if($period == 36) {
                $actual_days = 1095; // 3 years
            } else {
                $actual_days = $period; // Use as-is if not a known code
            }

            // Convert exp_date to timestamp
            // Priority: 1) exp_date field if filled, 2) period if selected, 3) default 30 days
            $exp_timestamp = time();

            error_log("UNLIMITED DEBUG - exp_date: '$exp_date', period: $period, actual_days: $actual_days");

            if($exp_date === 'UNLIMITED' || strtoupper(trim($exp_date)) === 'UNLIMITED') {
                // Unlimited period - set to NULL for remote database
                $exp_timestamp = 'NULL';
                error_log("UNLIMITED DEBUG - exp_date is UNLIMITED, set timestamp to NULL");
            } else if(!empty($exp_date)) {
                $exp_timestamp = strtotime($exp_date);
                if($exp_timestamp === false) {
                    $exp_timestamp = time() + (30 * 24 * 60 * 60); // Default 30 days
                }
                error_log("UNLIMITED DEBUG - Used exp_date field, timestamp: $exp_timestamp");
            } else if($actual_days > 0) {
                // Use actual days to calculate expiration
                $exp_timestamp = time() + ($actual_days * 24 * 60 * 60);
                error_log("UNLIMITED DEBUG - Used actual_days: $actual_days, timestamp: $exp_timestamp");
            } else if($actual_days == 0 && $period > 0) {
                // Unlimited
                $exp_timestamp = 'NULL';
                error_log("UNLIMITED DEBUG - Period unlimited (actual_days=0, period>0), set timestamp to NULL");
            } else {
                // Default to unlimited if nothing else specified
                $exp_timestamp = 'NULL';
                error_log("UNLIMITED DEBUG - No specific expiration, set to NULL (unlimited)");
            }

            if($max_connections == 0) {
                $max_connections = 1;
            }

            $disabled = ($enabled == 1) ? 0 : 1;

            // Build UPDATE query with proper escaping
            $update_parts = [];
            $update_parts[] = "username='" . addslashes($username) . "'";

            // Only update password if provided
            if(!empty($password)) {
                $update_parts[] = "password='" . addslashes($password) . "'";
            }

            // Handle expire_date - use NULL for unlimited, or timestamp value
            if($exp_timestamp === 'NULL') {
                $update_parts[] = "expire_date=NULL";
            } else {
                $update_parts[] = "expire_date=$exp_timestamp";
            }

            $update_parts[] = "max_allowed_connections=$max_connections";
            $update_parts[] = "disabled=$disabled";
            $update_parts[] = "https=$https_port";

            // Add bouquets if provided
            if(!empty($bouquets_str)) {
                $update_parts[] = "bouquets='" . addslashes($bouquets_str) . "'";
            }

            $update_sql = "UPDATE `lines` SET " . implode(", ", $update_parts) . " WHERE id=$userid";

            // Execute on remote server - use proper shell escaping
            // Escape backticks for MySQL table name
            $sql_for_shell = str_replace('`', '\`', $update_sql);
            // Escape single quotes using '"'"' technique for bash
            $sql_for_shell = str_replace("'", "'\"'\"'", $sql_for_shell);

            $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                   escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " " .
                   "'mysql " . $remote_db . " -e \"" . $sql_for_shell . "\"' 2>&1";

            $output = trim(shell_exec($cmd));

            // Log the SQL for debugging
            error_log("Remote UPDATE SQL: " . $update_sql);
            error_log("Remote UPDATE Output: " . $output);

            // Check for errors
            if(stripos($output, 'error') !== false || stripos($output, 'failed') !== false) {
                $_POST['userid'] = $userid;
                $_POST['id'] = $_POST['userid'];
                $error['general'] = '<span class=error>Failed to update remote user: ' . htmlspecialchars($output) . '</span>';
                $this->Form('edit');
                exit();
            }

            // Check if output is empty (successful update)
            if(empty($output)) {
                _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('User updated successfully on remote server!', 'success');
            } else {
                // Show output for debugging
                _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Update executed. Output: ' . $output, 'info');
            }
            $intro->redirect($this->appname . '/index?use_remote=1');
            exit();
        }

        // Original local user edit code
        $userid = $id = intval($intro->input->get_post('userid'));
        $fullname = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('fullname'), ' {ar}');
        $mobile = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('mobile'), '\+');
        $usernameold = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('usernameold'), $this->user_pattern);
        $username = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('username'), $this->user_pattern);
        $password = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('password'));
        $stream_output_format = $intro->input->post('stream_output_format');
        $period = intval($intro->input->post('period'));
        $adminid = intval($intro->input->post('adminid'));
        $bypass_ua = intval($intro->input->post('bypass_ua'));
        $is_isplock = intval($intro->input->post('is_isplock'));
        $is_stalker = intval($intro->input->post('is_stalker'));
        $max_connections = intval($intro->input->post('max_connections'));
        $free_days = intval($intro->input->post('free_days'));
        $exp_date = trim($intro->input->post('exp_date'));
        $forced_country = trim($intro->input->post('forced_country'));
        $allowed_ua = trim($intro->input->post('allowed_ua'));
        $allowed_ips = trim($intro->input->post('allowed_ips'));
        $admin_notes = $intro->db->escape($intro->input->post('admin_notes'));
        $reseller_notes = $intro->db->escape($intro->input->post('reseller_notes'));
        $bouquets = $intro->input->post('bouquets');
        $sql = $intro->db->query('SELECT id FROM users ' . (' where username=\'' . $username . '\' AND id!=' . $userid . ';'));
        if( $intro->db->returned_rows > 0 )
        {
            $_POST['userid'] = $userid;
            $_POST['id'] = $_POST['userid'];
            $error['username'] = '<span class=error>' . $userid . ' Username (' . $username . ') already exists!</span>';
            $this->Form('edit');
            exit();
        }

        // Username/Password similarity check disabled
        /*
        if($password != '') {
            similar_text($username, $password, $perc);
            $reverse_similar = false;
            similar_text($username, strrev($password), $perc2);
            if(round($perc) >= 80 || round($perc2) >= 80) {
                $_POST['userid'] = $userid;
                $_POST['id'] = $_POST['userid'];
                $error['password'] = '<span class=error>Username and Password are too similar (' . round(max($perc, $perc2)) . '% match). Please use a more different password.</span>';
                $this->Form('edit');
                exit();
            }
        }
        */

        $data = $data2 = [];
        $data2['userid'] = $userid;
        $data2['fullname'] = $fullname;
        $data2['mobile'] = $mobile;
        if( $this->admin['level'] == 1 ) 
        {
            $data2['period'] = $period;
            $data2['free_days'] = $free_days;
            $data['member_id'] = intval($intro->input->post('adminid'));
            $data['created_by'] = intval($intro->input->post('adminid'));
            $data['admin_notes'] = $admin_notes . '';
            $data['max_connections'] = $max_connections;
            $data['https'] = intval($intro->input->post('https_port'));  // Save HTTPS port setting
            $data['exp_date'] = ($exp_date != '' && $exp_date != 'UNLIMITED' ? strtotime($exp_date) : null);
            $data['is_trial'] = (in_array($period, $array['free']) && $period != -1 ? 1 : 0);
            if( isset($_POST['is_trial']) ) 
            {
                $data['is_trial'] = intval($intro->input->post('is_trial'));
            }
            $data['is_restreamer'] = intval($intro->input->post('is_restreamer'));
            $data['force_server_id'] = intval($intro->input->post('force_server_id'));
        }
        else if( $reseller_notes != '' ) 
        {
            $data['reseller_notes'] = $reseller_notes;
        }
        $data['bouquet'] = '[' . implode(',', $bouquets) . ']';
        if( $this->admin['level'] == 1 ) 
        {
            $data['username'] = $username;
        }
        if( $this->adminRow['can_set_pass'] == 1 || $this->admin['level'] == 1 ) 
        {
            $data['password'] = ($password == '' ? _obf_0D060735305C5C07152D1733241F3E070A1221100A4032() : $password);
        }
        if( $this->admin['level'] == 1 ) 
        {
            $data['bypass_ua'] = $bypass_ua;
            $data['forced_country'] = $forced_country;
            $data['allowed_ua'] = $this->allowed_uagent($allowed_ua, 'save');
            $data['allowed_ips'] = $this->allowed_uagent($allowed_ips, 'save');
            $data['is_isplock'] = $is_isplock;
        }
        $data['is_stalker'] = $is_stalker;
        $qry = '';
        $intro->db->update('users', $data, 'id=' . $userid . ' ' . $this->qry_admin);
        $intro->db->insert_update('' . PREFIX . '_users_data', $data2, $data2);
        $outIDs = [];
        if( is_array($stream_output_format) && count($stream_output_format) > 0 ) 
        {
            foreach( $stream_output_format as $key => $val ) 
            {
                $sql = $intro->db->query('select user_id from user_output where user_id=' . $userid . ' AND access_output_id=' . $val);
                if( $intro->db->returned_rows == 0 ) 
                {
                    $intro->db->insert('user_output', [
                        'user_id' => $userid, 
                        'access_output_id' => $val
                    ]);
                }
                $outIDs[] = $val;
            }
        }
        if( count($outIDs) >= 1 )
        {
            $intro->db->query('delete from user_output where user_id=' . $userid . ' AND access_output_id NOT IN(' . implode(',', $outIDs) . ')');
        }

        // Sync updated user to remote database (204.188.233.170) with all options
        $final_password = isset($data['password']) ? $data['password'] : $password;
        $final_exp_date = isset($data['exp_date']) ? $data['exp_date'] : 0;
        $final_max_conn = isset($data['max_connections']) ? $data['max_connections'] : 1;
        $final_enabled = 1; // Default enabled

        $sync_options = [
            'is_trial' => isset($data['is_trial']) ? $data['is_trial'] : 0,
            'is_mag' => isset($data['is_mag']) ? $data['is_mag'] : 0,
            'is_stalker' => isset($data['is_stalker']) ? $data['is_stalker'] : 0,
            'is_restreamer' => isset($data['is_restreamer']) ? $data['is_restreamer'] : 0,
            'allowed_ips' => isset($data['allowed_ips']) ? $data['allowed_ips'] : '',
            'allowed_ua' => isset($data['allowed_ua']) ? $data['allowed_ua'] : '',
            'admin_notes' => isset($data['admin_notes']) ? $data['admin_notes'] : '',
            'reseller_notes' => isset($data['reseller_notes']) ? $data['reseller_notes'] : '',
            'bouquets' => isset($data['bouquet']) ? $data['bouquet'] : '[1]'
        ];
        $this->updateUserInRemoteDb($username, $final_password, $final_exp_date, $final_max_conn, $final_enabled, $sync_options);

        // Sync to Flix Panel
        $this->updateUserInFlixPanel($username, $final_password, $final_exp_date, $final_max_conn);

        $intro->redirect($this->appname);
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $use_remote = intval($intro->input->get_post('use_remote'));

        policy($sess_admin['adminid'], $this->appname . '.php', 'del');

        // If deleting from remote server only
        if($use_remote == 1) {
            if($this->admin['level'] == 1 || $this->admin['can_delete'] == 1) {
                // Get username from remote server
                $remote_host = '204.188.233.170';
                $remote_user = 'root';
                $remote_pass = 'R7nMi4KCzZv920pG';
                $remote_db = 'midnight_iptv';

                $get_sql = "SELECT username FROM \\`lines\\` WHERE id = $id LIMIT 1;";
                $get_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                           escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db .
                           " -N -e \"" . $get_sql . "\"' 2>&1";
                $username = trim(shell_exec($get_cmd));

                // Delete from remote
                $delete_sql = "DELETE FROM \\`lines\\` WHERE id = $id;";
                $delete_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                              escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db .
                              " -e \"" . $delete_sql . "\"' 2>&1";
                shell_exec($delete_cmd);

                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('User deleted from remote server!', 'success');
                echo "<script>\r\n\t\t\t\$(function () {\r\n\t\t\t   setTimeout(function()\r\n\t\t\t   {\r\n\t\t\t\t\t\$('#m3u-modal').modal('hide');\r\n\t\t\t\t\t\$('#tr_" . $id . "').fadeOut();\r\n\t\t\t   }, 1000);\r\n\t\t\t   \r\n\t\t\t});</script>";
                exit();
            } else {
                exit('<h1>Not authorized!</h1>');
            }
        }

        // Delete from local database
        $sql = $intro->db->query('SELECT id,username FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        $username = $row['username'];
        if( intval($row['id']) == 0 )
        {
            echo '<h1>Not authorized!</h1>';
            exit();
        }
        if( $this->admin['level'] == 1 || $this->admin['can_delete'] == 1 )
        {
            // Delete from local database
            $intro->db->query('delete from users WHERE id=' . $id . ' ' . $this->qry_admin);
            $intro->db->query('delete from user_output where user_id=' . $id . ';');

            // Delete from remote database (204.188.233.170)
            $this->deleteUserFromRemoteDb($username);

            // Delete from Flix Panel
            $this->deleteUserFromFlixPanel($username);

            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('user deleted form database forever!', 'success');
            echo "<script>\r\n\t\t\t\$(function () {\r\n\t\t\t   setTimeout(function()\r\n\t\t\t   {\r\n\t\t\t\t\t\$('#m3u-modal').modal('hide');\r\n\t\t\t\t\t\$('#tr_" . $id . "').fadeOut();\r\n\t\t\t   }, 1000);\r\n\t\t\t   \r\n\t\t\t});</script>";
            exit();
        }
        else
        {
            exit( '<h1>Not authorized!</h1>' );
        }
    }

    public function DeleteSelectedUsers()
    {
        global $intro;
        global $sess_admin;
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');

        if($this->admin['level'] != 1 && $this->admin['can_delete'] != 1) {
            exit('<h1>Not authorized!</h1>');
        }

        $selected_users = isset($_POST['selected_users']) ? $_POST['selected_users'] : [];
        $deleted = 0;

        if(!empty($selected_users)) {
            foreach($selected_users as $id) {
                $id = intval($id);
                $sql = $intro->db->query('SELECT id, username FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
                $row = $intro->db->fetch_assoc($sql);
                if(intval($row['id']) > 0) {
                    $username = $row['username'];

                    // Delete from local database
                    $intro->db->query('delete from users WHERE id=' . $id . ' ' . $this->qry_admin);
                    $intro->db->query('delete from user_output where user_id=' . $id . ';');

                    // Delete from remote database (204.188.233.170)
                    $this->deleteUserFromRemoteDb($username);

                    // Delete from Flix Panel
                    $this->deleteUserFromFlixPanel($username);

                    $deleted++;
                }
            }
        }

        $intro->redirect($this->appname);
    }
    public function ResetPass()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $use_remote = intval($intro->input->get_post('use_remote'));
        sleep(2);

        // Generate new password
        $newpass = _obf_0D060735305C5C07152D1733241F3E070A1221100A4032();

        // Check if this is a remote user
        if($use_remote == 1) {
            // Update password on remote server
            $remote_host = '204.188.233.170';
            $remote_user = 'root';
            $remote_pass = 'R7nMi4KCzZv920pG';
            $remote_db = 'midnight_iptv';

            $update_sql = "UPDATE \\`lines\\` SET password='" . addslashes($newpass) . "' WHERE id=$id";
            $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                   escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " " .
                   "'mysql " . $remote_db . " -e \"" . str_replace("'", "'\"'\"'", $update_sql) . "\"' 2>&1";

            $output = trim(shell_exec($cmd));
            error_log("Remote ResetPass SQL: " . $update_sql);
            error_log("Remote ResetPass Output: " . $output);

            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Password Changed on Remote Server! New Password = ' . $newpass, 'success');
            echo "<script>\r\n\t\t\$(function () {\r\n\t\t\t\$('#pwd_" . $id . '\').html(\'<span class="blinking" style="color:red;font-size:16px;">' . $newpass . "</span>');\r\n\t\t   setTimeout(function()\r\n\t\t   {\r\n\t\t\t\t\$('#m3u-modal').modal('hide');\r\n\t\t\t\t\r\n\t\t   }, 1000);\r\n\t\t   \r\n\t\t});</script>";
            exit();
        }

        // Original local database logic
        $sql = $intro->db->query('SELECT id,username FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        $username = $row['username'];
        if( intval($row['id']) == 0 )
        {
            echo '<h1>Not authorized!</h1>';
            exit();
        }
        $intro->db->query('update users set password=\'' . $newpass . '\' WHERE id=' . $id . ' ' . $this->qry_admin);
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Password Changed! New Password = ' . $newpass, 'success');
        echo "<script>\r\n\t\t\$(function () {\r\n\t\t\t\$('#pwd_" . $id . '\').html(\'<span class="blinking" style="color:red;font-size:16px;">' . $newpass . "</span>');\r\n\t\t   setTimeout(function()\r\n\t\t   {\r\n\t\t\t\t\$('#m3u-modal').modal('hide');\r\n\t\t\t\t\r\n\t\t   }, 1000);\r\n\t\t   \r\n\t\t});</script>";
        exit();
    }

    /**
     * Sync user to external XC panel via API
     */
    private function syncUserToExternalPanel($username, $password, $exp_date, $max_connections = 1, $options = [])
    {
        global $intro;

        // Sync to remote database (204.188.233.170) with all options
        $this->addUserToRemoteDb($username, $password, $exp_date, $max_connections, $options);

        // XC Panel API settings
        $panel_url = 'https://flix-panel.xyz:2087';
        $api_key = 'eJIdy5sAgD';

        // Get panel settings from database if available
        $result = $intro->db->query("SELECT setting_key, setting_value FROM panel_settings WHERE setting_key IN ('panel_url', 'api_key')");
        if ($result) {
            while ($row = $intro->db->fetch_assoc($result)) {
                if ($row['setting_key'] == 'panel_url' && !empty($row['setting_value'])) {
                    $panel_url = rtrim($row['setting_value'], '/');
                }
                if ($row['setting_key'] == 'api_key' && !empty($row['setting_value'])) {
                    $api_key = $row['setting_value'];
                }
            }
        }

        // XC Panel API endpoint for creating new line/user
        $api_url = $panel_url . '/api/line/new';

        // Get all bouquets from database dynamically
        $all_bouquets = [];
        $bq_result = $intro->db->query("SELECT id FROM bouquets WHERE bouquet_status=1 ORDER BY view_order ASC");
        if ($bq_result) {
            while ($bq_row = $intro->db->fetch_assoc($bq_result)) {
                $all_bouquets[] = intval($bq_row['id']);
            }
        }
        // Fallback to default bouquets if query fails
        if (empty($all_bouquets)) {
            $all_bouquets = [1, 3, 4, 7, 8, 9, 10, 11, 12];
        }

        // Prepare POST data for XC Panel API with bouquets as array
        $post_data = http_build_query([
            'api_key' => $api_key,
            'data' => [
                'username' => $username,
                'password' => $password,
                'max_allowed_connections' => $max_connections,
                'expire_date' => $exp_date,
                'restreamer' => 0,
                'bouquets' => $all_bouquets, // All bouquets - fetched dynamically
                'https' => 1,                // Allow HTTPS port
                'allow_m3u' => 1,            // Allow M3U download
                'hls' => 1,                  // Allow HLS
                'mpegts' => 1,               // Allow MPEG-TS
                'rtmp' => 1                  // Allow RTMP
            ]
        ]);

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $api_url,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post_data,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded'],
            CURLOPT_TIMEOUT => 15,
            CURLOPT_SSL_VERIFYPEER => false
        ]);

        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // Log the sync result
        $log_msg = "XC Panel Sync: $username - Response: $response";
        error_log($log_msg);

        return $response;
    }

    public function ImportFlixPanel()
    {
        global $intro;
        global $sess_admin;

        // Admin only
        if($this->admin['level'] != 1) {
            exit('<h1>Not authorized!</h1>');
        }

        $this->nav();

        $panel_url = 'https://flix-panel.xyz:2087';
        $message = '';
        $users = [];
        $error = '';
        $imported_count = 0;
        $skipped_count = 0;

        // Handle CSV Import (file upload or paste)
        if(isset($_POST['import_csv'])) {
            $csv_content = '';

            // Check for file upload
            if(isset($_FILES['csv_file']) && $_FILES['csv_file']['error'] == UPLOAD_ERR_OK) {
                $csv_content = file_get_contents($_FILES['csv_file']['tmp_name']);
            }
            // Check for pasted content
            elseif(!empty($_POST['csv_content'])) {
                $csv_content = $_POST['csv_content'];
            }

            if(!empty($csv_content)) {
                $lines = preg_split('/\r\n|\r|\n/', $csv_content);
                $header = null;
                $header_map = [];

                foreach($lines as $line_num => $line) {
                    $line = trim($line);
                    if(empty($line)) continue;

                    // Parse CSV line
                    $fields = str_getcsv($line);

                    // First non-empty line is header
                    if($header === null) {
                        $header = array_map('strtolower', array_map('trim', $fields));
                        // Map header columns
                        foreach($header as $idx => $col) {
                            $col_clean = preg_replace('/[^a-z0-9_]/', '', $col);
                            $header_map[$col_clean] = $idx;
                        }
                        continue;
                    }

                    // Get values by header name
                    $username = $this->getCsvValue($fields, $header_map, ['username', 'user']);
                    $password = $this->getCsvValue($fields, $header_map, ['password', 'pass']);
                    $exp_date = $this->getCsvValue($fields, $header_map, ['expiredate', 'expire_date', 'exp_date', 'expiry']);
                    $max_conn = $this->getCsvValue($fields, $header_map, ['maxconnections', 'max_connections', 'max_allowed_connections', 'connections']);

                    if(empty($username)) continue;

                    // Parse expire date
                    $exp_timestamp = 0;
                    if(!empty($exp_date)) {
                        if(is_numeric($exp_date)) {
                            $exp_timestamp = intval($exp_date);
                        } else {
                            $exp_timestamp = strtotime($exp_date);
                        }
                    }
                    if($exp_timestamp <= 0) {
                        $exp_timestamp = strtotime('+1 month');
                    }

                    $max_conn = intval($max_conn) > 0 ? intval($max_conn) : 1;

                    $users[] = [
                        'username' => $username,
                        'password' => $password ?: $username,
                        'exp_date' => $exp_timestamp,
                        'max_connections' => $max_conn
                    ];
                }

                // Auto import all users
                if(isset($_POST['auto_import']) && $_POST['auto_import'] == '1') {
                    foreach($users as $user) {
                        $username_esc = mysqli_real_escape_string($intro->db->link, $user['username']);
                        $password_esc = mysqli_real_escape_string($intro->db->link, $user['password']);
                        $exp_date = intval($user['exp_date']);
                        $max_conn = intval($user['max_connections']);

                        // Check if user exists
                        $check = $intro->db->query("SELECT id FROM users WHERE username='$username_esc'");
                        if($intro->db->returned_rows == 0) {
                            $intro->db->query("INSERT INTO users (username, password, exp_date, enabled, admin_enabled, max_connections, created_at, member_id)
                                VALUES ('$username_esc', '$password_esc', '$exp_date', 1, 1, $max_conn, " . time() . ", " . $this->admin['adminid'] . ")");
                            $imported_count++;
                        } else {
                            $skipped_count++;
                        }
                    }
                    $message = "<div class='alert alert-success'><strong>Import Complete!</strong><br>Imported: $imported_count users<br>Skipped (already exist): $skipped_count users</div>";
                    $users = []; // Clear list after auto import
                }
            } else {
                $error = "No CSV content provided. Please upload a file or paste CSV content.";
            }
        }

        // Handle single user import
        if(isset($_POST['import_user']) && !empty($_POST['import_username'])) {
            $username = trim($_POST['import_username']);
            $password = trim($_POST['import_password']);
            $exp_date = intval($_POST['import_exp_date']);
            $max_conn = intval($_POST['import_max_conn']);

            $username_esc = mysqli_real_escape_string($intro->db->link, $username);
            $password_esc = mysqli_real_escape_string($intro->db->link, $password);

            $check = $intro->db->query("SELECT id FROM users WHERE username='$username_esc'");
            if($intro->db->returned_rows == 0) {
                $intro->db->query("INSERT INTO users (username, password, exp_date, enabled, admin_enabled, max_connections, created_at, member_id)
                    VALUES ('$username_esc', '$password_esc', '$exp_date', 1, 1, $max_conn, " . time() . ", " . $this->admin['adminid'] . ")");
                $message = "<div class='alert alert-success'>User <strong>$username</strong> imported successfully!</div>";
            } else {
                $message = "<div class='alert alert-warning'>User <strong>$username</strong> already exists.</div>";
            }
        }

        // Handle import selected users
        if(isset($_POST['import_selected']) && !empty($_POST['selected_users'])) {
            $selected_data = json_decode($_POST['users_data'], true);
            foreach($_POST['selected_users'] as $idx) {
                if(isset($selected_data[$idx])) {
                    $user = $selected_data[$idx];
                    $username_esc = mysqli_real_escape_string($intro->db->link, $user['username']);
                    $password_esc = mysqli_real_escape_string($intro->db->link, $user['password']);

                    $check = $intro->db->query("SELECT id FROM users WHERE username='$username_esc'");
                    if($intro->db->returned_rows == 0) {
                        $intro->db->query("INSERT INTO users (username, password, exp_date, enabled, admin_enabled, max_connections, created_at, member_id)
                            VALUES ('$username_esc', '$password_esc', '" . intval($user['exp_date']) . "', 1, 1, " . intval($user['max_connections']) . ", " . time() . ", " . $this->admin['adminid'] . ")");
                        $imported_count++;
                    } else {
                        $skipped_count++;
                    }
                }
            }
            $message = "<div class='alert alert-success'>Imported: $imported_count | Skipped: $skipped_count</div>";
        }

        echo '<div class="content-wrapper">
        <h2><icon class="icon-download"></icon> Import Users from Flix Panel</h2>

        ' . $message . '

        <div class="alert alert-info">
            <strong>Flix Panel:</strong> ' . $panel_url . '<br>
            <strong>CSV Export URL:</strong> <a href="' . $panel_url . '/59p9wwiu5r/lines/lines_report/csv" target="_blank">' . $panel_url . '/59p9wwiu5r/lines/lines_report/csv</a>
        </div>

        <div class="panel panel-primary">
            <div class="panel-heading">
                <h3 class="panel-title">Import from CSV</h3>
            </div>
            <div class="panel-body">
                <form method="post" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Upload CSV File:</label>
                                <input type="file" name="csv_file" class="form-control" accept=".csv,.txt">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Or Paste CSV Content:</label>
                                <textarea name="csv_content" class="form-control" rows="5" placeholder="username,password,expire_date,max_connections&#10;user1,pass1,2025-12-31,1&#10;user2,pass2,2025-12-31,2"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" name="auto_import" value="1" checked> Auto import all users (skip existing)</label>
                    </div>
                    <button type="submit" name="import_csv" class="btn btn-primary btn-lg"><icon class="icon-download"></icon> Import CSV</button>
                </form>
            </div>
        </div>';

        if($error) {
            echo '<div class="alert alert-danger">' . $error . '</div>';
        }

        if(!empty($users)) {
            echo '<form method="post">
            <input type="hidden" name="users_data" value="' . htmlspecialchars(json_encode($users)) . '">
            <div class="panel panel-success">
                <div class="panel-heading">
                    <h3 class="panel-title">Preview Users (' . count($users) . ') - Select to Import</h3>
                </div>
                <div class="panel-body">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="selectAll" onclick="toggleAll()"></th>
                                <th>Username</th>
                                <th>Password</th>
                                <th>Expire Date</th>
                                <th>Max Conn</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>';

            foreach($users as $idx => $user) {
                $username = htmlspecialchars($user['username']);
                $password = htmlspecialchars($user['password']);
                $exp_date = $user['exp_date'] > 0 ? date('Y-m-d', $user['exp_date']) : 'N/A';
                $max_conn = intval($user['max_connections']);

                // Check if exists
                $check = $intro->db->query("SELECT id FROM users WHERE username='" . mysqli_real_escape_string($intro->db->link, $user['username']) . "'");
                $exists = $intro->db->returned_rows > 0;
                $status = $exists ? '<span class="label label-warning">Exists</span>' : '<span class="label label-success">New</span>';
                $disabled = $exists ? 'disabled' : '';

                echo "<tr>
                    <td><input type='checkbox' name='selected_users[]' value='$idx' $disabled></td>
                    <td>$username</td>
                    <td>$password</td>
                    <td>$exp_date</td>
                    <td>$max_conn</td>
                    <td>$status</td>
                </tr>";
            }

            echo '</tbody>
                    </table>
                    <button type="submit" name="import_selected" class="btn btn-success btn-lg"><icon class="icon-download"></icon> Import Selected</button>
                </div>
            </div>
            </form>
            <script>
            function toggleAll() {
                var cbs = document.querySelectorAll("input[name=\'selected_users[]\']:not(:disabled)");
                var sa = document.getElementById("selectAll");
                cbs.forEach(function(cb) { cb.checked = sa.checked; });
            }
            </script>';
        }

        echo '</div>';
    }

    private function getCsvValue($fields, $header_map, $possible_names)
    {
        foreach($possible_names as $name) {
            if(isset($header_map[$name]) && isset($fields[$header_map[$name]])) {
                return trim($fields[$header_map[$name]]);
            }
        }
        return '';
    }

    public function SyncFlixPanel()
    {
        global $intro;
        global $sess_admin;

        // Admin only
        if($this->admin['level'] != 1) {
            exit('<h1>Not authorized!</h1>');
        }

        $this->nav();

        // Flix Panel Settings
        $panel_url = 'https://flix-panel.xyz:2087';
        $api_key = 'eJIdy5sAgD';
        $backup_dir = '/var/www/html/iptv/backups';
        $sha1_file = $backup_dir . '/last_backup.sha1';

        // Ensure backup directory exists
        if(!is_dir($backup_dir)) {
            mkdir($backup_dir, 0755, true);
        }

        $message = '';
        $error = '';
        $backup_info = null;
        $sync_stats = [];

        // Get current sync settings from database
        $sync_enabled = 0;
        $sync_interval = 60; // minutes
        $last_sync = 0;
        $settings_result = $intro->db->query("SELECT * FROM panel_settings WHERE setting_key LIKE 'flix_sync_%'");
        if($settings_result) {
            while($row = $intro->db->fetch_assoc($settings_result)) {
                if($row['setting_key'] == 'flix_sync_enabled') $sync_enabled = intval($row['setting_value']);
                if($row['setting_key'] == 'flix_sync_interval') $sync_interval = intval($row['setting_value']);
                if($row['setting_key'] == 'flix_sync_last') $last_sync = intval($row['setting_value']);
            }
        }

        // Handle settings update
        if(isset($_POST['save_settings'])) {
            $sync_enabled = isset($_POST['sync_enabled']) ? 1 : 0;
            $sync_interval = intval($_POST['sync_interval']) > 0 ? intval($_POST['sync_interval']) : 60;

            $intro->db->query("REPLACE INTO panel_settings (setting_key, setting_value) VALUES ('flix_sync_enabled', '$sync_enabled')");
            $intro->db->query("REPLACE INTO panel_settings (setting_key, setting_value) VALUES ('flix_sync_interval', '$sync_interval')");

            $message = "<div class='alert alert-success'>Settings saved!</div>";
        }

        // Handle manual sync
        if(isset($_POST['sync_now']) || isset($_POST['force_sync'])) {
            $force = isset($_POST['force_sync']);
            $sync_result = $this->performFlixPanelSync($panel_url, $api_key, $backup_dir, $sha1_file, $force);

            if($sync_result['success']) {
                $intro->db->query("REPLACE INTO panel_settings (setting_key, setting_value) VALUES ('flix_sync_last', '" . time() . "')");
                $last_sync = time();
                $message = "<div class='alert alert-success'><strong>Sync Complete!</strong><br>" .
                    "New users: " . $sync_result['imported'] . "<br>" .
                    "Updated: " . $sync_result['updated'] . "<br>" .
                    "Skipped: " . $sync_result['skipped'] . "</div>";
            } else {
                $error = $sync_result['error'];
            }
        }

        // Get backup info
        $backup_info = $this->getFlixBackupInfo($panel_url, $api_key);

        echo '<div class="content-wrapper">
        <h2><icon class="icon-refresh"></icon> Sync with Flix Panel</h2>

        ' . $message . '

        <div class="row">
            <div class="col-md-6">
                <div class="panel panel-info">
                    <div class="panel-heading">
                        <h3 class="panel-title">Flix Panel Connection</h3>
                    </div>
                    <div class="panel-body">
                        <p><strong>Panel URL:</strong> ' . $panel_url . '</p>
                        <p><strong>API Key:</strong> ' . substr($api_key, 0, 4) . '****</p>';

        if($backup_info && $backup_info['result']) {
            echo '<p><strong>Status:</strong> <span class="label label-success">Connected</span></p>
                  <p><strong>Last Backup:</strong> ' . $backup_info['filename'] . '</p>
                  <p><strong>Backup Date:</strong> ' . date('Y-m-d H:i:s', $backup_info['modified_time']) . '</p>
                  <p><strong>Size:</strong> ' . round($backup_info['size'] / 1024 / 1024, 2) . ' MB</p>';
        } else {
            echo '<p><strong>Status:</strong> <span class="label label-danger">Not Connected</span></p>';
            if(isset($backup_info['error'])) {
                echo '<p class="text-danger">' . $backup_info['error'] . '</p>';
            }
        }

        echo '      </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="panel panel-primary">
                    <div class="panel-heading">
                        <h3 class="panel-title">Sync Settings</h3>
                    </div>
                    <div class="panel-body">
                        <form method="post">
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" name="sync_enabled" value="1" ' . ($sync_enabled ? 'checked' : '') . '>
                                    Enable Auto Sync
                                </label>
                            </div>
                            <div class="form-group">
                                <label>Sync Interval (minutes):</label>
                                <input type="number" name="sync_interval" class="form-control" value="' . $sync_interval . '" min="5">
                            </div>
                            <p><strong>Last Sync:</strong> ' . ($last_sync > 0 ? date('Y-m-d H:i:s', $last_sync) : 'Never') . '</p>
                            <button type="submit" name="save_settings" class="btn btn-primary">Save Settings</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>';

        if($error) {
            echo '<div class="alert alert-danger">' . $error . '</div>';
        }

        echo '<div class="panel panel-success">
            <div class="panel-heading">
                <h3 class="panel-title">Manual Sync</h3>
            </div>
            <div class="panel-body">
                <form method="post" class="form-inline">
                    <button type="submit" name="sync_now" class="btn btn-success btn-lg">
                        <icon class="icon-refresh"></icon> Sync Now
                    </button>
                    <button type="submit" name="force_sync" class="btn btn-warning btn-lg" onclick="return confirm(\'Force sync will re-download backup even if unchanged. Continue?\')">
                        <icon class="icon-download"></icon> Force Sync
                    </button>
                </form>
                <br>
                <p class="text-muted">
                    <strong>Sync Now:</strong> Downloads backup only if changed (compares SHA1)<br>
                    <strong>Force Sync:</strong> Downloads backup regardless of changes
                </p>
            </div>
        </div>

        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Sync Options</h3>
            </div>
            <div class="panel-body">
                <p><icon class="icon-check"></icon> Import new users from Flix Panel</p>
                <p><icon class="icon-check"></icon> Update password if changed</p>
                <p><icon class="icon-check"></icon> Update expire date if changed</p>
                <p><icon class="icon-check"></icon> Update max connections if changed</p>
                <p><icon class="icon-check"></icon> Update enabled/disabled status</p>
            </div>
        </div>

        <div class="panel panel-info">
            <div class="panel-heading">
                <h3 class="panel-title">Cron Job Setup (for auto sync)</h3>
            </div>
            <div class="panel-body">
                <p>Add this cron job to enable automatic sync:</p>
                <pre>*/' . $sync_interval . ' * * * * curl -s "http://' . $_SERVER['HTTP_HOST'] . '/iptv/cron/sync_flix.php" > /dev/null 2>&1</pre>
                <p>Or run directly with PHP:</p>
                <pre>*/' . $sync_interval . ' * * * * php /var/www/html/iptv/cron/sync_flix.php > /dev/null 2>&1</pre>
            </div>
        </div>

        </div>';
    }

    private function getFlixBackupInfo($panel_url, $api_key)
    {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $panel_url . '/api/panel/last_backup_info/' . $api_key,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYPEER => false
        ]);
        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);

        if($error) {
            return ['result' => false, 'error' => $error];
        }
        return json_decode($response, true);
    }

    private function performFlixPanelSync($panel_url, $api_key, $backup_dir, $sha1_file, $force = false)
    {
        global $intro;

        $result = [
            'success' => false,
            'imported' => 0,
            'updated' => 0,
            'skipped' => 0,
            'error' => ''
        ];

        // Step 1: Get backup info
        $backup_info = $this->getFlixBackupInfo($panel_url, $api_key);
        if(!$backup_info || !isset($backup_info['result']) || !$backup_info['result']) {
            $result['error'] = "Failed to get backup info: " . ($backup_info['error'] ?? 'Unknown error');
            return $result;
        }

        $new_sha1 = $backup_info['sha1'];
        $filename = $backup_info['filename'];

        // Step 2: Check if backup changed
        $last_sha1 = file_exists($sha1_file) ? trim(file_get_contents($sha1_file)) : '';
        if(!$force && $new_sha1 === $last_sha1) {
            $result['success'] = true;
            $result['error'] = "Backup unchanged. No sync needed.";
            return $result;
        }

        // Step 3: Download backup
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $panel_url . '/api/panel/download_last_backup/' . $api_key,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 300, // 5 minutes for large files
            CURLOPT_SSL_VERIFYPEER => false
        ]);
        $backup_content = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);

        if($error || empty($backup_content)) {
            $result['error'] = "Failed to download backup: " . $error;
            return $result;
        }

        // Step 4: Save backup file
        $backup_file = $backup_dir . '/' . $filename;
        file_put_contents($backup_file, $backup_content);
        file_put_contents($sha1_file, $new_sha1);

        // Step 5: Extract and process backup
        $extract_dir = $backup_dir . '/extract_' . time();
        mkdir($extract_dir, 0755, true);

        // Determine file type and extract accordingly
        $sql_content = '';
        try {
            if(substr($filename, -3) === '.gz' && substr($filename, -7) !== '.tar.gz') {
                // Plain .gz file - decompress directly
                $gz_content = gzdecode($backup_content);
                if($gz_content === false) {
                    throw new Exception("Failed to decompress .gz file");
                }

                // Check if decompressed content is a tar archive
                if(substr($gz_content, 0, 5) === "ustar" || strpos(substr($gz_content, 257, 5), "ustar") !== false) {
                    // It's a tar archive inside gz
                    $tar_file = $extract_dir . '/backup.tar';
                    file_put_contents($tar_file, $gz_content);
                    $phar = new PharData($tar_file);
                    $phar->extractTo($extract_dir);
                    unlink($tar_file);
                } else {
                    // It's just SQL content compressed
                    $sql_content = $gz_content;
                }
            } elseif(substr($filename, -7) === '.tar.gz' || substr($filename, -4) === '.tgz') {
                // .tar.gz file
                $phar = new PharData($backup_file);
                $phar->extractTo($extract_dir);
            } else {
                // Try as tar.gz anyway
                $phar = new PharData($backup_file);
                $phar->extractTo($extract_dir);
            }
        } catch(Exception $e) {
            // Try alternative: use system commands
            exec("cd " . escapeshellarg($extract_dir) . " && gunzip -c " . escapeshellarg($backup_file) . " > backup.tar 2>&1 && tar -xf backup.tar 2>&1", $output, $retval);
            if($retval !== 0) {
                // Try just gunzip
                exec("gunzip -c " . escapeshellarg($backup_file) . " > " . escapeshellarg($extract_dir . '/backup.sql') . " 2>&1", $output2, $retval2);
            }
        }

        // Find SQL content
        if(empty($sql_content)) {
            $sql_files = glob($extract_dir . '/*.sql');
            if(empty($sql_files)) {
                $sql_files = glob($extract_dir . '/*/*.sql');
            }
            if(empty($sql_files)) {
                // Check for any file that might contain SQL
                $all_files = glob($extract_dir . '/*');
                foreach($all_files as $file) {
                    if(is_file($file) && filesize($file) > 1000) {
                        $content = file_get_contents($file, false, null, 0, 1000);
                        if(stripos($content, 'INSERT INTO') !== false || stripos($content, 'CREATE TABLE') !== false) {
                            $sql_files[] = $file;
                            break;
                        }
                    }
                }
            }

            if(!empty($sql_files)) {
                $sql_content = file_get_contents($sql_files[0]);
            }
        }

        if(empty($sql_content)) {
            $result['error'] = "No SQL content found in backup. Files in extract dir: " . implode(', ', glob($extract_dir . '/*'));
            $this->cleanupDir($extract_dir);
            return $result;
        }

        // Step 6: Parse users from SQL
        $users = $this->parseUsersFromSQL($sql_content);

        if(empty($users)) {
            $result['error'] = "No users found in backup SQL";
            $this->cleanupDir($extract_dir);
            return $result;
        }

        // Step 7: Sync users to local database
        foreach($users as $user) {
            $username_esc = mysqli_real_escape_string($intro->db->link, $user['username']);
            $password_esc = mysqli_real_escape_string($intro->db->link, $user['password']);
            $exp_date = intval($user['exp_date']);
            $max_conn = intval($user['max_connections']);
            $enabled = intval($user['enabled']);

            // Check if user exists
            $check = $intro->db->query("SELECT id, password, exp_date, max_connections, enabled FROM users WHERE username='$username_esc'");

            if($intro->db->returned_rows == 0) {
                // Insert new user
                $intro->db->query("INSERT INTO users (username, password, exp_date, enabled, admin_enabled, max_connections, created_at, member_id)
                    VALUES ('$username_esc', '$password_esc', '$exp_date', '$enabled', 1, $max_conn, " . time() . ", " . $this->admin['adminid'] . ")");
                $result['imported']++;
            } else {
                // Check if update needed
                $existing = $intro->db->fetch_assoc($check);
                $needs_update = false;
                $updates = [];

                if($existing['password'] != $user['password']) {
                    $updates[] = "password='$password_esc'";
                    $needs_update = true;
                }
                if($existing['exp_date'] != $exp_date) {
                    $updates[] = "exp_date='$exp_date'";
                    $needs_update = true;
                }
                if($existing['max_connections'] != $max_conn) {
                    $updates[] = "max_connections='$max_conn'";
                    $needs_update = true;
                }
                if($existing['enabled'] != $enabled) {
                    $updates[] = "enabled='$enabled'";
                    $needs_update = true;
                }

                if($needs_update) {
                    $intro->db->query("UPDATE users SET " . implode(', ', $updates) . " WHERE username='$username_esc'");
                    $result['updated']++;
                } else {
                    $result['skipped']++;
                }
            }
        }

        // Cleanup
        $this->cleanupDir($extract_dir);

        $result['success'] = true;
        return $result;
    }

    private function parseUsersFromSQL($sql_content)
    {
        $users = [];

        // Look for INSERT statements for lines/users table
        // Pattern: INSERT INTO `lines` or INSERT INTO `users`
        if(preg_match_all('/INSERT INTO [`\']?(lines|users)[`\']?\s+.*?VALUES\s*(.+?);/is', $sql_content, $matches)) {
            foreach($matches[2] as $values_block) {
                // Extract individual row values
                preg_match_all('/\(([^)]+)\)/s', $values_block, $rows);
                foreach($rows[1] as $row) {
                    $fields = str_getcsv($row, ',', "'");

                    // Try to identify username, password, expire_date by position or pattern
                    // This depends on the actual table structure - adjust as needed
                    if(count($fields) >= 3) {
                        $users[] = [
                            'username' => trim($fields[1] ?? '', "'\" "),
                            'password' => trim($fields[2] ?? '', "'\" "),
                            'exp_date' => intval(trim($fields[3] ?? '0', "'\" ")),
                            'max_connections' => intval(trim($fields[4] ?? '1', "'\" ")),
                            'enabled' => intval(trim($fields[5] ?? '1', "'\" "))
                        ];
                    }
                }
            }
        }

        return $users;
    }

    private function cleanupDir($dir)
    {
        if(!is_dir($dir)) return;
        $files = array_diff(scandir($dir), ['.', '..']);
        foreach($files as $file) {
            $path = $dir . '/' . $file;
            is_dir($path) ? $this->cleanupDir($path) : unlink($path);
        }
        rmdir($dir);
    }

    public function SyncRemoteDB()
    {
        global $intro;
        global $sess_admin;

        // Admin only
        if($this->admin['level'] != 1) {
            exit('<h1>Not authorized!</h1>');
        }

        $this->nav();

        // Remote server settings (Flix Panel)
        $remote_host = '204.188.233.170';
        $remote_user = 'root';
        $remote_pass = 'R7nMi4KCzZv920pG';
        $remote_db = 'midnight_iptv';

        $message = '';
        $error = '';
        $remote_users = [];
        $sync_stats = ['imported' => 0, 'updated' => 0, 'skipped' => 0];

        // Get sync settings
        $auto_sync = 0;
        $last_sync = 0;
        $settings_result = $intro->db->query("SELECT * FROM panel_settings WHERE setting_key LIKE 'remote_sync_%'");
        if($settings_result) {
            while($row = $intro->db->fetch_assoc($settings_result)) {
                if($row['setting_key'] == 'remote_sync_enabled') $auto_sync = intval($row['setting_value']);
                if($row['setting_key'] == 'remote_sync_last') $last_sync = intval($row['setting_value']);
            }
        }

        // Handle settings save
        if(isset($_POST['save_settings'])) {
            $auto_sync = isset($_POST['auto_sync']) ? 1 : 0;
            $intro->db->query("REPLACE INTO panel_settings (setting_key, setting_value) VALUES ('remote_sync_enabled', '$auto_sync')");
            $message = "<div class='alert alert-success'>Settings saved!</div>";
        }

        // Handle sync action
        if(isset($_POST['sync_now']) || isset($_POST['sync_all'])) {
            // Connect via SSH and get users
            $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " . escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db . " -N -e \"SELECT id, username, password, expire_date, max_allowed_connections, disabled, created_time, reseller_id, notes FROM \\`lines\\`;\"' 2>&1";

            $output = shell_exec($cmd);

            if(strpos($output, 'Access denied') !== false || strpos($output, 'Connection refused') !== false) {
                $error = "Connection failed: " . htmlspecialchars($output);
            } else {
                $lines = explode("\n", trim($output));
                foreach($lines as $line) {
                    if(empty(trim($line))) continue;
                    $fields = explode("\t", $line);
                    if(count($fields) >= 5) {
                        $remote_users[] = [
                            'id' => $fields[0],
                            'username' => $fields[1],
                            'password' => $fields[2],
                            'expire_date' => intval($fields[3]),
                            'max_connections' => intval($fields[4]),
                            'disabled' => intval($fields[5] ?? 0),
                            'created_time' => intval($fields[6] ?? time()),
                            'reseller_id' => $fields[7] ?? '',
                            'notes' => $fields[8] ?? ''
                        ];
                    }
                }

                // Auto sync all
                if(isset($_POST['sync_all']) && !empty($remote_users)) {
                    foreach($remote_users as $user) {
                        $result = $this->syncSingleUser($intro, $user);
                        $sync_stats[$result]++;
                    }
                    $intro->db->query("REPLACE INTO panel_settings (setting_key, setting_value) VALUES ('remote_sync_last', '" . time() . "')");
                    $last_sync = time();
                    $message = "<div class='alert alert-success'><strong>Sync Complete!</strong><br>Imported: {$sync_stats['imported']}<br>Updated: {$sync_stats['updated']}<br>Skipped: {$sync_stats['skipped']}</div>";
                    $remote_users = []; // Clear after sync
                }
            }
        }

        // Handle single user import
        if(isset($_POST['import_single'])) {
            $user_data = json_decode($_POST['user_data'], true);
            if($user_data) {
                $result = $this->syncSingleUser($intro, $user_data);
                $message = "<div class='alert alert-" . ($result == 'imported' ? 'success' : 'info') . "'>User {$user_data['username']}: $result</div>";
            }
        }

        // Handle selected users import
        if(isset($_POST['import_selected']) && !empty($_POST['selected_users'])) {
            $all_users = json_decode($_POST['all_users_data'], true);
            foreach($_POST['selected_users'] as $idx) {
                if(isset($all_users[$idx])) {
                    $result = $this->syncSingleUser($intro, $all_users[$idx]);
                    $sync_stats[$result]++;
                }
            }
            $message = "<div class='alert alert-success'>Imported: {$sync_stats['imported']} | Updated: {$sync_stats['updated']} | Skipped: {$sync_stats['skipped']}</div>";
        }

        // Test connection
        $connection_status = 'Unknown';
        $remote_count = 0;
        $test_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=5 " . escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db . " -N -e \"SELECT COUNT(*) FROM \\`lines\\`;\"' 2>&1";
        $test_output = trim(shell_exec($test_cmd));
        if(is_numeric($test_output)) {
            $connection_status = 'Connected';
            $remote_count = intval($test_output);
        } else {
            $connection_status = 'Failed';
        }

        echo '<div class="content-wrapper">
        <h2><icon class="icon-refresh"></icon> Sync Remote Database (Flix Panel)</h2>

        ' . $message . '

        <div class="row">
            <div class="col-md-6">
                <div class="panel panel-info">
                    <div class="panel-heading"><h3 class="panel-title">Remote Server</h3></div>
                    <div class="panel-body">
                        <p><strong>Host:</strong> ' . $remote_host . '</p>
                        <p><strong>Database:</strong> ' . $remote_db . '</p>
                        <p><strong>Status:</strong> <span class="label label-' . ($connection_status == 'Connected' ? 'success' : 'danger') . '">' . $connection_status . '</span></p>
                        <p><strong>Remote Users:</strong> ' . $remote_count . '</p>
                        <p><strong>Last Sync:</strong> ' . ($last_sync > 0 ? date('Y-m-d H:i:s', $last_sync) : 'Never') . '</p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="panel panel-primary">
                    <div class="panel-heading"><h3 class="panel-title">Sync Actions</h3></div>
                    <div class="panel-body">
                        <form method="post">
                            <button type="submit" name="sync_now" class="btn btn-info btn-lg btn-block">
                                <icon class="icon-eye"></icon> Preview Remote Users
                            </button>
                            <br>
                            <button type="submit" name="sync_all" class="btn btn-success btn-lg btn-block" onclick="return confirm(\'Sync all users from remote database?\')">
                                <icon class="icon-refresh"></icon> Sync All Users Now
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>';

        if($error) {
            echo '<div class="alert alert-danger">' . $error . '</div>';
        }

        if(!empty($remote_users)) {
            echo '<form method="post">
            <input type="hidden" name="all_users_data" value="' . htmlspecialchars(json_encode($remote_users)) . '">
            <div class="panel panel-success">
                <div class="panel-heading">
                    <h3 class="panel-title">Remote Users (' . count($remote_users) . ')</h3>
                </div>
                <div class="panel-body">
                    <table class="table table-striped table-bordered table-hover">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="selectAll" onclick="toggleAllRemote()"></th>
                                <th>ID</th>
                                <th>Username</th>
                                <th>Password</th>
                                <th>Expire Date</th>
                                <th>Max Conn</th>
                                <th>Status</th>
                                <th>Local Status</th>
                            </tr>
                        </thead>
                        <tbody>';

            foreach($remote_users as $idx => $user) {
                $exp_date = $user['expire_date'] > 0 ? date('Y-m-d', $user['expire_date']) : 'Unlimited';
                $status = $user['disabled'] ? '<span class="label label-danger">Disabled</span>' : '<span class="label label-success">Active</span>';

                // Check local
                $local_check = $intro->db->query("SELECT id, password, exp_date FROM users WHERE username='" . mysqli_real_escape_string($intro->db->link, $user['username']) . "'");
                if($intro->db->returned_rows > 0) {
                    $local = $intro->db->fetch_assoc($local_check);
                    $local_status = '<span class="label label-warning">Exists</span>';
                    $disabled = 'disabled';
                } else {
                    $local_status = '<span class="label label-info">New</span>';
                    $disabled = '';
                }

                echo "<tr>
                    <td><input type='checkbox' name='selected_users[]' value='$idx' $disabled></td>
                    <td>{$user['id']}</td>
                    <td>{$user['username']}</td>
                    <td>{$user['password']}</td>
                    <td>$exp_date</td>
                    <td>{$user['max_connections']}</td>
                    <td>$status</td>
                    <td>$local_status</td>
                </tr>";
            }

            echo '</tbody>
                    </table>
                    <button type="submit" name="import_selected" class="btn btn-success btn-lg">
                        <icon class="icon-download"></icon> Import Selected
                    </button>
                </div>
            </div>
            </form>
            <script>
            function toggleAllRemote() {
                var cbs = document.querySelectorAll("input[name=\'selected_users[]\']:not(:disabled)");
                var sa = document.getElementById("selectAll");
                cbs.forEach(function(cb) { cb.checked = sa.checked; });
            }
            </script>';
        }

        echo '</div>';
    }

    private function syncSingleUser($intro, $user)
    {
        $username_esc = mysqli_real_escape_string($intro->db->link, $user['username']);
        $password_esc = mysqli_real_escape_string($intro->db->link, $user['password']);
        $exp_date = intval($user['expire_date']);
        $max_conn = intval($user['max_connections']) > 0 ? intval($user['max_connections']) : 1;
        $enabled = $user['disabled'] ? 0 : 1;

        // Check if exists locally
        $check = $intro->db->query("SELECT id, password, exp_date, max_connections, enabled FROM users WHERE username='$username_esc'");

        if($intro->db->returned_rows == 0) {
            // Insert locally
            $intro->db->query("INSERT INTO users (username, password, exp_date, enabled, admin_enabled, max_connections, created_at, member_id)
                VALUES ('$username_esc', '$password_esc', '$exp_date', '$enabled', 1, $max_conn, " . time() . ", " . $this->admin['adminid'] . ")");

            // Also create in Flix Panel (https://flix-panel.xyz:2087)
            $this->createUserInFlixPanel($user['username'], $user['password'], $exp_date, $max_conn);

            return 'imported';
        } else {
            // Update if different
            $existing = $intro->db->fetch_assoc($check);
            $updates = [];

            if($existing['password'] != $user['password']) $updates[] = "password='$password_esc'";
            if($existing['exp_date'] != $exp_date) $updates[] = "exp_date='$exp_date'";
            if($existing['max_connections'] != $max_conn) $updates[] = "max_connections='$max_conn'";
            if($existing['enabled'] != $enabled) $updates[] = "enabled='$enabled'";

            if(!empty($updates)) {
                $intro->db->query("UPDATE users SET " . implode(', ', $updates) . " WHERE username='$username_esc'");

                // Also update in Flix Panel
                $this->updateUserInFlixPanel($user['username'], $user['password'], $exp_date, $max_conn);

                return 'updated';
            }
            return 'skipped';
        }
    }

    // Remote Database Operations (204.188.233.170)
    private function remoteDbExecute($sql)
    {
        $remote_host = '204.188.233.170';
        $remote_user = 'root';
        $remote_pass = 'R7nMi4KCzZv920pG';
        $remote_db = 'midnight_iptv';

        // Write SQL to temp file on remote server to avoid escaping issues
        $remote_tmp_file = '/tmp/remote_sql_' . uniqid() . '.sql';
        $local_tmp_file = '/tmp/local_sql_' . uniqid() . '.sql';

        file_put_contents($local_tmp_file, $sql);

        // Copy SQL file to remote server
        $scp_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " scp -o StrictHostKeyChecking=no -o ConnectTimeout=10 " . escapeshellarg($local_tmp_file) . " " . $remote_user . "@" . $remote_host . ":" . $remote_tmp_file . " 2>&1";
        shell_exec($scp_cmd);

        // Execute SQL on remote server
        $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " . $remote_user . "@" . $remote_host . " \"mysql " . $remote_db . " -N < " . $remote_tmp_file . " 2>&1; rm -f " . $remote_tmp_file . "\" 2>&1";

        $result = shell_exec($cmd);
        @unlink($local_tmp_file);

        error_log("Remote DB Execute: $sql - Result: $result");
        return $result;
    }

    private function deleteUserFromRemoteDb($username)
    {
        $username_esc = addslashes($username);
        $sql = 'DELETE FROM `lines` WHERE username=\'' . $username_esc . '\';';
        $result = $this->remoteDbExecute($sql);
        return (empty($result) || strpos($result, 'ERROR') === false);
    }

    private function addUserToRemoteDb($username, $password, $exp_date, $max_conn = 1, $options = [])
    {
        $username_esc = addslashes($username);
        $password_esc = addslashes($password);
        $exp_date = intval($exp_date);
        $max_conn = intval($max_conn) > 0 ? intval($max_conn) : 1;

        // Default options - all features enabled
        $is_trial = isset($options['is_trial']) ? intval($options['is_trial']) : 0;
        $is_mag = isset($options['is_mag']) ? intval($options['is_mag']) : 0;
        $is_stalker = isset($options['is_stalker']) ? intval($options['is_stalker']) : 0;
        $is_restreamer = isset($options['is_restreamer']) ? intval($options['is_restreamer']) : 0;
        $allowed_ips = isset($options['allowed_ips']) ? addslashes($options['allowed_ips']) : '';
        $allowed_ua = isset($options['allowed_ua']) ? addslashes($options['allowed_ua']) : '';
        $admin_notes = isset($options['admin_notes']) ? addslashes($options['admin_notes']) : '';
        $reseller_notes = isset($options['reseller_notes']) ? addslashes($options['reseller_notes']) : '';

        // Remote panel expects single bouquet ID, not JSON array
        $bouquets = '1'; // Always use bouquet 1 for remote panel
        if(isset($options['bouquets'])) {
            // If bouquets is a JSON array like [1,13,12], extract first ID
            $bouquet_data = $options['bouquets'];
            if(is_string($bouquet_data) && strpos($bouquet_data, '[') === 0) {
                $bouquet_arr = json_decode($bouquet_data, true);
                if(is_array($bouquet_arr) && !empty($bouquet_arr)) {
                    $bouquets = strval($bouquet_arr[0]);
                }
            } else {
                $bouquets = strval($bouquet_data);
            }
        }

        // Check if exists first
        $check_sql = 'SELECT id FROM `lines` WHERE username=\'' . $username_esc . '\';';
        $exists = trim($this->remoteDbExecute($check_sql));

        if(!empty($exists) && is_numeric($exists)) {
            // Update existing with all fields
            $sql = 'UPDATE `lines` SET
                password=\'' . $password_esc . '\',
                expire_date=' . $exp_date . ',
                max_allowed_connections=' . $max_conn . ',
                trial=' . $is_trial . ',
                mag=' . $is_mag . ',
                stalker=' . $is_stalker . ',
                restreamer=' . $is_restreamer . ',
                allowed_ips=\'' . $allowed_ips . '\',
                allowed_user_agents=\'' . $allowed_ua . '\',
                notes=\'' . $admin_notes . '\',
                reseller_notes=\'' . $reseller_notes . '\',
                bouquets=\'' . $bouquets . '\',
                hls=1, mpegts=1, rtmp=1, https=1, allow_m3u=1,
                subscription_plan_id=1,
                edit_time=' . time() . '
                WHERE username=\'' . $username_esc . '\';';
        } else {
            // Insert new with all features enabled
            $sql = 'INSERT INTO `lines` (
                username, password, expire_date, max_allowed_connections,
                disabled, created_time, mag, stalker, trial,
                hls, mpegts, rtmp, vpn, https,
                override_country, allow_m3u, encrypt_playlist, short_ts_form,
                log_errors, allow_claims, email_claims, username_claim_email,
                restart_stream_on_claim, call_stream_urls_on_claim, restreamer,
                admin_lock, disallow_2nd_ip, allow_from_proxy,
                allowed_ips, allowed_user_agents, notes, reseller_notes, bouquets,
                subscription_plan_id
            ) VALUES (
                \'' . $username_esc . '\', \'' . $password_esc . '\', ' . $exp_date . ', ' . $max_conn . ',
                0, ' . time() . ', ' . $is_mag . ', ' . $is_stalker . ', ' . $is_trial . ',
                1, 1, 1, 0, 1,
                0, 1, 0, 0,
                1, 0, 0, 0,
                0, 0, ' . $is_restreamer . ',
                0, 0, 0,
                \'' . $allowed_ips . '\', \'' . $allowed_ua . '\', \'' . $admin_notes . '\', \'' . $reseller_notes . '\', \'' . $bouquets . '\',
                1
            );';
        }

        $result = $this->remoteDbExecute($sql);
        return (empty($result) || strpos($result, 'ERROR') === false);
    }

    private function updateUserInRemoteDb($username, $password, $exp_date, $max_conn = 1, $enabled = 1, $options = [])
    {
        $username_esc = addslashes($username);
        $password_esc = addslashes($password);
        $disabled = $enabled ? 0 : 1;

        // Options
        $is_trial = isset($options['is_trial']) ? intval($options['is_trial']) : 0;
        $is_mag = isset($options['is_mag']) ? intval($options['is_mag']) : 0;
        $is_stalker = isset($options['is_stalker']) ? intval($options['is_stalker']) : 0;
        $is_restreamer = isset($options['is_restreamer']) ? intval($options['is_restreamer']) : 0;
        $allowed_ips = isset($options['allowed_ips']) ? addslashes($options['allowed_ips']) : '';
        $allowed_ua = isset($options['allowed_ua']) ? addslashes($options['allowed_ua']) : '';
        $admin_notes = isset($options['admin_notes']) ? addslashes($options['admin_notes']) : '';
        $reseller_notes = isset($options['reseller_notes']) ? addslashes($options['reseller_notes']) : '';

        // Remote panel expects single bouquet ID, not JSON array
        $bouquets = '1'; // Always use bouquet 1 for remote panel
        if(isset($options['bouquets'])) {
            // If bouquets is a JSON array like [1,13,12], extract first ID
            $bouquet_data = $options['bouquets'];
            if(is_string($bouquet_data) && strpos($bouquet_data, '[') === 0) {
                $bouquet_arr = json_decode($bouquet_data, true);
                if(is_array($bouquet_arr) && !empty($bouquet_arr)) {
                    $bouquets = strval($bouquet_arr[0]);
                }
            } else {
                $bouquets = strval($bouquet_data);
            }
        }

        $sql = 'UPDATE `lines` SET
            password=\'' . $password_esc . '\',
            expire_date=' . intval($exp_date) . ',
            max_allowed_connections=' . intval($max_conn) . ',
            disabled=' . $disabled . ',
            trial=' . $is_trial . ',
            mag=' . $is_mag . ',
            stalker=' . $is_stalker . ',
            restreamer=' . $is_restreamer . ',
            allowed_ips=\'' . $allowed_ips . '\',
            allowed_user_agents=\'' . $allowed_ua . '\',
            notes=\'' . $admin_notes . '\',
            reseller_notes=\'' . $reseller_notes . '\',
            bouquets=\'' . $bouquets . '\',
            hls=1, mpegts=1, rtmp=1, https=1, allow_m3u=1,
            subscription_plan_id=1,
            edit_time=' . time() . '
            WHERE username=\'' . $username_esc . '\';';

        $result = $this->remoteDbExecute($sql);
        return (empty($result) || strpos($result, 'ERROR') === false);
    }

    private function createUserInFlixPanel($username, $password, $exp_date, $max_conn)
    {
        $panel_url = 'https://flix-panel.xyz:2087';
        $api_key = 'eJIdy5sAgD';

        // Get all bouquets
        global $intro;
        $all_bouquets = [];
        $bq_result = $intro->db->query("SELECT id FROM bouquets WHERE bouquet_status=1 ORDER BY id ASC");
        if($bq_result) {
            while($bq_row = $intro->db->fetch_assoc($bq_result)) {
                $all_bouquets[] = intval($bq_row['id']);
            }
        }
        if(empty($all_bouquets)) {
            $all_bouquets = [1, 3, 4, 7, 8, 9, 10, 11, 12];
        }

        $post_data = http_build_query([
            'api_key' => $api_key,
            'data' => [
                'username' => $username,
                'password' => $password,
                'max_allowed_connections' => $max_conn,
                'expire_date' => $exp_date,
                'restreamer' => 0,
                'bouquets' => $all_bouquets,
                'https' => 1,
                'allow_m3u' => 1,
                'hls' => 1,
                'mpegts' => 1,
                'rtmp' => 1
            ]
        ]);

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $panel_url . '/api/line/new',
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post_data,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 15,
            CURLOPT_SSL_VERIFYPEER => false
        ]);
        $response = curl_exec($ch);
        curl_close($ch);

        error_log("Flix Panel Create User: $username - Response: $response");
        return $response;
    }

    private function updateUserInFlixPanel($username, $password, $exp_date, $max_conn)
    {
        $panel_url = 'https://flix-panel.xyz:2087';
        $api_key = 'eJIdy5sAgD';

        $post_data = http_build_query([
            'api_key' => $api_key,
            'username' => $username,
            'data' => [
                'password' => $password,
                'max_allowed_connections' => $max_conn,
                'expire_date' => $exp_date
            ]
        ]);

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $panel_url . '/api/line/update',
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post_data,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 15,
            CURLOPT_SSL_VERIFYPEER => false
        ]);
        $response = curl_exec($ch);
        curl_close($ch);

        error_log("Flix Panel Update User: $username - Response: $response");
        return $response;
    }

    private function deleteUserFromFlixPanel($username)
    {
        $panel_url = 'https://flix-panel.xyz:2087';
        $api_key = 'eJIdy5sAgD';

        $post_data = http_build_query([
            'api_key' => $api_key,
            'username' => $username
        ]);

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $panel_url . '/api/line/delete',
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post_data,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 15,
            CURLOPT_SSL_VERIFYPEER => false
        ]);
        $response = curl_exec($ch);
        curl_close($ch);

        error_log("Flix Panel Delete User: $username - Response: $response");
        return $response;
    }

    // Get users from remote server directly
    private function getRemoteUsers($limit = 50, $offset = 0, $filters = [])
    {
        $remote_host = '204.188.233.170';
        $remote_user = 'root';
        $remote_pass = 'R7nMi4KCzZv920pG';
        $remote_db = 'midnight_iptv';

        // Build WHERE clause based on filters
        $where = [];

        if(!empty($filters['username'])) {
            $username = str_replace(['*', '%'], '', $filters['username']);
            if(strpos($filters['username'], '*') !== false) {
                $where[] = "username LIKE '" . str_replace('*', '%', $filters['username']) . "'";
            } else {
                $where[] = "username LIKE '%" . $username . "%'";
            }
        }

        if(!empty($filters['disabled'])) {
            $where[] = "disabled = " . intval($filters['disabled']);
        }

        if(!empty($filters['expired'])) {
            $where[] = "expire_date IS NOT NULL AND expire_date != 0 AND expire_date <= " . time();
        }

        $where_clause = !empty($where) ? 'WHERE ' . implode(' AND ', $where) : '';

        // Get total count
        $count_sql = "SELECT COUNT(*) FROM \\`lines\\` $where_clause;";
        $count_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                     escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db .
                     " -N -e \"" . $count_sql . "\"' 2>&1";

        $total = intval(trim(shell_exec($count_cmd)));

        // Get users data with activity information
        $order = !empty($filters['order']) ? $filters['order'] : 'id DESC';
        $data_sql = "SELECT id, username, password, expire_date, max_allowed_connections, disabled, created_time, reseller_id, notes, last_ip, last_country, last_isp, last_channel, last_disconnection_time FROM \\`lines\\` $where_clause ORDER BY $order LIMIT $offset, $limit;";

        $data_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                    escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db .
                    " -N -e \"" . $data_sql . "\"' 2>&1";

        $output = shell_exec($data_cmd);

        $users = [];
        if($output) {
            $lines = explode("\n", trim($output));
            foreach($lines as $line) {
                if(empty(trim($line))) continue;
                $fields = explode("\t", $line);
                if(count($fields) >= 5) {
                    $users[] = [
                        'id' => $fields[0],
                        'username' => $fields[1],
                        'password' => $fields[2],
                        'exp_date' => intval($fields[3]),
                        'max_connections' => intval($fields[4]),
                        'enabled' => $fields[5] == '0' ? 1 : 0, // disabled=0 means enabled=1
                        'admin_enabled' => 1,
                        'created_at' => intval($fields[6] ?? time()),
                        'member_id' => $fields[7] ?? '',
                        'admin_notes' => $fields[8] ?? '',
                        'is_trial' => 0,
                        'is_restreamer' => 0,
                        'last_ip' => $fields[9] ?? 'N/A',
                        'last_country' => $fields[10] ?? 'N/A',
                        'last_isp' => $fields[11] ?? 'N/A',
                        'last_channel_id' => intval($fields[12] ?? 0),
                        'last_disconnection_time' => intval($fields[13] ?? 0)
                    ];
                }
            }
        }

        return [
            'users' => $users,
            'total' => $total
        ];
    }

    // Import single user from remote server to local DB
    public function ImportSingleRemoteUser()
    {
        global $intro;

        if($this->admin['level'] != 1) {
            exit('Not authorized!');
        }

        $remote_id = intval($intro->input->get_post('remote_id'));
        $username = trim($intro->input->get_post('username'));

        if($remote_id == 0 && $username == '') {
            exit('Missing remote_id or username!');
        }

        $remote_host = '204.188.233.170';
        $remote_user = 'root';
        $remote_pass = 'R7nMi4KCzZv920pG';
        $remote_db = 'midnight_iptv';

        // Get user from remote
        $where = $remote_id > 0 ? "id = $remote_id" : "username = '$username'";
        $data_sql = "SELECT id, username, password, expire_date, max_allowed_connections, disabled, created_time, reseller_id, notes FROM \\`lines\\` WHERE $where LIMIT 1;";

        $data_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                    escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " 'mysql " . $remote_db .
                    " -N -e \"" . $data_sql . "\"' 2>&1";

        $output = trim(shell_exec($data_cmd));

        if(empty($output)) {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('User not found in remote server!', 'danger');
            $intro->redirect($this->appname);
            exit();
        }

        $fields = explode("\t", $output);
        if(count($fields) < 5) {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Invalid user data from remote server!', 'danger');
            $intro->redirect($this->appname);
            exit();
        }

        $user_data = [
            'id' => $fields[0],
            'username' => $fields[1],
            'password' => $fields[2],
            'expire_date' => intval($fields[3]),
            'max_connections' => intval($fields[4]),
            'disabled' => intval($fields[5] ?? 0),
            'created_time' => intval($fields[6] ?? time()),
            'reseller_id' => $fields[7] ?? '',
            'notes' => $fields[8] ?? ''
        ];

        // Check if already exists locally
        $username_esc = mysqli_real_escape_string($intro->db->link, $user_data['username']);
        $check = $intro->db->query("SELECT id FROM users WHERE username='$username_esc'");

        if($intro->db->returned_rows > 0) {
            $row = $intro->db->fetch_assoc($check);
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('User already exists locally! Redirecting to edit...', 'info');
            $intro->redirect($this->appname . '/Form?t=edit&id=' . $row['id']);
            exit();
        }

        // Import user
        $password_esc = mysqli_real_escape_string($intro->db->link, $user_data['password']);
        $exp_date = $user_data['expire_date'];
        $max_conn = $user_data['max_connections'] > 0 ? $user_data['max_connections'] : 1;
        $enabled = $user_data['disabled'] ? 0 : 1;

        $intro->db->query("INSERT INTO users (username, password, exp_date, enabled, admin_enabled, max_connections, created_at, member_id, is_mag, is_e2)
            VALUES ('$username_esc', '$password_esc', '$exp_date', '$enabled', 1, $max_conn, " . time() . ", " . $this->admin['adminid'] . ", 0, 0)");

        $new_id = $intro->db->insert_id();

        _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('User imported successfully! You can now edit it.', 'success');
        $intro->redirect($this->appname . '/Form?t=edit&id=' . $new_id);
    }

    // Auto-sync function to sync local users to remote midnight_iptv database
    private function syncUserToRemoteDatabase($username, $password, $exp_date, $max_connections, $https = 1)
    {
        global $intro;

        // Get remote config from api_cfg_v6.php
        require_once('/var/www/html/iptv/V6APK/api_cfg_v6.php');

        if(!isset($_CFG['remote_panel_enabled']) || !$_CFG['remote_panel_enabled']) {
            return; // Remote sync disabled
        }

        $remote_host = $_CFG['remote_host'];
        $remote_user = $_CFG['remote_ssh_user'];
        $remote_pass = $_CFG['remote_ssh_pass'];
        $remote_db = $_CFG['remote_db_name'];

        // Check if user already exists on remote
        $check_sql = "SELECT id FROM \`lines\` WHERE username='" . addslashes($username) . "' LIMIT 1";
        $check_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=5 " .
                     escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) . " " .
                     "'mysql " . $remote_db . " -N -e \"" . str_replace('"', '\\"', $check_sql) . "\"' 2>&1";

        $existing = trim(shell_exec($check_cmd));

        if(!empty($existing) && is_numeric($existing)) {
            error_log("REMOTE SYNC: User $username already exists on remote (ID: $existing), skipping");
            return; // User already exists
        }

        // Prepare data for insert
        $exp_timestamp = ($exp_date == null || $exp_date == 0) ? 0 : $exp_date;
        $disabled = 0; // Enabled by default
        $https_val = ($https == 1) ? 1 : 0;
        $created_time = time();
        $bouquets = '1'; // Default bouquet

        // Build INSERT SQL with proper escaping for MySQL
        $username_escaped = str_replace('"', '\"', addslashes($username));
        $password_escaped = str_replace('"', '\"', addslashes($password));

        $insert_sql = "INSERT INTO \`lines\` (username, password, expire_date, max_allowed_connections, disabled, created_time, https, bouquets) " .
                     "VALUES (\"$username_escaped\", \"$password_escaped\", $exp_timestamp, $max_connections, $disabled, $created_time, $https_val, \"$bouquets\");";

        // Execute on remote server using single quotes for SSH command (don't escape user@host)
        $sync_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                    $remote_user . "@" . $remote_host . " " .
                    "'mysql " . $remote_db . " -e \"" . $insert_sql . "\"' 2>&1";

        $output = trim(shell_exec($sync_cmd));

        if(empty($output) || strpos(strtolower($output), 'error') === false) {
            error_log("REMOTE SYNC SUCCESS: User $username synced to remote server");
        } else {
            error_log("REMOTE SYNC ERROR: Failed to sync user $username - " . $output);
        }
    }
}
