#!/usr/bin/php
<?php
// Auto-sync script for streams from remote panel
// This script syncs stream data, logos, and status from the remote panel

require_once('/var/www/html/iptv/includes/Config.php');

// Remote connection details
$remote_host = "204.188.233.170";
$remote_user = "root";
$remote_pass = "R7nMi4KCzZv920pG";
$remote_db = "midnight_iptv";

// Log file
$logfile = '/var/log/auto_sync_streams.log';

function logMessage($message) {
    global $logfile;
    file_put_contents($logfile, "[" . date('Y-m-d H:i:s') . "] " . $message . "\n", FILE_APPEND);
    echo $message . "\n";
}

// Connect to local database
logMessage("Starting auto-sync...");
$db = new mysqli(
    $config['db']['hostname'],
    $config['db']['username'],
    $config['db']['password'],
    $config['db']['database']
);

if($db->connect_error) {
    logMessage("ERROR: Could not connect to local database: " . $db->connect_error);
    exit(1);
}

// Fetch streams from remote
logMessage("Fetching streams from remote panel...");
$cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " .
       escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
       " \"mysql " . $remote_db . " -N -e 'SELECT id, name, logo_image, disabled, direct_streaming_on_demand FROM streams WHERE type=0 ORDER BY id;'\" 2>&1";

$result = shell_exec($cmd);

if(empty($result) || strpos($result, 'ERROR') !== false) {
    logMessage("ERROR: Failed to fetch streams from remote: " . $result);
    exit(1);
}

$lines = explode("\n", trim($result));
logMessage("Found " . count($lines) . " streams on remote server");

$updated = 0;
$inserted = 0;
$errors = 0;

foreach($lines as $line) {
    if(empty(trim($line))) continue;

    $parts = explode("\t", $line);
    if(count($parts) < 5) continue;

    $id = intval($parts[0]);
    $name = trim($parts[1]);
    $logo_image = trim($parts[2]);
    $disabled = intval($parts[3]);
    $on_demand = intval($parts[4]);

    // Skip if name is empty
    if(empty($name)) continue;

    // Check if stream exists locally
    $check = $db->query("SELECT id, name, logo_image FROM streams WHERE id = $id");

    if($check && $check->num_rows > 0) {
        // Update existing stream
        $row = $check->fetch_assoc();

        // Only update if data has changed
        $needs_update = false;
        $update_fields = [];

        if($row['name'] != $name) {
            $update_fields[] = "name = '" . $db->real_escape_string($name) . "'";
            $needs_update = true;
        }

        if($row['logo_image'] != $logo_image && !empty($logo_image) && $logo_image != 'NULL') {
            $update_fields[] = "logo_image = '" . $db->real_escape_string($logo_image) . "'";
            $needs_update = true;
        }

        if($needs_update) {
            $update_sql = "UPDATE streams SET " . implode(', ', $update_fields) . " WHERE id = $id";
            if($db->query($update_sql)) {
                $updated++;
            } else {
                logMessage("ERROR updating stream $id: " . $db->error);
                $errors++;
            }
        }
    } else {
        // Insert new stream
        $insert_sql = "INSERT INTO streams (id, type, name, logo_image, disabled, direct_streaming_on_demand, added_time) VALUES (
            $id,
            1,
            '" . $db->real_escape_string($name) . "',
            " . (empty($logo_image) || $logo_image == 'NULL' ? "NULL" : "'" . $db->real_escape_string($logo_image) . "'") . ",
            $disabled,
            $on_demand,
            " . time() . "
        )";

        if($db->query($insert_sql)) {
            $inserted++;
            logMessage("Inserted new stream: $name (ID: $id)");
        } else {
            logMessage("ERROR inserting stream $id: " . $db->error);
            $errors++;
        }
    }

    // Update or insert into streams_sys table
    $check_sys = $db->query("SELECT stream_id FROM streams_sys WHERE stream_id = $id AND server_id = 1");

    if($check_sys && $check_sys->num_rows > 0) {
        // Update existing
        $db->query("UPDATE streams_sys SET on_demand = $on_demand WHERE stream_id = $id AND server_id = 1");
    } else {
        // Insert new
        $db->query("INSERT INTO streams_sys (stream_id, server_id, on_demand) VALUES ($id, 1, $on_demand)");
    }
}

logMessage("=== Sync Complete ===");
logMessage("Updated: $updated streams");
logMessage("Inserted: $inserted new streams");
logMessage("Errors: $errors");

$db->close();
?>
