#!/usr/bin/env php
<?php
/**
 * Cleanup Empty Users Cron Job
 *
 * This script automatically deletes users with empty usernames
 * that may be created by faulty imports
 *
 * Add to crontab:
 * 0 * * * * php /var/www/html/iptv/cron/cleanup_empty_users.php >> /var/log/cleanup_users.log 2>&1
 */

// Database configuration
$db_host = 'localhost';
$db_user = 'root';
$db_pass = 'Admin@123';
$db_name = 'xtream_iptvpro';

// Connect to database
$db = new mysqli($db_host, $db_user, $db_pass, $db_name);
if($db->connect_error) {
    echo "[" . date('Y-m-d H:i:s') . "] Database connection failed: " . $db->connect_error . "\n";
    exit(1);
}

// Find empty users
$check = $db->query("SELECT COUNT(*) as count FROM users WHERE username='' OR username IS NULL");
$row = $check->fetch_assoc();
$count = $row['count'];

if($count > 0) {
    echo "[" . date('Y-m-d H:i:s') . "] Found $count empty users. Deleting...\n";

    // Delete empty users
    $db->query("DELETE FROM users WHERE username='' OR username IS NULL");

    echo "[" . date('Y-m-d H:i:s') . "] Deleted $count empty users successfully.\n";
} else {
    echo "[" . date('Y-m-d H:i:s') . "] No empty users found. Database is clean.\n";
}

$db->close();
