<?php
/**
 * Auto Sync Bouquets from Remote MySQL Server
 * Syncs all bouquets from 204.188.233.170 to local database
 *
 * Add to crontab:
 * */5 * * * * php /var/www/html/iptv/cron/sync_bouquets.php >> /var/log/bouquet_sync.log 2>&1
 */

// Configuration
$remote_host = '204.188.233.170';
$remote_user = 'root';
$remote_pass = 'R7nMi4KCzZv920pG';
$remote_db = 'midnight_iptv';

$log_file = '/var/log/bouquet_sync.log';

function logMsg($msg) {
    global $log_file;
    $timestamp = date('Y-m-d H:i:s');
    $message = "[$timestamp] $msg\n";
    file_put_contents($log_file, $message, FILE_APPEND);
    echo $message;
}

// Load framework
define('_CHECK_X_ME', true);
require(dirname(__FILE__) . '/../load2.php');

logMsg("========================================");
logMsg("Starting bouquet auto-sync from remote MySQL server");

// Helper function to execute remote MySQL query via SSH
function remoteQuery($sql) {
    global $remote_host, $remote_user, $remote_pass, $remote_db;

    $cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
           escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
           " 'mysql " . $remote_db . " -N -e \"" . addslashes($sql) . "\"' 2>&1";

    $result = shell_exec($cmd);
    return trim($result);
}

try {
    // Step 1: Get all bouquets from remote server
    logMsg("Fetching bouquets from remote server...");
    $bouquets_sql = "SELECT id, name FROM bouquets ORDER BY id";
    $bouquets_result = remoteQuery($bouquets_sql);

    if(empty($bouquets_result)) {
        logMsg("No bouquets found on remote server");
        exit(0);
    }

    $bouquets_lines = array_filter(explode("\n", $bouquets_result));
    logMsg("Found " . count($bouquets_lines) . " bouquets on remote server");

    $synced = 0;
    $created = 0;
    $updated = 0;
    $errors = 0;

    // Step 2: Process each bouquet
    foreach($bouquets_lines as $line) {
        $parts = explode("\t", $line);
        if(count($parts) < 2) continue;

        $bouquet_id = intval($parts[0]);
        $bouquet_name = trim($parts[1]);

        if(empty($bouquet_name)) {
            logMsg("Skipping bouquet ID $bouquet_id - empty name");
            continue;
        }

        logMsg("Processing bouquet: $bouquet_name (ID: $bouquet_id)");

        // Step 3: Get streams for this bouquet
        $streams_sql = "SELECT sid FROM bouquets_sids WHERE bid=$bouquet_id ORDER BY ordering";
        $streams_result = remoteQuery($streams_sql);

        $stream_ids = [];
        if(!empty($streams_result)) {
            $stream_ids = array_filter(explode("\n", $streams_result));
        }

        logMsg("  - Found " . count($stream_ids) . " streams");

        // Convert to JSON for storage
        $channels_json = json_encode($stream_ids);

        // Step 4: Check if bouquet exists locally
        $check_sql = $intro->db->query("SELECT id, bouquet_channels FROM bouquets WHERE id=" . $bouquet_id);

        if($check_sql && $intro->db->num_rows($check_sql) > 0) {
            // Bouquet exists - check if update needed
            $local_bouquet = $intro->db->fetch_assoc($check_sql);

            if($local_bouquet['bouquet_channels'] != $channels_json) {
                // Update needed
                $update_sql = "UPDATE bouquets SET
                    bouquet_name='" . $intro->db->escape_string($bouquet_name) . "',
                    bouquet_channels='" . $intro->db->escape_string($channels_json) . "'
                    WHERE id=" . $bouquet_id;

                if($intro->db->query($update_sql)) {
                    logMsg("  ✅ Updated bouquet: $bouquet_name");
                    $updated++;
                } else {
                    logMsg("  ❌ Failed to update bouquet: " . $intro->db->error());
                    $errors++;
                }
            } else {
                logMsg("  ⏭️  No changes needed for: $bouquet_name");
            }
        } else {
            // Create new bouquet
            $insert_sql = "INSERT INTO bouquets (id, bouquet_name, bouquet_channels, bouquet_order)
                VALUES (
                    " . $bouquet_id . ",
                    '" . $intro->db->escape_string($bouquet_name) . "',
                    '" . $intro->db->escape_string($channels_json) . "',
                    " . $bouquet_id . "
                )";

            if($intro->db->query($insert_sql)) {
                logMsg("  ✅ Created bouquet: $bouquet_name");
                $created++;
            } else {
                logMsg("  ❌ Failed to create bouquet: " . $intro->db->error());
                $errors++;
            }
        }

        $synced++;
    }

    // Summary
    logMsg("========================================");
    logMsg("Sync complete!");
    logMsg("  - Total processed: $synced");
    logMsg("  - Created: $created");
    logMsg("  - Updated: $updated");
    logMsg("  - Errors: $errors");
    logMsg("========================================");

    // Update last sync timestamp
    $intro->db->query("REPLACE INTO panel_settings (setting_key, setting_value)
        VALUES ('bouquet_sync_last', '" . time() . "')");

} catch(Exception $e) {
    logMsg("ERROR: " . $e->getMessage());
    logMsg($e->getTraceAsString());
    exit(1);
}
