<?php
// Manual fix for OnDemand mode

echo "<h1>Fix OnDemand Settings Manually</h1>";

$streams = [
    ['id' => 3, 'name' => 'AlKuwait News'],
    ['id' => 4, 'name' => 'KTV2'],
    ['id' => 5, 'name' => 'AlKuwait Sport'],
];

foreach($streams as $stream) {
    $id = $stream['id'];
    $name = $stream['name'];

    echo "<h3>$name (ID: $id)</h3>";
    echo "<button onclick='setLive($id, \"$name\")'>Set to LIVE</button> ";
    echo "<button onclick='setOnDemand($id, \"$name\")'>Set to OnDemand</button>";
    echo "<div id='result_$id' style='margin:10px 0; padding:10px; background:#f0f0f0;'></div>";
}
?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function setLive(id, name) {
    $('#result_' + id).html('Setting to LIVE...');

    $.get('/iptv/index.php/streams/SetLive?NH=1&id=' + id, function(data){
        $('#result_' + id).html('<strong>SetLive Response:</strong> ' + data);
        console.log('SetLive response for ' + name + ':', data);

        // Check result on remote
        setTimeout(function(){
            checkRemoteStatus(id, name);
        }, 1000);
    }).fail(function(xhr, status, error){
        $('#result_' + id).html('<strong>ERROR:</strong> ' + status + ' - ' + error);
    });
}

function setOnDemand(id, name) {
    $('#result_' + id).html('Setting to OnDemand...');

    $.get('/iptv/index.php/streams/SetOnDemand?NH=1&id=' + id, function(data){
        $('#result_' + id).html('<strong>SetOnDemand Response:</strong> ' + data);
        console.log('SetOnDemand response for ' + name + ':', data);

        // Check result on remote
        setTimeout(function(){
            checkRemoteStatus(id, name);
        }, 1000);
    }).fail(function(xhr, status, error){
        $('#result_' + id).html('<strong>ERROR:</strong> ' + status + ' - ' + error);
    });
}

function checkRemoteStatus(id, name) {
    $.get('/iptv/check_stream_status.php?id=' + id, function(data){
        $('#result_' + id).append('<br><br><strong>Current Status:</strong><pre>' + data + '</pre>');
    });
}
</script>
