<?php
/**
 * MAC Address Logger
 * Logs all MAC addresses used with each code
 */

function logMacAddress($link, $code, $code_id, $mac_address, $serial = '', $user_agent = '', $ip_address = '') {
    if(empty($code) || empty($mac_address)) {
        return false;
    }

    $code = mysqli_real_escape_string($link, $code);
    $mac_address = mysqli_real_escape_string($link, $mac_address);
    $serial = mysqli_real_escape_string($link, $serial);
    $user_agent = mysqli_real_escape_string($link, $user_agent);
    $ip_address = mysqli_real_escape_string($link, $ip_address);

    // Check if MAC is blocked
    $check_sql = "SELECT is_blocked FROM code_macs WHERE code = '$code' AND mac_address = '$mac_address' LIMIT 1";
    $result = mysqli_query($link, $check_sql);

    if($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        if($row['is_blocked'] == 1) {
            return 'blocked';
        }

        // Update last_used timestamp
        $update_sql = "UPDATE code_macs SET
                       last_used = CURRENT_TIMESTAMP,
                       serial = '$serial',
                       user_agent = '$user_agent',
                       ip_address = '$ip_address'
                       WHERE code = '$code' AND mac_address = '$mac_address'";
        mysqli_query($link, $update_sql);
        return true;
    }

    // Insert new MAC address record
    $insert_sql = "INSERT INTO code_macs (code_id, code, mac_address, serial, user_agent, ip_address)
                   VALUES ('$code_id', '$code', '$mac_address', '$serial', '$user_agent', '$ip_address')";
    mysqli_query($link, $insert_sql);

    return true;
}

function checkMacBlocked($link, $code, $mac_address) {
    $code = mysqli_real_escape_string($link, $code);
    $mac_address = mysqli_real_escape_string($link, $mac_address);

    $sql = "SELECT is_blocked FROM code_macs WHERE code = '$code' AND mac_address = '$mac_address' AND is_blocked = 1 LIMIT 1";
    $result = mysqli_query($link, $sql);

    return ($result && mysqli_num_rows($result) > 0);
}
