<?php
/**
 * Remote Panel Configuration Helper
 * Manages connection settings to external MidnightStreamer panel
 */

class RemotePanelConfig
{
    private static $settings = null;

    /**
     * Get remote panel settings from database
     */
    public static function getSettings()
    {
        if (self::$settings !== null) {
            return self::$settings;
        }

        // Default settings (fallback)
        self::$settings = [
            'host' => '204.188.233.170',
            'port' => 7999,
            'user' => 'grboxbilling',
            'pass' => 'nasasat',
            'database' => 'midnight_iptv',
            'api_port' => 8000,
            'enabled' => true
        ];

        // Try to load from database
        try {
            // Use Config.php database connection if available
            global $config;
            if(!isset($config) && file_exists(dirname(__FILE__) . '/Config.php')) {
                require_once(dirname(__FILE__) . '/Config.php');
            }

            if(isset($config) && is_array($config) && isset($config['db'])) {
                $conn = new mysqli($config['db']['hostname'], $config['db']['username'], $config['db']['password'], $config['db']['database']);

                if(!$conn->connect_error) {
                    $result = $conn->query("SELECT setting_key, setting_value FROM panel_settings WHERE setting_key LIKE 'remote_panel_%'");

                    if ($result && $result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            $key = str_replace('remote_panel_', '', $row['setting_key']);

                            switch($key) {
                                case 'port':
                                case 'api_port':
                                    self::$settings[$key] = intval($row['setting_value']);
                                    break;
                                case 'enabled':
                                    self::$settings[$key] = ($row['setting_value'] == '1');
                                    break;
                                default:
                                    self::$settings[$key] = $row['setting_value'];
                            }
                        }
                    }

                    $conn->close();
                } else {
                    error_log("RemotePanelConfig: DB connection failed: " . $conn->connect_error);
                }
            }
        } catch (Exception $e) {
            error_log("RemotePanelConfig: Failed to load settings from database: " . $e->getMessage());
        }

        return self::$settings;
    }

    /**
     * Get a specific setting value
     */
    public static function get($key, $default = null)
    {
        $settings = self::getSettings();
        return isset($settings[$key]) ? $settings[$key] : $default;
    }

    /**
     * Check if remote panel sync is enabled
     */
    public static function isEnabled()
    {
        return self::get('enabled', true);
    }

    /**
     * Update a setting in database
     */
    public static function updateSetting($key, $value)
    {
        global $intro;

        $full_key = 'remote_panel_' . $key;
        $value_esc = $intro->db->real_escape_string($value);

        // Check if exists
        $check = $intro->db->query("SELECT id FROM panel_settings WHERE setting_key = '$full_key'");

        if ($intro->db->returned_rows > 0) {
            // Update
            $intro->db->query("UPDATE panel_settings SET setting_value = '$value_esc', updated_at = NOW() WHERE setting_key = '$full_key'");
        } else {
            // Insert
            $intro->db->query("INSERT INTO panel_settings (setting_key, setting_value) VALUES ('$full_key', '$value_esc')");
        }

        // Clear cache
        self::$settings = null;

        return true;
    }

    /**
     * Get API base URL
     */
    public static function getApiUrl()
    {
        $host = self::get('host');
        $port = self::get('api_port', 8000);
        return "http://{$host}:{$port}/api";
    }

    /**
     * Create MySQL connection to remote panel
     */
    public static function getConnection()
    {
        $settings = self::getSettings();

        $conn = new mysqli(
            $settings['host'],
            $settings['user'],
            $settings['pass'],
            $settings['database'],
            $settings['port']
        );

        if ($conn->connect_error) {
            error_log("RemotePanelConfig: Connection failed: " . $conn->connect_error);
            return false;
        }

        return $conn;
    }

    /**
     * Execute SSH command on remote panel
     */
    public static function sshExecute($command)
    {
        $settings = self::getSettings();

        $ssh_cmd = "sshpass -p " . escapeshellarg($settings['pass']) .
                   " ssh -o StrictHostKeyChecking=no -o ConnectTimeout=10 " .
                   escapeshellarg($settings['user']) . "@" . escapeshellarg($settings['host']) .
                   " " . escapeshellarg($command);

        return shell_exec($ssh_cmd);
    }
}
?>
