<?php 

class ApiBaseObject
{
    protected $_data = NULL;

    const MEDIA_TYPE_MOVIE = "movie";
    const CREDITS_TYPE_CAST = "cast";
    const CREDITS_TYPE_CREW = "crew";
    const MEDIA_TYPE_TV = "tv";

    public function __construct($data)
    {
        $this->_data = $data;
    }

    public function getID()
    {
        return $this->_data["id"];
    }

    public function getPoster()
    {
        return $this->_data["poster_path"];
    }

    public function getVoteAverage()
    {
        return $this->_data["vote_average"];
    }

    public function getVoteCount()
    {
        return $this->_data["vote_count"];
    }

    public function getCast()
    {
        return $this->getCredits("cast");
    }

    protected function getCredits($key)
    {
        $persons = [  ];
        foreach( $this->_data["credits"][$key] as $data ) 
        {
            $persons[] = new Person($data);
        }
        return $persons;
    }

    public function getGenres()
    {
        $genres = [  ];
        foreach( $this->_data["genres"] as $data ) 
        {
            $genres[] = new Genre($data);
        }
        return $genres;
    }

    public function getCrew()
    {
        return $this->getCredits("crew");
    }

    public function get($item = "")
    {
        if( empty($item) ) 
        {
            return $this->_data;
        }

        if( array_key_exists($item, $this->_data) ) 
        {
            return $this->_data[$item];
        }

        return NULL;
    }

}


