<?php 

class MovieJob
{
    private $_data = NULL;

    public function __construct($data, $ipPerson)
    {
        $this->_data = $data;
        $this->_data["person_id"] = $ipPerson;
    }

    public function getMovieTitle()
    {
        return $this->_data["title"];
    }

    public function getMovieID()
    {
        return $this->_data["id"];
    }

    public function getMovieOriginalTitle()
    {
        return $this->_data["original_title"];
    }

    public function getMovieReleaseDate()
    {
        return $this->_data["release_date"];
    }

    public function getPoster()
    {
        return $this->_data["poster_path"];
    }

    public function getMovieJob()
    {
        return $this->_data["job"];
    }

    public function getMovieDepartment()
    {
        return $this->_data["department"];
    }

    public function getMovieOverview()
    {
        return $this->_data["overview"];
    }

    public function getJSON()
    {
        return json_encode($this->_data, JSON_PRETTY_PRINT);
    }

}


