<?php
// Manual sync script - can be triggered from browser or command line
// This syncs streams from the remote panel database

define('_CHECK_X_ME', true);
require_once(dirname(__FILE__) . '/load2.php');

// Check admin access
$admin = $intro->auth->sess_admin();
if(!$admin || ($admin['level'] != 1 && $admin['level'] != 5)) {
    exit('Access denied - Admin only');
}

// Remote connection details (stored in AdminStreams)
$remote_host = "204.188.233.170";
$remote_user = "root";
$remote_pass = "R7nMi4KCzZv920pG";
$remote_db = "midnight_iptv";

echo "<h2>Manual Stream Sync</h2>";
echo "<p>Starting sync from remote panel...</p>";

// Test connection method
echo "<h3>Testing connection methods...</h3>";

// Try direct MySQL connection
echo "<p>1. Testing direct MySQL connection... ";
$remote_conn = @new mysqli($remote_host, $remote_user, $remote_pass, $remote_db);
if($remote_conn->connect_error) {
    echo "<span style='color:red'>FAILED: " . $remote_conn->connect_error . "</span></p>";
    $mysql_works = false;
} else {
    echo "<span style='color:green'>SUCCESS!</span></p>";
    $mysql_works = true;
    $remote_conn->close();
}

// Since MySQL might not work, let's use the AdminStreams methods
echo "<h3>Using AdminStreams API methods...</h3>";

require_once(dirname(__FILE__) . '/includes/AdminStreams.php');
$adminStreams = new AdminStreams();

// Get local streams count before sync
$before_count = $intro->db->dcount('id', 'streams', 'type=1');
echo "<p>Local streams before sync: <strong>$before_count</strong></p>";

// Try to sync using the remote API methods built into AdminStreams
echo "<p>Attempting to sync streams...</p>";

if($mysql_works) {
    // Use direct MySQL sync
    $remote_conn = new mysqli($remote_host, $remote_user, $remote_pass, $remote_db);

    $query = "SELECT id, name, logo_image, disabled, direct_streaming_on_demand FROM streams WHERE type=0 ORDER BY id LIMIT 100";
    $result = $remote_conn->query($query);

    if($result) {
        $updated = 0;
        $inserted = 0;

        while($row = $result->fetch_assoc()) {
            $id = intval($row['id']);
            $name = $intro->db->escape($row['name']);
            $logo_image = $row['logo_image'];

            // Check if exists
            $check = $intro->db->query("SELECT id FROM streams WHERE id = $id");

            if($intro->db->returned_rows > 0) {
                // Update
                $intro->db->query("UPDATE streams SET name = '$name' WHERE id = $id");
                $updated++;
            } else {
                // Insert
                $logo_val = empty($logo_image) || $logo_image == 'NULL' ? 'NULL' : "'" . $intro->db->escape($logo_image) . "'";
                $intro->db->query("INSERT INTO streams (id, type, name, logo_image, added_time) VALUES ($id, 1, '$name', $logo_val, " . time() . ")");
                $inserted++;
            }
        }

        echo "<p><span style='color:green'>Sync completed!</span></p>";
        echo "<p>Updated: <strong>$updated</strong> streams</p>";
        echo "<p>Inserted: <strong>$inserted</strong> new streams</p>";
    }

    $remote_conn->close();
} else {
    echo "<p style='color:orange'>Direct MySQL connection not available. Streams must be synced manually or via API.</p>";
    echo "<p>Current streams in database: <strong>$before_count</strong></p>";
}

// Get local streams count after sync
$after_count = $intro->db->dcount('id', 'streams', 'type=1');
echo "<p>Local streams after sync: <strong>$after_count</strong></p>";

echo "<hr>";
echo "<p><a href='" . admin_path . "index.php/streams/index'>Go to Streams</a></p>";
echo "<p><a href='" . admin_path . "index.php/streams_bulk/index'>Go to Streams Bulk</a></p>";
?>
