<?php
// Collapsible Sidebar Menu - Option 1
?>
<!DOCTYPE html>
<html dir="<?php echo $intro->lang['dir']; ?>">
<head>
	<meta charset="utf-8">
	<link rel="shortcut icon" type="image/x-icon" href="<?php echo admin_path; ?>style/favicon.ico" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<title><?php echo ' ' . $app_name . ' | ' . $intro->option['site_name'] . ' - ' . $copyright; ?></title>
	<meta name="description" content="">
	<meta name="viewport" content="width=device-width">

	<link rel="stylesheet" href="<?php echo admin_path; ?>style/css/css.php?v=235">
	<link rel="stylesheet" href="<?php echo admin_path; ?>style/css/modern-dashboard.css?v=1">
	<script src="<?php echo admin_path; ?>style/js.php?v=233"></script>

	<script>
	var lang_del = '<?php echo $intro->lang['del']; ?>';
	var lang_cancel = '<?php echo $intro->lang['cancel']; ?>';
	var admin_folder = '<?php echo admin_path; ?>';

	</script>

	<script src="<?php echo admin_path; ?>style/js/main.js?v=33"></script>

	<meta name="viewport" content="width=750">

	<style>
	/* Sidebar Styles */
	* {
		box-sizing: border-box;
	}

	body {
		margin: 0;
		padding: 0;
		font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
		background: #f5f7fa;
		overflow-x: hidden;
	}

	.sidebar {
		width: 260px;
		background: #1e1e2d;
		color: #fff;
		position: fixed;
		height: 100vh;
		overflow-y: auto;
		overflow-x: hidden;
		transition: all 0.3s ease;
		z-index: 1000;
		box-shadow: 0 0 50px rgba(0,0,0,0.3);
		left: 0;
		top: 0;
		border-right: 1px solid rgba(255,255,255,0.05);
	}

	.sidebar.collapsed {
		width: 80px;
	}

	.sidebar.collapsed .menu-text {
		display: none;
	}

	.sidebar.collapsed .caret {
		display: none;
	}

	.sidebar-header {
		padding: 20px 20px;
		background: #1a1a27;
		display: flex;
		align-items: center;
		justify-content: center;
		border-bottom: 1px solid rgba(255,255,255,0.08);
		min-height: 70px;
	}

	.sidebar-header .logo {
		display: flex;
		align-items: center;
		justify-content: center;
	}

	.sidebar-header .logo img {
		max-height: 40px;
		transition: all 0.3s;
	}

	.sidebar.collapsed .sidebar-header .logo img {
		max-height: 30px;
	}

	.sidebar-toggle {
		position: fixed;
		left: 245px;
		top: 20px;
		background: linear-gradient(135deg, #3699ff 0%, #0076ff 100%);
		border: 3px solid #fff;
		color: #fff;
		font-size: 16px;
		cursor: pointer;
		padding: 0;
		border-radius: 50%;
		transition: all 0.3s ease;
		width: 40px;
		height: 40px;
		display: flex;
		align-items: center;
		justify-content: center;
		box-shadow: 0 4px 15px rgba(54, 153, 255, 0.5);
		z-index: 10000;
	}

	.sidebar-toggle i {
		font-size: 18px;
		transition: transform 0.3s ease;
	}

	.sidebar-toggle:hover {
		background: linear-gradient(135deg, #0076ff 0%, #005acc 100%);
		transform: scale(1.15);
		box-shadow: 0 6px 20px rgba(54, 153, 255, 0.7);
	}

	.sidebar.collapsed .sidebar-toggle {
		left: 55px;
	}

	.sidebar.collapsed .sidebar-toggle i {
		transform: rotate(180deg);
	}


	.sidebar-menu {
		list-style: none;
		padding: 0;
		margin: 0;
	}

	.sidebar-menu > li {
		border-bottom: 1px solid rgba(255,255,255,0.05);
	}

	.sidebar-menu > li > a {
		display: flex;
		align-items: center;
		padding: 12px 20px;
		color: #a2a3b7;
		text-decoration: none;
		transition: all 0.2s;
		position: relative;
		font-size: 13px;
		font-weight: 500;
		border-left: 0px solid transparent;
	}

	.sidebar-menu > li > a:hover {
		background: rgba(54, 153, 255, 0.08);
		color: #3699ff;
	}

	.sidebar-menu > li.active > a {
		background: rgba(54, 153, 255, 0.12);
		color: #3699ff;
		border-left: 3px solid #3699ff;
	}

	.sidebar-menu > li > a i {
		font-size: 18px;
		min-width: 32px;
		margin-right: 12px;
		text-align: center;
	}

	.sidebar.collapsed .sidebar-menu > li > a {
		justify-content: center;
		padding: 16px 0;
		position: relative;
		overflow: visible;
		border-left: 0 !important;
	}

	.sidebar.collapsed .sidebar-menu > li > a i {
		margin-right: 0;
		font-size: 22px;
	}

	.sidebar.collapsed .sidebar-menu > li.active > a {
		background: rgba(54, 153, 255, 0.2);
		border-left: 0;
	}

	.sidebar.collapsed .sidebar-menu > li > a:hover {
		background: rgba(54, 153, 255, 0.15);
	}

	/* Tooltip on hover when collapsed */
	.sidebar.collapsed .sidebar-menu > li > a:hover::after {
		content: attr(data-title);
		position: absolute;
		left: 90px;
		top: 50%;
		transform: translateY(-50%);
		background: #2c3e50;
		color: #fff;
		padding: 10px 16px;
		border-radius: 8px;
		white-space: nowrap;
		z-index: 10001;
		font-size: 13px;
		font-weight: 500;
		box-shadow: 0 8px 20px rgba(0,0,0,0.4);
		border: 1px solid rgba(54, 153, 255, 0.3);
		animation: tooltipSlide 0.25s ease;
	}

	.sidebar.collapsed .sidebar-menu > li > a:hover::before {
		content: '';
		position: absolute;
		left: 80px;
		top: 50%;
		transform: translateY(-50%);
		width: 0;
		height: 0;
		border-top: 6px solid transparent;
		border-bottom: 6px solid transparent;
		border-right: 8px solid #2c3e50;
		z-index: 10001;
		animation: tooltipSlide 0.25s ease;
	}

	@keyframes tooltipSlide {
		from {
			opacity: 0;
			transform: translateY(-50%) translateX(-10px);
		}
		to {
			opacity: 1;
			transform: translateY(-50%) translateX(0);
		}
	}

	.sidebar-menu .submenu {
		list-style: none;
		padding: 8px 0;
		margin: 0;
		max-height: 0;
		overflow: hidden;
		transition: max-height 0.3s ease;
		background: #15151f;
	}

	.sidebar-menu li.active > .submenu {
		max-height: 2000px;
	}

	.sidebar-menu .submenu li a {
		display: flex;
		align-items: center;
		padding: 10px 20px 10px 52px;
		color: #7e8299;
		text-decoration: none;
		transition: all 0.2s;
		font-size: 12px;
		position: relative;
	}

	.sidebar-menu .submenu li a::before {
		content: '−';
		position: absolute;
		left: 35px;
		color: #565674;
		font-size: 12px;
		font-weight: bold;
	}

	.sidebar.collapsed .sidebar-menu .submenu {
		display: none;
	}

	.sidebar-menu .submenu li a:hover {
		background: rgba(54, 153, 255, 0.06);
		color: #3699ff;
	}

	.sidebar-menu > li > a .caret {
		margin-left: auto;
		border: 4px solid transparent;
		border-top-color: rgba(255,255,255,0.6);
		border-bottom: 0;
		transition: transform 0.3s;
	}

	.sidebar-menu li.active > a .caret {
		transform: rotate(180deg);
	}

	.main-content {
		margin-left: 260px;
		min-height: 100vh;
		transition: all 0.3s ease;
		background: #f5f7fa;
		position: relative;
	}

	.sidebar.collapsed ~ .main-content {
		margin-left: 70px;
	}

	.top-header {
		background: #fff;
		padding: 16px 30px;
		box-shadow: 0 1px 0 rgba(0,0,0,0.05);
		display: flex;
		justify-content: space-between;
		align-items: center;
		position: sticky;
		top: 0;
		z-index: 100;
		border-bottom: 1px solid #eff2f5;
	}

	.user-info {
		display: flex;
		align-items: center;
		gap: 15px;
		color: #3f4254;
		font-size: 14px;
		font-weight: 500;
	}

	.user-info a {
		color: #3699ff;
		margin-left: 8px;
	}

	.credit-badge {
		background: #f3f6f9;
		color: #3f4254;
		padding: 8px 18px;
		border-radius: 6px;
		font-weight: 600;
		font-size: 13px;
		border: 1px solid #e4e6ef;
	}

	.credit-badge span {
		color: #3699ff;
		margin-left: 5px;
	}

	.content-area {
		padding: 25px 30px;
		width: 100%;
		box-sizing: border-box;
	}

	/* Fix for tables and content */
	#Contents {
		width: 100%;
		overflow-x: visible;
		box-sizing: border-box;
	}

	#Contents > * {
		max-width: 100%;
		box-sizing: border-box;
	}

	.table-responsive {
		overflow-x: auto;
		-webkit-overflow-scrolling: touch;
		width: 100%;
	}

	table {
		width: 100% !important;
		table-layout: auto;
	}

	.app_nav {
		margin-bottom: 20px;
		display: flex;
		flex-wrap: wrap;
		gap: 8px;
	}

	.app_nav .btn {
		margin-bottom: 0;
		white-space: nowrap;
	}

	/* Fix for forms and inputs */
	.form-control,
	input,
	select,
	textarea {
		max-width: 100%;
		box-sizing: border-box;
	}

	/* Fix for rows and columns */
	.row {
		margin-left: -15px;
		margin-right: -15px;
	}

	.col-md-12,
	.col-md-6,
	.col-md-4,
	.col-md-3 {
		padding-left: 15px;
		padding-right: 15px;
		box-sizing: border-box;
	}

	/* Scrollbar */
	.sidebar::-webkit-scrollbar {
		width: 6px;
	}

	.sidebar::-webkit-scrollbar-track {
		background: rgba(255,255,255,0.05);
	}

	.sidebar::-webkit-scrollbar-thumb {
		background: rgba(255,255,255,0.2);
		border-radius: 3px;
	}

	.sidebar::-webkit-scrollbar-thumb:hover {
		background: rgba(255,255,255,0.3);
	}

	/* Mobile Responsive */
	@media (max-width: 768px) {
		.sidebar {
			transform: translateX(-100%);
		}

		.sidebar.mobile-open {
			transform: translateX(0);
		}

		.main-content {
			margin-left: 0 !important;
			width: 100% !important;
		}

		.content-area {
			padding: 15px;
		}

		.top-header {
			padding: 12px 15px;
		}
	}

	/* Print Mode */
	@media print {
		.sidebar {
			display: none !important;
		}

		.main-content {
			margin-left: 0 !important;
			width: 100% !important;
		}

		.top-header {
			display: none !important;
		}

		.content-area {
			padding: 0;
		}
	}

	/* Smooth animations */
	.sidebar, .sidebar * {
		-webkit-font-smoothing: antialiased;
		-moz-osx-font-smoothing: grayscale;
	}

	/* Better scrolling on mobile */
	.sidebar {
		-webkit-overflow-scrolling: touch;
	}

	/* Focus states for accessibility */
	.sidebar-menu a:focus {
		outline: 2px solid #667eea;
		outline-offset: -2px;
	}
	</style>

</head>
<body>

<div class="sidebar-container">
	<!-- Sidebar -->
	<aside class="sidebar" id="sidebar">
		<div class="sidebar-header">
			<button class="sidebar-toggle" onclick="toggleSidebar()">
				<i class="icon-left-open"></i>
			</button>
			<span class="logo">
				<a href="<?php echo $intro->app_url('home'); ?>">
					<img src="<?php echo $logo; ?>" alt="Logo"/>
				</a>
			</span>
		</div>

		<ul class="sidebar-menu">
			<li>
				<a href="<?php echo $intro->app_url('home', 'index'); ?>" data-title="Home">
					<i class="icon-home"></i>
					<span class="menu-text">Home</span>
				</a>
			</li>

			<?php
			// Add data-title attributes for tooltips
			$menu_with_titles = preg_replace('/<a\s+class="([^"]*)"/', '<a data-title="$1" class="$1"', $menu);
			$menu_with_titles = str_replace('dropdown-toggle', '', str_replace('dropdown-menu', 'submenu', $menu_with_titles));
			echo $menu_with_titles;

			$main_menu_with_titles = preg_replace('/<a\s+class="([^"]*)"/', '<a data-title="$1" class="$1"', $main_menu);
			$main_menu_with_titles = str_replace('dropdown-toggle', '', str_replace('dropdown-menu', 'submenu', $main_menu_with_titles));
			echo $main_menu_with_titles;
			?>

			<li>
				<a href="<?php echo admin_path; ?>login.php?maa=Logout" data-title="Logout">
					<i class="icon-logout"></i>
					<span class="menu-text"><?php echo $intro->lang['logout']; ?></span>
				</a>
			</li>
		</ul>
	</aside>

	<!-- Main Content -->
	<div class="main-content">
		<header class="top-header">
			<div class="user-info">
				<span><?php echo $admin_welcome; ?></span>
				<a href="<?php echo $intro->app_url('myaccount', 'index'); ?>" class="icon-info" title="My Account"></a>
			</div>
			<div class="credit-badge">
				Credit: <span><?php echo floatval($balance); ?></span>
			</div>
		</header>

		<div class="content-area" id="Contents">

<script>
// Toggle Sidebar
function toggleSidebar() {
	document.getElementById('sidebar').classList.toggle('collapsed');
	localStorage.setItem('sidebarCollapsed', document.getElementById('sidebar').classList.contains('collapsed'));
}

// Remember sidebar state
window.addEventListener('DOMContentLoaded', function() {
	if(localStorage.getItem('sidebarCollapsed') === 'true') {
		document.getElementById('sidebar').classList.add('collapsed');
	}

	// Add dropdown functionality
	document.querySelectorAll('.sidebar-menu > li > a').forEach(function(item) {
		if(item.querySelector('.caret')) {
			item.addEventListener('click', function(e) {
				e.preventDefault();
				var parent = this.parentElement;

				// Close other dropdowns
				document.querySelectorAll('.sidebar-menu > li.active').forEach(function(li) {
					if(li !== parent) {
						li.classList.remove('active');
					}
				});

				// Toggle current dropdown
				parent.classList.toggle('active');
			});
		}
	});
});

// Mobile toggle
function toggleMobileSidebar() {
	document.getElementById('sidebar').classList.toggle('mobile-open');
}
</script>

<!-- Dialog Box -->
<div id="dialog-box" title="Confirm Delete?" style="display: none">
	<p><span class="ui-icon ui-icon-alert" style="float: left; margin: 0 7px 20px 0;">
	</span>Warning: This action cannot be UN DONE!!!.</p>
</div>

<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
				 <h4 class="modal-title">Modal title</h4>

			</div>
			<div class="modal-body"><div class="te"></div></div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			</div>
		</div>
	</div>
</div>

<!-- M3U Modal -->
<div class='modal fade' id='m3u-modal'>
	<div class='modal-dialog modal-lg'>
		<div class='modal-content'>
			<div class='modal-body'></div>
			<div class='modal-footer'>
				<button class='btn btn-default' data-dismiss="modal">Close</button>
			</div>
		</div>
	</div>
</div>
