#!/usr/bin/php
<?php
// Codec and Bitrate sync daemon - Runs every 3 seconds
// Fetches codec and bitrate information from remote running streams via ffprobe
// Updates local streams_sys table with stream_info and bitrate

require_once('/var/www/html/iptv/includes/Config.php');

// Remote connection details
$remote_host = "204.188.233.170";
$remote_user = "root";
$remote_pass = "R7nMi4KCzZv920pG";

// Local connection
$local_host = $config['db']['hostname'];
$local_user = $config['db']['username'];
$local_pass = $config['db']['password'];
$local_db = $config['db']['database'];

// Log file
$logfile = '/var/log/sync_codec_daemon.log';

function logMsg($msg) {
    global $logfile;
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logfile, "[$timestamp] $msg\n", FILE_APPEND);
}

logMsg("=== Codec/Bitrate Sync Daemon Started ===");
logMsg("Remote: $remote_host");
logMsg("Check interval: 3 seconds");

// Main loop
$iteration = 0;
while(true) {
    $iteration++;
    $start_time = microtime(true);

    try {
        // Connect to local database
        $local_conn = @new mysqli($local_host, $local_user, $local_pass, $local_db);
        if($local_conn->connect_error) {
            logMsg("ERROR: Local DB connection failed: " . $local_conn->connect_error);
            sleep(3);
            continue;
        }

        // Get list of running streams from local streams_sys
        $running_result = $local_conn->query("SELECT stream_id, pid FROM streams_sys WHERE stream_status = 0 AND pid IS NOT NULL");

        if(!$running_result) {
            logMsg("ERROR: Query failed: " . $local_conn->error);
            $local_conn->close();
            sleep(3);
            continue;
        }

        $updated = 0;
        $errors = 0;

        while($row = $running_result->fetch_assoc()) {
            $stream_id = intval($row['stream_id']);
            $pid = intval($row['pid']);

            // Get stream URL from remote to run ffprobe
            $url_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " .
                       escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
                       " \"mysql midnight_iptv -N -e 'SELECT urls FROM streams WHERE id=$stream_id;'\" 2>&1";

            $url_result = shell_exec($url_cmd);

            if(empty($url_result) || strpos($url_result, 'ERROR') !== false) {
                continue;
            }

            // Parse JSON URL
            $url_result = trim($url_result);
            $urls_array = json_decode($url_result, true);

            if(empty($urls_array) || !is_array($urls_array) || count($urls_array) == 0) {
                continue;
            }

            $stream_url = $urls_array[0]; // Get first URL

            // Run ffprobe on remote server to get codec and bitrate info
            $ffprobe_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " .
                          escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
                          " \"timeout 10 /home/midnightstreamer/iptv_midnight_streamer/bin/ffprobe -v quiet -print_format json -show_streams -show_format " .
                          escapeshellarg($stream_url) . "\" 2>&1";

            $ffprobe_result = shell_exec($ffprobe_cmd);

            if(empty($ffprobe_result)) {
                $errors++;
                continue;
            }

            // Parse ffprobe JSON output
            $probe_data = json_decode($ffprobe_result, true);

            if(empty($probe_data) || !isset($probe_data['streams'])) {
                $errors++;
                continue;
            }

            // Extract codec and bitrate info
            $stream_info_data = [];
            $total_bitrate = 0;

            foreach($probe_data['streams'] as $stream) {
                $codec_type = isset($stream['codec_type']) ? $stream['codec_type'] : 'unknown';
                $codec_name = isset($stream['codec_name']) ? $stream['codec_name'] : 'unknown';
                $bitrate = isset($stream['bit_rate']) ? intval($stream['bit_rate']) : 0;

                if($bitrate > 0) {
                    $total_bitrate += $bitrate;
                }

                $info = [];
                $info['codec_type'] = $codec_type;
                $info['codec_name'] = $codec_name;

                if($codec_type == 'video') {
                    $info['width'] = isset($stream['width']) ? $stream['width'] : 0;
                    $info['height'] = isset($stream['height']) ? $stream['height'] : 0;
                    $info['fps'] = isset($stream['r_frame_rate']) ? $stream['r_frame_rate'] : '';
                } elseif($codec_type == 'audio') {
                    $info['sample_rate'] = isset($stream['sample_rate']) ? $stream['sample_rate'] : 0;
                    $info['channels'] = isset($stream['channels']) ? $stream['channels'] : 0;
                }

                if($bitrate > 0) {
                    $info['bitrate'] = $bitrate;
                }

                $stream_info_data[] = $info;
            }

            // Get overall bitrate from format if not from streams
            if($total_bitrate == 0 && isset($probe_data['format']['bit_rate'])) {
                $total_bitrate = intval($probe_data['format']['bit_rate']);
            }

            // Convert bitrate from bps to kbps
            $bitrate_kbps = round($total_bitrate / 1000);

            // Serialize stream_info as JSON
            $stream_info_json = json_encode($stream_info_data);
            $stream_info_escaped = $local_conn->real_escape_string($stream_info_json);

            // Update streams_sys
            $update_sql = "UPDATE streams_sys SET
                          stream_info = '$stream_info_escaped',
                          bitrate = $bitrate_kbps
                          WHERE stream_id = $stream_id";

            if($local_conn->query($update_sql)) {
                $updated++;
            } else {
                logMsg("ERROR updating stream $stream_id: " . $local_conn->error);
                $errors++;
            }
        }

        // Log summary every 20 iterations (every minute)
        if($iteration % 20 == 0) {
            logMsg("Iteration $iteration - Updated: $updated, Errors: $errors");
        }

        $running_result->free();
        $local_conn->close();

    } catch(Exception $e) {
        logMsg("ERROR: " . $e->getMessage());
    }

    // Sleep for 3 seconds
    $elapsed = microtime(true) - $start_time;
    $sleep_time = max(0, 3 - $elapsed);
    usleep($sleep_time * 1000000);
}
?>
