#!/usr/bin/php
<?php
// Continuous sync daemon using direct MySQL connection to remote server
// Syncs streams data from remote panel every 10 seconds

require_once('/var/www/html/iptv/includes/Config.php');

// Remote MySQL connection details
$remote_host = "204.188.233.170";
$remote_user = "root";
$remote_pass = "R7nMi4KCzZv920pG";
$remote_db = "midnight_iptv";

// Log file
$logfile = '/var/log/sync_daemon_mysql.log';

function logMessage($message) {
    global $logfile;
    file_put_contents($logfile, "[" . date('Y-m-d H:i:s') . "] " . $message . "\n", FILE_APPEND);
}

logMessage("=== Sync Daemon Started (MySQL Direct Connection) ===");

// Main loop - run forever
while(true) {
    $start_time = microtime(true);

    try {
        // Connect to local database
        $local_db = new mysqli(
            $config['db']['hostname'],
            $config['db']['username'],
            $config['db']['password'],
            $config['db']['database']
        );

        if($local_db->connect_error) {
            logMessage("ERROR: Local DB connection failed: " . $local_db->connect_error);
            sleep(10);
            continue;
        }

        // Connect to remote database
        $remote_db_conn = new mysqli($remote_host, $remote_user, $remote_pass, $remote_db);

        if($remote_db_conn->connect_error) {
            logMessage("ERROR: Remote DB connection failed: " . $remote_db_conn->connect_error);
            $local_db->close();
            sleep(10);
            continue;
        }

        // Fetch streams from remote (type=0 on remote = live channels)
        $query = "SELECT id, name, logo_image, disabled, direct_streaming_on_demand FROM streams WHERE type=0 ORDER BY id";
        $result = $remote_db_conn->query($query);

        if(!$result) {
            logMessage("ERROR: Failed to query remote database: " . $remote_db_conn->error);
            $remote_db_conn->close();
            $local_db->close();
            sleep(10);
            continue;
        }

        $updated = 0;
        $inserted = 0;

        while($row = $result->fetch_assoc()) {
            $id = intval($row['id']);
            $name = $local_db->real_escape_string($row['name']);
            $logo_image = $row['logo_image'];
            $disabled = intval($row['disabled']);
            $on_demand = intval($row['direct_streaming_on_demand']);

            // Check if stream exists locally
            $check = $local_db->query("SELECT id, name, logo_image FROM streams WHERE id = $id");

            if($check && $check->num_rows > 0) {
                // Update existing stream
                $local_row = $check->fetch_assoc();

                $update_fields = [];

                if($local_row['name'] != $row['name']) {
                    $update_fields[] = "name = '$name'";
                }

                if(!empty($logo_image) && $logo_image != 'NULL' && $local_row['logo_image'] != $logo_image) {
                    $logo_escaped = $local_db->real_escape_string($logo_image);
                    $update_fields[] = "logo_image = '$logo_escaped'";
                }

                if(count($update_fields) > 0) {
                    $update_sql = "UPDATE streams SET " . implode(', ', $update_fields) . " WHERE id = $id";
                    $local_db->query($update_sql);
                    $updated++;
                }
            } else {
                // Insert new stream (type=1 locally for live channels)
                $logo_val = empty($logo_image) || $logo_image == 'NULL' ? 'NULL' : "'" . $local_db->real_escape_string($logo_image) . "'";

                $insert_sql = "INSERT INTO streams (id, type, name, logo_image, disabled, direct_streaming_on_demand, added_time)
                               VALUES ($id, 1, '$name', $logo_val, $disabled, $on_demand, " . time() . ")";

                if($local_db->query($insert_sql)) {
                    $inserted++;
                }
            }

            // Update streams_sys table
            $check_sys = $local_db->query("SELECT stream_id FROM streams_sys WHERE stream_id = $id AND server_id = 1");

            if($check_sys && $check_sys->num_rows > 0) {
                $local_db->query("UPDATE streams_sys SET on_demand = $on_demand WHERE stream_id = $id AND server_id = 1");
            } else {
                $local_db->query("INSERT INTO streams_sys (stream_id, server_id, on_demand) VALUES ($id, 1, $on_demand)");
            }
        }

        // Log every 6 iterations (every minute if 10s interval)
        if(rand(1, 6) == 1) {
            logMessage("Synced - Updated: $updated, Inserted: $inserted");
        }

        $result->free();
        $remote_db_conn->close();
        $local_db->close();

    } catch(Exception $e) {
        logMessage("ERROR: " . $e->getMessage());
    }

    // Sleep for 10 seconds
    $elapsed = microtime(true) - $start_time;
    $sleep_time = max(0, 10 - $elapsed);
    sleep($sleep_time);
}
?>
