#!/usr/bin/php
<?php
// Online Users Sync Daemon
// Syncs online user counts from MidnightStreamer to local panel
// Runs every 10 seconds

require_once('/var/www/html/iptv/includes/Config.php');

// Remote connection details
require_once('/var/www/html/iptv/includes/RemotePanelConfig.php'); $remote_host = RemotePanelConfig::get('host');
$remote_user = RemotePanelConfig::get('user');
$remote_pass = RemotePanelConfig::get('pass');

// Local connection
$local_host = $config['db']['hostname'];
$local_user = $config['db']['username'];
$local_pass = $config['db']['password'];
$local_db = $config['db']['database'];

// Log file
$logfile = '/var/log/sync_online_users.log';

function logMsg($msg) {
    global $logfile;
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logfile, "[$timestamp] $msg\n", FILE_APPEND);
}

logMsg("=== Online Users Sync Daemon Started ===");
logMsg("Remote: $remote_host");
logMsg("Sync interval: 10 seconds");

// Main loop
$iteration = 0;
while(true) {
    $iteration++;
    $start_time = microtime(true);

    try {
        // Connect to local database
        $local_conn = @new mysqli($local_host, $local_user, $local_pass, $local_db);
        if($local_conn->connect_error) {
            logMsg("ERROR: Local DB connection failed: " . $local_conn->connect_error);
            sleep(10);
            continue;
        }

        // Method: Count unique recent accesses to .m3u8 files via segment file modification times
        // HLS clients request segments every ~10 seconds, so we check segment files modified in last 30 seconds

        // Get list of all active streams (running on server 1)
        $streams_result = $local_conn->query("SELECT DISTINCT stream_id FROM streams_sys WHERE server_id = 1");

        if(!$streams_result) {
            $local_conn->close();
            sleep(10);
            continue;
        }

        $active_streams = [];
        while($row = $streams_result->fetch_assoc()) {
            $active_streams[] = intval($row['stream_id']);
        }

        if(empty($active_streams)) {
            $local_conn->close();
            sleep(10);
            continue;
        }

        // Get real online user counts from external panel's lines_log table
        // lines_log tracks active user connections (disconnection_time IS NULL)
        $remote_conn = @new mysqli($remote_host, 'root', $remote_pass, 'midnight_iptv', 7999);

        if($remote_conn->connect_error) {
            $local_conn->close();
            sleep(10);
            continue;
        }

        // Query active connections grouped by stream ID
        $query = "SELECT sid as stream_id, COUNT(*) as user_count
                  FROM lines_log
                  WHERE disconnection_time IS NULL
                  GROUP BY sid";

        $result = $remote_conn->query($query);

        $online_users = [];
        if($result) {
            while($row = $result->fetch_assoc()) {
                $online_users[intval($row['stream_id'])] = intval($row['user_count']);
            }
        }

        $remote_conn->close();

        // Clear all existing user_activity_now entries for server 1
        $local_conn->query("DELETE FROM user_activity_now WHERE server_id = 1");

        // Insert dummy user activity records for streams with online users
        foreach($online_users as $stream_id => $count) {
            // Insert a dummy user record
            $insert_sql = "INSERT INTO user_activity_now
                          (user_id, stream_id, server_id, user_agent, user_ip, container, pid, date_start, date_end, geoip_country_code, isp, external_device)
                          VALUES
                          (0, $stream_id, 1, 'MidnightStreamer', '204.188.233.170', 'hls', 0, " . time() . ", NULL, 'XX', 'MidnightStreamer', 'Unknown')";

            $local_conn->query($insert_sql);
        }

        // Log summary every 6 iterations (every minute)
        if($iteration % 6 == 0) {
            $total_online = count($online_users);
            $streams_with_users = implode(', ', array_keys($online_users));
            logMsg("Iteration $iteration - Online users: $total_online on streams: $streams_with_users");
        }

        $local_conn->close();

    } catch(Exception $e) {
        logMsg("ERROR: " . $e->getMessage());
    }

    // Sleep for 10 seconds
    $elapsed = microtime(true) - $start_time;
    $sleep_time = max(0, 10 - $elapsed);
    usleep($sleep_time * 1000000);
}
?>
