<?php
// Sync stream status from remote panel to local panel
// Run this periodically (e.g., every 5 minutes via cron)

require_once('/var/www/html/iptv/includes/Config.php');

echo "=== Stream Status Sync ===\n";
echo date('Y-m-d H:i:s') . "\n\n";

// Connect to local database
$db = new mysqli(
    $config['db']['hostname'],
    $config['db']['username'],
    $config['db']['password'],
    $config['db']['database']
);

if($db->connect_error) {
    die("ERROR: Could not connect to local database: " . $db->connect_error . "\n");
}

// Remote panel credentials
$remote_host = "204.188.233.170";
$remote_user = "root";
$remote_pass = "R7nMi4KCzZv920pG";
$remote_db = "midnight_iptv";

// Get stream status from remote (disabled status and OnDemand mode)
$cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " .
       escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
       " \"mysql " . $remote_db . " -N -e 'SELECT id, disabled, direct_streaming_on_demand, on_demand_servers, on_demand_probesize FROM streams WHERE type=0;'\"";

$result = shell_exec($cmd . " 2>&1");

// Also get running stream PIDs
echo "Fetching running stream processes...\n";
$pid_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " .
           escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
           " \"ps aux | grep -E 'ffmpeg.*streams/[0-9]+' | grep -v grep\" 2>&1";

$pid_result = shell_exec($pid_cmd);

// Parse running streams
$running_streams = [];
if(!empty($pid_result)) {
    $pid_lines = explode("\n", trim($pid_result));
    foreach($pid_lines as $pid_line) {
        if(preg_match('/streams\/(\d+)_/', $pid_line, $matches)) {
            $stream_id = intval($matches[1]);
            // Extract PID
            if(preg_match('/^[a-z]+\s+(\d+)/', $pid_line, $pid_match)) {
                $running_streams[$stream_id] = intval($pid_match[1]);
            }
        }
    }
    echo "Found " . count($running_streams) . " running streams\n\n";
}

if(empty($result)) {
    die("ERROR: Could not fetch stream status from remote\n");
}

if(strpos($result, 'ERROR') !== false) {
    die("ERROR from remote: $result\n");
}

$lines = explode("\n", trim($result));
$updated = 0;
$errors = 0;

foreach($lines as $line) {
    if(empty($line)) continue;

    $parts = explode("\t", $line);
    if(count($parts) < 5) {
        echo "WARNING: Invalid line: $line\n";
        continue;
    }

    $id = intval($parts[0]);
    $disabled = intval($parts[1]); // 0 = enabled, 1 = disabled on remote
    $on_demand = intval($parts[2]); // 0 = live, 1 = on-demand on remote
    $on_demand_servers = $parts[3];
    $on_demand_probesize = $parts[4];

    // Convert remote status to local status
    // Remote: disabled=0 means enabled (status=1 in local)
    // Remote: disabled=1 means disabled (status=0 in local)
    $local_status = $disabled == 0 ? 1 : 0;

    // Convert OnDemand mode
    // Remote: direct_streaming_on_demand=0 means Live (direct_source=1 in local)
    // Remote: direct_streaming_on_demand=1 means OnDemand (direct_source=0 in local)
    $direct_source = $on_demand == 0 ? 1 : 0;

    // Update local streams table
    $update_streams = "UPDATE streams SET
                       status = $local_status,
                       direct_source = $direct_source
                       WHERE id = $id";

    if($db->query($update_streams)) {
        echo "✓ Updated stream ID $id - Status: $local_status, Direct Source: $direct_source\n";
        $updated++;
    } else {
        echo "✗ Failed to update stream ID $id: " . $db->error . "\n";
        $errors++;
    }

    // Update streams_sys table for OnDemand mode AND running status
    $check_sys = "SELECT stream_id FROM streams_sys WHERE stream_id = $id";
    $result_sys = $db->query($check_sys);

    // Determine if stream is running
    $is_running = isset($running_streams[$id]);
    $pid = $is_running ? $running_streams[$id] : 'NULL';
    $stream_status = $is_running ? 0 : 1; // 0=running, 1=stopped

    if($result_sys && $result_sys->num_rows > 0) {
        $update_sys = "UPDATE streams_sys SET
                       on_demand = $on_demand,
                       pid = $pid,
                       stream_status = $stream_status
                       WHERE stream_id = $id";
        $db->query($update_sys);
    } else {
        $insert_sys = "INSERT INTO streams_sys (stream_id, server_id, on_demand, pid, stream_status)
                       VALUES ($id, 1, $on_demand, $pid, $stream_status)";
        $db->query($insert_sys);
    }

    if($is_running) {
        echo "  🟢 Stream is RUNNING (PID: {$running_streams[$id]})\n";
    }
}

echo "\n=== Summary ===\n";
echo "Updated: $updated\n";
echo "Errors: $errors\n";
echo "Completed at: " . date('Y-m-d H:i:s') . "\n";

?>
