<?php
// Script to sync streams from remote panel to local panel with same IDs

// Remote connection details
$remote_host = "204.188.233.170";
$remote_user = "root";
$remote_pass = "R7nMi4KCzZv920pG";
$remote_db = "midnight_iptv";

// Local database connection
require_once('/var/www/html/iptv/includes/Config.php');
$local_host = $config['db']['hostname'];
$local_user = $config['db']['username'];
$local_pass = $config['db']['password'];
$local_db = $config['db']['database'];

echo "Connecting to local database...\n";
$local_conn = new mysqli($local_host, $local_user, $local_pass, $local_db);
if ($local_conn->connect_error) {
    die("Local connection failed: " . $local_conn->connect_error);
}

echo "Fetching streams from remote server...\n";
$cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " .
       escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
       " \"mysql " . $remote_db . " -N -e 'SELECT id, type, redirect, proxy, radio, solution, name, ch_number, urls, files, audio_file, duration, stream_backup_simultaneus, random_backups, container_format, subtitles, delete_subtitles, hardsub, subtitles_file, subtitles_font_size, year, series_id, season_number, episode_number, logo_image, parental_lock, rtmp_output, genpts, native_frames, delay, use_ramdisk, schedule_channel, channel_start_time, custom_sid, auto_sid, epg_id, epg_channel_id, epg_channel_lang, epg_from_stream, server_id, servers, custom_ffmpeg, custom_map, audio_language, auto_restart, restart_on_audio_loss, min_video_bitrate, network_interfaces, ffmpeg_bin, muxer, segment_time, stream_all_tracks, transcoding_profile, user_agent, http_proxy, http_proxy_server_id, http_cookie, http_headers, e2_service_type, notes, disabled, transcoding_options, tmdb_id, tmdb_lang, tmdb, epg_events, feed_num, feed_start, feed_live, live_feeds, feed_length, on_demand_probesize, on_demand_servers, direct_streaming_on_demand, direct_streaming_mode, proxy_servers, adaptive_streams, tv_archive_duration, tv_archive_server_id, tv_archive_dir, tv_archive_disabled, rtmp_push, udp_buffer_size, udp_pkt_size, udp_bitrate, udp_push, append_flussonic_token, claim_emails, username_claim_email, claim_urls, auto_claim_interval, provider_id, provider_stream_id, modified_by, added_time, edit_time FROM streams WHERE type=0;'\"";

$output = shell_exec($cmd);
$lines = explode("\n", trim($output));

echo "Found " . count($lines) . " streams on remote server\n";

$inserted = 0;
$failed = 0;

foreach($lines as $line) {
    if(empty(trim($line))) continue;

    $fields = explode("\t", $line);
    if(count($fields) < 90) {
        echo "Skipping invalid line with " . count($fields) . " fields\n";
        continue;
    }

    $id = intval($fields[0]);

    // Convert type from remote (0) to local (1) for Live TV
    $type = 1;

    // Prepare insert statement with all fields
    $sql = "INSERT INTO streams (id, type, redirect, proxy, radio, solution, name, ch_number, urls, files, audio_file, duration, stream_backup_simultaneus, random_backups, container_format, subtitles, delete_subtitles, hardsub, subtitles_file, subtitles_font_size, year, series_id, season_number, episode_number, logo_image, parental_lock, rtmp_output, genpts, native_frames, delay, use_ramdisk, schedule_channel, channel_start_time, custom_sid, auto_sid, epg_id, epg_channel_id, epg_channel_lang, epg_from_stream, server_id, servers, custom_ffmpeg, custom_map, audio_language, auto_restart, restart_on_audio_loss, min_video_bitrate, network_interfaces, ffmpeg_bin, muxer, segment_time, stream_all_tracks, transcoding_profile, user_agent, http_proxy, http_proxy_server_id, http_cookie, http_headers, e2_service_type, notes, disabled, transcoding_options, tmdb_id, tmdb_lang, tmdb, epg_events, feed_num, feed_start, feed_live, live_feeds, feed_length, on_demand_probesize, on_demand_servers, direct_streaming_on_demand, direct_streaming_mode, proxy_servers, adaptive_streams, tv_archive_duration, tv_archive_server_id, tv_archive_dir, tv_archive_disabled, rtmp_push, udp_buffer_size, udp_pkt_size, udp_bitrate, udp_push, append_flussonic_token, claim_emails, username_claim_email, claim_urls, auto_claim_interval, provider_id, provider_stream_id, modified_by, added_time, edit_time) VALUES (";

    // Add ID and type
    $sql .= $id . ", " . $type . ", ";

    // Add rest of fields
    for($i = 2; $i < 90; $i++) {
        $value = $fields[$i];

        // Handle NULL values
        if($value === 'NULL' || $value === '') {
            $sql .= "NULL, ";
        } else {
            // Escape and quote strings
            $value = $local_conn->real_escape_string($value);
            $sql .= "'" . $value . "', ";
        }
    }

    // Remove last comma and close
    $sql = rtrim($sql, ', ') . ")";

    if($local_conn->query($sql)) {
        $inserted++;
        echo "Inserted stream ID $id: " . $fields[6] . "\n";
    } else {
        $failed++;
        echo "Failed to insert stream ID $id: " . $local_conn->error . "\n";
    }
}

echo "\n=== Summary ===\n";
echo "Inserted: $inserted\n";
echo "Failed: $failed\n";

// Now sync categories_map
echo "\nSyncing stream categories...\n";
$cat_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " .
           escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
           " \"mysql " . $remote_db . " -N -e 'SELECT stream_id, category_id FROM stream_categories;'\"";

$cat_output = shell_exec($cat_cmd);
if(!empty(trim($cat_output))) {
    $cat_lines = explode("\n", trim($cat_output));

    echo "Found " . count($cat_lines) . " category mappings\n";

    $cat_inserted = 0;
    foreach($cat_lines as $cat_line) {
        if(empty(trim($cat_line))) continue;

        $cat_fields = explode("\t", $cat_line);
        if(count($cat_fields) < 2) continue;

        $stream_id = intval($cat_fields[0]);
        $category_id = intval($cat_fields[1]);

        $cat_sql = "INSERT INTO stream_categories (stream_id, category_id) VALUES ($stream_id, $category_id)";
        if($local_conn->query($cat_sql)) {
            $cat_inserted++;
        }
    }

    echo "Inserted $cat_inserted category mappings\n";
}

$local_conn->close();
echo "\nDone!\n";
?>
