<?php
// Script to sync streams from remote panel (MidnightStreamer format) to local panel (Xtream format)

// Remote connection details
$remote_host = "204.188.233.170";
$remote_user = "root";
$remote_pass = "R7nMi4KCzZv920pG";
$remote_db = "midnight_iptv";

// Local database connection
require_once('/var/www/html/iptv/includes/Config.php');
$local_host = $config['db']['hostname'];
$local_user = $config['db']['username'];
$local_pass = $config['db']['password'];
$local_db = $config['db']['database'];

echo "Connecting to local database...\n";
$local_conn = new mysqli($local_host, $local_user, $local_pass, $local_db);
if ($local_conn->connect_error) {
    die("Local connection failed: " . $local_conn->connect_error);
}

echo "Fetching streams from remote server...\n";
// Get main stream data
$cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " .
       escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
       " \"mysql " . $remote_db . " -N -e 'SELECT id, name, urls, logo_image, notes, disabled, custom_sid, epg_id, epg_channel_id, auto_restart, direct_streaming_on_demand, server_id FROM streams WHERE type=0;'\"";

$output = shell_exec($cmd);
$lines = explode("\n", trim($output));

echo "Found " . count($lines) . " streams on remote server\n\n";

$inserted = 0;
$failed = 0;

foreach($lines as $line) {
    if(empty(trim($line))) continue;

    $fields = explode("\t", $line);
    if(count($fields) < 12) {
        echo "Skipping invalid line with " . count($fields) . " fields\n";
        continue;
    }

    $id = intval($fields[0]);
    $name = $local_conn->real_escape_string($fields[1]);
    $urls = $fields[2] === 'NULL' ? '[]' : $local_conn->real_escape_string($fields[2]);
    $logo = $fields[3] === 'NULL' ? '' : $local_conn->real_escape_string($fields[3]);
    $notes = $fields[4] === 'NULL' ? '' : $local_conn->real_escape_string($fields[4]);
    $disabled = intval($fields[5]);
    $custom_sid = $fields[6] === 'NULL' ? '' : $local_conn->real_escape_string($fields[6]);
    $epg_id = $fields[7] === 'NULL' ? 'NULL' : intval($fields[7]);
    $epg_channel_id = $fields[8] === 'NULL' ? '' : $local_conn->real_escape_string($fields[8]);
    $auto_restart = $fields[9] === 'NULL' ? '' : $local_conn->real_escape_string($fields[9]);
    $direct_source = intval($fields[10]);
    $server_id = $fields[11] === 'NULL' ? 0 : intval($fields[11]);

    // Map to local structure (type=1 for Live TV)
    $sql = "INSERT INTO streams (
        id, type, category_id, stream_display_name, stream_source,
        stream_icon, notes, created_channel_location, enable_transcode,
        transcode_attributes, custom_ffmpeg, movie_propeties, movie_subtitles,
        read_native, target_container, stream_all, remove_subtitles,
        custom_sid, epg_id, channel_id, `order`,
        auto_restart, transcode_profile_id, pids_create_channel,
        cchannel_rsources, gen_timestamps, added, series_no,
        direct_source, tv_archive_duration, tv_archive_server_id,
        tv_archive_pid, movie_symlink, redirect_stream, rtmp_output,
        number, allow_record, probesize_ondemand, custom_map,
        external_push, delay_minutes, status
    ) VALUES (
        $id, 1, NULL, '$name', '$urls',
        '$logo', '$notes', $server_id, 0,
        '', '', NULL, '',
        1, NULL, 0, 0,
        " . ($custom_sid ? "'$custom_sid'" : "NULL") . ", " . ($epg_id === 'NULL' ? 'NULL' : $epg_id) . ", " . ($epg_channel_id ? "'$epg_channel_id'" : "NULL") . ", 0,
        '$auto_restart', 0, '',
        '', 1, " . time() . ", 0,
        $direct_source, 0, 0,
        0, 0, 0, 0,
        0, 0, 128000, '',
        '', 0, " . ($disabled ? "0" : "1") . "
    )";

    if($local_conn->query($sql)) {
        $inserted++;
        echo "✓ Inserted stream ID $id: $name\n";
    } else {
        $failed++;
        echo "✗ Failed to insert stream ID $id: " . $local_conn->error . "\n";
    }
}

echo "\n=== Summary ===\n";
echo "Inserted: $inserted\n";
echo "Failed: $failed\n";

// Now sync stream categories
echo "\nSyncing stream categories...\n";
$cat_cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " .
           escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
           " \"mysql " . $remote_db . " -N -e 'SELECT sid, cid FROM categories_sids;'\"";

$cat_output = shell_exec($cat_cmd);
if(!empty(trim($cat_output))) {
    $cat_lines = explode("\n", trim($cat_output));

    echo "Found " . count($cat_lines) . " category mappings\n";

    $cat_updated = 0;
    foreach($cat_lines as $cat_line) {
        if(empty(trim($cat_line))) continue;

        $cat_fields = explode("\t", $cat_line);
        if(count($cat_fields) < 2) continue;

        $stream_id = intval($cat_fields[0]);
        $category_id = intval($cat_fields[1]);

        // Update the stream with category_id
        $update_sql = "UPDATE streams SET category_id = $category_id WHERE id = $stream_id";
        if($local_conn->query($update_sql)) {
            $cat_updated++;
            echo "✓ Set category $category_id for stream $stream_id\n";
        }
    }

    echo "Updated $cat_updated stream categories\n";
}

$local_conn->close();
echo "\nDone!\n";
?>
