<?php
/**
 * Direct test of syncBouquetStreamsToRemote function
 */

define('_CHECK_X_ME', true);
require(dirname(__FILE__) . '/load2.php');

// Bypass authentication for testing
$_SESSION['admin'] = ['adminid' => 1, 'level' => 1];
$sess_admin = ['adminid' => 1, 'level' => 1];

require_once('apps/bouquets.php');

echo "<h2>Direct Bouquet Sync Test</h2>";
echo "<p>Testing syncBouquetStreamsToRemote function directly...</p>";

$bouquet_id = 14;
$bouquet_name = 'ok';

// Get current streams from local DB
$sql = $intro->db->query("SELECT bouquet_channels FROM bouquets WHERE id=$bouquet_id");
$data = $intro->db->fetch_assoc($sql);
$channels = json_decode($data['bouquet_channels'], true);

echo "<h3>Test Parameters:</h3>";
echo "<ul>";
echo "<li>Bouquet ID: $bouquet_id</li>";
echo "<li>Bouquet Name: $bouquet_name</li>";
echo "<li>Local Channels: " . implode(', ', $channels) . "</li>";
echo "<li>Total Local Channels: " . count($channels) . "</li>";
echo "</ul>";

// Check BEFORE
echo "<h3>Remote DB BEFORE:</h3>";
$before_cmd = "sshpass -p '1980123nasa' ssh -o StrictHostKeyChecking=no root@45.154.207.117 \"mysql midnight_iptv -N -e \\\"SELECT COUNT(*) FROM bouquets_sids WHERE bid=$bouquet_id;\\\"\"";
$before_count = intval(trim(shell_exec($before_cmd)));
echo "<p>Streams in remote bouquet: $before_count</p>";

// Get remote streams list
$streams_cmd = "sshpass -p '1980123nasa' ssh -o StrictHostKeyChecking=no root@45.154.207.117 \"mysql midnight_iptv -N -e \\\"SELECT sid FROM bouquets_sids WHERE bid=$bouquet_id ORDER BY ordering;\\\"\"";
$remote_streams = shell_exec($streams_cmd);
$remote_list = array_filter(explode("\n", trim($remote_streams)));
echo "<p>Remote streams: " . implode(', ', $remote_list) . "</p>";

// Create bouquet instance
$bouquet = new Bouquets_AppAdmin('bouquets', '/iptv/index.php/bouquets');

// Call the function using reflection
echo "<h3>Calling syncBouquetStreamsToRemote...</h3>";
$reflection = new ReflectionClass($bouquet);
$method = $reflection->getMethod('syncBouquetStreamsToRemote');
$method->setAccessible(true);

// Modify channels - remove stream 27
$modified_channels = array_filter($channels, function($ch) { return $ch != 27; });
$modified_channels = array_values($modified_channels); // Re-index

echo "<p><strong>Modified channels (removed 27):</strong> " . implode(', ', $modified_channels) . "</p>";
echo "<p><strong>Total modified channels:</strong> " . count($modified_channels) . "</p>";

$result = $method->invoke($bouquet, $bouquet_name, $modified_channels);

echo "<p style='color:green; font-weight:bold;'>Result: " . ($result ? 'Success' : 'Failed') . "</p>";

// Wait
echo "<p>Waiting 2 seconds...</p>";
flush();
sleep(2);

// Check AFTER
echo "<h3>Remote DB AFTER:</h3>";
$after_count = intval(trim(shell_exec($before_cmd)));
echo "<p>Streams in remote bouquet: $after_count</p>";

$remote_streams_after = shell_exec($streams_cmd);
$remote_list_after = array_filter(explode("\n", trim($remote_streams_after)));
echo "<p>Remote streams: " . implode(', ', $remote_list_after) . "</p>";

// Check if stream 27 exists
$check_27 = "sshpass -p '1980123nasa' ssh -o StrictHostKeyChecking=no root@45.154.207.117 \"mysql midnight_iptv -N -e \\\"SELECT COUNT(*) FROM bouquets_sids WHERE bid=$bouquet_id AND sid=27;\\\"\"";
$has_27 = intval(trim(shell_exec($check_27)));

echo "<h3>Verification:</h3>";
echo "<ul>";
echo "<li>Before count: $before_count</li>";
echo "<li>After count: $after_count</li>";
echo "<li>Expected count: " . count($modified_channels) . "</li>";

if($after_count == count($modified_channels) && $has_27 == 0) {
    echo "<li style='color:green; font-weight:bold;'>✅ SUCCESS! Sync worked perfectly!</li>";
    echo "<li>Stream 27 removed: ✅</li>";
    echo "<li>Count matches: ✅</li>";
} else {
    echo "<li style='color:red; font-weight:bold;'>❌ FAILED!</li>";
    echo "<li>Stream 27 removed: " . ($has_27 == 0 ? '✅' : '❌') . "</li>";
    echo "<li>Count matches: " . ($after_count == count($modified_channels) ? '✅' : '❌') . "</li>";
}
echo "</ul>";

echo "<hr>";
echo "<h3>Check Error Log:</h3>";
echo "<pre>";
$logs = shell_exec("tail -20 /var/log/apache2/error.log | grep -i 'syncBouquet'");
echo htmlspecialchars($logs ? $logs : 'No logs found');
echo "</pre>";

echo "<hr>";
echo "<p><a href='test_bouquet_direct_sync.php'>🔄 Run Test Again</a> | ";
echo "<a href='test_bouquet_sync.php'>📊 Full Sync Test</a></p>";
