<?php
/**
 * Test file to verify bulk actions fix is working
 */
define('_CHECK_X_ME', true);
require_once(dirname(__FILE__) . '/load2.php');
require_once(dirname(__FILE__) . '/includes/AdminStreams.php');

echo "<!DOCTYPE html><html><head><title>Bulk Actions Test</title></head><body>";
echo "<h1>Bulk Actions Fix Test</h1>";

echo "<h2>File Check:</h2>";
echo "<ul>";

// Check if files exist
$files = [
    '/var/www/html/iptv/apps/streams_bulk_actions.php',
    '/var/www/html/iptv/style/js/streams-bulk-fix.js',
    '/var/www/html/iptv/includes/streams_bulk_fix_loader.php'
];

foreach($files as $file) {
    if(file_exists($file)) {
        echo "<li style='color:green'>✓ $file EXISTS</li>";
    } else {
        echo "<li style='color:red'>✗ $file NOT FOUND</li>";
    }
}

echo "</ul>";

echo "<h2>AdminStreams Class Check:</h2>";
echo "<ul>";

// Check if class exists
if(class_exists('AdminStreams')) {
    echo "<li style='color:green'>✓ AdminStreams class exists</li>";

    // Check if methods exist
    $methods = ['BulkDelete', 'BulkRestart', 'BulkStop', 'BulkDisable'];
    foreach($methods as $method) {
        if(method_exists('AdminStreams', $method)) {
            echo "<li style='color:green'>✓ Method $method exists</li>";
        } else {
            echo "<li style='color:red'>✗ Method $method NOT FOUND</li>";
        }
    }
} else {
    echo "<li style='color:red'>✗ AdminStreams class NOT FOUND</li>";
}

echo "</ul>";

echo "<h2>Bulk Actions Handler Test:</h2>";
echo "<ul>";

// Test the handler
$test_url = 'http://15.204.231.210/iptv/apps/streams_bulk_actions.php?action=invalid';
$ch = curl_init($test_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 5);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if($http_code == 200) {
    echo "<li style='color:green'>✓ Handler URL accessible (HTTP $http_code)</li>";
    if(strpos($response, 'Invalid action') !== false) {
        echo "<li style='color:green'>✓ Handler responding correctly</li>";
    } else {
        echo "<li style='color:orange'>⚠ Handler response unexpected: $response</li>";
    }
} else {
    echo "<li style='color:red'>✗ Handler URL not accessible (HTTP $http_code)</li>";
}

echo "</ul>";

echo "<h2>JavaScript File Check:</h2>";
echo "<ul>";

$js_content = file_get_contents('/var/www/html/iptv/style/js/streams-bulk-fix.js');
if(strpos($js_content, 'bulkDelete') !== false) {
    echo "<li style='color:green'>✓ JavaScript file contains bulkDelete handler</li>";
}
if(strpos($js_content, 'bulkRestart') !== false) {
    echo "<li style='color:green'>✓ JavaScript file contains bulkRestart handler</li>";
}
if(strpos($js_content, 'bulkStop') !== false) {
    echo "<li style='color:green'>✓ JavaScript file contains bulkStop handler</li>";
}
if(strpos($js_content, 'bulkDisable') !== false) {
    echo "<li style='color:green'>✓ JavaScript file contains bulkDisable handler</li>";
}

echo "</ul>";

echo "<h2>AdminStreams.php Modification Check:</h2>";
echo "<ul>";

$admin_streams_content = file_get_contents('/var/www/html/iptv/includes/AdminStreams.php');
if(strpos($admin_streams_content, 'streams-bulk-fix.js') !== false) {
    echo "<li style='color:green'>✓ AdminStreams.php includes fix script</li>";
} else {
    echo "<li style='color:red'>✗ AdminStreams.php does NOT include fix script</li>";
}

echo "</ul>";

echo "<hr>";
echo "<h2 style='color:green'>✓ All tests completed!</h2>";
echo "<p><a href='/iptv/index.php/streams/index'>→ Go to Streams Page</a></p>";

echo "</body></html>";
