<?php
// Test OnDemand sync to remote server
define('_CHECK_X_ME', true);
require_once(__DIR__ . '/load2.php');
require_once(__DIR__ . '/includes/AdminStreams.php');

// Create AdminStreams instance
$adminStreams = new AdminStreams();
$adminStreams->type = 1; // Live TV

echo "=== Testing OnDemand Sync ===\n\n";

// Test 1: Sync stream 5 with servers [1,2] and probesize 512000
echo "Test 1: Syncing 'AlKuwait Sport' with OnDemand=1, servers=[1,2], probesize=512000\n";
$result = $adminStreams->setStreamModeOnRemote('AlKuwait Sport', 1, [1, 2], 512000);
echo "Result: $result\n\n";

// Test 2: Check the remote database
echo "Test 2: Checking remote database for 'AlKuwait Sport'\n";
$sql = "SELECT id, name, direct_streaming_on_demand, on_demand_servers, on_demand_probesize FROM streams WHERE name = 'AlKuwait Sport';";
$result2 = $adminStreams->remoteDbExecute($sql);
echo "Remote DB Result:\n$result2\n\n";

// Test 3: Sync stream 7 which currently has NULL on_demand_servers
echo "Test 3: Syncing 'AL-Qurain' with OnDemand=1, servers=[1,2], probesize=512000\n";
$result3 = $adminStreams->setStreamModeOnRemote('AL-Qurain', 1, [1, 2], 512000);
echo "Result: $result3\n\n";

// Test 4: Check stream 7 in remote database
echo "Test 4: Checking remote database for 'AL-Qurain'\n";
$sql4 = "SELECT id, name, direct_streaming_on_demand, on_demand_servers, on_demand_probesize FROM streams WHERE name = 'AL-Qurain';";
$result4 = $adminStreams->remoteDbExecute($sql4);
echo "Remote DB Result:\n$result4\n\n";

echo "=== Test Complete ===\n";
echo "\nCheck error log for SQL queries:\n";
echo "tail -20 /var/log/apache2/error.log | grep 'setStreamModeOnRemote SQL'\n";
?>
