<?php
// View stream synchronization status between local and remote panels

require_once('/var/www/html/iptv/includes/Config.php');

// Connect to local database
$db = new mysqli(
    $config['db']['hostname'],
    $config['db']['username'],
    $config['db']['password'],
    $config['db']['database']
);

if($db->connect_error) {
    die("ERROR: Could not connect to local database: " . $db->connect_error);
}

// Remote panel credentials
$remote_host = "204.188.233.170";
$remote_user = "root";
$remote_pass = "R7nMi4KCzZv920pG";
$remote_db = "midnight_iptv";

// Get stream status from remote
$cmd = "sshpass -p " . escapeshellarg($remote_pass) . " ssh -o StrictHostKeyChecking=no " .
       escapeshellarg($remote_user) . "@" . escapeshellarg($remote_host) .
       " \"mysql " . $remote_db . " -N -e 'SELECT id, name, disabled, direct_streaming_on_demand FROM streams WHERE type=0 ORDER BY id;'\"";

$remote_result = shell_exec($cmd . " 2>&1");

// Get local stream status
$local_sql = "SELECT id, stream_display_name, status, direct_source FROM streams WHERE type=1 ORDER BY id";
$local_result = $db->query($local_sql);

$local_streams = array();
while($row = $local_result->fetch_assoc()) {
    $local_streams[$row['id']] = $row;
}

?>
<!DOCTYPE html>
<html>
<head>
    <title>Stream Sync Status</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
        h1 { color: #333; }
        .sync-info { background: #fff; padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; background: #fff; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background: #4CAF50; color: white; font-weight: bold; }
        tr:hover { background: #f1f1f1; }
        .status-ok { color: green; font-weight: bold; }
        .status-error { color: red; font-weight: bold; }
        .badge { padding: 4px 8px; border-radius: 3px; font-size: 12px; font-weight: bold; }
        .badge-live { background: #28a745; color: white; }
        .badge-ondemand { background: #17a2b8; color: white; }
        .badge-enabled { background: #28a745; color: white; }
        .badge-disabled { background: #dc3545; color: white; }
        .sync-button { padding: 10px 20px; background: #4CAF50; color: white; border: none;
                      border-radius: 5px; cursor: pointer; font-size: 16px; }
        .sync-button:hover { background: #45a049; }
    </style>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <h1>Stream Synchronization Status</h1>

    <div class="sync-info">
        <strong>Remote Panel:</strong> <?php echo $remote_host; ?>:8000<br>
        <strong>Local Panel:</strong> 15.204.231.210<br>
        <strong>Last Update:</strong> <span id="last_update"><?php echo date('Y-m-d H:i:s'); ?></span><br>
        <br>
        <button class="sync-button" onclick="runSync()">🔄 Sync Now</button>
        <span id="sync_result" style="margin-left: 15px;"></span>
    </div>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Stream Name</th>
                <th>Remote Status</th>
                <th>Remote Mode</th>
                <th>Local Status</th>
                <th>Local Mode</th>
                <th>Sync Status</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $remote_lines = explode("\n", trim($remote_result));

            foreach($remote_lines as $line) {
                if(empty($line)) continue;

                $parts = explode("\t", $line);
                if(count($parts) < 4) continue;

                $id = intval($parts[0]);
                $name = $parts[1];
                $remote_disabled = intval($parts[2]);
                $remote_ondemand = intval($parts[3]);

                $remote_status_text = $remote_disabled == 0 ? 'Enabled' : 'Disabled';
                $remote_mode_text = $remote_ondemand == 0 ? 'Live' : 'OnDemand';

                // Check local status
                if(isset($local_streams[$id])) {
                    $local = $local_streams[$id];
                    $local_status_text = $local['status'] == 1 ? 'Enabled' : 'Disabled';
                    $local_mode_text = $local['direct_source'] == 1 ? 'Live' : 'OnDemand';

                    // Check if in sync
                    $status_match = ($remote_disabled == 0 && $local['status'] == 1) ||
                                   ($remote_disabled == 1 && $local['status'] == 0);
                    $mode_match = ($remote_ondemand == 0 && $local['direct_source'] == 1) ||
                                 ($remote_ondemand == 1 && $local['direct_source'] == 0);

                    $in_sync = $status_match && $mode_match;
                    $sync_status = $in_sync ? '<span class="status-ok">✓ Synced</span>' :
                                             '<span class="status-error">✗ Out of Sync</span>';
                } else {
                    $local_status_text = '<span class="status-error">Missing</span>';
                    $local_mode_text = '<span class="status-error">Missing</span>';
                    $sync_status = '<span class="status-error">✗ Not Found</span>';
                }

                $remote_status_badge = $remote_disabled == 0 ? 'badge-enabled' : 'badge-disabled';
                $remote_mode_badge = $remote_ondemand == 0 ? 'badge-live' : 'badge-ondemand';
                $local_status_badge = isset($local_streams[$id]) && $local_streams[$id]['status'] == 1 ?
                                     'badge-enabled' : 'badge-disabled';
                $local_mode_badge = isset($local_streams[$id]) && $local_streams[$id]['direct_source'] == 1 ?
                                   'badge-live' : 'badge-ondemand';

                echo "<tr>";
                echo "<td>$id</td>";
                echo "<td>$name</td>";
                echo "<td><span class='badge $remote_status_badge'>$remote_status_text</span></td>";
                echo "<td><span class='badge $remote_mode_badge'>$remote_mode_text</span></td>";

                if(isset($local_streams[$id])) {
                    echo "<td><span class='badge $local_status_badge'>$local_status_text</span></td>";
                    echo "<td><span class='badge $local_mode_badge'>$local_mode_text</span></td>";
                } else {
                    echo "<td>$local_status_text</td>";
                    echo "<td>$local_mode_text</td>";
                }

                echo "<td>$sync_status</td>";
                echo "</tr>";
            }
            ?>
        </tbody>
    </table>

    <script>
    function runSync() {
        $('#sync_result').html('<i>⏳ Syncing...</i>');

        $.get('/iptv/sync_stream_status.php', function(data){
            console.log('Sync result:', data);
            $('#sync_result').html('<span style="color:green;">✓ Sync completed!</span>');
            $('#last_update').text('<?php echo date('Y-m-d H:i:s'); ?>');

            // Reload page after 2 seconds
            setTimeout(function(){
                location.reload();
            }, 2000);
        }).fail(function(xhr, status, error){
            $('#sync_result').html('<span style="color:red;">✗ Sync failed: ' + error + '</span>');
        });
    }

    // Auto-refresh every 3 seconds
    setTimeout(function(){
        location.reload();
    }, 3000);
    </script>
</body>
</html>
