# Direct Stream - دليل المشاهدة المباشرة

## 🎯 ما هو Direct Stream؟

**Direct Stream** هو واجهة جديدة تتيح لك:
- ✅ مشاهدة وتحميل الحلقات مباشرة بدون تعقيد
- ✅ الوصول للحلقات من قاعدة البيانات أو من السيرفر مباشرة
- ✅ واجهة بسيطة وسريعة وسهلة الاستخدام
- ✅ نسخ روابط التحميل بنقرة واحدة
- ✅ بحث سريع في المسلسلات

---

## 🚀 الوصول للواجهة

### الواجهة الرئيسية (Direct Stream):
```
http://15.204.231.210/VOD/direct_stream.html
```

### واجهة الاختبار (Test Episodes):
```
http://15.204.231.210/VOD/test_episodes.html
```

---

## 📱 كيفية الاستخدام

### 1. البحث عن مسلسل
- افتح الواجهة: `http://15.204.231.210/VOD/direct_stream.html`
- اكتب اسم المسلسل في خانة البحث
- أو اضغط على أحد الأزرار السريعة (مثل: اسمي فرح، One Piece، إلخ)

### 2. عرض الحلقات
- اضغط على المسلسل الذي تريده
- سيتم تحميل جميع الحلقات تلقائياً
- يمكنك تصفية الحلقات حسب الموسم

### 3. المشاهدة أو التحميل
- اضغط على "▶ مشاهدة / تحميل" لفتح الحلقة
- أو اضغط "📋 نسخ الرابط" لنسخ رابط التحميل المباشر

---

## 🔥 مميزات Direct Stream

### 1. سرعة الوصول
- لا حاجة لاستيراد الحلقات مسبقاً
- الحلقات تُحمّل مباشرة عند الطلب
- يستخدم البيانات من قاعدة البيانات إذا كانت موجودة

### 2. واجهة مبسطة
- تصميم عصري وأنيق
- سهلة الاستخدام
- تعمل على الموبايل والكمبيوتر

### 3. روابط مباشرة
- جميع الحلقات بصيغة MP4
- روابط تحميل مباشرة
- يمكن نسخ الروابط بسهولة

---

## 📊 المسلسلات المتاحة

### مسلسلات بأكثر عدد حلقات:

| المسلسل | عدد الحلقات | Series ID |
|---------|-------------|-----------|
| One Piece - ون بيس | 1,165 | 6278 |
| Law and Order SVU | 577 | 5190 |
| Family Guy | 438 | 6323 |
| زهور الدم مترجم | 433 | 5223 |
| على مر الزمان مدبلج | 311 | 5604 |
| ثلاث اخوات مدبلج | 249 | 5398 |
| Naruto | 220 | 6240 |
| The Blacklist | 218 | 5264 |
| عودة مهند مدبلج | 213 | 5251 |
| اسمي فرح مدبلج | 135 | 5281 |

---

## 🔌 API Usage

### الحصول على حلقات مسلسل:
```bash
curl "http://15.204.231.210/VOD/stream_direct.php?action=get_episodes&series_id=5281"
```

### Response:
```json
{
  "success": true,
  "series": {
    "id": 5281,
    "title": "اسمي فرح مدبلج",
    "plot": "...",
    "year": null,
    "rating": "9.0",
    "poster": "...",
    "seasons_count": 2,
    "episodes_count": 135
  },
  "episodes": [
    {
      "id": 24754,
      "season_number": 1,
      "episode_number": 1,
      "title": "Esmi Farah.S01.E01",
      "stream_url": "http://hplayer.info:8080/series/3733676136/1519059670/359352.mp4",
      "container_extension": "mp4",
      "duration": null,
      "air_date": null,
      "rating": null
    }
  ],
  "source": "database"
}
```

### قائمة المسلسلات:
```bash
curl "http://15.204.231.210/VOD/stream_direct.php?action=list_series&limit=50&search=فرح"
```

---

## 💡 نصائح

### 1. للتحميل السريع:
- انسخ رابط الحلقة واستخدم برنامج تحميل مثل IDM أو wget
```bash
wget "http://hplayer.info:8080/series/3733676136/1519059670/359352.mp4"
```

### 2. للمشاهدة عبر VLC:
- انسخ رابط الحلقة
- افتح VLC
- اذهب إلى Media → Open Network Stream
- الصق الرابط

### 3. لتحميل موسم كامل:
```bash
# استخدم API للحصول على روابط جميع الحلقات
curl -s "http://15.204.231.210/VOD/stream_direct.php?action=get_episodes&series_id=5281" | \
  jq -r '.episodes[] | select(.season_number == 1) | .stream_url' | \
  xargs -n 1 wget
```

---

## 🆚 الفرق بين Direct Stream والواجهة الرئيسية

| الميزة | Direct Stream | الواجهة الرئيسية |
|--------|--------------|------------------|
| السرعة | ⚡ سريع جداً | عادية |
| سهولة الاستخدام | ⭐⭐⭐⭐⭐ | ⭐⭐⭐ |
| مميزات إضافية | محدودة | كاملة |
| إدارة التحميلات | ❌ لا | ✅ نعم |
| Remote Servers | ❌ لا | ✅ نعم |
| **الاستخدام المثالي** | **المشاهدة والتحميل السريع** | **الإدارة الشاملة** |

---

## 📈 الإحصائيات الحالية

```
✅ إجمالي المسلسلات:      6,909
✅ مسلسلات مع حلقات:       1,328+
✅ إجمالي الحلقات:         35,430+
✅ متاح عبر Direct Stream: جميعها!
```

---

## ❓ الأسئلة الشائعة

### Q: هل جميع المسلسلات متاحة؟
**A:** نعم! جميع المسلسلات التي لديها حلقات في قاعدة البيانات (1,328+ مسلسل) متاحة فوراً.

### Q: ما هو مصدر الحلقات؟
**A:**
1. أولاً: من قاعدة البيانات (إذا كانت موجودة)
2. ثانياً: مباشرة من السيرفر المصدر (Xtream API)

### Q: هل يمكنني تحميل الحلقات؟
**A:** نعم! كل حلقة لها رابط تحميل مباشر بصيغة MP4.

### Q: ما الفرق بين "database" و "direct_stream" في source؟
**A:**
- `database`: الحلقات محفوظة في قاعدة البيانات (أسرع)
- `direct_stream`: الحلقات من السيرفر مباشرة (للمسلسلات الجديدة)

### Q: لماذا بعض المسلسلات لا تعرض حلقات؟
**A:** المسلسلات الأحدث (ID > 5700) غير متوفرة على السيرفر المصدر. اختر من 1,328+ مسلسل آخر متاح!

---

## 🔗 روابط مفيدة

### الواجهات:
- **Direct Stream**: `http://15.204.231.210/VOD/direct_stream.html`
- **Test Episodes**: `http://15.204.231.210/VOD/test_episodes.html`
- **الواجهة الرئيسية**: `http://15.204.231.210/VOD/`

### APIs:
- **Episodes API**: `http://15.204.231.210/VOD/stream_direct.php?action=get_episodes&series_id={id}`
- **Series List API**: `http://15.204.231.210/VOD/stream_direct.php?action=list_series`
- **Main API**: `http://15.204.231.210/VOD/api/`

### التوثيق:
- **QUICK_START.md** - دليل البدء السريع
- **SYSTEM_STATUS.md** - حالة النظام
- **HOW_TO_ACCESS_EPISODES.md** - دليل الوصول للحلقات (مفصل)
- **DIRECT_STREAM_GUIDE.md** - هذا الملف

---

## ✨ الخلاصة

**Direct Stream** هو أسرع وأسهل طريقة للوصول للحلقات ومشاهدتها أو تحميلها!

```
🎬 افتح: http://15.204.231.210/VOD/direct_stream.html
🔍 ابحث عن مسلسلك المفضل
▶️ شاهد أو حمّل على طول!
```

**استمتع بالمشاهدة! 🍿**
