<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

echo "Loading classes...\n";

try {
    echo "1. Config...";
    require_once __DIR__ . '/../config/config.php';
    echo "OK\n";

    echo "2. ServerManager...";
    require_once __DIR__ . '/../classes/ServerManager.php';
    echo "OK\n";

    echo "3. MovieImporter...";
    require_once __DIR__ . '/../classes/MovieImporter.php';
    echo "OK\n";

    echo "4. FolderWatch...";
    require_once __DIR__ . '/../classes/FolderWatch.php';
    echo "OK\n";

    echo "5. Logger...";
    require_once __DIR__ . '/../classes/Logger.php';
    echo "OK\n";

    echo "6. Auth...";
    require_once __DIR__ . '/../classes/Auth.php';
    echo "OK\n";

    echo "7. RemoteDownloader...";
    require_once __DIR__ . '/../classes/RemoteDownloader.php';
    echo "OK\n";

    echo "\nAll classes loaded successfully!\n";
} catch (Exception $e) {
    echo "FAILED: " . $e->getMessage() . "\n";
} catch (Error $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?>
