#!/bin/bash
#############################################
# VOD Import System - Deployment Script
# Copy files to remote server
# Usage: bash deploy.sh user@host
#############################################

RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m'

if [ -z "$1" ]; then
    echo -e "${RED}Usage: bash deploy.sh user@host [port]${NC}"
    echo "Example: bash deploy.sh root@192.168.1.100"
    echo "Example: bash deploy.sh root@192.168.1.100 22"
    exit 1
fi

REMOTE_HOST=$1
SSH_PORT=${2:-22}
LOCAL_DIR="/var/www/html/VOD"
REMOTE_DIR="/var/www/html/VOD"

echo -e "${YELLOW}Deploying VOD System to ${REMOTE_HOST}...${NC}"

# Create archive excluding unnecessary files
echo -e "${GREEN}[1/4] Creating archive...${NC}"
cd /var/www/html
tar -czf /tmp/vod_system.tar.gz \
    --exclude='VOD/cache/*' \
    --exclude='VOD/logs/*' \
    --exclude='VOD/media/*' \
    --exclude='VOD/*.tar.gz' \
    VOD/

# Copy archive to remote server
echo -e "${GREEN}[2/4] Copying to remote server...${NC}"
scp -P ${SSH_PORT} /tmp/vod_system.tar.gz ${REMOTE_HOST}:/tmp/

# Copy install script
echo -e "${GREEN}[3/4] Copying install script...${NC}"
scp -P ${SSH_PORT} ${LOCAL_DIR}/install.sh ${REMOTE_HOST}:/tmp/

# Extract on remote server
echo -e "${GREEN}[4/4] Extracting on remote server...${NC}"
ssh -p ${SSH_PORT} ${REMOTE_HOST} << 'REMOTE_CMD'
cd /var/www/html
tar -xzf /tmp/vod_system.tar.gz
chown -R www-data:www-data /var/www/html/VOD
chmod -R 755 /var/www/html/VOD
chmod -R 777 /var/www/html/VOD/{cache,logs,media,watch}
rm /tmp/vod_system.tar.gz
echo "Files extracted successfully!"
REMOTE_CMD

# Cleanup local temp file
rm /tmp/vod_system.tar.gz

echo ""
echo -e "${GREEN}=============================================="
echo "   Deployment Complete!"
echo "==============================================${NC}"
echo ""
echo -e "${YELLOW}Next steps on remote server:${NC}"
echo "  1. SSH to server: ssh -p ${SSH_PORT} ${REMOTE_HOST}"
echo "  2. Run installer: sudo bash /tmp/install.sh"
echo ""
