<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/ServerManager.php';
require_once __DIR__ . '/classes/Logger.php';

$seriesId = isset($argv[1]) ? (int)$argv[1] : 0;

if ($seriesId === 0) {
    die("Usage: php import_single_series.php <series_id>\n");
}

$db = getDB();

// Get series info
$stmt = $db->prepare("SELECT id, tmdb_id, title FROM series WHERE id = ?");
$stmt->execute([$seriesId]);
$series = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$series) {
    die("Series not found with ID: $seriesId\n");
}

echo "Importing episodes for: {$series['title']} (ID: {$series['id']}, TMDB: {$series['tmdb_id']})\n";

// Get active server
$stmt = $db->query("SELECT id, name, url, username, password FROM servers WHERE is_active = 1 LIMIT 1");
$server = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$server) {
    die("No active server found\n");
}

echo "Using server: {$server['name']}\n";

// Fetch episodes from Xtream API
$apiUrl = $server['url'] . '/player_api.php?username=' . urlencode($server['username']) .
          '&password=' . urlencode($server['password']) .
          '&action=get_series_info&series_id=' . $series['tmdb_id'];

echo "Fetching from: $apiUrl\n";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode !== 200 || !$response) {
    die("Failed to fetch series info. HTTP Code: $httpCode\n");
}

$data = json_decode($response, true);

if (!$data || !isset($data['episodes']) || empty($data['episodes'])) {
    die("No episodes found in API response\n");
}

$totalEpisodes = 0;
$seasons = $data['episodes'];

echo "Found " . count($seasons) . " seasons\n";

foreach ($seasons as $seasonNum => $episodes) {
    echo "  Season $seasonNum: " . count($episodes) . " episodes\n";

    foreach ($episodes as $episode) {
        $episodeNum = isset($episode['episode_num']) ? (int)$episode['episode_num'] : 0;
        $title = isset($episode['title']) ? $episode['title'] : "Episode $episodeNum";
        $streamUrl = isset($episode['id']) ?
            $server['url'] . '/series/' . $server['username'] . '/' . $server['password'] . '/' . $episode['id'] . '.mp4' :
            null;

        $plot = isset($episode['info']['plot']) ? $episode['info']['plot'] : null;
        $duration = isset($episode['info']['duration']) ? $episode['info']['duration'] : null;
        $airDate = isset($episode['info']['releasedate']) ? $episode['info']['releasedate'] : null;

        try {
            $stmt = $db->prepare("
                INSERT INTO episodes (
                    series_id, season_number, episode_number, title,
                    plot, air_date, duration, stream_url, created_at
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())
                ON DUPLICATE KEY UPDATE
                    title = VALUES(title),
                    plot = VALUES(plot),
                    air_date = VALUES(air_date),
                    duration = VALUES(duration),
                    stream_url = VALUES(stream_url)
            ");

            $stmt->execute([
                $series['id'],
                $seasonNum,
                $episodeNum,
                $title,
                $plot,
                $airDate,
                $duration,
                $streamUrl
            ]);

            $totalEpisodes++;
        } catch (Exception $e) {
            echo "    Error inserting episode: " . $e->getMessage() . "\n";
        }
    }
}

// Update series episodes_count and seasons_count
$stmt = $db->prepare("
    UPDATE series
    SET episodes_count = ?,
        seasons_count = ?,
        updated_at = NOW()
    WHERE id = ?
");
$stmt->execute([$totalEpisodes, count($seasons), $series['id']]);

echo "\n✓ Successfully imported $totalEpisodes episodes from " . count($seasons) . " seasons\n";
echo "Done!\n";
