# تعليمات رفع الملفات إلى chatti.tmaxhosting.com

## 🚨 المشكلة
التطبيق عالق في صفحة إدخال الكود لأن `methode=5` يرجع خطأ 500 من الخادم `chatti.tmaxhosting.com`.

السبب: **الملفات على الخادم المباشر قديمة ولم يتم تحديثها!**

---

## 📦 الملفات التي يجب رفعها

يجب رفع هذه الملفات إلى: `chatti.tmaxhosting.com/PanelAndroid/`

### الملفات الأساسية:
1. ✅ `API.php` - الملف الرئيسي (تم تحديثه - 15KB)
2. ✅ `db_helper.php` - مساعد قاعدة البيانات
3. ✅ `xtream_helper.php` - مساعد Xtream API
4. ✅ `db.json` - ملف الإعدادات
5. ✅ `.htaccess` - إعدادات Apache
6. ✅ `1` - endpoint تسجيل الدخول 1 (بدون امتداد)
7. ✅ `2` - endpoint تسجيل الدخول 2 (بدون امتداد)

### الملفات الاختيارية (للإدارة):
- `config.php` - واجهة إدارة الإعدادات
- `test_auth.php` - صفحة اختبار
- `clear_log.php` - مسح السجل

---

## 🔄 خطوات الرفع

### الطريقة 1: عبر FTP/SFTP
```
1. استخدم FileZilla أو WinSCP
2. اتصل بـ: chatti.tmaxhosting.com
3. انتقل إلى مجلد: /PanelAndroid/
4. ارفع جميع الملفات المذكورة أعلاه
5. تأكد من الأذونات: 644 للملفات
```

### الطريقة 2: عبر cPanel
```
1. سجل الدخول إلى cPanel
2. افتح File Manager
3. انتقل إلى: public_html/PanelAndroid/
4. ارفع الملفات
5. تأكد من استبدال الملفات القديمة
```

### الطريقة 3: عبر SSH (إذا كان متاحاً)
```bash
# من الخادم المحلي إلى الخادم المباشر
rsync -avz /var/www/html/PanelAndroid/ user@chatti.tmaxhosting.com:/path/to/PanelAndroid/

# أو استخدم scp
scp /var/www/html/PanelAndroid/API.php user@chatti.tmaxhosting.com:/path/to/PanelAndroid/
scp /var/www/html/PanelAndroid/db_helper.php user@chatti.tmaxhosting.com:/path/to/PanelAndroid/
scp /var/www/html/PanelAndroid/xtream_helper.php user@chatti.tmaxhosting.com:/path/to/PanelAndroid/
scp /var/www/html/PanelAndroid/db.json user@chatti.tmaxhosting.com:/path/to/PanelAndroid/
scp /var/www/html/PanelAndroid/.htaccess user@chatti.tmaxhosting.com:/path/to/PanelAndroid/
scp /var/www/html/PanelAndroid/1 user@chatti.tmaxhosting.com:/path/to/PanelAndroid/
scp /var/www/html/PanelAndroid/2 user@chatti.tmaxhosting.com:/path/to/PanelAndroid/
```

---

## ✅ التحقق من الرفع

بعد رفع الملفات، اختبر:

### 1. اختبار Method 5 (Config):
```bash
curl -X POST "http://chatti.tmaxhosting.com/PanelAndroid/API.php?methode=5" \
  -H "Content-Type: application/json" \
  -d '{"str1":"","str2":""}' -s
```

**النتيجة المتوقعة:**
```json
{
  "str0": "API.php?methode=",
  "str1": "http://chatti.tmaxhosting.com",
  "str2": "/PanelAndroid/",
  ...
}
```

### 2. اختبار Login:
```bash
curl -X POST "http://chatti.tmaxhosting.com/PanelAndroid/1" \
  -H "Content-Type: application/json" \
  -d '{"android_id":"test","code":"1231231","macE":"","macW":"0"}' -s
```

**النتيجة المتوقعة:**
```json
{
  "id": "1",
  "username": "1231231",
  "status": "active",
  ...
}
```

### 3. اختبار Method 2 (Categories):
```bash
curl -X POST "http://chatti.tmaxhosting.com/PanelAndroid/API.php?methode=2" \
  -H "Content-Type: application/json" \
  -d '{"android_id":"test","code":"1231231","macE":"","macW":"0"}' -s | head -20
```

**النتيجة المتوقعة:**
```json
{
  "bou": [
    {"name": "114", "path": "usa_news_networks.png"},
    ...
  ]
}
```

---

## 🎯 بعد رفع الملفات

### 1. جرب التطبيق:
- أدخل الكود: `1231231`
- أو: `mohamed!!!secret123`
- اضغط تفعيل

### 2. يجب أن يحدث:
✅ التطبيق يمر من صفحة التفعيل
✅ يعرض الفئات
✅ يعرض القنوات المباشرة
✅ يمكن تشغيل القنوات

### 3. إذا بقيت المشكلة:
- امسح cache التطبيق
- أعد تشغيل التطبيق
- تحقق من السجل: `http://chatti.tmaxhosting.com/PanelAndroid/debug_log.txt`

---

## 📋 قائمة التحقق

- [ ] رفع `API.php` (15KB - محدث في 2025-11-18 10:55)
- [ ] رفع `db_helper.php`
- [ ] رفع `xtream_helper.php`
- [ ] رفع `db.json`
- [ ] رفع `.htaccess`
- [ ] رفع الملف `1` (بدون امتداد)
- [ ] رفع الملف `2` (بدون امتداد)
- [ ] اختبار Method 5
- [ ] اختبار Login endpoint
- [ ] اختبار Method 2
- [ ] اختبار التطبيق

---

## 🆘 إذا واجهت مشاكل

1. **خطأ 500**: تحقق من سجل الأخطاء على الخادم
2. **Authentication failed**: تأكد من أن `xtream_url` صحيح في db.json
3. **Empty response**: تحقق من أن الملفات تم رفعها بشكل صحيح
4. **App stuck**: امسح cache التطبيق وأعد المحاولة

---

## 📞 للدعم

أرسل لي:
1. نتيجة اختبار Method 5
2. محتوى السجل: `http://chatti.tmaxhosting.com/PanelAndroid/debug_log.txt`
3. أي رسائل خطأ تظهر
