<?php
/**
 * Update movie_links with category_id from Xtream API
 */
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/XtreamAPI.php';

echo "Starting category update...\n";

$db = getDB();

// Get server info (realiptv = server 2)
$server = $db->query("SELECT * FROM servers WHERE id = 2")->fetch();
if (!$server) { die('Server not found'); }

$api = new XtreamAPI($server['url'], $server['username'], $server['password'], $server['port'], (bool)$server['use_https']);
if (!$api->authenticate()) { die('Auth failed'); }

// Get all movies from Xtream
echo "Fetching movies from Xtream API...\n";
$movies = $api->getVODStreams();
unset($movies['_meta']);

echo 'Total movies from API: ' . count($movies) . PHP_EOL;

// Update category_id for each movie
$updated = 0;
$stmt = $db->prepare('UPDATE movie_links SET category_id = ? WHERE stream_id = ? AND server_id = ?');
foreach ($movies as $i => $movie) {
    if (!is_array($movie)) continue;
    $catId = $movie['category_id'] ?? null;
    if ($catId && isset($movie['stream_id'])) {
        $stmt->execute([$catId, $movie['stream_id'], 2]);
        if ($stmt->rowCount() > 0) $updated++;
    }
    if ($i % 5000 === 0 && $i > 0) {
        echo "Progress: {$i} processed, {$updated} updated\n";
    }
}
echo "Completed! Updated: {$updated} links\n";
