<?php
/**
 * Add Token Manually to Database
 * Usage: php add_token_manually.php <username> <token>
 */

if ($argc < 3) {
    echo "Usage: php add_token_manually.php <username> <token>\n\n";
    echo "Example:\n";
    echo "php add_token_manually.php 426687097695 \"f3ed71d56579442cbdc114e8f77e57b4...\"\n\n";
    exit(1);
}

$username = $argv[1];
$token = $argv[2];

echo "Adding Token to Database\n";
echo str_repeat("=", 72) . "\n\n";

// Connect to database
require_once('/var/www/html/iptv/includes/Config.php');
$link = mysqli_connect(
    $config['db']['hostname'],
    $config['db']['username'],
    $config['db']['password'],
    $config['db']['database']
);

if (!$link) {
    die("❌ Database connection failed: " . mysqli_connect_error() . "\n");
}

// Find user
$safe_username = mysqli_real_escape_string($link, $username);
$result = mysqli_query($link, "SELECT id, username, FROM_UNIXTIME(exp_date) as expiry FROM users WHERE username = '$safe_username'");

if (!$result || mysqli_num_rows($result) === 0) {
    die("❌ User '$username' not found in database\n");
}

$user = mysqli_fetch_assoc($result);
echo "✅ Found user: " . $user['username'] . " (ID: " . $user['id'] . ")\n";
echo "   Account expires: " . $user['expiry'] . "\n\n";

// Check if token already exists
$safe_token = mysqli_real_escape_string($link, $token);
$check = mysqli_query($link, "SELECT id FROM user_tokens WHERE token = '$safe_token'");

if ($check && mysqli_num_rows($check) > 0) {
    echo "⚠️  This token already exists in database!\n";
    echo "   Skipping insertion.\n";
    mysqli_close($link);
    exit(0);
}

// Insert token
$created = time();
$expires = $created + (86400 * 7); // 7 days

$insert_sql = sprintf(
    "INSERT INTO user_tokens (user_id, token, created, expires, ip, user_agent) VALUES (%d, '%s', %d, %d, '%s', '%s')",
    $user['id'],
    $safe_token,
    $created,
    $expires,
    '127.0.0.1',
    'Manual Entry'
);

if (mysqli_query($link, $insert_sql)) {
    echo "✅ Token added successfully!\n\n";
    echo "Details:\n";
    echo "  User ID: " . $user['id'] . "\n";
    echo "  Username: " . $user['username'] . "\n";
    echo "  Token: " . substr($token, 0, 50) . "...\n";
    echo "  Created: " . date('Y-m-d H:i:s', $created) . "\n";
    echo "  Expires: " . date('Y-m-d H:i:s', $expires) . "\n";
    echo "\n✅ Token is ready to use!\n";
} else {
    echo "❌ Failed to insert token: " . mysqli_error($link) . "\n";
}

mysqli_close($link);

echo "\n" . str_repeat("=", 72) . "\n";
