<?php 
define('_CHECK_X_ME', true);
require('../load2.php');
require('API_USER_CFG.php');
$class = new intro_ps();
$mode = $intro->input->get_post('mode');
if( $mode != '' && method_exists($class, $mode) ) 
{
    $class->$mode();
}
else
{
    echo 'Error: mode not defined.';
}
class intro_ps
{
    private $cfg = null;
    private $length = null;
    private $resel = '';
    private $user = '';
    private $new_user = '';
    private $pass = '';
    private $code = '';
    private $mac = '';
    private $sn = '';
    private $period = 0;
    private $days = 0;
    private $group = 0;
    private $sub_end = 0;
    private $id = 0;
    private $userid = 0;
    private $host = '';
    private $freeDays = [
        101, 
        103, 
        107, 
        110
    ];
    public function __construct()
    {
        global $intro;
        global $abed;
        $this->cfg = $intro->option;
        $this->validate_api();
        $this->set_vars();
        $this->host = trim($intro->option['iptv_host']);
        if( $intro->input->get_post('mode') != 'devices' ) 
        {
            header('Content-Type: application/json; charset=utf-8');
        }
    }
    public function validate_api()
    {
        global $intro;
        $key = trim($intro->input->get_post('key'));
        $sec = trim($intro->input->get_post('sec'));
        $db_key = trim($intro->option['api_key']);
        $db_sec = trim($intro->option['api_secret']);
        if( $key == $db_key && $sec == $db_sec ) 
        {
            return true;
        }
        else
        {
            exit( 'Error: Access Denied. Wrong api secrect and api key.' );
        }
    }
    public function set_vars()
    {
        global $intro;
        $length = intval($intro->option['api_code_length']);
        if( $length == 0 ) 
        {
            $length = 12;
        }
        $this->length = $length;
        $this->resel = trim($intro->input->get_post('resel'));
        $this->user = trim($intro->input->get_post('u'));
        $this->userid = intval($intro->input->get_post('id'));
        $this->id = $this->userid;
        $this->pass = trim($intro->input->get_post('p'));
        $this->code = trim($intro->input->get_post('code'));
        $this->codeid = intval($intro->input->get_post('codeid'));
        $this->days = intval($intro->input->get_post('days'));
        $this->period = intval($intro->input->get_post('period'));
        $this->pkgs = trim($intro->input->get_post('pkgs'));
        $this->sub_end = trim($intro->input->get_post('sub_end'));
        $this->mac = trim($intro->input->get_post('mac'));
        $this->sn = trim($intro->input->get_post('sn'));
        $this->group = intval($intro->input->get_post('group'));
        if( in_array($this->days, $this->freeDays) ) 
        {
            $this->days = $this->days - 100;
            if( $this->days < 0 ) 
            {
                $this->days = 1;
            }
        }
        if( $this->period > 36 ) 
        {
            $this->period = 101;
        }
        if( $this->days > 720 ) 
        {
            $this->days = 1;
        }
    }
    public function bouquets()
    {
        global $intro;
        $ar = [];
        $sql = $intro->db->query('SELECT * FROM bouquets WHERE bouquet_status=1 order by view_order ASC');
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            @extract($row);
            $i++;
            $ar[] = $id;
        }
        return implode(',', $ar);
    }
    public function bouquets_json()
    {
        global $intro;
        $ar = [];
        $sql = $intro->db->query('SELECT id,bouquet_name FROM bouquets  WHERE bouquet_status=1 order by view_order ASC');
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $i++;
            $ar[] = $row;
        }
        $array = [
            'status' => 'success', 
            'msg' => 'success', 
            'rows' => $ar
        ];
        $json = json_encode($array);
        echo $json;
    }
    public function add_user()
    {
        global $intro;
        global $DisableUagent;
        $sql = $intro->db->query('SELECT id,username from users where username = \'' . $this->user . '\';');
        if( $intro->db->returned_rows > 0 ) 
        {
            $array = [
                'status' => 'already_used', 
                'msg' => 'Error: Username (' . $this->user . ') already used!!!'
            ];
            echo json_encode($array);
            exit();
        }
        $data = [];
        $data['member_id'] = 1;
        $data['username'] = $this->user;
        $data['password'] = $this->pass;
        $data['exp_date'] = time() + ($this->days * 60 * 60 * 24);
        if( in_array($this->days, [
            1, 
            3, 
            7, 
            10
        ]) ) 
        {
            $data['is_trial'] = 1;
        }
        $data['admin_notes'] = $this->resel;
        $data['admin_enabled'] = 1;
        $data['enabled'] = 1;
        if( $this->pkgs == '' ) 
        {
            $data['bouquet'] = '[' . $this->bouquets() . ']';
        }
        else
        {
            $ex = explode(',', $this->pkgs);
            $data['bouquet'] = json_encode($ex);
        }
        $data['max_connections'] = 1;
        $data['created_at'] = time();
        $data['created_by'] = 1;
        if( $DisableUagent == 1 ) 
        {
            $data['bypass_ua'] = 1;
        }
        $intro->db->insert('users', $data);
        $id = intval($intro->db->insert_id());
        if( $id != 0 ) 
        {
            $intro->db->insert('user_output', [
                'user_id' => $id, 
                'access_output_id' => 1
            ]);
            $intro->db->insert('user_output', [
                'user_id' => $id, 
                'access_output_id' => 2
            ]);
            $intro->db->insert('user_output', [
                'user_id' => $id, 
                'access_output_id' => 3
            ]);
            $array = [
                'status' => 'success', 
                'msg' => 'success', 
                'id' => $id
            ];
        }
        else
        {
            $array = [
                'status' => 'error', 
                'msg' => 'Error: sorry cannot insert into Table: user_output.', 
                'id' => 0
            ];
        }
        echo json_encode($array);
    }
    public function edit_user()
    {
        global $intro;
        $sql = $intro->db->query('SELECT id,username from users where id = ' . $this->userid . ';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $array = [
                'status' => 'error', 
                'msg' => 'Error: Username (' . $this->user . ' | userid=' . $this->userid . ') not found in IPTV database'
            ];
            echo json_encode($array);
            exit();
        }
        $data = [];
        $data['username'] = $this->user;
        $data['password'] = $this->pass;
        $data['enabled'] = 1;
        if( $this->pkgs == '' ) 
        {
            $data['bouquet'] = '[' . $this->bouquets() . ']';
        }
        else
        {
            $ex = explode(',', $this->pkgs);
            $data['bouquet'] = json_encode($ex);
        }
        $intro->db->update('users', $data, 'id=' . $this->userid);
        $array = [
            'status' => 'success', 
            'msg' => 'success', 
            'id' => $this->userid
        ];
        echo json_encode($array);
    }
    public function add_code()
    {
        global $intro;
        if( $this->days == 0 ) 
        {
            exit( 'Error: days not known!!' );
        }
        $data_code = [];
        $data_code['fullname'] = $this->resel;
        $data_code['code'] = $this->random_number($this->length);
        $data_code['period'] = $this->period;
        $data_code['days'] = $this->days;
        $data_code['adminid'] = 1;
        $data_code['transid'] = 0;
        $data_code['status'] = 0;
        $data_code['last_update'] = '';
        $data_code['groupID'] = $this->group;
        if( $this->pkgs == '' ) 
        {
            $data_code['bouquets'] = $this->bouquets();
        }
        else
        {
            $data_code['bouquets'] = $this->pkgs;
        }
        if( $data_code['bouquets'] == '' ) 
        {
            $array = [
                'status' => 'error', 
                'msg' => 'Error: please choose Packages.'
            ];
            echo json_encode($array);
            exit();
        }
        $intro->db->insert(PREFIX . '_codes', $data_code);
        $array = [
            'msg' => 'success', 
            'code' => $data_code['code']
        ];
        echo json_encode($array);
    }
    public function del_user()
    {
        global $intro;
        $sql = $intro->db->query('SELECT id,username from users where username = \'' . $this->user . '\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $array = ['msg' => 'Error: Username (' . $this->user . ') not found in IPTV database'];
            echo json_encode($array);
            exit();
        }
        $sql = $intro->db->query('DELETE from users where username = \'' . $this->user . '\';');
        $sql = $intro->db->query('DELETE from ' . PREFIX . ('_codes where code = \'' . $this->code . '\';'));
        $array = ['msg' => 'success'];
        echo json_encode($array);
    }
    public function sus_user()
    {
        global $intro;
        $sql = $intro->db->query('SELECT id,username from users where username = \'' . $this->user . '\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $array = ['msg' => 'Error: Username (' . $this->user . ') not found in IPTV database'];
            echo json_encode($array);
            exit();
        }
        $enabled = intval($intro->input->get_post('enabled'));
        $status = intval($intro->input->get_post('status'));
        $sql = $intro->db->query('update users set enabled=' . $enabled . ' where username = \'' . $this->user . '\';');
        if( $status == 1 || $status == 2 ) 
        {
            $sql = $intro->db->query('update ' . PREFIX . ('_codes set status=' . $status . '  where code = \'' . $this->code . '\';'));
        }
        $array = ['msg' => 'success'];
        echo json_encode($array);
    }
    public function code_reset()
    {
        global $intro;
        $sql = $intro->db->query('SELECT id,code from ' . PREFIX . ('_codes where inputBy=0 AND code = \'' . $this->code . '\';'));
        if( $intro->db->returned_rows == 1 ) 
        {
            $intro->db->query('update ' . PREFIX . ('_codes set mac=\'reset_me\',serial=\'reset_me\'  where inputBy=0 AND code = \'' . $this->code . '\';'));
            $array = [
                'msg' => 'success', 
                'data' => 'Success. code is reset please re-activate.'
            ];
            echo json_encode($array);
            exit();
        }
        $array = ['msg' => 'code is not found.'];
        echo json_encode($array);
    }
    public function code_info()
    {
        global $intro;
        $sql = $intro->db->query('SELECT * from ' . PREFIX . ('_codes where code=\'' . $this->code . '\';'));
        if( $intro->db->returned_rows == 1 ) 
        {
            $row = $intro->db->fetch_assoc($sql);
            $row['date_expire'] = date('Y-m-d', $row['date_expire']);
            $row['date_start'] = date('Y-m-d', $row['date_start']);
            $row['date_expire'] = ($row['date_expire'] == '1970-01-01' ? '-' : $row['date_expire']);
            $row['date_start'] = ($row['date_start'] == '1970-01-01' ? '-' : $row['date_start']);
            $row['status'] = $intro->status[$row['status']];
            $row['channel'] = $this->getOnlineData('user_activity_now');
            $row['channel_prev'] = $this->getOnlineData('user_activity');
            $array = [
                'msg' => 'success', 
                'data' => $row
            ];
            echo json_encode($array);
            exit();
        }
        $array = [
            'msg' => 'error', 
            'data' => 'code is not found.'
        ];
        echo json_encode($array);
    }
    public function getOnlineData($table)
    {
        global $intro;
        $fields = [
            'users.id,users.username,streams.stream_display_name', 
            'online.stream_id', 
            'online.server_id', 
            'online.user_agent', 
            'online.user_ip', 
            'online.container', 
            'online.date_start', 
            'online.date_end', 
            'online.geoip_country_code', 
            'online.isp'
        ];
        $sql = $intro->db->query('SELECT ' . implode(',', $fields) . (' from `' . $table . '` online, streams, users, ') . PREFIX . '_codes codes ' . (' where online.stream_id=streams.id AND online.user_id=users.id AND users.username=codes.code AND codes.code=\'' . $this->code . '\' ') . ' ORDER BY activity_id desc LIMIT 1;');
        if( $intro->db->returned_rows >= 1 ) 
        {
            $r = $intro->db->fetch_assoc($sql);
            extract($r);
            if( $date_start != '' ) 
            {
                $date_start = date('Y-m-d H:i:s', $date_start);
            }
            if( $date_end != '' ) 
            {
                $date_end = date('Y-m-d H:i:s', $date_end);
            }
            return $stream_display_name . ' | ' . $ruser_ip . ' | ' . $geoip_country_code . ' | ' . $user_agent . ' | ' . $date_start;
        }
        return '';
    }
    public function code_logs()
    {
        global $intro;
        $sql = $intro->db->query('SELECT * from ' . PREFIX . ('_logs where code=\'' . $this->code . '\' order by id desc LIMIT 20;'));
        if( $intro->db->returned_rows >= 1 ) 
        {
            $log = "\n\t\t\t<table class='table table-condensed table-bordered table-hover table-stripped'>\n\t\t\t<tr>\n\t\t\t\t<th>Ver</th>\n\t\t\t\t<th>Date</th>\n\t\t\t\t\n\t\t\t\t<th>Serial</th>\n\t\t\t\t<th>Mac</th>\n\t\t\t\t<th>IP</th>\n\t\t\t\t<th>Log</th>\n\t\t\t\t\n\t\t\t</tr>";
            $i = 0;
            while( $myrow = $intro->db->fetch_assoc($sql) ) 
            {
                @extract($myrow);
                $i++;
                $dtime = date('Y-m-d H:i:s', $dtime);
                $thelog = str_replace('+', '<br/>', $thelog);
                $thelog = str_replace('@Wrong Code', '<span class=\'label label-danger\'>@Wrong Code</span>', $thelog);
                $thelog = str_replace('ReActivation', '<span class=\'label label-default\'>ReActivation</span>', $thelog);
                $thelog = str_replace('Success', '<span class=\'label label-success\'>Success</span>', $thelog);
                $log .= ("<tr>\n\t\t\t\t\t<td class=\"center\">" . $ver . "</td>\n\t\t\t\t\t<td class=\"center\">" . $dtime . "</th>\n\t\t\t\t\t\n\t\t\t\t\t<td class=\"center\">" . $serial . "</th>\n\t\t\t\t\t<td class=\"center\">" . $mac . "</th>\n\t\t\t\t\t<td class=\"center\"><a href='http://ipinfo.io/" . $ip . '\' target=\'_blank\'>' . $ip . "</a></th>\n\t\t\t\t\t<td>" . $thelog . "</th>     \n\t\t\t\t\t   \n\t\t\t\t</tr>");
            }
            $log .= '</table>';
            $array = [
                'msg' => 'success', 
                'data' => $log
            ];
            echo json_encode($array);
            exit();
        }
        $array = ['msg' => 'no logs for this code'];
        echo json_encode($array);
    }
    public function devices()
    {
        global $intro;
        echo "<!DOCTYPE html><html><head><style>/* LIST #4 */\n\t\tbody { /*width:320px;*/ font-family:Georgia, Times, serif; font-size:15px; }\n\t\tul { list-style: none; }\n\t\tul li { }\n\t\tul li a { display:block; text-decoration:none; color:#000000; background-color:#FFFFFF; line-height:30px;\n\t\t  border-bottom-style:solid; border-bottom-width:1px; border-bottom-color:#CCCCCC; padding-left:5px; cursor:pointer; }\n\t\tul li a:hover { color:#FFFFFF; background:#00238C;  }\n\t\tul li a strong { margin-left:10px; }</style></head><body>";
        $sql = $intro->db->query('SELECT id,username,password from users where username = \'' . $this->user . '\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            exit( '<h3 style="color:red">Sorry: this user (' . $this->user . ') was not found in IPTV database.' );
        }
        $row_check = $intro->db->fetch_assoc($sql);
        if( $row_check['password'] != $this->pass ) 
        {
            exit( '<h3 style="color:red">Sorry: the password for user (' . $this->user . ') is not correct in IPTV database.' );
        }
        $sql = $intro->db->query('SELECT * from devices order by device_name asc;');
        echo '<ul>';
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $device_name = $row['device_name'];
            $device_key = $row['device_key'];
            $link = str_replace([
                '/{type}/{user}/{pass}/{ch}', 
                '/{type}/{user}/{pass}/{ch}.ts', 
                '/{type}/{user}/{pass}/{ch}.m3u8', 
                '/{user}/{pass}/{ch}'
            ], '', $this->host) . '/' . _GET_URL . '?' . ('username=' . $this->user . '&password=' . $this->pass . '&type=' . $device_key . '&output=mpegts');
            $link = str_replace([
                '.ts', 
                '.m3u8'
            ], '', $link);
            echo '<li><a href="' . $link . '">' . $device_name . '</a> ';
            if( $device_name == 'm3u' ) 
            {
                $link = str_replace('output=mpegts', 'output=hls', $link);
                echo ' | <a href="' . $link . '"> HLS </a> ';
            }
            echo '</li>';
        }
        echo '</ul>';
    }
    public function renew_user()
    {
        global $intro;
        if( $this->id > 0 ) 
        {
            $qry = ' id = ' . intval($this->id);
        }
        else
        {
            $qry = ' username = \'' . $this->user . '\'';
        }
        $sql = $intro->db->query('SELECT id,username from users where ' . $qry . ';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $array = [
                'status' => 'error', 
                'msg' => 'Error: Username (' . $this->user . ') not found in IPTV database'
            ];
            echo json_encode($array);
            exit();
        }
        $row = $intro->db->fetch_assoc($sql);
        $id = intval($row['id']);
        $data = [];
        $data['exp_date'] = $this->sub_end;
        $data['enabled'] = 1;
        $intro->db->update('users', $data, 'id=' . $id);
        $array = [
            'status' => 'success', 
            'msg' => 'success', 
            'id' => $id
        ];
        echo json_encode($array);
    }
    public function renew_code()
    {
        global $intro;
        if( $this->codeid > 0 ) 
        {
            $qry = ' AND id = ' . intval($this->codeid);
        }
        else
        {
            $qry = ' AND code = \'' . $this->code . '\'';
        }
        if( strlen($this->mac) > 10 && strlen($this->sn) > 8 ) 
        {
            $qry .= (' AND mac = \'' . $this->mac . '\' AND serial = \'' . $this->sn . '\' ');
        }
        else
        {
            $qry .= ' AND inputBy=0 ';
        }
        $sql = $intro->db->query('SELECT id,code,userid from solus_codes where `status`>0 ' . $qry . ' LIMIT 1;');
        if( $intro->db->returned_rows != 1 ) 
        {
            $array = [
                'status' => 'error', 
                'msg' => 'Error: Code (' . $this->code . ') not found in IPTV database'
            ];
            echo json_encode($array);
            exit();
        }
        if( $this->sub_end < time() ) 
        {
            $array = [
                'status' => 'error', 
                'msg' => 'Error: Wrong expire date. ' . $this->sub_end
            ];
            echo json_encode($array);
            exit();
        }
        $row = $intro->db->fetch_assoc($sql);
        $id = intval($row['id']);
        $userid = intval($row['userid']);
        $data = [];
        $data['date_expire'] = $this->sub_end;
        $data['groupID'] = $this->group;
        $data['status'] = 1;
        $intro->db->update('solus_codes', $data, 'id=' . $id);
        $data = [];
        $data['exp_date'] = $this->sub_end;
        $data['enabled'] = 1;
        $intro->db->update('users', $data, 'id=' . $userid);
        $array = [
            'status' => 'success', 
            'msg' => 'success', 
            'id' => $id
        ];
        echo json_encode($array);
    }
    public function random_number($length)
    {
        $random = substr(number_format(time() * rand(), 0, '', ''), 0, $length);
        return $random;
    }
}
